/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.esproc.dql.jdbc.DQLUtil;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.query.metadata.ErrorData;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.utils.IOUtil;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import java.util.List;

public class Dql
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("dql" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("dql" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        FileObject lmdFile;
        Object obj = this.param.getLeafExpression().calculate(ctx);
        if (obj instanceof String) {
            lmdFile = new FileObject((String)obj);
        } else if (obj instanceof FileObject) {
            lmdFile = (FileObject)obj;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("dql" + mm.getMessage("function.paramTypeError"));
        }
        try {
            LogicMetaData lmd = IOUtil.readLogicMetaData(lmdFile.getInputStream());
            List<ErrorData> errorList = lmd.prepare(ctx);
            if (!lmd.getReady()) {
                String error = DQLUtil.getErrorString(errorList);
                Logger.error((Object)error);
            }
            return lmd;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }
}

