/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.parallel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.Machines;
import com.scudata.dm.ParallelCaller;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

public class Callx
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        JobSpace js;
        String dfx;
        IParam dfxParam;
        IParam leftParam = null;
        String[] hosts = null;
        int[] ports = null;
        String reduce = null;
        if (this.param != null) {
            if (this.param.getType() == ';') {
                IParam reduceParam;
                int size = this.param.getSubSize();
                if (size > 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("callx" + mm.getMessage("function.invalidParam"));
                }
                leftParam = this.param.getSub(0);
                IParam rightParam = this.param.getSub(1);
                IParam hubParam = null;
                if (rightParam != null && rightParam.getType() == ',') {
                    hubParam = rightParam.getSub(0);
                    IParam sParam = rightParam.getSub(1);
                    if (sParam.getSubSize() != 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("callx" + mm.getMessage("function.invalidParam"));
                    }
                    Object indexObj = sParam.getLeafExpression().calculate(ctx);
                    if (!(indexObj instanceof Sequence)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("callx" + mm.getMessage("function.invalidParam"));
                    }
                } else {
                    hubParam = rightParam;
                }
                if (hubParam != null) {
                    Machines mc = new Machines();
                    Object hostObj = hubParam.getLeafExpression().calculate(ctx);
                    if (!mc.set(hostObj)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("callx" + mm.getMessage("function.invalidParam"));
                    }
                    hosts = mc.getHosts();
                    ports = mc.getPorts();
                }
                if (size > 2 && (reduceParam = this.param.getSub(2)) != null) {
                    reduce = (String)reduceParam.getLeafExpression().calculate(ctx);
                }
            } else {
                leftParam = this.param;
            }
        }
        int mcount = -1;
        Object[] args = null;
        if (leftParam == null || leftParam.getType() != ',') {
            dfxParam = leftParam;
        } else {
            dfxParam = leftParam.getSub(0);
            int pcount = leftParam.getSubSize() - 1;
            args = new Object[pcount];
            for (int p = 0; p < pcount; ++p) {
                IParam sub = leftParam.getSub(p + 1);
                if (sub == null) continue;
                args[p] = sub.getLeafExpression().calculate(ctx);
                if (!(args[p] instanceof Sequence)) continue;
                int len = ((Sequence)args[p]).length();
                if (len == 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("callx" + mm.getMessage("function.invalidParam"));
                }
                if (mcount == -1) {
                    mcount = len;
                    continue;
                }
                if (mcount == len) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("callx" + mm.getMessage("function.paramCountNotMatch"));
            }
        }
        if (dfxParam == null) {
            dfx = null;
        } else {
            if (!dfxParam.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("callx" + mm.getMessage("function.invalidParam"));
            }
            Object obj = dfxParam.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("callx" + mm.getMessage("function.paramTypeError"));
            }
            dfx = (String)obj;
        }
        ParallelCaller caller = new ParallelCaller(dfx, hosts, ports);
        caller.setContext(ctx);
        caller.setOptions(this.option);
        caller.setReduce(reduce);
        if (args != null) {
            if (mcount == -1) {
                mcount = 1;
            }
            int pcount = args.length;
            for (int i = 1; i <= mcount; ++i) {
                ArrayList<Object> list = new ArrayList<Object>(pcount);
                for (int p = 0; p < pcount; ++p) {
                    if (args[p] instanceof Sequence) {
                        Sequence sequence = (Sequence)args[p];
                        list.add(sequence.get(i));
                        continue;
                    }
                    list.add(args[p]);
                }
                caller.addCall(list);
            }
        }
        if ((js = ctx.getJobSpace()) != null) {
            caller.setJobSpaceId(js.getID());
        }
        return caller.execute();
    }
}

