/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.LineImporter;
import com.scudata.dm.RandomObjectWriter;
import com.scudata.dm.RandomOutputStream;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.BFileFetchCursor;
import com.scudata.dm.cursor.BFileSortxCursor;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.FileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.expression.Expression;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.expression.mfn.file.IIlIlIlllllllllI;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import com.scudata.util.EnvUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sortx
extends FileFunction {
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("sortx" + mm.getMessage("function.missingParam"));
        }
        Object[] objs = Sortx.parseParam(this.param, ctx);
        FileObject out = (FileObject)objs[0];
        String[] fields = (String[])objs[1];
        String s = (String)objs[2];
        return Sortx._$1(this.file, out, fields, s, this.option, ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object[] parseParam(IParam param, Context ctx) {
        String[] fields;
        String s;
        FileObject out;
        IParam sortParam;
        block18: {
            block19: {
                sortParam = null;
                out = null;
                s = null;
                if (param == null) break block18;
                if (param.getType() != ';') break block19;
                if (param.getSubSize() > 2) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
                }
                sortParam = param.getSub(0);
                IParam sub = param.getSub(1);
                if (sub != null) {
                    Object obj;
                    if (sub.isLeaf()) {
                        obj = sub.getLeafExpression().calculate(ctx);
                        if (!(obj instanceof FileObject)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("sortx" + mm.getMessage("function.paramTypeError"));
                        }
                        out = (FileObject)obj;
                        break block18;
                    } else {
                        if (sub.getSubSize() != 2) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
                        }
                        if (sub.getSub(0) != null) {
                            obj = sub.getSub(0).getLeafExpression().calculate(ctx);
                            if (!(obj instanceof FileObject)) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("sortx" + mm.getMessage("function.paramTypeError"));
                            }
                            out = (FileObject)obj;
                        }
                        if (sub.getSub(1) != null) {
                            obj = sub.getSub(1).getLeafExpression().calculate(ctx);
                            if (!(obj instanceof String)) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("sortx" + mm.getMessage("function.paramTypeError"));
                            }
                            s = (String)obj;
                        }
                    }
                }
                break block18;
            }
            sortParam = param;
        }
        if (sortParam == null) {
            fields = null;
        } else if (sortParam.isLeaf()) {
            fields = new String[]{sortParam.getLeafExpression().toString()};
        } else {
            if (sortParam.getType() != ',') {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            int size = sortParam.getSubSize();
            fields = new String[size];
            for (int i = 0; i < size; ++i) {
                IParam sub = sortParam.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
                }
                fields[i] = sub.getLeafExpression().toString();
            }
        }
        if (out != null && out.isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", (Object)out.getFileName()));
        }
        return new Object[]{out, fields, s};
    }

    private static Object _$1(FileObject file, FileObject outFile, String[] fields, String s, String opt, Context ctx) {
        int fcount = fields.length;
        boolean bOpt = opt != null && opt.indexOf(98) != -1;
        BFileFetchCursor cursor = bOpt ? new BFileFetchCursor(file, fields) : new BFileFetchCursor(file, fields, null, s, opt, ctx);
        DataStruct ds = cursor.getFileDataStruct();
        Expression[] tempExps = new Expression[fcount];
        for (int i = 0; i < fcount; ++i) {
            tempExps[i] = new Expression(fields[i]);
        }
        int[] findex = null;
        if (Sortx._$1(ds, tempExps)) {
            findex = new int[fcount];
            for (int i = 0; i < fcount; ++i) {
                findex[i] = i;
            }
        }
        double backup = EnvUtil.getMaxUsedMemoryPercent();
        EnvUtil.setMaxUsedMemoryPercent((double)0.2);
        ICursor cs = Sortx._$1((ICursor)cursor, tempExps, ctx, 0, opt, findex);
        EnvUtil.setMaxUsedMemoryPercent((double)backup);
        if (outFile == null) {
            if (bOpt) {
                return new BFileSortxCursor(cs, fcount, ds);
            }
            FileCursor fcs = new FileCursor(file, 1, 1, s, opt, ctx);
            fcs.fetch(1);
            LineImporter importer = fcs.getImporter();
            fcs.close();
            return new BFileSortxCursor(cs, fcount, ds, importer);
        }
        if (outFile.isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", (Object)outFile.getFileName()));
        }
        if (bOpt) {
            BFileWriter writer = new BFileWriter(outFile, null);
            writer.exportBinary(cs, ds, fcount, ctx);
            writer.close();
        } else {
            Sortx._$1(outFile, cursor.getTitleBytes(), cs, fcount, opt);
        }
        return Boolean.TRUE;
    }

    private static void _$1(FileObject out, byte[] title, ICursor cursor, int fieldIndex, String opt) {
        OutputStream os = out.getBufferedOutputStream(false);
        boolean append = false;
        try {
            Sequence data;
            byte[] LINE_SEPARATOR = FileObject.LINE_SEPARATOR;
            if (opt != null && opt.indexOf(119) != -1) {
                LINE_SEPARATOR = FileObject.DM_LINE_SEPARATOR;
            }
            if (opt != null && opt.indexOf(116) != -1) {
                os.write(title);
            }
            if ((data = cursor.fetch(ICursor.FETCHCOUNT)) == null || data.length() == 0) {
                out.delete();
                return;
            }
            while (data != null && data.length() > 0) {
                int len = data.length();
                for (int i = 1; i <= len; ++i) {
                    if (append) {
                        os.write(LINE_SEPARATOR);
                    } else {
                        append = true;
                    }
                    BaseRecord r = (BaseRecord)data.getMem(i);
                    byte[] bytes = (byte[])r.getNormalFieldValue(fieldIndex);
                    os.write(bytes);
                }
                data = cursor.fetch(ICursor.FETCHCOUNT);
            }
            os.flush();
        }
        catch (IOException e) {
            throw new RQException((Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RQException((Throwable)e);
            }
        }
    }

    private static boolean _$1(DataStruct ds, Expression[] exps) {
        int fcount = exps.length;
        for (int i = 0; i < fcount; ++i) {
            if (ds.getFieldIndex(exps[i].getIdentifierName()) != -1) continue;
            return false;
        }
        return true;
    }

    private static Thread _$1(FileObject fo, Sequence sequence, Context ctx, ArrayList<ICursor> cursorList) {
        return new IIlIlIlllllllllI(fo, sequence, ctx, cursorList);
    }

    private static ICursor _$1(ICursor cursor, Expression[] exps, Context ctx, int capacity, String opt, int[] findex) {
        int size;
        Sequence table;
        int fcount = exps.length;
        ArrayList<ICursor> cursorList = new ArrayList<ICursor>();
        if (capacity <= 1) {
            table = CursorUtil.tryFetch((ICursor)cursor);
            if (table != null) {
                capacity = table.length();
            }
        } else {
            table = cursor.fetch(capacity);
        }
        Logger.info((Object)("Sortx capacity = " + capacity));
        MessageManager mm = EngineMessage.get();
        String msg = mm.getMessage("engine.createTmpFile");
        Expression[] tempExps = (Expression[])exps.clone();
        Thread exportThread = null;
        if (cursor instanceof BFileFetchCursor && ((BFileFetchCursor)cursor).isClosed()) {
            Sequence sequence;
            int len = tempExps.length;
            for (int i = 0; i < len; ++i) {
                tempExps[i] = exps[i].newExpression(ctx);
            }
            if (findex != null) {
                opt = opt == null ? "o" : opt + "o";
                sequence = table.sort(tempExps, null, opt, findex, ctx);
            } else {
                sequence = fcount == 1 ? table.sort(tempExps[0], null, opt, ctx) : table.sort(tempExps, null, opt, ctx);
            }
            table = null;
            return new MemoryCursor(sequence);
        }
        while (table != null && table.length() > 0) {
            Sequence sequence;
            int len = tempExps.length;
            for (int i = 0; i < len; ++i) {
                tempExps[i] = exps[i].newExpression(ctx);
            }
            if (findex != null) {
                opt = opt == null ? "o" : opt + "o";
                sequence = table.sort(tempExps, null, opt, findex, ctx);
            } else {
                sequence = fcount == 1 ? table.sort(tempExps[0], null, opt, ctx) : table.sort(tempExps, null, opt, ctx);
            }
            table = null;
            int len2 = tempExps.length;
            for (int i = 0; i < len2; ++i) {
                tempExps[i] = null;
            }
            FileObject fo = FileObject.createTempFileObject();
            Logger.info((Object)(msg + fo.getFileName()));
            if (exportThread != null) {
                try {
                    exportThread.join();
                }
                catch (InterruptedException e) {
                    throw new RQException((Throwable)e);
                }
            }
            exportThread = Sortx._$1(fo, sequence, ctx, cursorList);
            exportThread.start();
            sequence = null;
            table = cursor.fetch(capacity);
        }
        if (exportThread != null) {
            try {
                exportThread.join();
            }
            catch (InterruptedException e) {
                throw new RQException((Throwable)e);
            }
        }
        if ((size = cursorList.size()) == 0) {
            return new MemoryCursor(null);
        }
        if (size == 1) {
            return (ICursor)cursorList.get(0);
        }
        int bufSize = Env.getMergeFileBufSize((int)size);
        for (int i = 0; i < size; ++i) {
            BFileCursor bfc = (BFileCursor)cursorList.get(i);
            bfc.setFileBufferSize(bufSize);
        }
        ICursor[] cursors = new ICursor[size];
        cursorList.toArray(cursors);
        return CursorUtil.merge((ICursor[])cursors, (Expression[])exps, (String)opt, (Context)ctx);
    }

    public static Object sortx(Sequence files, FileObject outFile, String[] fields, String s, String opt, Context ctx) {
        int fcount = fields == null ? 0 : fields.length;
        boolean bOpt = opt != null && opt.indexOf(98) != -1;
        int len = files.length();
        if (outFile == null && fields == null) {
            return Sortx._$1(files, s, opt, ctx);
        }
        BFileFetchCursor[] cursors = new BFileFetchCursor[len];
        for (int i = 1; i <= len; ++i) {
            Object obj = files.get(i);
            if (obj instanceof FileObject) {
                FileObject file = (FileObject)obj;
                if (bOpt) {
                    cursors[i - 1] = new BFileFetchCursor(file, fields);
                    continue;
                }
                cursors[i - 1] = new BFileFetchCursor(file, fields, null, s, opt, ctx);
                continue;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
        }
        ConjxCursor cursor = new ConjxCursor((ICursor[])cursors);
        if (fcount == 0 && outFile != null) {
            if (bOpt) {
                return Sortx._$1(files, outFile);
            }
            byte[] title = cursors[0].getTitleBytes();
            return Sortx._$1(files, title, outFile);
        }
        DataStruct ds = cursors[0].getFileDataStruct();
        Expression[] tempExps = new Expression[fcount];
        for (int i = 0; i < fcount; ++i) {
            tempExps[i] = new Expression(fields[i]);
        }
        int[] findex = null;
        if (Sortx._$1(ds, tempExps)) {
            findex = new int[fcount];
            for (int i = 0; i < fcount; ++i) {
                findex[i] = i;
            }
        }
        double backup = EnvUtil.getMaxUsedMemoryPercent();
        EnvUtil.setMaxUsedMemoryPercent((double)0.2);
        ICursor cs = Sortx._$1((ICursor)cursor, tempExps, ctx, 0, opt, findex);
        EnvUtil.setMaxUsedMemoryPercent((double)backup);
        if (outFile == null) {
            if (bOpt) {
                return new BFileSortxCursor(cs, fcount, ds);
            }
            FileCursor fcs = new FileCursor((FileObject)files.get(1), 1, 1, s, opt, ctx);
            fcs.fetch(1);
            LineImporter importer = fcs.getImporter();
            fcs.close();
            return new BFileSortxCursor(cs, fcount, ds, importer);
        }
        if (outFile.isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", (Object)outFile.getFileName()));
        }
        if (bOpt) {
            BFileWriter writer = new BFileWriter(outFile, null);
            writer.exportBinary(cs, ds, fcount, ctx);
            writer.close();
        } else {
            Sortx._$1(outFile, cursors[0].getTitleBytes(), cs, fcount, opt);
        }
        return Boolean.TRUE;
    }

    private static ICursor _$1(Sequence files, String s, String opt, Context ctx) {
        int len = files.length();
        ICursor[] cursors = new ICursor[len];
        for (int i = 1; i <= len; ++i) {
            Object obj = files.get(i);
            if (!(obj instanceof FileObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            FileObject file = (FileObject)obj;
            cursors[i - 1] = new FileCursor(file, 1, 1, s, opt, ctx);
        }
        return new ConjxCursor(cursors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _$1(Sequence files, FileObject outFile) {
        int len = files.length();
        FileObject[] fileArray = new FileObject[len];
        long[][] blocks = new long[len][];
        long[] startPosArray = new long[len];
        long[] lengthArray = new long[len];
        long totalRecordCount = 0L;
        DataStruct ds = null;
        if (outFile.isExists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", (Object)outFile.getFileName()));
        }
        for (int i = 1; i <= len; ++i) {
            long length;
            long start;
            FileObject file;
            Object obj = files.get(i);
            if (obj instanceof FileObject) {
                file = (FileObject)obj;
                try {
                    BFileReader reader = new BFileReader(file);
                    reader.open();
                    start = reader.getFirstRecordPos();
                    length = file.size() - start + 1L;
                    blocks[i - 1] = reader.getBlocks();
                    totalRecordCount += reader.getTotalRecordCount();
                    ds = reader.getDataStruct();
                    reader.close();
                }
                catch (IOException e) {
                    return null;
                }
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sortx" + mm.getMessage("function.invalidParam"));
            }
            fileArray[i - 1] = file;
            startPosArray[i - 1] = start;
            lengthArray[i - 1] = length;
        }
        RandomOutputStream ros = outFile.getRandomOutputStream(true);
        RandomObjectWriter writer = new RandomObjectWriter(ros);
        try {
            writer.position(0L);
            writer.write(114);
            writer.write(113);
            writer.write(116);
            writer.write(98);
            writer.write(120);
            writer.write(BFileWriter.TYPE_NORMAL);
            writer.writeInt32(0);
            writer.writeLong64(totalRecordCount);
            writer.writeStrings(ds.getFieldNames());
            writer.close();
            ros.close();
        }
        catch (IOException e) {
            Object start = null;
            return start;
        }
        finally {
            try {
                writer.close();
                ros.close();
            }
            catch (IOException e) {}
        }
        for (int i = 0; i < len; ++i) {
            FileObject file = fileArray[i];
            FileInputStream fis = null;
            FileOutputStream fos = null;
            long start = startPosArray[i];
            long length = lengthArray[i];
            try {
                fis = new FileInputStream(file.getLocalFile().getFile());
                fos = new FileOutputStream(outFile.getLocalFile().getFile(), true);
                FileChannel in = fis.getChannel();
                FileChannel out = fos.getChannel();
                in.transferTo(start, length, out);
                continue;
            }
            catch (IOException e) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                outFile.delete();
                Object var21_32 = null;
                return var21_32;
            }
            finally {
                IOException ie = null;
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ie = e;
                }
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ie = e;
                }
                if (ie != null) {
                    throw new RQException((Throwable)ie);
                }
            }
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _$1(Sequence files, byte[] titleBytes, FileObject outFile) {
        int len = files.length();
        if (titleBytes != null) {
            RandomOutputStream ros = outFile.getRandomOutputStream(true);
            RandomObjectWriter writer = new RandomObjectWriter(ros);
            try {
                writer.position(0L);
                writer.write(titleBytes);
                writer.close();
                ros.close();
            }
            catch (IOException e) {
                outFile.delete();
                Object var7_10 = null;
                return var7_10;
            }
            finally {
                try {
                    writer.close();
                    ros.close();
                }
                catch (IOException e) {}
            }
        }
        long start = titleBytes.length;
        for (int i = 1; i <= len; ++i) {
            Object obj = files.get(i);
            FileObject file = (FileObject)obj;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            long length = file.size() - start + 1L;
            try {
                fis = new FileInputStream(file.getLocalFile().getFile());
                fos = new FileOutputStream(outFile.getLocalFile().getFile(), true);
                FileChannel in = fis.getChannel();
                FileChannel out = fos.getChannel();
                in.transferTo(start, length, out);
                if (i == len) continue;
                ByteBuffer bf = ByteBuffer.allocate(8);
                bf.put((byte)13);
                bf.put((byte)10);
                bf.flip();
                out.write(bf);
                continue;
            }
            catch (IOException e) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                outFile.delete();
                Object var14_21 = null;
                return var14_21;
            }
            finally {
                IOException ie = null;
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ie = e;
                }
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ie = e;
                }
                if (ie != null) {
                    throw new RQException((Throwable)ie);
                }
            }
        }
        return Boolean.TRUE;
    }
}

