/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.btx;

import com.scudata.app.common.Section;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.DBConfig;
import com.scudata.common.ISessionFactory;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.PseudoTable;
import com.scudata.dm.query.utils.IOUtil;
import com.scudata.ide.IdeUtil;
import com.scudata.ide.btx.MenuBaseBtx;
import com.scudata.ide.btx.MenuEtlStepsBtx;
import com.scudata.ide.btx.cloud.DialogCloud;
import com.scudata.ide.common.AppMenu;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.dft.DFT;
import com.scudata.ide.dft.etl.SheetEtlSteps;
import com.scudata.ide.dft.resources.DftMessage;
import com.scudata.ide.dft.step.meta.EtlSteps;
import com.scudata.ide.spl.EsprocEE;
import com.scudata.ide.spl.ICloudClientIDE;
import com.scudata.ide.spl.SPL;
import com.scudata.ide.spl.dialog.DialogCloudLogin;
import com.scudata.ide.spl.dialog.DialogCloudLogout;
import com.scudata.ide.spl.dialog.DialogSplash;
import com.scudata.util.CellSetUtil;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class BTX
extends DFT {
    private static final long serialVersionUID = 1L;
    private static ICloudClientIDE cc = null;
    private static String defLogoName = "dft_logo.png";
    MessageManager dm = DftMessage.get();

    public BTX() {
        this(null);
        EsprocEE.initEnt();
    }

    public static ICloudClientIDE getCloudClient() {
        return cc;
    }

    public BTX(String openFile) {
        super(openFile);
        EsprocEE.initEnt();
    }

    public AppMenu getMenuBase() {
        return new MenuBaseBtx("");
    }

    public AppMenu getMenuEtlSteps() {
        return new MenuEtlStepsBtx("");
    }

    public void refreshCloud() {
        MenuBaseBtx mb = (MenuBaseBtx)GV.appMenu;
        boolean isLoggin = cc != null;
        mb.setMenuEnabled((short)2401, !isLoggin);
        mb.setMenuEnabled((short)2403, isLoggin);
        mb.setMenuEnabled((short)1087, isLoggin);
    }

    public void executeCmd(short cmdId) throws Exception {
        switch (cmdId) {
            case 2401: {
                this.newDialogServerLogin().setVisible(true);
                this.refreshCloud();
                return;
            }
            case 2403: {
                new DialogCloudLogout((JFrame)GV.appFrame, GM.getLogoImage((boolean)true), cc.getName()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Vector<String> getCloudNames() {
                        Vector<String> names = new Vector<String>();
                        names.add(cc.getName());
                        return names;
                    }

                    @Override
                    public void deleteCloud(String cloudName) {
                        cc = null;
                    }
                }.setVisible(true);
                this.refreshCloud();
                return;
            }
            case 1087: {
                new DialogCloud().setVisible(true);
                return;
            }
            case 1397: {
                SheetEtlSteps ses = (SheetEtlSteps)this.currentSheet;
                String filePath = ses.getFilePath();
                EtlSteps es = ses.getEtlSteps();
                this.toPseudoDefine(es, filePath);
                return;
            }
        }
        super.executeCmd(cmdId);
    }

    public DialogCloudLogin newDialogServerLogin() {
        XMLFile xmlFile = null;
        try {
            xmlFile = ConfigFile.getConfigFile().xmlFile();
        }
        catch (Throwable e1) {
            Logger.info((Object)e1);
        }
        ConfigFile configFile = null;
        try {
            configFile = ConfigFile.getConfigFile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        final ConfigFile cf = configFile;
        return new DialogCloudLogin((JFrame)GV.appFrame, GM.getLogoImage((boolean)true), GM.getLogoImage((boolean)false), xmlFile){
            private static final long serialVersionUID = 1L;

            @Override
            public String getRootName() {
                return "RAQSOFT";
            }

            @Override
            public void setConfigNode(String node) {
                if (cf != null) {
                    cf.setConfigNode(node);
                }
            }

            @Override
            public String getConfigNode() {
                if (cf != null) {
                    return cf.getConfigNode();
                }
                return null;
            }

            @Override
            public String getAttrValue(String attr) {
                if (cf != null) {
                    return cf.getAttrValue(attr);
                }
                return null;
            }

            @Override
            public void setAttrValue(String attr, Object val) {
                if (cf != null) {
                    cf.setAttrValue(attr, val);
                }
            }

            @Override
            public void saveConfig() {
                if (cf != null) {
                    try {
                        cf.save();
                    }
                    catch (Exception e) {
                        Logger.info((Object)e);
                    }
                }
            }

            @Override
            public void addCloud(ICloudClientIDE cloud) {
                cc = cloud;
            }

            @Override
            public Vector<String> getCloudNames() {
                Vector<String> names = new Vector<String>();
                if (cc != null) {
                    names.add(cc.getName());
                }
                return names;
            }

            @Override
            public void outputMessage(Object message) {
                Logger.info((Object)message);
            }

            @Override
            protected String getSystemConfigFileName() {
                return "dqlsystemconfig";
            }
        };
    }

    private LogicMetaData executePseudoSplx(EtlSteps es) throws Exception {
        PgmCellSet pcs = null;
        try {
            LogicMetaData lmd = new LogicMetaData();
            if (es.size() == 0) {
                throw new Exception(this.dm.getMessage("sheetetlsteps.emptyfile"));
            }
            Context context = GM.prepareParentContext();
            if (!es.prepareArg(context, false)) {
                throw new Exception("Arg error");
            }
            pcs = es.toPseudoSPLX();
            if (DFT.isDebug()) {
                CellSetUtil.writePgmCellSet((String)"d:/debug.splx", (PgmCellSet)pcs);
            }
            pcs.setContext(context);
            CellSetUtil.putArgStringValue((CellSet)pcs, null);
            pcs.calculateResult();
            ArrayList<PseudoTable> pseudoTableList = new ArrayList<PseudoTable>();
            while (pcs.hasNextResult()) {
                com.scudata.pseudo.PseudoTable result = (com.scudata.pseudo.PseudoTable)((Object)pcs.nextResult());
                PseudoTable pt = new PseudoTable(result);
                pseudoTableList.add(pt);
            }
            lmd.setPseudoTableList(pseudoTableList);
            LogicMetaData logicMetaData = lmd;
            return logicMetaData;
        }
        finally {
            if (pcs != null) {
                pcs.reset();
            }
        }
    }

    public boolean toPseudoDefine(EtlSteps es, String filePath) {
        StringTokenizer st = new StringTokenizer(filePath);
        String defaultName = filePath;
        if (st.hasMoreTokens()) {
            defaultName = st.nextToken();
        }
        int slash = defaultName.lastIndexOf(System.getProperty("file.separator"));
        int dot = defaultName.lastIndexOf(".");
        defaultName = slash > -1 && dot > -1 ? defaultName.substring(slash + 1, dot) : "";
        String tmpExt = "glmd";
        File saveFile = GM.dialogSelectFile((Component)GV.appFrame, (String)tmpExt, (String)GV.lastDirectory, (String)DftMessage.get().getMessage("label.saveas"), (String)defaultName);
        if (saveFile == null) {
            return false;
        }
        String sfile = saveFile.getAbsolutePath();
        if (!sfile.toLowerCase().endsWith(tmpExt)) {
            saveFile = new File(saveFile.getParent(), String.valueOf(saveFile.getName()) + "." + tmpExt);
            sfile = saveFile.getAbsolutePath();
        }
        if (!GM.canSaveAsFile((String)sfile)) {
            return false;
        }
        try {
            LogicMetaData lmd = this.executePseudoSplx(es);
            IOUtil.writeLogicMetaData(sfile, lmd);
            JOptionPane.showMessageDialog((Component)GV.appFrame, String.valueOf(sfile) + this.dm.getMessage("sheetetlsteps.saved"));
            return true;
        }
        catch (Exception x) {
            GM.showException((Object)x);
            return false;
        }
    }

    public static String prepareEnv(String[] args) {
        String openFile = "";
        String arg = "";
        String usage = "Usage: com.scudata.ide.btx.BTX\nwhere possible options include:\n-help                            Print out these messages\n-?                               Print out these messages\nwhere btx/etl/ctx file option is to specify the default to be openned\nExample:\njava com.scudata.ide.btx.BTX d:\\test.btx      Start IDE with default file d:\\test.btx\n";
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0 && arg.charAt(1) != ':') {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                arg = args[i].toLowerCase();
                if (!arg.equalsIgnoreCase("com.scudata.ide.btx.BTX")) {
                    if (!arg.startsWith("-")) {
                        if (!StringUtils.isValidString((Object)openFile)) {
                            openFile = args[i];
                        }
                    } else if (arg.startsWith("-d")) {
                        isDebug = true;
                    } else if (arg.startsWith("-help") || arg.startsWith("-?")) {
                        Logger.debug((Object)usage);
                        System.exit(0);
                    }
                }
                ++i;
            }
        }
        String sTmp = System.getProperty("java.version");
        String sPath = System.getProperty("java.home");
        MessageManager mm = IdeCommonMessage.get();
        if (sTmp.compareTo("1.4.1") < 0) {
            String t1 = mm.getMessage("prjx.jdkversion", (Object)"", (Object)sPath, (Object)sTmp);
            String t2 = mm.getMessage("public.prompt");
            JOptionPane.showMessageDialog(null, t1, t2, 0);
            System.exit(0);
        }
        int c = GV.dsModel.getSize();
        int i = 0;
        while (i < c) {
            DBConfig db = GV.dsModel.getDataSource(i).getDBConfig();
            String dbName = db.getName();
            try {
                ISessionFactory isf = db.createSessionFactory();
                Env.setDBSessionFactory((String)dbName, (ISessionFactory)isf);
            }
            catch (Throwable x) {
                Logger.info((Object)("Create database factory: " + dbName + " failed." + x.getMessage()));
                x.printStackTrace();
            }
            ++i;
        }
        return openFile;
    }

    public void changeMenuAndToolBar(JMenuBar menu, JToolBar toolBar) {
        super.changeMenuAndToolBar(menu, toolBar);
        if (menu instanceof MenuBaseBtx) {
            this.refreshCloud();
        }
    }

    public static void main(final String[] args) {
        BTX.mainInit();
        String splashFile = SPL.getSplashFile();
        ImageIcon ii = IdeUtil.getLogoImage((boolean)true, (String)defLogoName);
        int[] versions = new int[]{7, 6};
        try {
            ConfigOptions.load2((boolean)false, (boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        final DialogSplash ds = SPL.check((String)splashFile, (Image)(ii == null ? null : ii.getImage()), (boolean)false, (String)DftMessage.get().getMessage("btx.title"), (String)"", (int[])versions);
        try {
            ConfigOptions.save((boolean)false, (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                IdeUtil.initLNF();
                try {
                    String openFile = BTX.prepareEnv(args);
                    SPL.loadSystemConfig();
                    BTX frame = new BTX(openFile);
                    ds.dispose();
                    BTX.showFrame((DFT)frame);
                    frame.refreshDataFiles();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    try {
                        GM.showException((Object)t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
    }
}

