/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.ide.monitor.BaseTreeNode;
import com.scudata.ide.monitor.ServerData;
import com.scudata.ide.monitor.resources.MonitorMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public abstract class BaseTree
extends JTree {
    private static final long serialVersionUID = 1L;
    MessageManager mm = MonitorMessage.get();
    protected BaseTreeNode root;

    public BaseTree(BaseTreeNode root) {
        super(root);
        this.root = root;
        this.setCellRenderer(new BaseTreeRender());
        this.setBorder(BorderFactory.createBevelBorder(1));
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(4);
        this.setSelectionModel(dtsm);
        this.addMouseListener(new mTree_mouseAdapter());
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                BaseTree.this.checkAlive();
            }
        };
        Timer timer = new Timer();
        timer.schedule(tt, 1000L, 3000L);
    }

    public abstract void showNode(BaseTreeNode var1);

    public void doubleClickNode(BaseTreeNode node) {
    }

    public BaseTreeNode getActiveNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (BaseTreeNode)path.getLastPathComponent();
    }

    public void selectNode(BaseTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.expandPath(path);
        this.setSelectionPath(path);
    }

    public synchronized void nodeStructureChanged(BaseTreeNode node) {
        if (node != null) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        }
    }

    public BaseTreeNode getRoot() {
        return this.root;
    }

    public synchronized void addClusterServer(String host, int port) {
        BaseTreeNode node = this.locateServerNode(host, port);
        if (node != null) {
            return;
        }
        ServerData serverData = new ServerData(host, port);
        BaseTreeNode serverNode = new BaseTreeNode(serverData);
        serverNode.refresh();
        serverNode.reload();
        this.root.add(serverNode);
        this.selectNode(serverNode);
        this.showNode(serverNode);
        Logger.debug((Object)this.mm.getMessage("BaseTree.addunit", (Object)(String.valueOf(host) + ":" + port)));
    }

    private BaseTreeNode locateServerNode(String host, int port) {
        int count = this.root.getChildCount();
        int i = 0;
        while (i < count) {
            BaseTreeNode node = (BaseTreeNode)this.root.getChildAt(i);
            ServerData sd = (ServerData)node.getUserObject();
            if (host.equals(sd.getHost()) && port == sd.getPort()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public void refresh() {
        int serverCount = this.root.getChildCount();
        int s = 0;
        while (s < serverCount) {
            BaseTreeNode serverNode = (BaseTreeNode)this.root.getChildAt(s);
            serverNode.refresh();
            int unitCount = serverNode.getChildCount();
            int u = 0;
            while (u < unitCount) {
                BaseTreeNode unitNode = (BaseTreeNode)serverNode.getChildAt(u);
                unitNode.refresh();
                ++u;
            }
            ++s;
        }
    }

    public BaseTreeNode getSelectedNode() {
        TreePath tp = this.getSelectionPath();
        if (tp != null) {
            return (BaseTreeNode)tp.getLastPathComponent();
        }
        return null;
    }

    private void checkAlive() {
        int serverCount = this.root.getChildCount();
        boolean isStateChanged = false;
        int s = 0;
        while (s < serverCount) {
            BaseTreeNode serverNode = (BaseTreeNode)this.root.getChildAt(s);
            if (serverNode.checkAlive()) {
                isStateChanged = true;
            }
            ++s;
        }
        if (isStateChanged) {
            this.nodeStructureChanged(this.root);
        }
    }

    class BaseTreeRender
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            BaseTreeNode node = (BaseTreeNode)value;
            if (node.getType() != 1) {
                if (node.isAlive()) {
                    this.setForeground(Color.BLUE);
                } else {
                    this.setForeground(Color.RED);
                }
            }
            this.setIcon(node.getDispIcon());
            return this;
        }
    }

    class mTree_mouseAdapter
    extends MouseAdapter {
        mTree_mouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTree mTree = (JTree)e.getSource();
            TreePath path = mTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            if (!e.isControlDown() && !e.isShiftDown() && e.getButton() != 3) {
                BaseTree.this.setSelectionPath(path);
            }
            BaseTreeNode node = (BaseTreeNode)path.getLastPathComponent();
            BaseTree.this.showNode(node);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            TreePath path = BaseTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            JTree mTree = (JTree)e.getSource();
            if (mTree.getSelectionCount() == 1) {
                BaseTree.this.setSelectionPath(path);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JTree mTree = (JTree)e.getSource();
                TreePath path = mTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                BaseTreeNode node = (BaseTreeNode)path.getLastPathComponent();
                BaseTree.this.doubleClickNode(node);
            }
        }
    }
}

