/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.ide.common.GM;
import com.scudata.ide.monitor.IServerProxy;
import com.scudata.ide.monitor.MONITOR;
import com.scudata.ide.monitor.ServerData;
import com.scudata.ide.monitor.UnitData;
import com.scudata.parallel.UnitConfig;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class BaseTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_ROOT = 1;
    public static final byte TYPE_SERVER = 2;
    public static final byte TYPE_UNIT = 3;
    private byte type;
    private transient int taskRow = -1;
    private transient int paramRow = -1;
    private Object lock = new Object();

    public void setTaskRow(int row) {
        this.taskRow = row;
    }

    public void setParamRow(int row) {
        this.paramRow = row;
    }

    public int getTaskRow() {
        return this.taskRow;
    }

    public int getParamRow() {
        return this.paramRow;
    }

    public BaseTreeNode(Object data) {
        this.setUserObject(data);
        this.type = data instanceof ServerData ? (byte)2 : (data instanceof UnitData ? (byte)3 : (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.type != 2) {
            return;
        }
        ServerData sd = (ServerData)this.getUserObject();
        Object object = this.lock;
        synchronized (object) {
            this.removeAllChildren();
        }
        UnitConfig uc = sd.getUnitConfig();
        if (uc == null) {
            return;
        }
        List hosts = uc.getHosts();
        if (hosts == null) {
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            for (UnitConfig.Host host : hosts) {
                String ip = host.getIp();
                if (!sd.getHost().equals(ip)) continue;
                int port = host.getPort();
                UnitData ud = new UnitData(ip, port);
                BaseTreeNode unitNode = new BaseTreeNode(ud);
                this.add(unitNode);
            }
        }
    }

    public void refresh() {
        IServerProxy isp = (IServerProxy)this.getUserObject();
        if (isp.isAlive()) {
            isp.refresh();
        }
    }

    public boolean isAlive() {
        IServerProxy isp = (IServerProxy)this.getUserObject();
        return isp.isAlive();
    }

    public boolean checkAlive() {
        IServerProxy isp = (IServerProxy)this.getUserObject();
        if (this.type == 2) {
            int unitCount = this.getChildCount();
            boolean isStateChanged = false;
            int i = 0;
            while (i < unitCount) {
                if (i >= this.getChildCount()) break;
                BaseTreeNode unitNode = (BaseTreeNode)this.getChildAt(i);
                if (unitNode.checkAlive()) {
                    isStateChanged = true;
                }
                ++i;
            }
            return isStateChanged || isp.checkAlive();
        }
        if (this.type == 3) {
            return isp.checkAlive();
        }
        return false;
    }

    public ImageIcon getDispIcon() {
        String url = String.valueOf(MONITOR.IMAGE_SRC) + "tree";
        switch (this.type) {
            case 1: {
                url = String.valueOf(url) + "root.gif";
                break;
            }
            case 2: {
                url = String.valueOf(url) + "node";
                url = this.isAlive() ? String.valueOf(url) + "on" : String.valueOf(url) + "off";
                url = String.valueOf(url) + ".gif";
                break;
            }
            case 3: {
                url = String.valueOf(url) + "unit";
                url = this.isAlive() ? String.valueOf(url) + "on" : String.valueOf(url) + "off";
                url = String.valueOf(url) + ".gif";
            }
        }
        return GM.getImageIcon((String)url);
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getName() {
        return this.toString();
    }

    @Override
    public String toString() {
        Object data = this.getUserObject();
        return data.toString();
    }

    public void stop() {
        IServerProxy isp = (IServerProxy)this.getUserObject();
        isp.stop();
    }

    public boolean start() {
        UnitData ud = (UnitData)this.getUserObject();
        BaseTreeNode serverNode = (BaseTreeNode)this.getParent();
        ServerData sd = (ServerData)serverNode.getUserObject();
        return sd.startUnit(ud.getHost(), ud.getPort());
    }
}

