/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.monitor.DialogServerOptions_jBCancel_actionAdapter;
import com.scudata.ide.monitor.DialogServerOptions_jBMainPath_actionAdapter;
import com.scudata.ide.monitor.DialogServerOptions_jBOK_actionAdapter;
import com.scudata.ide.monitor.DialogServerOptions_jBPaths_actionAdapter;
import com.scudata.ide.monitor.DialogServerOptions_this_windowAdapter;
import com.scudata.ide.monitor.DialogUnitConfigC;
import com.scudata.ide.monitor.ServerClient;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.parallel.UnitContext;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DialogServerOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeCommonMessage.get();
    String YES = this.mm.getMessage("DialogServerOptions.yes");
    String NO = this.mm.getMessage("DialogServerOptions.no");
    private final byte TAB_NORMAL = 0;
    private JTabbedPane tabMain = new JTabbedPane();
    private JPanel panelNormal = new JPanel();
    private JPanel jPanelButton = new JPanel();
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JTextField jTFPaths = new JTextField();
    private JTextField jTFMainPath = new JTextField();
    private JButton jBPaths = new JButton();
    private JButton jBMainPath = new JButton();
    JLabel labelFileBuffer = new JLabel(this.mm.getMessage("dialogoptions.filebuffer"));
    private JTextField textFileBuffer = new JTextField();
    private JLabel jLabelLevel = new JLabel();
    private JComboBoxEx jCBLevel = new JComboBoxEx();
    private JLabel labelDate = new JLabel("\u65e5\u671f\u683c\u5f0f");
    private JLabel labelTime = new JLabel("\u65f6\u95f4\u683c\u5f0f");
    private JLabel labelDateTime = new JLabel("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f");
    private JComboBoxEx jCBDate = new JComboBoxEx();
    private JComboBoxEx jCBTime = new JComboBoxEx();
    private JComboBoxEx jCBDateTime = new JComboBoxEx();
    JComboBoxEx jCBCharset = new JComboBoxEx();
    boolean isIniting = false;
    private JLabel labelBlockSize = new JLabel(IdeSplMessage.get().getMessage("dialogoptions.stbs"));
    private JTextField textBlockSize = new JTextField();
    JFrame parent;
    int option = 2;
    static RaqsoftConfig clusterConfig = null;
    static ServerClient serverClient = null;

    public DialogServerOptions(JFrame parent) {
        super(parent, "\u9009\u9879", true);
        this.parent = parent;
        try {
            this.rqInit();
            this.init();
            this.setSize(600, 400);
            GM.setDialogDefaultButton((Window)this, (JButton)this.jBOK, (JButton)this.jBCancel);
            this.resetLangText();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setClusterEnv(RaqsoftConfig rc, ServerClient sc) {
        clusterConfig = rc;
        serverClient = sc;
    }

    private boolean isClusterEditing() {
        return clusterConfig != null;
    }

    public int getOption() {
        return this.option;
    }

    private void init() {
        try {
            RaqsoftConfig config = null;
            config = this.isClusterEditing() ? clusterConfig : this.loadConfig();
            GV.dsModel = new DataSourceListModel();
            if (config != null) {
                String sLevel = config.getLogLevel();
                this.jCBLevel.x_setSelectedCodeItem((Object)sLevel);
                List paths = config.getSplPathList();
                if (paths != null) {
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < paths.size()) {
                        if (i > 0) {
                            sb.append(";");
                        }
                        sb.append((String)paths.get(i));
                        ++i;
                    }
                    this.jTFPaths.setText(sb.toString());
                } else {
                    this.jTFPaths.setText(null);
                }
                this.jTFMainPath.setText(config.getMainPath());
                this.jCBDate.setSelectedItem((Object)config.getDateFormat());
                this.jCBTime.setSelectedItem((Object)config.getTimeFormat());
                this.jCBDateTime.setSelectedItem((Object)config.getDateTimeFormat());
                this.jCBCharset.setSelectedItem((Object)config.getCharSet());
                this.textFileBuffer.setText(config.getBufSize());
                this.textBlockSize.setText(config.getBlockSize());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RaqsoftConfig loadConfig() {
        block12: {
            InputStream is = null;
            try {
                try {
                    is = UnitContext.getUnitInputStream((String)"raqsoftConfig.xml");
                    GV.config = ConfigUtilIde.loadConfig((InputStream)is);
                }
                catch (Exception x) {
                    GV.config = new RaqsoftConfig();
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return GV.config;
    }

    private boolean save() throws Throwable {
        Logger.setLevel((String)((String)this.jCBLevel.x_getSelectedItem()));
        ConfigOptions.sPaths = this.jTFPaths.getText();
        ConfigOptions.sMainPath = this.jTFMainPath.getText();
        ConfigOptions.sDateFormat = this.jCBDate.getSelectedItem() == null ? null : (String)this.jCBDate.getSelectedItem();
        ConfigOptions.sTimeFormat = this.jCBTime.getSelectedItem() == null ? null : (String)this.jCBTime.getSelectedItem();
        ConfigOptions.sDateTimeFormat = this.jCBDateTime.getSelectedItem() == null ? null : (String)this.jCBDateTime.getSelectedItem();
        String string = ConfigOptions.sDefCharsetName = this.jCBCharset.getSelectedItem() == null ? null : (String)this.jCBCharset.getSelectedItem();
        if (!this.checkFileBuffer()) {
            this.tabMain.setSelectedIndex(0);
            return false;
        }
        if (!this.checkBlockSize()) {
            this.tabMain.setSelectedIndex(0);
            return false;
        }
        ConfigOptions.sFileBuffer = this.textFileBuffer.getText();
        ConfigOptions.sBlockSize = this.textBlockSize.getText();
        if (!this.isClusterEditing()) {
            ConfigOptions.applyOptions((boolean)false);
        }
        try {
            String[] paths;
            if (this.isClusterEditing()) {
                GV.config = clusterConfig;
            }
            GV.config.setSplPathList(null);
            if (StringUtils.isValidString((Object)ConfigOptions.sPaths) && (paths = ConfigOptions.sPaths.split(";")) != null) {
                ArrayList<String> splList = new ArrayList<String>();
                int i = 0;
                while (i < paths.length) {
                    splList.add(paths[i]);
                    ++i;
                }
                GV.config.setSplPathList(splList);
            }
            GV.config.setMainPath(ConfigOptions.sMainPath);
            GV.config.setTempPath(ConfigOptions.sTempPath);
            GV.config.setDateFormat(ConfigOptions.sDateFormat);
            GV.config.setTimeFormat(ConfigOptions.sTimeFormat);
            GV.config.setDateTimeFormat(ConfigOptions.sDateTimeFormat);
            GV.config.setCharSet(ConfigOptions.sDefCharsetName);
            GV.config.setLogLevel(Logger.getLevelName((int)Logger.getLevel()));
            GV.config.setBufSize(ConfigOptions.sFileBuffer);
            Env.setFileBufSize((int)Integer.parseInt(GV.config.getBufSize()));
            GV.config.setBlockSize(ConfigOptions.sBlockSize);
            GV.config.setParallelNum(ConfigOptions.iParallelNum == null ? null : ConfigOptions.iParallelNum.toString());
            ConfigUtilIde.writeConfig((boolean)false);
        }
        catch (Exception ex) {
            GM.showException((Object)ex);
        }
        return true;
    }

    void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogoptions.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jLabelLevel.setText(this.mm.getMessage("dialogoptions.loglevel"));
        this.jBPaths.setText(this.mm.getMessage("dialogoptions.select"));
        this.jBMainPath.setText(this.mm.getMessage("dialogoptions.select"));
        this.tabMain.setTitleAt(0, this.mm.getMessage("dialogoptions.panel0"));
        this.labelDate.setText(this.mm.getMessage("dialogoptions.date"));
        this.labelTime.setText(this.mm.getMessage("dialogoptions.time"));
        this.labelDateTime.setText(this.mm.getMessage("dialogoptions.datetime"));
    }

    private void rqInit() throws Exception {
        this.jTFPaths.setToolTipText(this.mm.getMessage("dialogoptions.pathtip"));
        this.jTFMainPath.setToolTipText(this.mm.getMessage("dialogoptions.mainpathtip"));
        this.jBPaths.setText("\u9009\u62e9");
        this.jBPaths.addActionListener(new DialogServerOptions_jBPaths_actionAdapter(this));
        this.jBMainPath.setText("\u9009\u62e9");
        this.jBMainPath.addActionListener(new DialogServerOptions_jBMainPath_actionAdapter(this));
        this.jLabelLevel.setText("\u65e5\u5fd7\u7ea7\u522b");
        this.jPanelButton.setLayout((LayoutManager)new VFlowLayout());
        this.jBOK.setActionCommand("");
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogServerOptions_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setActionCommand("");
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogServerOptions_jBCancel_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        this.jPanelButton.add((Component)this.jBOK, null);
        this.jPanelButton.add((Component)this.jBCancel, null);
        this.panelNormal.setLayout(new GridBagLayout());
        this.panelNormal.add((Component)new JLabel(this.mm.getMessage("dialogoptions.dfxpath")), GM.getGBC((int)1, (int)1));
        this.panelNormal.add((Component)this.jTFPaths, GM.getGBC((int)1, (int)2, (boolean)true));
        this.panelNormal.add((Component)this.jBPaths, GM.getGBC((int)1, (int)3));
        this.panelNormal.add((Component)new JLabel(this.mm.getMessage("dialogoptions.mainpath")), GM.getGBC((int)2, (int)1));
        this.panelNormal.add((Component)this.jTFMainPath, GM.getGBC((int)2, (int)2, (boolean)true));
        this.panelNormal.add((Component)this.jBMainPath, GM.getGBC((int)2, (int)3));
        JPanel panelEnv = new JPanel(new GridBagLayout());
        panelEnv.add((Component)this.labelDate, GM.getGBC((int)1, (int)1));
        panelEnv.add((Component)this.jCBDate, GM.getGBC((int)1, (int)2, (boolean)true));
        panelEnv.add((Component)this.labelTime, GM.getGBC((int)1, (int)3));
        panelEnv.add((Component)this.jCBTime, GM.getGBC((int)1, (int)4, (boolean)true));
        panelEnv.add((Component)this.labelDateTime, GM.getGBC((int)2, (int)1));
        panelEnv.add((Component)this.jCBDateTime, GM.getGBC((int)2, (int)2, (boolean)true));
        panelEnv.add((Component)new JLabel(this.mm.getMessage("dialogoptions.defcharset")), GM.getGBC((int)2, (int)3));
        panelEnv.add((Component)this.jCBCharset, GM.getGBC((int)2, (int)4, (boolean)true));
        panelEnv.add((Component)this.jLabelLevel, GM.getGBC((int)3, (int)1));
        panelEnv.add((Component)this.jCBLevel, GM.getGBC((int)3, (int)2, (boolean)true));
        panelEnv.add((Component)this.labelFileBuffer, GM.getGBC((int)3, (int)3));
        panelEnv.add((Component)this.textFileBuffer, GM.getGBC((int)3, (int)4, (boolean)true));
        panelEnv.add((Component)this.labelBlockSize, GM.getGBC((int)4, (int)1));
        panelEnv.add((Component)this.textBlockSize, GM.getGBC((int)4, (int)2, (boolean)true));
        panelEnv.add((Component)new JLabel(""), GM.getGBC((int)5, (int)2, (boolean)true, (boolean)true));
        GridBagConstraints gbc = GM.getGBC((int)3, (int)1, (boolean)true, (boolean)true);
        gbc.gridwidth = 3;
        this.panelNormal.add((Component)panelEnv, gbc);
        this.tabMain.add((Component)this.panelNormal, "General");
        this.addWindowListener(new DialogServerOptions_this_windowAdapter(this));
        this.getContentPane().add((Component)this.tabMain, "Center");
        this.getContentPane().add((Component)this.jPanelButton, "East");
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.jCBDate.setListData((Object[])GC.DATE_FORMATS);
        this.jCBTime.setListData((Object[])GC.TIME_FORMATS);
        this.jCBDateTime.setListData((Object[])GC.DATE_TIME_FORMATS);
        this.jCBLevel.x_setData(ConfigOptions.dispLevels(), ConfigOptions.dispLevels());
        this.jCBLevel.x_setSelectedCodeItem((Object)Logger.DEBUG);
        Vector<String> charsets = new Vector<String>();
        try {
            SortedMap<String, Charset> map = Charset.availableCharsets();
            Iterator<String> it = map.keySet().iterator();
            while (it.hasNext()) {
                charsets.add(it.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jCBCharset.x_setData(charsets, charsets);
        this.jCBCharset.setEditable(true);
        this.textFileBuffer.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return DialogServerOptions.this.checkFileBuffer();
            }
        });
        this.textBlockSize.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return DialogServerOptions.this.checkBlockSize();
            }
        });
    }

    private boolean checkFileBuffer() {
        int buffer = ConfigUtil.parseBufferSize((String)this.textFileBuffer.getText());
        if (buffer == -1) {
            JOptionPane.showMessageDialog(this.parent, this.mm.getMessage("dialogoptions.emptyfilebuffer"));
            this.textFileBuffer.setText(String.valueOf(Env.getFileBufSize()));
            return false;
        }
        if (buffer == -2) {
            JOptionPane.showMessageDialog(this.parent, this.mm.getMessage("dialogoptions.invalidfilebuffer"));
            this.textFileBuffer.setText(String.valueOf(Env.getFileBufSize()));
            return false;
        }
        if (buffer < 4096) {
            JOptionPane.showMessageDialog(this.parent, this.mm.getMessage("dialogoptions.minfilebuffer"));
            this.textFileBuffer.setText("4096");
            return false;
        }
        return true;
    }

    private boolean checkBlockSize() {
        if (!GMSpl.isBlockSizeEnabled()) {
            return true;
        }
        String sBlockSize = this.textBlockSize.getText();
        int blockSize = ConfigUtil.parseBufferSize((String)sBlockSize);
        if (blockSize == -1) {
            JOptionPane.showMessageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.emptyblocksize"));
            this.textBlockSize.setText(String.valueOf(Env.getBlockSize()));
            return false;
        }
        if (blockSize == -2) {
            JOptionPane.showMessageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.invalidblocksize"));
            this.textBlockSize.setText(String.valueOf(Env.getBlockSize()));
            return false;
        }
        if (blockSize < 4096) {
            JOptionPane.showMessageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.minblocksize"));
            this.textBlockSize.setText("4096");
            return false;
        }
        if (blockSize % 4096 != 0) {
            int size = blockSize / 4096;
            if (size < 1) {
                size = 1;
            }
            blockSize = (size + 1) * 4096;
            JOptionPane.showMessageDialog(this.parent, IdeSplMessage.get().getMessage("dialogoptions.invalidblocksize"));
            this.textBlockSize.setText(ConfigUtil.getUnitBlockSize((int)blockSize, (String)sBlockSize));
            return false;
        }
        return true;
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension((Component)this);
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        try {
            if (!this.save()) {
                return;
            }
            this.option = 0;
            GM.setWindowDimension((Component)this);
            this.dispose();
        }
        catch (Throwable t) {
            GM.showException((Object)t);
        }
    }

    void jBPaths_actionPerformed(ActionEvent e) {
        String newPath;
        File f;
        String oldDir = this.jTFMainPath.getText();
        if (StringUtils.isValidString((Object)oldDir) && (f = new File(oldDir)) != null && f.exists()) {
            oldDir = f.getParent();
        }
        if (!StringUtils.isValidString((Object)oldDir)) {
            oldDir = GV.lastDirectory;
        }
        if (StringUtils.isValidString((Object)(newPath = DialogUnitConfigC.dialogSelectDirectory(oldDir, serverClient)))) {
            String oldPath = this.jTFPaths.getText();
            if (StringUtils.isValidString((Object)oldPath)) {
                if (!oldPath.endsWith(";")) {
                    oldPath = String.valueOf(oldPath) + ";";
                }
                newPath = String.valueOf(oldPath) + newPath;
            }
            this.jTFPaths.setText(newPath);
        }
    }

    public RaqsoftConfig getClusterConfig() {
        return clusterConfig;
    }

    void jBMainPath_actionPerformed(ActionEvent e) {
        String newPath;
        File f;
        String oldDir = this.jTFMainPath.getText();
        if (StringUtils.isValidString((Object)oldDir) && (f = new File(oldDir)) != null && f.exists()) {
            oldDir = f.getParent();
        }
        if (!StringUtils.isValidString((Object)oldDir)) {
            oldDir = GV.lastDirectory;
        }
        if ((newPath = DialogUnitConfigC.dialogSelectDirectory(oldDir, serverClient)) != null) {
            this.jTFMainPath.setText(newPath);
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension((Component)this);
        this.dispose();
    }

    void jBSearchTarget_actionPerformed(ActionEvent e) {
        if (GM.getOperationSytem() == 0) {
            try {
                Runtime.getRuntime().exec("cmd /C start explorer.exe " + GM.getAbsolutePath((String)"log"));
            }
            catch (Exception x) {
                GM.showException((Object)x);
            }
        }
    }
}

