/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.AppMenu;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.monitor.MONITOR;
import com.scudata.ide.monitor.resources.MonitorMessage;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBase
extends AppMenu {
    private static final long serialVersionUID = -7465442995940102676L;
    public static final String IMAGES_PATH = "/com/scudata/ide/monitor/resources/";
    public static final short iSEARCH = 1001;
    public static final short iREFRESH = 1005;
    public static final short iSTOP = 1010;
    public static final short iSTART = 1015;
    public static final short iSTOPTASK = 1020;
    public static final String SEARCH = "tool.search";
    public static final String REFRESH = "tool.refresh";
    public static final String STOP = "tool.stop";
    public static final String START = "tool.start";
    public static final String STOPTASK = "tool.stoptask";
    public static final String MENU_SERVER = "menu.server";
    public static final short iDELETE = 1050;
    public static final short iDATASOURCE = 1055;
    public static final short iCONFIG = 1060;
    public static final short iOPTIONS = 1065;
    public static final short iUPLOAD = 1070;
    public static final short iUPDATE = 1075;
    public static final String DELETE = "server.delete";
    public static final String DATASOURCE = "server.datasource";
    public static final String CONFIG = "server.config";
    public static final String OPTIONS = "server.options";
    public static final String UPLOAD = "server.upload";
    public static final String UPDATE = "server.update";
    protected MessageManager mm = MonitorMessage.get();

    public MenuBase() {
    }

    public MenuBase(String arg) {
        JMenu menu = this.getToolMenu();
        this.add(menu);
        menu = this.getServerMenu();
        this.add(menu);
        this.add(this.getHelpMenu());
    }

    public JMenu getToolMenu() {
        JMenu menu = this.getCommonMenuItem("tool", 'T', true);
        menu.add(this.newMenuItem((short)1001, SEARCH, 'S', 64, true));
        menu.add(this.newMenuItem((short)1005, REFRESH, 't', 2, true));
        menu.addSeparator();
        menu.add(this.newMenuItem((short)1010, STOP, 'S', 64, true));
        menu.add(this.newMenuItem((short)1015, START, 'T', 64, true));
        menu.add(this.newMenuItem((short)1020, STOPTASK, 'T', 64, true));
        menu.addSeparator();
        menu.add(this.newCommonMenuItem((short)80, "file.quit", 'X', 64, true));
        return menu;
    }

    public JMenu getServerMenu() {
        String menuText = this.mm.getMessage(MENU_SERVER);
        JMenu menu = new JMenu(menuText);
        menu.setMnemonic('S');
        menu.add(this.newMenuItem((short)1050, DELETE, 'D', 64, true));
        menu.add(this.newMenuItem((short)1055, DATASOURCE, 'D', 64, true));
        menu.add(this.newMenuItem((short)1060, CONFIG, 'C', 64, true));
        menu.add(this.newMenuItem((short)1065, OPTIONS, 'O', 64, true));
        menu.addSeparator();
        menu.add(this.newMenuItem((short)1070, UPLOAD, 'U', 64, false));
        return menu;
    }

    public static ImageIcon getMenuImageIcon(String menuId) {
        int dot = menuId.indexOf(".");
        String iconText = dot > 0 ? menuId.substring(dot + 1) : menuId;
        String iconPath = "/com/scudata/ide/monitor/resources/m_" + iconText.toLowerCase() + ".gif";
        return GM.getImageIcon((String)iconPath);
    }

    public JMenuItem getMenuItem(short cmdId) {
        return (JMenuItem)menuItems.get(cmdId);
    }

    private JMenuItem getMenuItem(short cmdId, String menuId, char mneKey, int mask, boolean hasIcon, String menuText) {
        JMenuItem mItem = null;
        mItem = new JMenuItem(menuText, mneKey);
        mItem.setName(Short.toString(cmdId));
        if (hasIcon) {
            mItem.setIcon(MenuBase.getMenuImageIcon(menuId));
        } else {
            mItem.setIcon(MenuBase.getMenuImageIcon("blank"));
        }
        if (mask != 64) {
            if (GM.isMacOS()) {
                if ((mask & 2) == 2) {
                    mask = mask - 2 + 4;
                }
                if (mneKey == '\u007f') {
                    mneKey = (char)8;
                }
            }
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, mask);
            mItem.setAccelerator(ks);
        }
        return mItem;
    }

    public JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, int mask, boolean hasIcon) {
        String menuText = this.mm.getMessage("menu." + menuId);
        JMenuItem mItem = this.getMenuItem(cmdId, menuId, mneKey, mask, hasIcon, menuText);
        mItem.addActionListener(this.menuAction);
        menuItems.put(cmdId, mItem);
        return mItem;
    }

    public void executeCmd(short cmdId) {
        try {
            ((MONITOR)GV.appFrame).executeCmd(cmdId);
        }
        catch (Exception x) {
            GM.showException((Object)x);
        }
    }

    public void dataSourceConnected() {
    }

    public short[] getMenuItems() {
        return null;
    }
}

