/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.ide.monitor.MulticastListener;
import com.scudata.ide.monitor.resources.MonitorMessage;
import com.scudata.parallel.UnitClient;
import com.scudata.resources.ParallelMessage;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;

public class MulticastMonitor
extends Thread {
    public static String MULTICAST_HOST = "231.0.0.1";
    public static int MULTICAST_PORT = 18281;
    public static int MULTICAST_PORT2 = 18282;
    static MessageManager cm = MonitorMessage.get();
    public static String LIST_CLUSTER_SERVERS = "LIST CLUSTER SERVER";
    public static String REPLY_CLUSTER_SERVER = "REPLY CLUSTER SERVER";
    private String host = null;
    private int port = -1;
    private volatile boolean stop = false;
    private MulticastListener listener;
    private boolean isServer = false;
    static MessageManager mm = ParallelMessage.get();
    static final boolean localDebug = false;
    boolean isRunning = false;

    @Override
    public String toString() {
        return "[" + this.host + ":" + this.port + "]";
    }

    public void setHost(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void stopThread() {
        this.stop = true;
    }

    public MulticastMonitor() {
        this.isServer = true;
    }

    public MulticastMonitor(MulticastListener listener) {
        this.listener = listener;
        this.setName(this.toString());
    }

    public void broadcast() {
        this.send(LIST_CLUSTER_SERVERS);
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<NetworkInterface> listNetworks() {
        nis = new ArrayList<NetworkInterface>();
        e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl19
        }
        catch (SocketException ex) {
            ex.printStackTrace();
            return nis;
        }
        do {
            ni = e.nextElement();
            try {
                if (!ni.isUp()) {
                    continue;
                }
            }
            catch (Exception var4_5) {
                // empty catch block
            }
            nis.add(ni);
lbl19:
            // 3 sources

        } while (e.hasMoreElements());
        return nis;
    }

    private void send(InetAddress group, int port, String message, NetworkInterface ni) {
        Enumeration<InetAddress> niAddr = ni.getInetAddresses();
        InetSocketAddress isa = new InetSocketAddress(niAddr.nextElement(), 0);
        try (MulticastSocket ms = null;){
            try {
                ms = new MulticastSocket(isa);
                DatagramPacket packet = new DatagramPacket(message.getBytes(), message.length(), group, port);
                ms.send(packet);
                Logger.debug((Object)("Send a message " + message + " to network:" + ni.getDisplayName()));
            }
            catch (Exception x) {
                x.printStackTrace();
                if (ms != null) {
                    ms.close();
                }
            }
        }
    }

    private void send(String message) {
        try (DatagramSocket ms = null;){
            try {
                int multicastPort = MULTICAST_PORT;
                if (this.isServer) {
                    multicastPort = MULTICAST_PORT2;
                }
                InetAddress group = InetAddress.getByName(MULTICAST_HOST);
                ArrayList<NetworkInterface> nis = this.listNetworks();
                if (nis.isEmpty()) {
                    ms = new MulticastSocket(multicastPort);
                    ((MulticastSocket)ms).joinGroup(group);
                    DatagramPacket packet = new DatagramPacket(message.getBytes(), message.length(), group, multicastPort);
                    ms.send(packet);
                    Logger.debug((Object)("Send a message " + message + " at port:" + multicastPort));
                } else {
                    for (NetworkInterface ni : nis) {
                        this.send(group, multicastPort, message, ni);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (ms != null) {
                    ms.close();
                }
            }
        }
    }

    private void handle(DatagramPacket packet) {
        try {
            String message = new String(packet.getData(), 0, packet.getLength());
            Logger.debug((Object)("Receive message\uff1a" + message));
            if (message.equals(LIST_CLUSTER_SERVERS)) {
                if (this.host == null) {
                    return;
                }
                this.send(String.valueOf(REPLY_CLUSTER_SERVER) + this.host + ":" + this.port);
                return;
            }
            if (this.listener == null) {
                return;
            }
            if (message.startsWith(REPLY_CLUSTER_SERVER)) {
                String unitHost = UnitClient.parseHost((String)(message = message.substring(REPLY_CLUSTER_SERVER.length())));
                if (unitHost == null) {
                    return;
                }
                int unitPort = UnitClient.parsePort((String)message);
                this.listener.addClusterServer(unitHost, unitPort);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void run() {
        try (DatagramSocket ms = null;){
            try {
                int multicastPort = MULTICAST_PORT2;
                String thisHost = this.toString();
                String msg = "Host\uff1a " + thisHost;
                int waitTime = 1000;
                if (this.isServer) {
                    waitTime = 3000;
                    multicastPort = MULTICAST_PORT;
                }
                ms = new MulticastSocket(multicastPort);
                ms.setTrafficClass(4);
                ms.setSoTimeout(waitTime);
                ArrayList<NetworkInterface> nis = this.listNetworks();
                InetAddress group = InetAddress.getByName(MULTICAST_HOST);
                if (nis.isEmpty()) {
                    ((MulticastSocket)ms).joinGroup(group);
                } else {
                    for (NetworkInterface ni : nis) {
                        InetSocketAddress isa = new InetSocketAddress(group, 0);
                        ((MulticastSocket)ms).joinGroup(isa, ni);
                    }
                }
                Logger.debug((Object)(String.valueOf(msg) + " has started multicast listening."));
                while (!this.stop) {
                    this.isRunning = true;
                    try {
                        byte[] data = new byte[256];
                        DatagramPacket packet = new DatagramPacket(data, data.length);
                        ms.receive(packet);
                        this.handle(packet);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                }
                Logger.debug((Object)(String.valueOf(msg) + " halt multicast listening."));
            }
            catch (Exception x) {
                x.printStackTrace();
                if (ms != null) {
                    ms.close();
                }
            }
        }
    }
}

