/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.ConfigWriter;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Env;
import com.scudata.ide.monitor.Request;
import com.scudata.ide.monitor.Response;
import com.scudata.ide.monitor.resources.MonitorMessage;
import com.scudata.parallel.RemoteFileProxyManager;
import com.scudata.parallel.SocketData;
import com.scudata.parallel.UnitConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.List;

public class ServerClient {
    static MessageManager mm = MonitorMessage.get();
    String host;
    int port;

    public ServerClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(String nodeHost, int nodePort) {
        return this.host.equalsIgnoreCase(nodeHost) && this.port == nodePort;
    }

    public boolean isAlive() {
        SocketData sd = null;
        try {
            try {
                sd = this.newSocketData();
            }
            catch (Exception x) {
                if (sd != null) {
                    try {
                        sd.clientClose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sd = null;
                }
                return false;
            }
        }
        finally {
            if (sd != null) {
                try {
                    sd.clientClose();
                }
                catch (Exception exception) {}
                sd = null;
            }
        }
        return true;
    }

    private SocketData newSocketData() throws Exception {
        Socket s = new Socket();
        SocketData sd = new SocketData(s);
        InetSocketAddress isa = null;
        isa = new InetSocketAddress(this.host, this.port);
        sd.connect((SocketAddress)isa, 5000);
        return sd;
    }

    public Response sendByNewSocket(Request req) throws Exception {
        SocketData tmp = null;
        try {
            tmp = this.newSocketData();
            tmp.write((Object)req);
            Response res = (Response)tmp.read();
            if (res == null) {
                new Exception().printStackTrace();
            }
            res.setFromHost(this.toString());
            Response response = res;
            return response;
        }
        finally {
            if (tmp != null) {
                tmp.clientClose();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ServerClient)) {
            return false;
        }
        ServerClient otherUc = (ServerClient)other;
        return otherUc.getHost().equalsIgnoreCase(this.host) && otherUc.getPort() == this.port;
    }

    public void shutDown() {
        Request req = new Request(100);
        try {
            this.sendByNewSocket(req);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean startUnit(String unitHost, int unitPort) {
        Request req = new Request(1001);
        req.setAttr("Host", unitHost);
        req.setAttr("Port", unitPort);
        req.setAttr("Action", true);
        try {
            Response res = this.sendByNewSocket(req);
            Exception xx = res.getException();
            if (xx != null) {
                throw new Exception(mm.getMessage("ServerClient.starterror", (Object)(String.valueOf(unitHost) + ":" + unitPort), (Object)xx.getMessage()), xx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean unitAction(String host, int port, boolean isStart) {
        Request req = new Request(1001);
        req.setAttr("Host", host);
        req.setAttr("Port", port);
        req.setAttr("Action", isStart);
        try {
            Response res = this.sendByNewSocket(req);
            Exception xx = res.getException();
            if (xx != null) {
                throw new Exception(mm.getMessage("ServerClient.starterror", (Object)(String.valueOf(host) + ":" + port), (Object)xx.getMessage()), xx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public UnitConfig getUnitConfig() throws Exception {
        byte[] buf = this.getConfig(2);
        UnitConfig uc = new UnitConfig();
        if (buf != null) {
            uc.load(buf);
        }
        return uc;
    }

    public void putUnitConfig(UnitConfig uc) throws Exception {
        Request req = new Request(2);
        this.putConfig(req, uc.toFileBytes());
    }

    public RaqsoftConfig getRaqsoftConfig() throws Exception {
        byte[] buf = this.getConfig(1);
        if (buf == null) {
            return new RaqsoftConfig();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        RaqsoftConfig raqsoftConfig = ConfigUtil.load((InputStream)bais, (boolean)false);
        return raqsoftConfig;
    }

    public String getUpdateVersion() {
        try {
            Request req = new Request(10);
            return (String)this.ask(req);
        }
        catch (Exception x) {
            return "";
        }
    }

    public String getUpdateZipPath() throws Exception {
        Request req = new Request(11);
        return (String)this.ask(req);
    }

    public Object[] getUploadPaths() throws Exception {
        Request req = new Request(13);
        return (Object[])this.ask(req);
    }

    public String getHome() throws Exception {
        Request req = new Request(15);
        return (String)this.ask(req);
    }

    private Object ask(Request req) {
        try {
            Response res = this.sendByNewSocket(req);
            if (res.getException() != null) {
                throw res.getException();
            }
            return res.getResult();
        }
        catch (Exception x) {
            throw new RQException(this.toString(), (Throwable)x);
        }
    }

    public void putRaqsoftConfig(RaqsoftConfig rc) throws Exception {
        Request req = new Request(1);
        ConfigWriter cw = new ConfigWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cw.write((OutputStream)baos, rc);
        this.putConfig(req, baos.toByteArray());
        baos.close();
    }

    private byte[] getConfig(int cmd) {
        Request req = new Request(cmd);
        req.setAttr("Config method", 0);
        return (byte[])this.ask(req);
    }

    private void putConfig(Request req, byte[] fileBytes) {
        req.setAttr("Config method", 1);
        req.setAttr("Config content", fileBytes);
        this.ask(req);
    }

    public List listFiles(String parent, String ext, boolean onlyDirectory) throws Exception {
        Request req = new Request(10002);
        req.setAttr("Files path", parent);
        req.setAttr("Files ext", ext);
        req.setAttr("Only directory", onlyDirectory);
        return (List)this.ask(req);
    }

    public boolean isFileExists(String absPath) throws Exception {
        Request req = new Request(10003);
        req.setAttr("Dest absolute path", absPath);
        return (Boolean)this.ask(req);
    }

    public boolean uploadFile(File localFile, String dstPathName) throws Exception {
        SocketData tmp = null;
        boolean flag = false;
        try {
            tmp = this.newSocketData();
            Request req = new Request(10001);
            req.setAttr("Dest absolute path", dstPathName);
            req.setAttr("Last modified", localFile.lastModified());
            tmp.write((Object)req);
            FileInputStream fis = new FileInputStream(localFile);
            byte[] fileBuf = RemoteFileProxyManager.read((InputStream)fis, (int)Env.FILE_BUFSIZE);
            tmp.write((Object)fileBuf);
            while (fileBuf != null) {
                fileBuf = RemoteFileProxyManager.read((InputStream)fis, (int)Env.FILE_BUFSIZE);
                tmp.write((Object)fileBuf);
            }
            fis.close();
            Response res = (Response)tmp.read();
            if (res.getException() != null) {
                throw res.getException();
            }
            flag = true;
            Logger.debug((Object)("upload: " + localFile.getAbsolutePath() + " OK."));
        }
        finally {
            if (tmp != null) {
                tmp.clientClose();
            }
        }
        return flag;
    }

    public boolean updateUnZip() throws Exception {
        Request req = new Request(12);
        return (Boolean)this.ask(req);
    }

    public static void main(String[] args1) {
    }
}

