/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.app.config.RaqsoftConfig;
import com.scudata.ide.common.GM;
import com.scudata.ide.monitor.IServerProxy;
import com.scudata.ide.monitor.ServerClient;
import com.scudata.parallel.UnitConfig;

public class ServerData
implements IServerProxy {
    String host;
    int port;
    RaqsoftConfig raqsoftConfig;
    UnitConfig unitConfig;
    boolean isAlive = false;
    transient ServerClient serverClient = null;

    public ServerData(String host, int port) {
        this.host = host;
        this.port = port;
        this.serverClient = new ServerClient(host, port);
        this.isAlive = true;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RaqsoftConfig getRaqsoftConfig() {
        return this.raqsoftConfig;
    }

    public UnitConfig getUnitConfig() {
        return this.unitConfig;
    }

    public void setUnitConfig(UnitConfig uc) {
        this.unitConfig = uc;
        try {
            this.serverClient.putUnitConfig(uc);
        }
        catch (Exception x) {
            GM.showException((Object)x);
        }
    }

    public void setRaqsoftConfig(RaqsoftConfig rc) {
        this.raqsoftConfig = rc;
        try {
            this.serverClient.putRaqsoftConfig(rc);
        }
        catch (Exception x) {
            GM.showException((Object)x);
        }
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public boolean checkAlive() {
        boolean newAlive = this.serverClient.isAlive();
        boolean isStateChanged = newAlive ^ this.isAlive;
        this.isAlive = newAlive;
        return isStateChanged;
    }

    @Override
    public void refresh() {
        if (!this.isAlive) {
            return;
        }
        try {
            this.raqsoftConfig = this.serverClient.getRaqsoftConfig();
            this.unitConfig = this.serverClient.getUnitConfig();
        }
        catch (Exception x) {
            GM.showException((Object)x);
        }
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public boolean equals(String other, int oport) {
        return this.host.equalsIgnoreCase(other) && this.port == oport;
    }

    @Override
    public void stop() {
        this.serverClient.shutDown();
    }

    public boolean startUnit(String unitHost, int unitPort) {
        return this.serverClient.startUnit(unitHost, unitPort);
    }
}

