/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.dm.CanceledException;
import com.scudata.dm.Table;
import com.scudata.ide.monitor.IServerProxy;
import com.scudata.ide.monitor.resources.MonitorMessage;
import com.scudata.parallel.UnitClient;

public class UnitData
implements IServerProxy {
    String host;
    int port;
    boolean isAlive = false;
    private Table tasks;
    private Table params;
    MessageManager mm = MonitorMessage.get();
    UnitClient unitClient;

    public UnitData(String host, int port) {
        this.host = host;
        this.port = port;
        this.unitClient = new UnitClient(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public boolean checkAlive() {
        boolean newAlive = this.unitClient.isAlive();
        boolean isStateChanged = newAlive ^ this.isAlive;
        this.isAlive = newAlive;
        return isStateChanged;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof UnitData) {
            UnitData ud = (UnitData)other;
            return ud.toString().equals(this.toString());
        }
        return false;
    }

    @Override
    public void refresh() {
        try (UnitClient uc = null;){
            try {
                this.tasks = null;
                this.params = null;
                this.checkAlive();
                uc = new UnitClient(this.host, this.port);
                uc.connect();
                this.tasks = uc.getTaskList();
                this.params = uc.getEnvParamList();
                StringBuffer sb = new StringBuffer();
                sb.append(uc.toString());
                int taskCount = 0;
                int paramCount = 0;
                if (this.tasks != null) {
                    taskCount = this.tasks.length();
                }
                if (this.params != null) {
                    paramCount = this.params.length();
                }
                Logger.debug((Object)this.mm.getMessage("UnitData.taskinfo", (Object)uc, (Object)taskCount, (Object)paramCount));
            }
            catch (Exception e) {
                Logger.error((Object)e.getMessage());
                if (uc != null) {
                    uc.close();
                }
            }
        }
    }

    public Table getTasks() {
        return this.tasks;
    }

    public Table getParams() {
        return this.params;
    }

    public boolean stopTask(Integer taskId) {
        this.unitClient.cancel(taskId, CanceledException.TYPE_MONITOR);
        return true;
    }

    @Override
    public void stop() {
        this.unitClient.shutDown();
    }

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port;
    }
}

