/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.monitor.server;

import com.scudata.ide.monitor.Request;
import com.scudata.ide.monitor.Response;
import com.scudata.ide.monitor.server.CLUSTERSERVER;
import com.scudata.ide.monitor.server.FileService;
import com.scudata.parallel.SocketData;

public class ClusterWorker
extends Thread {
    SocketData socketData;
    private volatile boolean stop = false;

    public ClusterWorker(ThreadGroup tg, String name) {
        super(tg, name);
    }

    public void setSocket(SocketData sd) {
        this.socketData = sd;
    }

    @Override
    public void run() {
        try {
            try {
                Response response = null;
                while (!this.stop) {
                    Object obj = this.socketData.read();
                    if (obj == null) break;
                    if (!(obj instanceof Request)) {
                        break;
                    }
                    Request req = (Request)obj;
                    switch (req.getActionType()) {
                        case 0: {
                            CLUSTERSERVER server = CLUSTERSERVER.getInstance();
                            response = server.execute(req);
                            break;
                        }
                        case 10000: {
                            response = FileService.execute(req, this.socketData);
                        }
                    }
                    this.socketData.write(response);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                try {
                    this.socketData.serverClose();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                this.socketData.serverClose();
            }
            catch (Exception exception) {}
        }
    }

    public void shutdown() {
        this.stop = true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ManageWorker:");
        sb.append(this.socketData.getSocket().getRemoteSocketAddress());
        sb.append("-" + this.socketData.getSocket().hashCode());
        return sb.toString();
    }
}

