/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl;

import com.scudata.app.common.AppUtil;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.docker.client.Client;
import com.scudata.expression.FunctionLib;
import com.scudata.ide.common.AppMenu;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.CloudValue;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplEE;
import com.scudata.ide.spl.ICloudClientIDE;
import com.scudata.ide.spl.IIllllIlllIIIlll;
import com.scudata.ide.spl.SPL;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.SheetSplEE;
import com.scudata.ide.spl.StepInfo;
import com.scudata.ide.spl.base.FileTreeEE;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogInputPassword;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.CellSetUtil;
import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class EsprocEE
extends SPL {
    private static final long serialVersionUID = 1L;
    public static boolean isEntFuncLoad = false;
    private static boolean _$1 = false;
    public static final String RELEASE_DATE = "2026-01-07";

    public EsprocEE(String openFile) {
        super(openFile);
        EsprocEE.initEnt();
    }

    protected SheetSpl newSheetSpl(String filePath, PgmCellSet cs, StepInfo stepInfo) throws Exception {
        return new SheetSplEE(filePath, cs, stepInfo);
    }

    public synchronized JInternalFrame openSheetFile(InputStream in, String filePath, byte type) throws Exception {
        SheetSpl sheet = (SheetSpl)this.getSheet(filePath);
        if (sheet != null && this.showSheet((JInternalFrame)sheet)) {
            GV.toolWin.refresh();
            return null;
        }
        PgmCellSet cs = filePath != null && filePath.toLowerCase().endsWith(".spl") ? AppUtil.readSPL((InputStream)in) : this.readPgmCellSet(in, filePath, type);
        sheet = (SheetSpl)this.openSheet(filePath = !StringUtils.isValidString((Object)filePath) ? GMSpl.getNewName() : filePath.trim(), cs, false);
        if (sheet != null && sheet instanceof SheetSplEE) {
            ((SheetSplEE)sheet).setType(type);
        }
        return sheet;
    }

    protected void mixpanel() {
    }

    protected boolean exitCustom() {
        boolean canExit = super.exitCustom();
        if (!canExit) {
            return false;
        }
        try {
            if (GVSplEE.dockerSession >= 0) {
                Client.logout((String)GVSplEE.dockerIP, (int)GVSplEE.dockerPort, (int)GVSplEE.dockerSession);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.closeRemoteServer();
        if (SplEditorSE.isNodes()) {
            try {
                Class<?> clz = Class.forName("com.scudata.ecloud.ide.GMCloud");
                Method m = clz.getMethod("exitCloud", null);
                m.invoke(clz, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public PgmCellSet readPgmCellSet(InputStream is, String fileName, byte type) throws Exception {
        PgmCellSet cellSet;
        String psw = null;
        if (type == 0 && CellSetUtil.isEncrypted((String)fileName)) {
            DialogInputPassword dip = new DialogInputPassword(true);
            dip.setPassword(null);
            dip.setVisible(true);
            if (dip.getOption() == 0) {
                psw = dip.getPassword();
            } else {
                return null;
            }
        }
        if ((cellSet = CellSetUtil.readPgmCellSet((InputStream)is, psw)) != null && fileName != null) {
            cellSet.setName(fileName);
        }
        return cellSet;
    }

    protected boolean isLocalSheet(SheetSpl sheet) {
        if (sheet instanceof SheetSplEE) {
            SheetSplEE ssc = (SheetSplEE)sheet;
            return ssc.getType() == 0;
        }
        return true;
    }

    protected void newResourceTree() {
        if (GV.fileTree == null) {
            GV.fileTree = this.fileTree = new FileTreeEE();
        } else {
            this.fileTree = GV.fileTree;
        }
    }

    protected boolean closeRemoteServer() {
        GVSplEE.getResourceTree().setClosing();
        List<ICloudClientIDE> cloudList = GVSplEE.getResourceTree().getCloudList();
        if (cloudList != null && cloudList.size() > 0) {
            for (int i = cloudList.size() - 1; i >= 0; --i) {
                try {
                    ICloudClientIDE server = cloudList.get(i);
                    server.setShowMessage(false);
                    GVSplEE.getResourceTree().deleteCloud(server);
                    continue;
                }
                catch (Exception ex) {
                    GM.outputMessage((Object)ex);
                }
            }
        }
        return true;
    }

    protected void selectParam(String varName, Object val, String spaceName) {
        byte dataType = 0;
        if (val instanceof CloudValue) {
            CloudValue cv = (CloudValue)val;
            val = cv.getValue();
            dataType = cv.getDataType();
        }
        if (dataType == 1) {
            // empty if block
        }
        GVSpl.panelValue.tableValue.setValue1(val, varName);
        GVSpl.panelValue.valueBar.refresh();
        this.repaint();
    }

    protected AppMenu newMenuBase() {
        return GVSplEE.newBaseMenu();
    }

    protected AppMenu newMenuSpl() {
        return GVSplEE.newSplMenu();
    }

    public static void initEnt() {
        EsprocEE.loadEntFunctions();
        EsprocEE._$1();
    }

    public static void loadEntFunctions() {
        if (isEntFuncLoad) {
            return;
        }
        isEntFuncLoad = true;
        EsprocEE.loadCustomFunctions();
        try {
            EsprocEE._$2();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void loadCustomFunctions() {
        if (_$1) {
            return;
        }
        _$1 = true;
        SPL.loadCustomFunctions();
        try {
            FunctionLib.loadCustomFunctions((String)"splfunctions.properties");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void _$2() {
        try {
            Class<?> clz = Class.forName("com.scudata.ecloud.ide.GMCloud");
            Method m = clz.getMethod("loadQFunctions", null);
            m.invoke(clz, null);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    private static void _$1() {
        if (SplEditorSE.isNodes()) {
            try {
                Class<?> clz = Class.forName("com.scudata.ecloud.ide.GMCloud");
                Method m = clz.getMethod("initCloud", null);
                m.invoke(clz, null);
            }
            catch (Throwable t) {
                Logger.error((Object)t);
            }
        }
    }

    public static void loadSystemConfig() {
        ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
        if (sysConfig != null) {
            try {
                String sCloudEnabled = sysConfig.getAttrValue("isAIOEnabled");
                if (sCloudEnabled != null) {
                    GVSplEE.isAIOEnabled = Boolean.parseBoolean(sCloudEnabled);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setSerialNo() throws Exception {
        String configDir = GM.getAbsolutePath((String)"config");
        String filePath = new File(configDir, "raqsoftConfig.xml").getAbsolutePath();
        RaqsoftConfig config = ConfigUtil.load((String)filePath, (boolean)false, (boolean)false);
        SPL.checkNoUI((RaqsoftConfig)config, (int[])new int[]{7, 6}, (String)IdeSplMessage.get().getMessage("spl.productname"));
    }

    public static void main(String[] args) {
        EsprocEE.mainInit();
        String splashFile = EsprocEE.getSplashFile();
        ImageIcon ii = GMSpl.getLogoImage((boolean)true);
        EsprocEE.check((String)splashFile, (Image)(ii == null ? null : ii.getImage()), (boolean)true, (String)IdeSplMessage.get().getMessage("spl.productname"), (String)"esProc", (int[])new int[]{7, 6}, (String)"esproc_port");
        SwingUtilities.invokeLater(new IIllllIlllIIIlll(args));
    }

    public String getProductName() {
        return IdeSplMessage.get().getMessage("spl.productname");
    }

    public String getReleaseDate() {
        return RELEASE_DATE;
    }
}

