/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.base;

import com.scudata.app.common.AppUtil;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.custom.FileInfo;
import com.scudata.ide.spl.FileFilter;
import com.scudata.ide.spl.GMSplEE;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.GVSplEE;
import com.scudata.ide.spl.ICloudClientIDE;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.SheetSplEE;
import com.scudata.ide.spl.base.FileTree;
import com.scudata.ide.spl.base.FileTreeNode;
import com.scudata.ide.spl.base.FileTreeNodeEE;
import com.scudata.ide.spl.base.FileTreeSE;
import com.scudata.ide.spl.base.IIIllIIllIIllIlI;
import com.scudata.ide.spl.base.IlIllIIllIIllIlI;
import com.scudata.ide.spl.base.ProcessWindow;
import com.scudata.ide.spl.base.lIIllIIllIIllIlI;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeEE
extends FileTreeSE {
    private static final long serialVersionUID = 1L;
    public static final byte LOGIN_AIO = 30;
    public static final byte LOGIN_CLOUD = 31;
    public static final byte LOGOUT = 33;
    public static final byte FILE_SAVE = 35;
    public static final byte FILE_DOWNLOAD = 41;
    public static final byte DIR_DOWNLOAD = 42;
    public static final byte DIR_DOWNLOAD_WITHCHILD = 43;
    public static final byte FILE_UPLOAD = 51;
    public static final byte FILE_REMOVE = 52;
    public static final byte DIR_REMOVE = 53;
    protected FileTreeNodeEE cloudRoot = null;
    private boolean _$6 = false;
    private boolean _$5 = false;
    public static final String BUSINESS_DIR = mm.getMessage("filetreese.businessdir");
    public static final String BUFFER_DIR = mm.getMessage("filetreese.bufferdir");
    public static final String BACKUP_DIR = mm.getMessage("filetreese.backupdir");
    public static final String MAIN_DIR = IdeCommonMessage.get().getMessage("dialogoptions.mainpath");
    public static final String STORE_DIR = IdeCommonMessage.get().getMessage("filetreeee.storedir");
    public static final byte ACTION_ADD_CLOUD = 0;
    public static final byte ACTION_REFRESH_NODE = 1;
    public static final byte ACTION_EXPAND_NODE = 2;
    public static final byte ACTION_REFRESH_CLOUD = 3;
    private List<ICloudClientIDE> _$4;
    public static String selectCloud;
    private static final String _$3;
    private static final String _$2;
    private ProcessWindow _$1;

    protected JMenuItem getMenuItem(byte action, ActionListener al) {
        String imgPath;
        String title;
        JMenuItem mi = super.getMenuItem(action, al);
        if (mi != null) {
            return mi;
        }
        switch (action) {
            case 30: {
                title = mm.getMessage("filetree.loginaio");
                imgPath = "m_login.gif";
                break;
            }
            case 31: {
                title = mm.getMessage("filetree.logincloud");
                imgPath = "m_login.gif";
                break;
            }
            case 33: {
                title = mm.getMessage("filetree.serverlogout");
                imgPath = "m_quit.gif";
                break;
            }
            case 35: {
                title = mm.getMessage("filetree.save");
                imgPath = "m_save.gif";
                break;
            }
            case 41: {
                title = mm.getMessage("filetree.downloadfile");
                imgPath = "m_loadtxt.gif";
                break;
            }
            case 42: {
                title = mm.getMessage("filetree.downloaddir");
                imgPath = "blank.gif";
                break;
            }
            case 43: {
                title = mm.getMessage("filetree.downloaddirwithchild");
                imgPath = "blank.gif";
                break;
            }
            case 51: {
                title = mm.getMessage("filetree.uploadfile");
                imgPath = "m_uploadfile.gif";
                break;
            }
            case 53: {
                title = mm.getMessage("filetree.deletetree");
                imgPath = "m_delete.gif";
                break;
            }
            case 52: {
                title = mm.getMessage("filetree.deletenode");
                imgPath = "m_deleterecord.gif";
                break;
            }
            default: {
                return null;
            }
        }
        mi = new JMenuItem(title);
        mi.setName(action + "");
        if (imgPath != null) {
            mi.setIcon(GM.getImageIcon((String)("/com/scudata/ide/common/resources/" + imgPath)));
        }
        mi.addActionListener(al);
        return mi;
    }

    public synchronized void refreshCloud() {
        this._$2();
        IlIllIIllIIllIlI delayExecute = new IlIllIIllIIllIlI(this);
        delayExecute.start();
    }

    private void _$2() {
        try {
            this._$1();
            this._$1 = new ProcessWindow(IdeSplMessage.get().getMessage("filetreeee.loadingcloud"));
            this._$1(this._$1);
            this._$1.setVisible(true);
        }
        catch (Exception e) {
            Logger.error((Object)e);
        }
    }

    private void _$1() {
        if (this._$1 != null) {
            try {
                this._$1.disposeWindow();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._$1 = null;
        }
    }

    public void treeNodeWillExpand(FileTreeNode node) {
        if (this._$6) {
            return;
        }
        this.nodeSelected(node);
        if (node != null && !node.isLoaded()) {
            if (node.getType() == 1) {
                this.loadSubNode(node);
            } else {
                if (node.getType() == 2) {
                    this._$1((FileTreeNodeEE)node, true, (byte)2);
                    return;
                }
                if (node.getType() == 0) {
                    this.refreshLocal();
                    this.refreshCloud();
                }
            }
            node.setExpanded(true);
            this.nodeStructureChanged(node);
        }
    }

    protected void menuAction(FileTreeNode node, JMenuItem mi) {
        super.menuAction(node, mi);
        this.nodeSelected(node);
        if (!GMSplSE.checkSerialNo()) {
            return;
        }
        String sAction = mi.getName();
        byte action = Byte.parseByte(sAction);
        switch (action) {
            case 30: 
            case 31: {
                short cmdId;
                if (node.getType() == 2) {
                    cmdId = action == 31 ? (short)2461 : 2401;
                } else {
                    return;
                }
                try {
                    GMSplEE.executeCmd(cmdId);
                }
                catch (Exception e) {
                    this.showException(e);
                }
                return;
            }
            case 33: {
                String cloudName = selectCloud;
                ICloudClientIDE cloud = FileTreeEE.getCloud(cloudName);
                try {
                    if (cloud.getType() == 2) {
                        GMSplEE.executeCmd((short)2463);
                    } else if (cloud.getType() == 1) {
                        GMSplEE.executeCmd((short)2403);
                    }
                }
                catch (Exception e) {
                    this.showException(e);
                }
                return;
            }
            case 35: {
                if (node.getUserObject() instanceof FileInfo) {
                    FileInfo fileInfo = (FileInfo)node.getUserObject();
                    if (fileInfo.canWrite()) {
                        try {
                            byte[] fileBytes = null;
                            SheetSplEE sheet = (SheetSplEE)((Object)GV.appFrame.getSheet(this.getCloudSheetName(node)));
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            sheet.saveOutStream(os);
                            fileBytes = os.toByteArray();
                            String filePath = FileTreeEE.getCloudPath(node);
                            if (filePath.startsWith("/")) {
                                filePath = filePath.substring(1);
                            }
                            ICloudClientIDE cloud = FileTreeEE.getCloud(((FileTreeNodeEE)node).getCloudName());
                            cloud.save(filePath, fileBytes, sheet.getArea());
                        }
                        catch (Throwable t) {
                            this.showException(t);
                        }
                    } else {
                        this.showException(mm.getMessage("filetree.nopritosave"));
                    }
                }
                return;
            }
            case 41: {
                int option;
                SheetSpl sheet;
                if (node == null) {
                    return;
                }
                String sheetName = this.getCloudSheetName(node);
                JInternalFrame jif = GV.appFrame.getSheet(sheetName);
                if (jif != null && (sheet = (SheetSpl)jif).isDataChanged() && (option = sheet.querySave(1)) == 2) {
                    return;
                }
                FileInfo fi = (FileInfo)node.getUserObject();
                String fileName = fi.getFilename();
                File f = GM.dialogSelectFile((Component)GV.appFrame, (String)"", (String)GV.lastDirectory, null, (String)fileName);
                if (f == null) {
                    return;
                }
                String cloudName = ((FileTreeNodeEE)node).getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                ICloudClientIDE cloud = FileTreeEE.getCloud(cloudName);
                String cloudPath = FileTreeEE.getCloudPath(node);
                cloud.dialogDownloadFile((Component)GV.appFrame, cloudPath, f, ((FileTreeNodeEE)node).getArea());
                return;
            }
            case 42: 
            case 43: {
                if (node == null) {
                    return;
                }
                String localDirPath = GM.dialogSelectDirectory((Component)GV.appFrame, (String)GV.lastDirectory);
                if (!StringUtils.isValidString((Object)localDirPath)) {
                    return;
                }
                File localDir = new File(localDirPath);
                String cloudName = ((FileTreeNodeEE)node).getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                File downloadDir = localDir;
                String dirName = null;
                Object obj = node.getUserObject();
                if (obj instanceof FileInfo) {
                    FileInfo fi = (FileInfo)obj;
                    dirName = new File(fi.getFilename()).getName();
                } else if (obj instanceof String) {
                    dirName = (String)obj;
                }
                int option = 0;
                if (dirName != null) {
                    downloadDir = localDir = new File(localDir, dirName);
                    if (downloadDir.exists()) {
                        option = JOptionPane.showOptionDialog((Component)GV.appFrame, mm.getMessage("filetreeee.existdirtodeal", (Object)downloadDir.getAbsolutePath()), mm.getMessage("filetreeee.download"), 1, 3, null, new String[]{mm.getMessage("filetreeee.replacefile"), mm.getMessage("filetreeee.skip"), mm.getMessage("filetreeee.canceldownload")}, mm.getMessage("filetreeee.replacefile"));
                        if (option == 2) {
                            return;
                        }
                    } else {
                        downloadDir.mkdirs();
                    }
                }
                ICloudClientIDE cloud = FileTreeEE.getCloud(cloudName);
                String cloudPath = FileTreeEE.getCloudPath(node);
                cloud.dialogDownloadDir((Component)GV.appFrame, cloudPath, downloadDir, action == 43, option, ((FileTreeNodeEE)node).getArea());
                return;
            }
            case 51: {
                String cloudName;
                String string = cloudName = node == null ? null : ((FileTreeNodeEE)node).getCloudName();
                if (cloudName == null) {
                    Vector<String> cloudNames;
                    if (!StringUtils.isValidString((Object)selectCloud) && !(cloudNames = FileTreeEE.getCloudNames()).isEmpty()) {
                        FileTreeEE.setSelectedCloudName(cloudNames.get(0));
                    }
                    cloudName = selectCloud;
                } else {
                    FileTreeEE.setSelectedCloudName(cloudName);
                }
                lIIllIIllIIllIlI dcuf = new lIIllIIllIIllIlI(this, (JFrame)GV.appFrame, this.getLogoImage(), "\"splx,spl,dfx\"", cloudName, node == null ? null : FileTreeEE.getCloudPath(node));
                if (node != null) {
                    byte area = ((FileTreeNodeEE)node).getArea();
                    dcuf.setArea(area);
                    ICloudClientIDE cloud = FileTreeEE.getCloud(cloudName);
                    if (cloud != null && cloud.getType() == 2) {
                        if (area == 1) {
                            dcuf.setDispArea(MAIN_DIR);
                        } else {
                            dcuf.setDispArea(STORE_DIR);
                        }
                    }
                }
                dcuf.setVisible(true);
                if (dcuf.isUploadFile()) {
                    this.refreshNode(node);
                }
                return;
            }
            case 52: {
                ICloudClientIDE cloud;
                String cloudName;
                String string = cloudName = node == null ? null : ((FileTreeNodeEE)node).getCloudName();
                if (cloudName == null) {
                    cloudName = selectCloud;
                }
                if ((cloud = FileTreeEE.getCloud(cloudName)) == null) {
                    return;
                }
                String sheetName = this.getCloudSheetName(node);
                JInternalFrame jif = GV.appFrame.getSheet(sheetName);
                if (jif != null && !((IDEBase)GV.appFrame).closeSheet((Object)jif)) {
                    return;
                }
                String cloudFilePath = FileTreeEE.getCloudPath(node);
                cloud.remove(cloudFilePath, ((FileTreeNodeEE)node).getArea());
                FileTreeNode parentNode = (FileTreeNode)node.getParent();
                if (parentNode != null) {
                    this.refreshNode(parentNode);
                }
                return;
            }
            case 53: {
                return;
            }
        }
    }

    public void refreshActiveNode() {
        FileTreeNode activeNode = this.getActiveNode();
        this.refreshNode(activeNode);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refreshNode(FileTreeNode node) {
        if (node == null) {
            return;
        }
        node.setLoaded(false);
        if (node.getType() == 2) {
            if (node.getLevel() != 1) {
                this._$1((FileTreeNodeEE)node, true, (byte)1);
                return;
            }
            this.refreshCloud();
        } else if (node.getType() == 1) {
            this.loadSubNode(node);
        } else if (node.getType() == 0) {
            this.refreshLocal();
            this.refreshCloud();
        }
        this.nodeStructureChanged(node);
        if (!node.isDir()) return;
        int i = 0;
        while (i < node.getChildCount()) {
            FileTreeNode subNode = (FileTreeNode)node.getChildAt(i);
            if (!subNode.isDir()) {
                TreePath path = new TreePath(subNode.getPath());
                this.expandPath(path);
                return;
            }
            ++i;
        }
    }

    protected ImageIcon getLogoImage() {
        return GM.getLogoImage((boolean)true);
    }

    protected JInternalFrame openSheetFile(String file) throws Exception {
        return GV.appFrame.openSheetFile(file);
    }

    protected JInternalFrame openSheetFile(InputStream in, String fileName, byte sheetType) throws Exception {
        return GV.appFrame.openSheetFile(in, fileName, sheetType);
    }

    public JInternalFrame getSheet(String title) {
        return GV.appFrame.getSheet(title);
    }

    public void setClosing() {
        this._$5 = true;
    }

    protected void showException(Object oMsg) {
        if (this._$5) {
            GM.outputMessage((Object)oMsg);
        } else {
            GM.showException((Component)GV.appFrame, (Object)oMsg, (boolean)true, (ImageIcon)this.getLogoImage());
        }
    }

    public void openFile(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            try {
                this.openSheetFile((String)node.getUserObject());
            }
            catch (Exception e) {
                this.showException(e);
            }
        } else if (o instanceof FileInfo) {
            if (!((FileInfo)o).canRead()) {
                this.showException(mm.getMessage("filetree.filecannotread", (Object)((FileInfo)o).getFilename()));
                return;
            }
            String cloudName = ((FileTreeNodeEE)node).getCloudName();
            byte area = ((FileTreeNodeEE)node).getArea();
            try {
                InputStream in;
                String fileName;
                if (node.getType() == 2) {
                    ICloudClientIDE cloud = FileTreeEE.getCloud(cloudName);
                    if (cloud == null) {
                        this.showException(mm.getMessage("filetree.servernotconnect", (Object)cloudName));
                        return;
                    }
                    fileName = FileTreeEE.getCloudPath(node);
                    if (!AppUtil.isSPLFile((String)fileName)) {
                        return;
                    }
                    in = cloud.open(fileName, area);
                    if (in == null) {
                        this.showException(mm.getMessage("filetree.isnotfound", (Object)fileName));
                        return;
                    }
                } else {
                    return;
                }
                byte sheetType = 1;
                fileName = this.getCloudSheetName(node);
                SheetSplEE sheet = (SheetSplEE)((Object)this.openSheetFile(in, fileName, sheetType));
                if (sheet != null) {
                    sheet.setArea(area);
                    sheet.createDebugger();
                }
            }
            catch (Exception e) {
                this.showException(e);
            }
        }
    }

    protected void nodeSelected(FileTreeNode node) {
        String cloudName;
        if (node == null) {
            return;
        }
        if (node.getType() == 2 && StringUtils.isValidString((Object)(cloudName = ((FileTreeNodeEE)node).getCloudName()))) {
            FileTreeEE.setSelectedCloudName(cloudName);
        }
    }

    public static void setSelectedCloudName(String cloudName) {
        selectCloud = cloudName;
    }

    protected JPopupMenu getPopupMenu(FileTreeNode node) {
        FileTree.MenuListener menuListener = new FileTree.MenuListener((FileTree)this, node);
        JPopupMenu popMenu = new JPopupMenu();
        byte type = node.getType();
        if (type == 1) {
            if (node.isDir()) {
                popMenu.add(this.getMenuItem((byte)2, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)4, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)21, (ActionListener)menuListener));
            } else {
                popMenu.add(this.getMenuItem((byte)1, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)3, (ActionListener)menuListener));
            }
            popMenu.add(this.getMenuItem((byte)5, (ActionListener)menuListener));
        } else if (type == 2) {
            if ((node.getUserObject() instanceof ICloudClientIDE || node.getUserObject() instanceof FileInfo || node.getUserObject() instanceof String) && type == 2) {
                FileTreeEE.setSelectedCloudName(((FileTreeNodeEE)node).getCloudName());
            }
            if (node.getLevel() == 1) {
                if (GVSplEE.isAIOEnabled.booleanValue()) {
                    popMenu.add(this.getMenuItem((byte)30, (ActionListener)menuListener));
                }
                if (SplEditorSE.isNodes()) {
                    popMenu.add(this.getMenuItem((byte)31, (ActionListener)menuListener));
                }
                popMenu.add(this.getMenuItem((byte)4, (ActionListener)menuListener));
                return popMenu;
            }
            if (node.getLevel() == 2) {
                if (!this._$4.isEmpty()) {
                    popMenu.add(this.getMenuItem((byte)33, (ActionListener)menuListener));
                }
                popMenu.add(this.getMenuItem((byte)4, (ActionListener)menuListener));
                return popMenu;
            }
            if (node.getLevel() == 3) {
                popMenu.add(this.getMenuItem((byte)33, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)51, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)4, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)42, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)43, (ActionListener)menuListener));
                return popMenu;
            }
            if (node.isDir()) {
                popMenu.add(this.getMenuItem((byte)51, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)4, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)42, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)43, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)21, (ActionListener)menuListener));
            } else {
                FileInfo fi;
                String fileName;
                boolean canOpen = true;
                Object obj = node.getUserObject();
                if (obj instanceof FileInfo && !AppUtil.isSPLFile((String)(fileName = (fi = (FileInfo)obj).getFilename()))) {
                    canOpen = false;
                }
                if (canOpen) {
                    popMenu.add(this.getMenuItem((byte)1, (ActionListener)menuListener));
                    JMenuItem saveMenu = this.getMenuItem((byte)35, (ActionListener)menuListener);
                    popMenu.add(saveMenu);
                    JInternalFrame o = this.getSheet(this.getCloudSheetName(node));
                    if (o != null) {
                        boolean canSave = true;
                        if (o instanceof SheetSplEE) {
                            SheetSplEE sheet = (SheetSplEE)((Object)o);
                            canSave = sheet.isDataChanged();
                        }
                        saveMenu.setEnabled(canSave);
                    } else {
                        saveMenu.setEnabled(false);
                    }
                }
                popMenu.add(this.getMenuItem((byte)41, (ActionListener)menuListener));
                popMenu.add(this.getMenuItem((byte)52, (ActionListener)menuListener));
            }
        }
        return popMenu;
    }

    private synchronized void _$1(FileTreeNodeEE cloudNode, boolean first, byte action) {
        if (action != 3) {
            this._$2();
        }
        IIIllIIllIIllIlI delayExecute = new IIIllIIllIIllIlI(this, cloudNode, first, action);
        delayExecute.start();
    }

    public static void loadCloudTree(FileTreeNodeEE cloudNode, boolean first, FileFilter filter) {
        if (cloudNode == null) {
            return;
        }
        cloudNode.removeAllChildren();
        if (cloudNode.getUserObject() instanceof ICloudClientIDE) {
            ICloudClientIDE cloud = (ICloudClientIDE)cloudNode.getUserObject();
            if (cloud == null) {
                return;
            }
            String cloudName = cloud.getName();
            if (cloud.getType() == 1) {
                FileTreeNodeEE dirNode = new FileTreeNodeEE(BUSINESS_DIR, 2);
                dirNode.setTitle(BUSINESS_DIR);
                dirNode.setDir(true);
                dirNode.setArea((byte)1);
                dirNode.setCloudName(cloudName);
                cloudNode.add((MutableTreeNode)((Object)dirNode));
                FileTreeEE.loadCloudTree(dirNode, true, filter);
                dirNode = new FileTreeNodeEE(BUFFER_DIR, 2);
                dirNode.setTitle(BUFFER_DIR);
                dirNode.setDir(true);
                dirNode.setArea((byte)2);
                dirNode.setCloudName(cloudName);
                cloudNode.add((MutableTreeNode)((Object)dirNode));
                FileTreeEE.loadCloudTree(dirNode, true, filter);
                dirNode = new FileTreeNodeEE(BACKUP_DIR, 2);
                dirNode.setTitle(BACKUP_DIR);
                dirNode.setDir(true);
                dirNode.setArea((byte)3);
                dirNode.setCloudName(cloudName);
                cloudNode.add((MutableTreeNode)((Object)dirNode));
                FileTreeEE.loadCloudTree(dirNode, true, filter);
            } else if (cloud.getType() == 2) {
                FileTreeNodeEE dirNode = new FileTreeNodeEE(MAIN_DIR, 2);
                dirNode.setTitle(MAIN_DIR);
                dirNode.setDir(true);
                dirNode.setArea((byte)1);
                dirNode.setCloudName(cloudName);
                cloudNode.add((MutableTreeNode)((Object)dirNode));
                FileTreeEE.loadCloudTree(dirNode, true, filter);
                dirNode = new FileTreeNodeEE(STORE_DIR, 2);
                dirNode.setTitle(STORE_DIR);
                dirNode.setDir(true);
                dirNode.setArea((byte)2);
                dirNode.setCloudName(cloudName);
                cloudNode.add((MutableTreeNode)((Object)dirNode));
                FileTreeEE.loadCloudTree(dirNode, true, filter);
            }
            cloudNode.setExpanded(true);
            cloudNode.setLoaded(true);
        } else if (cloudNode.getUserObject() instanceof FileInfo || cloudNode.getUserObject() instanceof String) {
            FileTreeNodeEE node;
            String fileName;
            boolean isDir;
            List<FileInfo> subFiles;
            ICloudClientIDE cloud = FileTreeEE.getCloud(cloudNode.getCloudName());
            if (cloud == null) {
                return;
            }
            byte area = cloudNode.getArea();
            if (cloudNode.getUserObject() instanceof String) {
                subFiles = cloud.listFiles("", area);
                if (subFiles == null && cloudNode.getArea() == 2 && STORE_DIR.equals(cloudNode.getTitle())) {
                    FileTreeNodeEE pNode = (FileTreeNodeEE)((Object)cloudNode.getParent());
                    if (pNode != null) {
                        pNode.remove((MutableTreeNode)((Object)cloudNode));
                    }
                    return;
                }
            } else {
                String p = FileTreeEE.getCloudPath(cloudNode);
                subFiles = cloud.listFiles(p, area);
            }
            if (subFiles == null || subFiles.size() <= 0) {
                return;
            }
            if (!first) {
                FileInfo fileInfo = subFiles.get(0);
                String fileName2 = fileInfo.getFilename();
                FileTreeNodeEE node2 = new FileTreeNodeEE(fileInfo, 2);
                node2.setTitle(fileName2);
                node2.setCloudName(cloud.getName());
                node2.setArea(area);
                node2.setDir(fileInfo.isDirectory());
                cloudNode.add((MutableTreeNode)((Object)node2));
                return;
            }
            for (FileInfo fileInfo : subFiles) {
                if (fileInfo == null || !(isDir = fileInfo.isDirectory()) || !StringUtils.isValidString((Object)(fileName = fileInfo.getFilename()))) continue;
                node = new FileTreeNodeEE(fileInfo, 2);
                node.setTitle(fileName);
                node.setCloudName(cloud.getName());
                node.setArea(area);
                node.setDir(isDir);
                cloudNode.add((MutableTreeNode)((Object)node));
                if (!first) continue;
                FileTreeEE.loadCloudTree(node, false, filter);
            }
            for (FileInfo fileInfo : subFiles) {
                if (fileInfo == null || (isDir = fileInfo.isDirectory()) || !StringUtils.isValidString((Object)(fileName = fileInfo.getFilename()))) continue;
                node = new FileTreeNodeEE(fileInfo, 2);
                node.setTitle(fileName);
                node.setCloudName(cloud.getName());
                node.setArea(area);
                if (!filter.isValidFile(fileName)) continue;
                node.setDir(isDir);
                cloudNode.add((MutableTreeNode)((Object)node));
            }
        }
    }

    public boolean isValidFile(byte type, String fileName) {
        if (type == 1) {
            return super.isValidFile(type, fileName);
        }
        return true;
    }

    protected String getCloudSheetName(FileTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof FileInfo) {
            String cloudName = ((FileTreeNodeEE)node).getCloudName();
            ICloudClientIDE cloud = FileTreeEE.getCloud(cloudName);
            if (cloud == null) {
                new Throwable(mm.getMessage("filetree.servernotconnect", (Object)cloudName));
            }
            String fileName = FileTreeEE.getCloudPath(node);
            fileName = cloudName + ":" + fileName;
            return fileName;
        }
        return null;
    }

    public List<ICloudClientIDE> getCloudList() {
        return this._$4;
    }

    public boolean isAIOLogin() {
        if (this._$4 != null) {
            for (ICloudClientIDE cc : this._$4) {
                if (cc.getType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isECloudLogin() {
        if (this._$4 != null) {
            for (ICloudClientIDE cc : this._$4) {
                if (cc.getType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    public void addCloud(ICloudClientIDE cloud) {
        if (this.cloudRoot == null) {
            this.cloudRoot = new FileTreeNodeEE("", 2);
            this.cloudRoot.setDir(true);
            this.cloudRoot.setTitle(_$2);
            this.root.add((MutableTreeNode)((Object)this.cloudRoot));
        }
        if (this._$4 == null) {
            this._$4 = new ArrayList<ICloudClientIDE>();
        }
        this._$4.add(cloud);
        FileTreeNodeEE cloudNode = new FileTreeNodeEE(cloud, 2);
        cloudNode.setDir(true);
        cloudNode.setExpanded(true);
        cloudNode.setTitle(cloud.getName());
        cloudNode.setCloudName(cloud.getName());
        this.cloudRoot.add((MutableTreeNode)((Object)cloudNode));
        this.cloudRoot.setTitle(_$3);
        this.cloudRoot.setExpanded(true);
        this.cloudRoot.setLoaded(true);
        FileTreeEE.setSelectedCloudName(cloud.getName());
        try {
            this._$1(cloudNode, true, (byte)0);
        }
        catch (Throwable t) {
            this.showException(t);
        }
    }

    public void deleteCloud(ICloudClientIDE cloud) {
        Vector<String> cloudNames;
        if (this._$4 == null || cloud == null) {
            return;
        }
        JInternalFrame[] sheets = GV.appFrame.getAllSheets();
        if (sheets != null) {
            for (JInternalFrame sheet : sheets) {
                String sheetName;
                if (sheet == null || !(sheet instanceof SheetSplEE) || !StringUtils.isValidString((Object)(sheetName = sheet.getTitle())) || !sheetName.startsWith(cloud.getName() + ":")) continue;
                SheetSplEE cloudSheet = (SheetSplEE)((Object)sheet);
                if (cloudSheet.isDataChanged()) {
                    int option = cloudSheet.querySave(0);
                    if (option == 0) {
                        cloudSheet.save();
                    } else {
                        cloudSheet.setDataChanged(false);
                    }
                }
                ((IDEBase)GV.appFrame).closeSheet((Object)cloudSheet);
            }
        }
        try {
            cloud.logout();
        }
        catch (Throwable e) {
            this.showException(e);
        }
        this._$4.remove(cloud);
        this.cloudRoot.setLoaded(false);
        int cc = this.cloudRoot.getChildCount();
        for (int i = 0; i < cc; ++i) {
            FileTreeNodeEE cloudNode = (FileTreeNodeEE)((Object)this.cloudRoot.getChildAt(i));
            if (cloudNode == null || !cloud.getName().equals(cloudNode.getCloudName())) continue;
            this.cloudRoot.remove((MutableTreeNode)((Object)cloudNode));
            break;
        }
        this.nodeStructureChanged(this.cloudRoot);
        if (cloud.getName().equals(selectCloud) && this._$4.size() > 0 && !(cloudNames = FileTreeEE.getCloudNames()).isEmpty()) {
            FileTreeEE.setSelectedCloudName(cloudNames.get(0));
        }
        GVSplEE.jSPFileTree.closeNode();
    }

    public static String getCloudPath(FileTreeNode node) {
        if (node == null || node.getType() != 2) {
            return "";
        }
        if (node.getUserObject() instanceof ICloudClientIDE || node.getUserObject() instanceof String) {
            return "";
        }
        if (node.getUserObject() instanceof FileInfo) {
            String path = node.getName();
            for (FileTreeNode pNode = (FileTreeNode)node.getParent(); pNode != null && pNode.getType() == 2; pNode = (FileTreeNode)pNode.getParent()) {
                String p = pNode.getTitle();
                if (!StringUtils.isValidString((Object)p) || !(pNode.getUserObject() instanceof FileInfo)) continue;
                path = p + "/" + path;
            }
            return path;
        }
        return "/";
    }

    public static ICloudClientIDE getCloud(String cloudName) {
        if (!StringUtils.isValidString((Object)cloudName)) {
            return null;
        }
        List<ICloudClientIDE> cloudList = GVSplEE.getResourceTree().getCloudList();
        if (cloudList != null) {
            for (ICloudClientIDE cloud : cloudList) {
                if (!cloudName.equals(cloud.getName())) continue;
                return cloud;
            }
        }
        return null;
    }

    public static Vector<String> getCloudNames() {
        Vector<String> cloudNames = new Vector<String>();
        List<ICloudClientIDE> cloudList = GVSplEE.getResourceTree().getCloudList();
        if (cloudList != null) {
            for (ICloudClientIDE cloud : cloudList) {
                cloudNames.add(cloud.getName());
            }
        }
        return cloudNames;
    }

    private void _$1(JWindow jwindow) {
        int treeWidth = this.getWidth();
        if (treeWidth < 10) {
            GM.centerWindow((Component)jwindow);
            return;
        }
        Dimension winSize = jwindow.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (winSize.height > screenSize.height) {
            winSize.height = screenSize.height;
        }
        int x = GM.getAbsolutePos((Component)((Object)this), (boolean)true);
        x = winSize.width > treeWidth ? (x += 20) : (x += (treeWidth - winSize.width) / 2);
        jwindow.setLocation(x, (screenSize.height - winSize.height) / 2);
    }

    static /* synthetic */ List _$2(FileTreeEE x0) {
        return x0._$4;
    }

    static /* synthetic */ void _$1(FileTreeEE x0, FileTreeNodeEE x1, boolean x2, byte x3) {
        x0._$1(x1, x2, x3);
    }

    static /* synthetic */ void _$1(FileTreeEE x0) {
        x0._$1();
    }

    static /* synthetic */ boolean _$1(FileTreeEE x0, boolean x1) {
        x0._$6 = x1;
        return x0._$6;
    }

    static {
        _$3 = mm.getMessage("filetree.cloudfileresource");
        _$2 = mm.getMessage("filetree.nocloudresource");
    }
}

