/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigMenuAction;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.spl.dql.ConfigFile;
import com.scudata.ide.spl.dql.ConfigOptions;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.GVDql;
import com.scudata.ide.spl.dql.ICloudClientDql;
import com.scudata.ide.spl.dql.IIIlIIlIlllIlIII;
import com.scudata.ide.spl.dql.lIIlIIlIlllIlIII;
import com.scudata.ide.spl.dql.llllIIlIlllIlIII;
import com.scudata.ide.spl.dql.resources.IdeDqlMessage;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MenuFactory
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    public JMenuItem[] connItem = new JMenuItem[5];
    public JMenuItem[] fileItem = new JMenuItem[20];
    protected JMenu tmpLiveMenu;
    protected static HashSet liveMenuItems = new HashSet();
    protected static JMenu liveMenu;
    protected static HashMap<Short, Object> menuItems;
    private final String _$3 = "live_";
    protected final String ROOT = "RAQSOFT/";
    protected final String NODE_RECENT_FILE = "RECENTFILES/";
    protected final String NODE_RECENT_CONN = "RECENTCONNECTIONS/";
    public static final String APP_NAME = "dm";
    public static JMenu windowMenu;
    public static JMenu helpMenu;
    protected static HashSet tmpLiveMenuItems;
    private MessageManager _$2 = IdeDqlMessage.get();
    private static ActionListener _$1;

    public void setEnable(short[] menuIds, boolean enable) {
        for (int i = 0; i < menuIds.length; ++i) {
            JMenuItem mi = (JMenuItem)menuItems.get(menuIds[i]);
            if (mi == null) continue;
            mi.setEnabled(enable);
        }
    }

    public JMenuItem getJMenuItem(short menuId) {
        return (JMenuItem)menuItems.get(menuId);
    }

    public void addLiveMenu(String sheetTitle) {
        lIIlIIlIlllIlIII action = new lIIlIIlIlllIlIII(this);
        if (liveMenu == null) {
            return;
        }
        JMenuItem mi = GMDql.getMenuByName((JMenuBar)this, (String)("live_" + sheetTitle));
        this._$2();
        if (mi == null) {
            if (liveMenu.getItemCount() == 4) {
                liveMenu.addSeparator();
            }
            JMenuItem rmi = new JMenuItem(sheetTitle);
            rmi.setName("live_" + sheetTitle);
            rmi.addActionListener(action);
            liveMenu.add(rmi);
            liveMenuItems.add(rmi);
            rmi.setIcon(this._$1(true));
        } else {
            JMenuItem rmi = mi;
            rmi.setIcon(this._$1(true));
        }
    }

    private Icon _$1(boolean isSelected) {
        if (isSelected) {
            return GMDql.getMenuImageIcon("selected");
        }
        return GMDql.getMenuImageIcon("blank");
    }

    public void removeLiveMenu(String sheetTitle) {
        JMenuItem mi = GMDql.getMenuByName((JMenuBar)this, (String)("live_" + sheetTitle));
        if (mi != null) {
            liveMenu.remove(mi);
            liveMenuItems.remove(mi);
        }
        if (liveMenu != null && liveMenu.getItemCount() == 5) {
            liveMenu.remove(4);
        }
    }

    public void removeAllLiveMenu() {
        liveMenuItems.clear();
        if (liveMenu != null && liveMenu.getItemCount() >= 5) {
            int ic = liveMenu.getItemCount();
            for (int i = ic - 1; i >= 4; --i) {
                liveMenu.remove(i);
            }
        }
    }

    public void renameLiveMenu(String srcName, String tarName) {
        JMenuItem mi = GMDql.getMenuByName((JMenuBar)this, (String)srcName);
        if (mi != null) {
            mi.setName(tarName);
            mi.setText(tarName);
        }
    }

    private void _$2() {
        for (JMenuItem rmi : liveMenuItems) {
            rmi.setIcon(this._$1(false));
        }
    }

    public void refreshRecentConn(String dsName) {
        String tempConnName;
        int i;
        if (!StringUtils.isValidString((Object)dsName)) {
            return;
        }
        int point = 4;
        for (i = 0; i < 5; ++i) {
            tempConnName = this.connItem[i].getText();
            if (!dsName.equals(tempConnName)) continue;
            point = i;
            break;
        }
        for (i = point; i > 0; --i) {
            tempConnName = this.connItem[i - 1].getText();
            this.connItem[i].setText(tempConnName);
            this.connItem[i].setVisible(!tempConnName.equals(""));
        }
        this.connItem[0].setText(dsName);
        this.connItem[0].setVisible(true);
        this.storeRecentConnections();
    }

    public void storeRecentConnections() {
        try {
            ConfigFile cf = ConfigFile.getConfigFile();
            XMLFile configFile = cf.xmlFile();
            String path = "RAQSOFT/RECENTCONNECTIONS";
            if (!configFile.isPathExists(path)) {
                configFile.newElement("RAQSOFT", "RECENTCONNECTIONS");
            }
            for (int i = 0; i < 5; ++i) {
                String sTmp = "c" + i;
                configFile.setAttribute(path + "/" + sTmp, this.connItem[i].getText());
            }
            configFile.save();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void storeRecentFiles() {
        try {
            ConfigFile cf = ConfigFile.getConfigFile();
            XMLFile configFile = cf.xmlFile();
            String path = "RAQSOFT/dm";
            if (!configFile.isPathExists(path)) {
                configFile.newElement("RAQSOFT", APP_NAME);
            }
            if (!configFile.isPathExists(path = path + "/RECENTFILES")) {
                configFile.newElement("RAQSOFT/dm", "RECENTFILES");
            }
            for (int i = 0; i < 20; ++i) {
                String sTmp = "f" + i;
                configFile.setAttribute(path + "/" + sTmp, this.fileItem[i].getText());
            }
            configFile.save();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void setMenuIdEnabled(short menuId, boolean enable) {
        JMenuItem mi = (JMenuItem)menuItems.get(menuId);
        if (mi != null) {
            mi.setEnabled(enable);
        }
    }

    public void setMenuIdVisible(short menuId, boolean vis) {
        JMenuItem mi = (JMenuItem)menuItems.get(menuId);
        if (mi != null) {
            mi.setVisible(vis);
        }
    }

    public static ImageIcon getImageIcon(String menuId) {
        int dot = menuId.indexOf(".");
        String iconText = dot > 0 ? menuId.substring(dot + 1) : menuId;
        String iconPath = "/com/scudata/ide/spl/dql/images/m_" + iconText.toLowerCase() + ".png";
        ImageIcon ii = GMDql.getImageIcon((String)iconPath, (boolean)false);
        if (ii == null) {
            iconPath = "/com/scudata/ide/spl/dql/images/m_" + iconText.toLowerCase() + ".gif";
            return GMDql.getImageIcon((String)iconPath);
        }
        return ii;
    }

    public void resetLiveMenu() {
        liveMenuItems = tmpLiveMenuItems;
        liveMenu = this.tmpLiveMenu;
    }

    protected JMenu getSystemMenu() {
        JMenu menu = this.getMenu("system", 'T', true);
        JMenuItem mi = this.newMenuItem((short)4435, "system.datasource", 'S', Boolean.FALSE, true);
        mi.setVisible(GVDql.isDBEnabled);
        mi.setEnabled(GVDql.isDBEnabled);
        menu.add(mi);
        menu.add(this.newMenuItem((short)4433, "system.options", 'O', Boolean.FALSE, true));
        return menu;
    }

    protected JMenu getAIOMenu() {
        MessageManager mm = IdeSplMessage.get();
        boolean hasCloud = false;
        if (GVDql.fileTree != null) {
            List<ICloudClientDql> cloudList = GVDql.fileTree.getCloudList();
            hasCloud = cloudList != null && !cloudList.isEmpty();
        }
        JMenu menu = this.getMenu("aio", 'A', true);
        menu.add(this.newMenuItem((short)2401, "cloud.login", 'L', Boolean.FALSE, true, mm));
        JMenuItem mi = this.newMenuItem((short)2403, "cloud.logout", 'O', Boolean.FALSE, false, mm);
        mi.setEnabled(hasCloud);
        menu.add(mi);
        menu.addSeparator();
        mi = this.newMenuItem((short)2411, "cloud.updatesystem", 'S', Boolean.FALSE, false, mm);
        mi.setEnabled(hasCloud);
        menu.add(mi);
        mi = this.newMenuItem((short)2413, "cloud.uploadextlib", 'E', Boolean.FALSE, false, mm);
        mi.setEnabled(hasCloud);
        menu.add(mi);
        mi = this.newMenuItem((short)2415, "cloud.uploaddriver", 'D', Boolean.FALSE, false, mm);
        mi.setEnabled(hasCloud);
        menu.add(mi);
        menu.addSeparator();
        mi = this.newMenuItem((short)2441, "cloud.uploadfile", 'U', Boolean.FALSE, true, mm);
        mi.setEnabled(hasCloud);
        menu.add(mi);
        mi = this.newMenuItem((short)2443, "cloud.downloadfile", 'W', Boolean.FALSE, false, mm);
        mi.setEnabled(hasCloud);
        menu.add(mi);
        menu.addSeparator();
        JMenuItem scMenu = this.newMenuItem((short)4483, "cloud.setconfig", 'C', Boolean.FALSE, false);
        scMenu.setEnabled(hasCloud);
        menu.add(scMenu);
        JMenuItem dqMenu = this.newMenuItem((short)4481, "system.dqlquery", 'Q', Boolean.FALSE, true);
        dqMenu.setEnabled(hasCloud);
        menu.add(dqMenu);
        JMenuItem stMenu = this.newMenuItem((short)4485, "system.searchtest", 'T', Boolean.FALSE, false);
        stMenu.setEnabled(hasCloud);
        menu.add(stMenu);
        return menu;
    }

    protected JMenu getWindowMenu() {
        if (windowMenu != null) {
            return windowMenu;
        }
        JMenu menu = this.getMenu("window", 'W', true);
        menu.add(this.newMenuItem((short)205, "window.cascade", 'C', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)210, "window.tilehorizontal", 'H', Boolean.FALSE));
        menu.add(this.newMenuItem((short)215, "window.tilevertical", 'V', Boolean.FALSE));
        menu.add(this.newMenuItem((short)220, "window.layer", 'L', Boolean.FALSE));
        windowMenu = menu;
        return menu;
    }

    protected JMenu getHelperMenu() {
        if (helpMenu != null) {
            return helpMenu;
        }
        JMenu menu = this.getMenu("help", 'H', true);
        List configMenus = this._$1();
        for (int i = 0; i < configMenus.size(); ++i) {
            Object o = configMenus.get(i);
            if (o instanceof JMenu) {
                menu.add((Component)((JMenu)o), i);
                ((JMenu)o).setIcon(GMDql.getMenuImageIcon("blank"));
                continue;
            }
            if (o instanceof JMenuItem) {
                menu.add((Component)((JMenuItem)o), i);
                ((JMenuItem)o).setIcon(GMDql.getMenuImageIcon("blank"));
                continue;
            }
            if (!(o instanceof JSeparator)) continue;
            menu.add((Component)((JSeparator)o), i);
        }
        menu.add(this.newMenuItem((short)1005, "help.about", 'A', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)1007, "help.serialnumber", 'S', Boolean.FALSE, false));
        menu.add(this.newMenuItem((short)1010, "help.clearmemory", 'C', Boolean.FALSE));
        helpMenu = menu;
        return menu;
    }

    private List _$1() {
        ArrayList<JComponent> helpMenus = new ArrayList<JComponent>();
        try {
            String menuConfigPath = GMDql.getAbsolutePath((String)("config/dqlmenuconfig" + GMDql.getLanguageSuffix() + "." + "xml"));
            File menuConfigFile = new File(menuConfigPath);
            if (!menuConfigFile.isFile() || !menuConfigFile.exists()) {
                return helpMenus;
            }
            Document doc = null;
            doc = this._$1(menuConfigPath);
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node el = list.item(i);
                if (!el.getNodeName().equalsIgnoreCase("help")) continue;
                NodeList helpList = el.getChildNodes();
                for (int j = 0; j < helpList.getLength(); ++j) {
                    el = helpList.item(j);
                    if (el.getNodeName().equalsIgnoreCase("menu")) {
                        helpMenus.add(this._$1(el));
                        continue;
                    }
                    if (el.getNodeName().equalsIgnoreCase("menuitem")) {
                        JMenuItem mi = MenuFactory.getNewItem(el);
                        if (mi == null) continue;
                        helpMenus.add(mi);
                        continue;
                    }
                    if (!el.getNodeName().equalsIgnoreCase("separator")) continue;
                    helpMenus.add(new JSeparator());
                }
            }
        }
        catch (Exception ex) {
            GMDql.writeLog((Object)ex);
        }
        return helpMenus;
    }

    private Document _$1(String filename) throws Exception {
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        doc = docBuilder.parse(new File(filename));
        return doc;
    }

    private JMenu _$1(Node rootEl) {
        NodeList list = rootEl.getChildNodes();
        NamedNodeMap tmp = rootEl.getAttributes();
        JMenu menu = new JMenu(tmp.getNamedItem("text").getNodeValue());
        menu.setName(tmp.getNamedItem("name").getNodeValue());
        String hk = tmp.getNamedItem("hotKey").getNodeValue();
        if (hk != null && !hk.trim().equals("")) {
            menu.setMnemonic(hk.charAt(0));
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node el = list.item(i);
            if (el.getNodeName().equalsIgnoreCase("Separator")) {
                menu.addSeparator();
                continue;
            }
            if (!el.getNodeName().equalsIgnoreCase("menuitem")) continue;
            try {
                JMenuItem mi = MenuFactory.getNewItem(el);
                if (mi == null) continue;
                menu.add(mi);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return menu;
    }

    public static JMenuItem getNewItem(Node el) throws Exception {
        NodeList list = el.getChildNodes();
        NamedNodeMap tmp = el.getAttributes();
        Node node = tmp.getNamedItem("text");
        if (node == null) {
            return null;
        }
        String a = node.getNodeValue();
        node = MenuFactory._$1(list, "commonderClass");
        if (node == null) {
            return null;
        }
        String classname = node.getNodeValue();
        node = MenuFactory._$1(list, "commonderArgs");
        if (node == null) {
            return null;
        }
        String pathname = node.getNodeValue();
        JMenuItem jmenuitem = new JMenuItem(a);
        ConfigMenuAction cma = (ConfigMenuAction)Class.forName(classname).newInstance();
        cma.setConfigArgument(pathname);
        jmenuitem.addActionListener((ActionListener)cma);
        String hk = tmp.getNamedItem("hotKey").getNodeValue();
        if (hk != null && !"".equals(hk)) {
            jmenuitem.setMnemonic(hk.charAt(0));
        }
        return jmenuitem;
    }

    private static Node _$1(NodeList list, String key) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals(key)) continue;
            return node.getChildNodes().item(0);
        }
        return null;
    }

    public JMenuItem cloneMenuItem(short cmdId) {
        JMenuItem mItem = new JMenuItem();
        JMenuItem jmi = (JMenuItem)menuItems.get(cmdId);
        String text = jmi.getText();
        int pos = text.indexOf("(");
        if (pos > 0) {
            text = text.substring(0, pos);
        }
        mItem.setText(text);
        short cmd = Short.parseShort(jmi.getName());
        mItem.setName(Integer.toString(cmd));
        mItem.setIcon(jmi.getIcon());
        mItem.setVisible(jmi.isVisible());
        mItem.setEnabled(jmi.isEnabled());
        mItem.setAccelerator(jmi.getAccelerator());
        mItem.addActionListener(_$1);
        return mItem;
    }

    protected JMenu getMenuItem(boolean isMainMenu, String menuId, char mneKey) {
        return this.getMenuItem(isMainMenu, menuId, mneKey, true);
    }

    protected JMenu getMenuItem(boolean isMainMenu, String menuId, char mneKey, boolean convert) {
        String text = convert ? this._$2.getMessage("menu." + menuId) : menuId;
        JMenu mItem = new JMenu(text);
        if (!isMainMenu) {
            mItem.setIcon(GMDql.getMenuImageIcon("blank"));
        }
        if (StringUtils.isValidString((Object)String.valueOf(mneKey))) {
            mItem.setMnemonic(mneKey);
        }
        return mItem;
    }

    protected JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator) {
        return this.newMenuItem(cmdId, menuId, mneKey, accelerator, false);
    }

    protected JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator, boolean hasIcon) {
        return this.newMenuItem(cmdId, menuId, mneKey, accelerator, hasIcon, this._$2);
    }

    protected JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, Boolean accelerator, boolean hasIcon, MessageManager mm) {
        JMenuItem mItem = this._$1(cmdId, menuId, mneKey, accelerator, hasIcon, mm);
        mItem.addActionListener(_$1);
        menuItems.put(cmdId, mItem);
        return mItem;
    }

    private JMenuItem _$1(short cmdId, String menuId, char mneKey, Boolean accelerator, boolean hasIcon, MessageManager mm) {
        JMenuItem mItem = new JMenuItem(mm.getMessage("menu." + menuId), mneKey);
        mItem.setName(Short.toString(cmdId));
        if (hasIcon) {
            mItem.setIcon(GMDql.getMenuImageIcon(menuId));
        } else {
            mItem.setIcon(GMDql.getMenuImageIcon("blank"));
        }
        if (accelerator == null) {
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, 0);
            mItem.setAccelerator(ks);
        } else if (accelerator.booleanValue()) {
            int mask = 2;
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, mask);
            mItem.setAccelerator(ks);
        }
        return mItem;
    }

    public JMenu getRecentFile() {
        IIIlIIlIlllIlIII actionNew = new IIIlIIlIlllIlIII(this);
        try {
            JMenu menu = this.getMenu("file.recentfiles", 'F', false);
            ConfigFile.getConfigFile().loadRecentFiles(this.fileItem);
            for (int i = 0; i < 20; ++i) {
                this.fileItem[i].addActionListener(actionNew);
                menu.add(this.fileItem[i]);
                if (i != 0 || !StringUtils.isValidString((Object)this.fileItem[0].getText()) || !ConfigOptions.bAutoOpen.booleanValue() || StringUtils.isValidString((Object)GVDql.autoOpenFileName)) continue;
                GVDql.autoOpenFileName = this.fileItem[0].getText();
            }
            return menu;
        }
        catch (Throwable t) {
            GMDql.showException((Component)GV.appFrame, (Object)t);
            return null;
        }
    }

    private void _$1(JMenuItem tt, Action actionNew) {
        File f;
        if (StringUtils.isValidString((Object)tt.getText()) && !(f = new File(tt.getText())).exists() && this.fileItem != null) {
            int len = this.fileItem.length;
            int index = -1;
            for (int i = 0; i < len; ++i) {
                if (!tt.getText().equalsIgnoreCase(this.fileItem[i].getText())) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return;
            }
            JMenuItem[] newFileItem = new JMenuItem[20];
            if (index > 0) {
                System.arraycopy(this.fileItem, 0, newFileItem, 0, index);
            }
            if (index < len - 1) {
                System.arraycopy(this.fileItem, index + 1, newFileItem, index, len - index - 1);
            }
            newFileItem[len - 1] = new JMenuItem("");
            newFileItem[len - 1].setVisible(false);
            newFileItem[len - 1].addActionListener(actionNew);
            this.fileItem = newFileItem;
            try {
                this.storeRecentFiles();
            }
            catch (Throwable e1) {
                Logger.error((Object)e1);
            }
            try {
                ConfigFile.getConfigFile().loadRecentFiles(this.fileItem);
            }
            catch (Throwable e1) {
                Logger.error((Object)e1);
            }
        }
    }

    public void refreshRecentFile(String fileName) {
        String tempFileName;
        int i;
        if (!StringUtils.isValidString((Object)fileName)) {
            return;
        }
        int point = 19;
        for (i = 0; i < this.fileItem.length; ++i) {
            tempFileName = this.fileItem[i].getText();
            if (!fileName.equals(tempFileName)) continue;
            point = i;
            break;
        }
        for (i = point; i > 0; --i) {
            tempFileName = this.fileItem[i - 1].getText();
            this.fileItem[i].setText(tempFileName);
            this.fileItem[i].setVisible(!tempFileName.equals(""));
        }
        this.fileItem[0].setText(fileName);
        this.fileItem[0].setVisible(true);
        this.storeRecentFiles();
    }

    protected JMenu getMenu(String menuText, char mneKey, boolean isMainMenu) {
        menuText = this._$2.getMessage("menu." + menuText);
        return GMDql.getMenu(menuText, mneKey, isMainMenu);
    }

    static /* synthetic */ Icon _$1(MenuFactory x0, boolean x1) {
        return x0._$1(x1);
    }

    static /* synthetic */ void _$1(MenuFactory x0, JMenuItem x1, Action x2) {
        x0._$1(x1, x2);
    }

    static {
        menuItems = new HashMap();
        tmpLiveMenuItems = new HashSet();
        _$1 = new llllIIlIlllIlIII();
    }
}

