/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.query.metadata.DataMaintenanceTable;
import com.scudata.dm.query.utils.IOUtil;
import com.scudata.dm.query.utils.JsonUtils;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.dql.ConfigOptions;
import com.scudata.ide.spl.dql.GCDql;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.GVDql;
import com.scudata.ide.spl.dql.ICloudClientDql;
import com.scudata.ide.spl.dql.IIllllIIllIIIIIl;
import com.scudata.ide.spl.dql.ISheetDql;
import com.scudata.ide.spl.dql.IllIIIIlIIlllIIl;
import com.scudata.ide.spl.dql.MenuDataMaintenance;
import com.scudata.ide.spl.dql.ToolBarDataMaintenance;
import com.scudata.ide.spl.dql.base.FileTree;
import com.scudata.ide.spl.dql.base.PanelDataMaintenanceTable;
import com.scudata.ide.spl.dql.resources.IdeDqlMessage;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class SheetDataMaintenance
extends ISheetDql {
    private static final long serialVersionUID = 1L;
    private MessageManager _$8 = IdeDqlMessage.get();
    private DataMaintenanceTable _$7;
    private boolean _$6 = false;
    private PanelDataMaintenanceTable _$5 = new IllIIIIlIIlllIIl(this);

    public SheetDataMaintenance(String filePath, DataMaintenanceTable dmt) throws Exception {
        super(filePath);
        this.filePath = filePath;
        this._$7 = dmt;
        this.setTitle(this.filePath);
        this._$3();
    }

    public SheetDataMaintenance(String filePath, InputStream in) throws Exception {
        super(filePath);
        this.filePath = filePath;
        this._$7 = IOUtil.readDataMaintenanceTable(in);
        this.setTitle(this.filePath);
        this._$3();
    }

    public void resetEnv() {
    }

    private void _$3() {
        this.getContentPane().add((Component)this._$5, "Center");
        this.addInternalFrameListener(new IIllllIIllIIIIIl(this, this));
        this.setDefaultCloseOperation(0);
        this._$5.setDataMaintenanceTable(this._$7);
    }

    public String getSheetTitle() {
        return this.filePath;
    }

    public boolean save() {
        if (!this._$2()) {
            return false;
        }
        if (GMDql.isNewGrid(this.filePath, GCDql.NEW_DATA_M) || !this.filePath.toLowerCase().endsWith("json")) {
            return this.saveAs();
        }
        if (this.type == 1) {
            String serverName = this.filePath.substring(0, this.filePath.indexOf(58));
            if (StringUtils.isValidString((Object)serverName)) {
                String fileName = this.filePath.substring(this.filePath.indexOf(58) + 1).replaceAll("\\\\", "/");
                if (fileName.startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                try {
                    ICloudClientDql cloud;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    JsonUtils.writeJsonToStream(out, this._$7.toJsonString());
                    if (this.type == 1 && (cloud = FileTree.getCloud(serverName)) != null) {
                        cloud.save(fileName, out.toByteArray(), (byte)1);
                        this.setDataChanged(false);
                        return true;
                    }
                }
                catch (Exception e) {
                    GMDql.showException((Component)GV.appFrame, (Object)e);
                    return false;
                }
            }
            return false;
        }
        try {
            File f = new File(this.filePath);
            if (f.exists() && !f.canWrite()) {
                String msg = IdeDqlMessage.get().getMessage("public.readonly", (Object)f.getName());
                JOptionPane.showMessageDialog((Component)GVDql.appFrame, msg);
                return false;
            }
            if (ConfigOptions.bAutoBackup.booleanValue()) {
                String saveFile = this.filePath + ".bak";
                File fb = new File(saveFile);
                fb.delete();
                f.renameTo(fb);
            }
            if (f.exists() && f.isFile()) {
                f.delete();
            }
            IOUtil.writeDataMaintenanceTable(this.filePath, this._$7);
            GVDql.appMenu.refreshRecentFile(this.filePath);
            this.setDataChanged(false);
            return true;
        }
        catch (Exception ex) {
            GMDql.showException((Component)GV.appFrame, (Object)ex);
            return false;
        }
    }

    private boolean _$2() {
        if (!this._$5.isValidData()) {
            return false;
        }
        this._$7 = this._$5.getDataMaintenanceTable();
        return true;
    }

    public boolean saveOutStream(OutputStream os, boolean refreshRecent) throws Exception {
        if (!this._$2()) {
            return false;
        }
        JsonUtils.writeJsonToStream(os, this._$7.toJsonString());
        if (refreshRecent) {
            GVDql.appMenu.refreshRecentFile(this.filePath);
        }
        this.setDataChanged(false);
        return true;
    }

    public void refreshMenu() {
    }

    public boolean saveAs() {
        StringTokenizer st = new StringTokenizer(this.filePath);
        String defaultName = this.filePath;
        if (st.hasMoreTokens()) {
            defaultName = st.nextToken();
        }
        int slash = defaultName.lastIndexOf(File.separator);
        int dot = defaultName.lastIndexOf(".");
        defaultName = slash > -1 && dot > -1 ? defaultName.substring(slash + 1, dot) : "";
        File saveFile = GMDql.dialogSelectFile((Component)GV.appFrame, (String)"json", (String)GVDql.lastDirectory, (String)this._$8.getMessage("public.save"), (String)defaultName);
        if (saveFile == null) {
            return false;
        }
        String sfile = saveFile.getAbsolutePath();
        GVDql.lastDirectory = saveFile.getParent();
        if (!sfile.toLowerCase().endsWith("json")) {
            saveFile = new File(saveFile.getParent(), saveFile.getName() + "json");
            sfile = saveFile.getAbsolutePath();
        }
        if (!GMDql.canSaveAsFile((String)sfile)) {
            return false;
        }
        this.changeFileName(this.filePath, sfile);
        return this.save();
    }

    public void changeFileName(String oldFile, String newFile) {
        GVDql.appMenu.removeLiveMenu(oldFile);
        GVDql.appMenu.addLiveMenu(newFile);
        this.filePath = newFile;
        this.setTitle(newFile);
        GVDql.toolWin.changeFileName(this, newFile);
        GVDql.getDQL().resetTitle();
    }

    public void setDataChanged(boolean changed) {
        this._$6 = changed;
        GVDql.appMenu.setEnable(new short[]{4011}, this._$6);
        GVDql.appTool.setButtonEnabled((short)4011, this._$6);
    }

    public Object executeCmd(short cmd) {
        switch (cmd) {
            case 4011: {
                this.save();
                break;
            }
            case 4013: {
                this.saveAs();
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private boolean _$1() {
        boolean saved = true;
        if (this._$6) {
            String t1 = IdeDqlMessage.get().getMessage("public.querysave", (Object)IdeDqlMessage.get().getMessage("public.file"), (Object)this.filePath);
            String t2 = IdeDqlMessage.get().getMessage("public.save");
            int option = JOptionPane.showConfirmDialog((Component)GVDql.appFrame, t1, t2, 1);
            switch (option) {
                case 0: {
                    saved = this.save();
                    break;
                }
                case 1: {
                    saved = true;
                    break;
                }
                default: {
                    saved = false;
                }
            }
        }
        return saved;
    }

    public boolean close() {
        boolean closed = this._$1();
        if (closed) {
            GMDql.setWindowDimension((Component)this);
            this.dispose();
        }
        return closed;
    }

    public JPanel getContainPanel() {
        return this.getContainPanel();
    }

    public void sheetActivated() {
        GVDql.activeSheet = this;
        GVDql.getDQL().switchMenu(new MenuDataMaintenance(), (JToolBar)((Object)new ToolBarDataMaintenance()));
        GVDql.appMenu.addLiveMenu(this.getSheetTitle());
        this.refreshMenu();
        this.setDataChanged(this._$6);
        GVDql.getDQL().resetTitle();
        GVDql.toolWin.refreshSheet(this);
    }

    static /* synthetic */ boolean _$1(SheetDataMaintenance x0) {
        return x0._$6;
    }
}

