/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql.base;

import com.scudata.dm.query.metadata.Table;
import com.scudata.ide.spl.dql.GMDql;
import com.scudata.ide.spl.dql.GVDql;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DqlListViewRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String val = "";
        boolean isFolder = false;
        if (value != null) {
            val = GMDql.getObjectName(value);
            if (value instanceof String) {
                isFolder = true;
            }
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label1 = new JLabel(val);
        if (isSelected) {
            panel.setForeground(list.getSelectionForeground());
            panel.setBackground(list.getSelectionBackground());
            label1.setForeground(list.getSelectionForeground());
            label1.setBackground(list.getSelectionBackground());
        } else {
            panel.setForeground(list.getForeground());
            panel.setBackground(list.getBackground());
            label1.setForeground(list.getForeground());
            label1.setBackground(list.getBackground());
        }
        GridBagConstraints gbc = GMDql.getGBC((int)1, (int)2, (boolean)true);
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)label1, gbc);
        JLabel label = new JLabel();
        Dimension d = new Dimension(20, 20);
        label.setMinimumSize(d);
        label.setPreferredSize(d);
        String url = "/com/scudata/ide/spl/dql/images/tree";
        if (isFolder) {
            url = url + "folder.gif";
        } else if (value instanceof Table) {
            Table t = (Table)value;
            switch (t.getType()) {
                case 0: {
                    url = url + "table.gif";
                    break;
                }
                case 1: {
                    url = url + "pseud.gif";
                }
            }
        } else {
            url = url + "table.gif";
        }
        Icon icon = GVDql.iconMap.get(url);
        if (icon == null) {
            icon = GMDql.getImageIcon((String)url);
            GVDql.iconMap.put(url, icon);
        }
        label.setIcon(icon);
        gbc = GMDql.getGBC((int)1, (int)1);
        gbc.insets = new Insets(0, 4, 0, 0);
        panel.add((Component)label, gbc);
        return panel;
    }
}

