/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dql.base;

import com.scudata.ide.common.swing.TristateCheckBox;
import com.scudata.ide.spl.dql.base.FileTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FileTreeRender
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        FileTreeNode node = (FileTreeNode)((Object)value);
        if (node.isCheckNode()) {
            return this._$2(tree, node, sel);
        }
        return this._$1(tree, node, sel);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width + 5, d.height);
    }

    private JPanel _$2(JTree tree, FileTreeNode node, boolean sel) {
        JPanel panel = new JPanel(new BorderLayout());
        TristateCheckBox check = new TristateCheckBox();
        switch (node.getSelectedState()) {
            case 0: {
                check.setState(TristateCheckBox.NOT_SELECTED);
                break;
            }
            case 1: {
                check.setState(TristateCheckBox.SELECTED);
                break;
            }
            case 2: {
                check.setState(TristateCheckBox.DONT_CARE);
            }
        }
        check.setForeground(tree.getForeground());
        check.setBackground(tree.getBackground());
        panel.add((Component)check, "West");
        JLabel labelIcon = new JLabel(node.getDispIcon());
        panel.add((Component)labelIcon, "Center");
        JLabel labelName = new JLabel("  " + node.getName());
        panel.add((Component)labelName, "East");
        if (sel) {
            Color backColor = new DefaultTreeCellRenderer().getBackgroundSelectionColor();
            panel.setBackground(backColor);
            check.setBackground(backColor);
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
        } else {
            Color backColor = Color.WHITE;
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
            panel.setBackground(backColor);
            check.setBackground(backColor);
        }
        Color foreColor = tree.getForeground();
        labelIcon.setForeground(foreColor);
        labelName.setForeground(foreColor);
        panel.setForeground(foreColor);
        check.setForeground(foreColor);
        return panel;
    }

    private JPanel _$1(JTree tree, FileTreeNode node, boolean sel) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel labelIcon = new JLabel(node.getDispIcon());
        panel.add((Component)labelIcon, "Center");
        JLabel labelName = new JLabel("  " + node.getName());
        panel.add((Component)labelName, "East");
        if (sel) {
            Color backColor = new DefaultTreeCellRenderer().getBackgroundSelectionColor();
            panel.setBackground(backColor);
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
        } else {
            Color backColor = Color.WHITE;
            labelIcon.setBackground(backColor);
            labelName.setBackground(backColor);
            panel.setBackground(backColor);
        }
        labelIcon.setForeground(tree.getForeground());
        labelName.setForeground(tree.getForeground());
        panel.setForeground(tree.getForeground());
        return panel;
    }
}

