/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.jni;

import com.scudata.dm.Env;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public enum Native {

    private static boolean loaded = false;

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        if (osName.contains("Mac")) {
            return OS.MAC;
        }
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("Solaris") || osName.contains("SunOS")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + osName);
    }

    private static String resourceName() {
        OS os = Native.os();
        return "/com/scudata/jni/" + os.name + "/" + Native.arch() + "/native-lib." + os.libExtension;
    }

    private static String resourceName2() {
        OS os = Native.os();
        return "/com/scudata/jni/" + os.name + "/" + Native.arch() + "/libopenblas." + os.libExtension;
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    private static boolean loadFile(String path, String fileName) {
        boolean bl;
        boolean loaded = false;
        String resourceName = path;
        InputStream is = Native.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + resourceName + ". Please try building from source.");
        }
        String tempPath = Env.getTempPath();
        tempPath = tempPath == null ? "" : String.valueOf(tempPath) + "/";
        File tempLib = new File(String.valueOf(tempPath) + fileName + "." + Native.os().libExtension);
        if (tempLib.exists()) {
            tempLib.delete();
        }
        FileOutputStream out = new FileOutputStream(tempLib);
        try {
            int read;
            byte[] buf = new byte[4096];
            while ((read = is.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            try {
                out.close();
                out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.load(tempLib.getAbsolutePath());
            bl = loaded = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (tempLib != null && tempLib.exists()) {
                    if (!loaded) {
                        tempLib.delete();
                    } else {
                        tempLib.deleteOnExit();
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError("Cannot unpack file.");
            }
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tempLib != null && tempLib.exists()) {
            if (!loaded) {
                tempLib.delete();
            } else {
                tempLib.deleteOnExit();
            }
        }
        return bl;
    }

    public static synchronized void load() {
        if (loaded) {
            return;
        }
        String resource = Native.resourceName2();
        boolean flag = Native.loadFile(resource, "libopenblas");
        if (!flag) {
            return;
        }
        flag = Native.loadFile(Native.resourceName(), "native-lib");
        if (!flag) {
            return;
        }
        loaded = true;
    }

    private static enum OS {
        WINDOWS("win", "dll"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String name, String libExtension) {
            this.name = name;
            this.libExtension = libExtension;
        }
    }
}

