/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.SerialBytesArray;
import com.scudata.array.StringArray;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.DataBlockType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class DataBlockReader2 {
    private static IArray[] _$1(int[] dict, boolean isPublicDict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        int pos;
        int i;
        int[] array = new int[count + 1];
        boolean[] sign = null;
        int[] posData = null;
        IntArray posArr = null;
        int nullPos = dict[0];
        if (isConst) {
            if (constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
                posData = new int[count + 1];
                Arrays.fill(posData, constPos);
                posArr = new IntArray(posData, null, count);
            }
        } else if (nullPos > 0) {
            for (i = 1; i <= count; ++i) {
                if ((pos = buffer[index++]) == nullPos) {
                    if (sign == null) {
                        sign = new boolean[count + 1];
                    }
                    sign[i] = true;
                    continue;
                }
                array[i] = dict[pos];
            }
        } else {
            posData = new int[count + 1];
            for (i = 1; i <= count; ++i) {
                posData[i] = pos = buffer[index++];
                array[i] = dict[pos];
            }
            posArr = new IntArray(posData, null, count);
        }
        IntArray arr = new IntArray(array, sign, count);
        IntArray dictArr = isPublicDict ? null : new IntArray(dict, null, dict.length - 1);
        return new IArray[]{arr, dictArr, posArr};
    }

    private static IArray[] _$1(long[] dict, boolean isPublicDict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        int pos;
        int i;
        long[] array = new long[count + 1];
        boolean[] sign = null;
        int[] posData = null;
        IntArray posArr = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((long)constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                Arrays.fill(array, dict[constPos]);
                posData = new int[count + 1];
                Arrays.fill(posData, constPos);
                posArr = new IntArray(posData, null, count);
            }
        } else if (nullPos > 0) {
            for (i = 1; i <= count; ++i) {
                if ((pos = buffer[index++]) == nullPos) {
                    if (sign == null) {
                        sign = new boolean[count + 1];
                    }
                    sign[i] = true;
                    continue;
                }
                array[i] = dict[pos];
            }
        } else {
            posData = new int[count + 1];
            for (i = 1; i <= count; ++i) {
                posData[i] = pos = buffer[index++];
                array[i] = dict[pos];
            }
            posArr = new IntArray(posData, null, count);
        }
        LongArray arr = new LongArray(array, sign, count);
        LongArray dictArr = isPublicDict ? null : new LongArray(dict, null, dict.length - 1);
        return new IArray[]{arr, dictArr, posArr};
    }

    private static IArray[] _$1(double[] dict, boolean isPublicDict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        int pos;
        double[] array = new double[count + 1];
        boolean[] sign = null;
        int[] posData = null;
        IntArray posArr = null;
        int nullPos = (int)dict[0];
        if (isConst) {
            if ((double)constPos == dict[0]) {
                sign = new boolean[count + 1];
                Arrays.fill(sign, true);
            } else {
                double value = dict[constPos];
                for (int i = 1; i <= count; ++i) {
                    array[i] = value;
                }
                posData = new int[count + 1];
                Arrays.fill(posData, constPos);
                posArr = new IntArray(posData, null, count);
            }
        } else if (nullPos > 0) {
            for (int i = 1; i <= count; ++i) {
                if ((pos = buffer[index++]) == nullPos) {
                    if (sign == null) {
                        sign = new boolean[count + 1];
                    }
                    sign[i] = true;
                    continue;
                }
                array[i] = dict[pos];
            }
        } else {
            posData = new int[count + 1];
            for (int i = 1; i <= count; ++i) {
                posData[i] = pos = buffer[index++];
                array[i] = dict[pos];
            }
            posArr = new IntArray(posData, null, count);
        }
        DoubleArray arr = new DoubleArray(array, sign, count);
        DoubleArray dictArr = isPublicDict ? null : new DoubleArray(dict, null, dict.length - 1);
        return new IArray[]{arr, dictArr, posArr};
    }

    private static IArray[] _$1(Date[] dict, boolean isPublicDict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        Date[] array = new Date[count + 1];
        int[] posData = new int[count + 1];
        IntArray posArr = null;
        if (isConst) {
            Date value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
            Arrays.fill(posData, constPos);
            posArr = new IntArray(posData, null, count);
        } else {
            for (int i = 1; i <= count; ++i) {
                int pos;
                posData[i] = pos = buffer[index++];
                array[i] = dict[pos];
            }
            posArr = new IntArray(posData, null, count);
        }
        DateArray arr = new DateArray(array, count);
        DateArray dictArr = isPublicDict ? null : new DateArray(dict, dict.length - 1);
        return new IArray[]{arr, dictArr, posArr};
    }

    private static IArray[] _$1(String[] dict, boolean isPublicDict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        String[] array = new String[count + 1];
        int[] posData = new int[count + 1];
        IntArray posArr = null;
        if (isConst) {
            String value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
            Arrays.fill(posData, constPos);
            posArr = new IntArray(posData, null, count);
        } else {
            for (int i = 1; i <= count; ++i) {
                int pos;
                posData[i] = pos = buffer[index++];
                array[i] = dict[pos];
            }
            posArr = new IntArray(posData, null, count);
        }
        StringArray arr = new StringArray(array, count);
        StringArray dictArr = isPublicDict ? null : new StringArray(dict, dict.length - 1);
        return new IArray[]{arr, dictArr, posArr};
    }

    private static IArray[] _$1(SerialBytes[] dict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        long[] array1 = new long[count + 1];
        long[] array2 = new long[count + 1];
        if (isConst) {
            SerialBytes value = dict[constPos];
            if (value == null) {
                for (int i = 1; i <= count; ++i) {
                    array1[i] = 0L;
                    array2[i] = 0L;
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    array1[i] = value.getValue1();
                    array2[i] = value.getValue2();
                }
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                byte pos;
                SerialBytes value;
                if ((value = dict[pos = buffer[index++]]) == null) {
                    array1[i] = 0L;
                    array2[i] = 0L;
                    continue;
                }
                array1[i] = value.getValue1();
                array2[i] = value.getValue2();
            }
        }
        SerialBytesArray arr = new SerialBytesArray(array1, array2, count);
        return new IArray[]{arr, null, null};
    }

    private static IArray[] _$1(Object[] dict, boolean isPublicDict, int index, byte[] buffer, boolean isConst, int constPos, int count) {
        Object[] array = new Object[count + 1];
        int[] posData = null;
        IntArray posArr = null;
        if (isConst) {
            Object value = dict[constPos];
            for (int i = 1; i <= count; ++i) {
                array[i] = value;
            }
            posData = new int[count + 1];
            Arrays.fill(posData, constPos);
            posArr = new IntArray(posData, null, count);
        } else {
            posData = new int[count + 1];
            for (int i = 1; i <= count; ++i) {
                int pos;
                posData[i] = pos = buffer[index++];
                array[i] = dict[pos];
            }
            posArr = new IntArray(posData, null, count);
        }
        ObjectArray arr = new ObjectArray(array, count);
        ObjectArray dictArr = isPublicDict ? null : new ObjectArray(dict, dict.length - 1);
        return new IArray[]{arr, dictArr, posArr};
    }

    public static IArray[] readArrayAndDict(BufferReader reader, ColumnMetaData column, int count) throws IOException {
        IArray[] arrays;
        int blockType;
        Object dictArray;
        boolean isPublicDict = true;
        Object columnDict = column.getDictArray();
        if (reader.read() == 0) {
            dictArray = columnDict;
            blockType = reader.read();
            if (column.getDataType() != blockType) {
                dictArray = DataBlockType.dictToArray((Sequence)column.getDict(), (int)blockType);
                isPublicDict = false;
            }
        } else {
            isPublicDict = false;
            Sequence dict = (Sequence)reader.readObject();
            blockType = reader.read();
            dictArray = DataBlockType.dictToArray((Sequence)dict, (int)blockType);
        }
        boolean isConst = reader.readBoolean();
        int constPos = 0;
        if (isConst) {
            constPos = reader.read();
        }
        int index = reader.index;
        byte[] buffer = reader.buffer;
        if (blockType == 0) {
            blockType = column.getDataType();
        }
        switch (blockType) {
            case 126: {
                arrays = DataBlockReader2._$1((Object[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                arrays = DataBlockReader2._$1((int[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 40: {
                arrays = DataBlockReader2._$1((long[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
                break;
            }
            case 48: 
            case 56: {
                arrays = DataBlockReader2._$1((double[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
                break;
            }
            case 64: {
                arrays = DataBlockReader2._$1((Date[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
                break;
            }
            case 80: 
            case 81: {
                arrays = DataBlockReader2._$1((String[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
                break;
            }
            case 70: {
                arrays = DataBlockReader2._$1((SerialBytes[])dictArray, index, buffer, isConst, constPos, count);
                break;
            }
            default: {
                arrays = DataBlockReader2._$1((Object[])dictArray, isPublicDict, index, buffer, isConst, constPos, count);
            }
        }
        arrays[0].setSize(count);
        return arrays;
    }
}

