/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.DBTypes;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.SQLParser;
import com.scudata.common.SQLTool;
import com.scudata.common.Sentence;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.pdm.PureTable;
import com.scudata.resources.DataSetMessage;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtil {
    public static int TYPE_ORACLE_TIMESTAMP = com.scudata.util.DatabaseUtil.TYPE_ORACLE_TIMESTAMP;
    public static int TYPE_ORACLE_DATE = com.scudata.util.DatabaseUtil.TYPE_ORACLE_DATE;
    public static int TYPE_SYBASE_TIMESTAMP = com.scudata.util.DatabaseUtil.TYPE_SYBASE_TIMESTAMP;
    public static byte PROC_MODE_IN = com.scudata.util.DatabaseUtil.PROC_MODE_IN;
    public static byte PROC_MODE_OUT = com.scudata.util.DatabaseUtil.PROC_MODE_OUT;
    public static byte PROC_MODE_INOUT = com.scudata.util.DatabaseUtil.PROC_MODE_INOUT;

    private static Table _$1(String sql, Object[] params, byte[] types, DBSession dbs, String opt, int recordLimit) {
        ResultSet rs = null;
        Statement st = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        boolean isSolid = opt != null && opt.indexOf("s") > -1;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", (Object)name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            boolean bb = true;
            if (toCharset != null) {
                boolean bl = bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                    pos = Sentence.indexOf((String)sql, (String)"?", (int)(pos + 1), (int)18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] == null) continue;
                    if (args[paramIndex] instanceof Sequence && tranContent) {
                        Sequence l = (Sequence)args[paramIndex];
                        int size = l.length();
                        for (int i = 1; i <= size; ++i) {
                            Object o = l.get(i);
                            if (!(o instanceof String) || !tranSQL) continue;
                            o = new String(((String)o).getBytes(), dbCharset);
                            l.set(i, o);
                        }
                    } else if (args[paramIndex] instanceof String && tranSQL) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                    }
                    if (!(args[paramIndex] instanceof Sequence)) continue;
                    Object[] objs = ((Sequence)args[paramIndex]).toArray();
                    int objCount = objs.length;
                    StringBuffer sb = new StringBuffer(2 * objCount);
                    for (int iObj = 0; iObj < objCount; ++iObj) {
                        sb.append("?,");
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    if (sb.length() > 1) {
                        sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                    }
                    pos += sb.length();
                }
            }
            if (isSolid && args != null && args.length > 0) {
                isSolid = false;
            }
            try {
                if (isSolid) {
                    st = con.createStatement();
                } else {
                    pst = con.prepareStatement(sql);
                }
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name2, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                for (int iArg = 0; iArg < args.length; ++iArg) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            for (int iObj = 0; iObj < objs.length; ++iObj) {
                                SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)objs[iObj], (int)type);
                                ++pos;
                            }
                            --pos;
                            continue;
                        }
                        SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)args[iArg], (int)type);
                        continue;
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", (Object)name3, (Object)Integer.toString(iArg + 1)));
                    }
                }
            }
            try {
                rs = isSolid ? st.executeQuery(sql) : pst.executeQuery();
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name4, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            boolean addTable = false;
            if (opt != null && opt.indexOf("f") > -1) {
                addTable = true;
            }
            Table table = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, addTable, null, false, recordLimit, opt);
            if (opt != null && opt.indexOf("t") > -1) {
                ResultSetMetaData rsmd = rs.getMetaData();
                String tableName = rsmd.getTableName(1);
                if ((tableName = DatabaseUtil._$1(tableName, tranContent, dbCharset, toCharset, bb, opt)) == null || tableName.trim().length() < 1) {
                    tableName = SQLParser.getClause((String)sql, (int)1);
                    tableName = DatabaseUtil._$1(tableName, dbs);
                }
                if (opt != null && opt.indexOf("u") > -1) {
                    DatabaseMetaData dmd = con.getMetaData();
                    try {
                        rs = dmd.getPrimaryKeys(con.getCatalog(), null, tableName);
                        int count = 0;
                        ArrayList<String> nameList = new ArrayList<String>();
                        while (rs.next()) {
                            String keyName = rs.getString("COLUMN_NAME");
                            if (keyName == null || keyName.trim().length() <= 0) continue;
                            nameList.add(keyName);
                            ++count;
                        }
                        if (count > 0) {
                            String[] pks = new String[count];
                            for (int i = 0; i < count; ++i) {
                                pks[i] = (String)nameList.get(i);
                            }
                            table.setPrimary(pks);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Table table2 = table;
            return table2;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Table _$1(String sql, Object[] params, byte[] types, DBSession dbs, Context ctx, String opt) {
        ResultSet rs = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", (Object)name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                    pos = Sentence.indexOf((String)sql, (String)"?", (int)(pos + 1), (int)18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] == null) continue;
                    if (args[paramIndex] instanceof Sequence && tranContent) {
                        Sequence l = (Sequence)args[paramIndex];
                        int size = l.length();
                        for (int i = 1; i <= size; ++i) {
                            Object o = l.get(i);
                            if (!(o instanceof String) || !tranSQL) continue;
                            o = new String(((String)o).getBytes(), dbCharset);
                            l.set(i, o);
                        }
                    } else if (args[paramIndex] instanceof String && tranSQL) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                    }
                    if (!(args[paramIndex] instanceof Sequence)) continue;
                    Object[] objs = ((Sequence)args[paramIndex]).toArray();
                    int objCount = objs.length;
                    StringBuffer sb = new StringBuffer(2 * objCount);
                    for (int iObj = 0; iObj < objCount; ++iObj) {
                        sb.append("?,");
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    if (sb.length() > 1) {
                        sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                    }
                    pos += sb.length();
                }
            }
            try {
                pst = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name2, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                for (int iArg = 0; iArg < args.length; ++iArg) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            for (int iObj = 0; iObj < objs.length; ++iObj) {
                                SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)objs[iObj], (int)type);
                                ++pos;
                            }
                            --pos;
                            continue;
                        }
                        SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)args[iArg], (int)type);
                        continue;
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", (Object)name3, (Object)Integer.toString(iArg + 1)));
                    }
                }
            }
            try {
                rs = pst.executeQuery();
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name4, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            Table table = DatabaseUtil._$2(rs, dbCharset, tranContent, toCharset, dbType, opt);
            return table;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Table _$1(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, boolean addTable, Table table, boolean oneRecord, int recordLimit, String opt) throws SQLException, UnsupportedEncodingException {
        boolean nolimit;
        if (rs == null) {
            return null;
        }
        boolean pure = false;
        if (opt != null && opt.indexOf(118) > -1) {
            pure = true;
        }
        ResultSetMetaData rsmd = null;
        try {
            rsmd = rs.getMetaData();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (rsmd == null) {
            return null;
        }
        int colCount = rsmd.getColumnCount();
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        DataStruct ds = null;
        int[] colTypes = new int[colCount];
        if (table == null) {
            String[] colNames = new String[colCount];
            for (int c = 1; c <= colCount; ++c) {
                try {
                    if (addTable) {
                        String tn = rsmd.getTableName(c);
                        tn = (tn = DatabaseUtil._$1(tn, needTranContent, dbCharset, toCharset, bb, opt)) == null ? "" : tn + "_";
                        colNames[c - 1] = tn + DatabaseUtil._$1(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                    } else {
                        colNames[c - 1] = DatabaseUtil._$1(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                    }
                    colTypes[c - 1] = rsmd.getColumnType(c);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ds = new DataStruct(colNames);
        }
        if (recordLimit == 0) {
            if (table == null) {
                table = new Table(ds);
            }
            return table;
        }
        boolean bl = nolimit = recordLimit < 0;
        if (pure && (table == null || table instanceof PureTable)) {
            IArray[] cas = new IArray[colCount];
            int[] setmodes = new int[colCount];
            int count = -1;
            while (rs.next()) {
                ++count;
                for (int n = 1; n <= colCount; ++n) {
                    Object ca = cas[n - 1];
                    int setmode = setmodes[n - 1];
                    if (setmode > 0) {
                        if (setmode == 1) {
                            int v = rs.getInt(n);
                            ((IntArray)ca).addInt(v);
                            continue;
                        }
                        if (setmode == 6) {
                            double v = rs.getDouble(n);
                            ((DoubleArray)ca).addDouble(v);
                            continue;
                        }
                        if (setmode == 2) {
                            long v = rs.getLong(n);
                            ((com.scudata.dm.LongArray)ca).add(v);
                            continue;
                        }
                        if (setmode != 12) continue;
                        boolean v = rs.getBoolean(n);
                        ((BoolArray)ca).addBool(v);
                        continue;
                    }
                    try {
                        Object v = DatabaseUtil.tranData(colTypes[n - 1], dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                        if (ca == null && v != null) {
                            if (v != null) {
                                if (v instanceof Integer) {
                                    ca = new IntArray();
                                    setmodes[n - 1] = 1;
                                } else if (v instanceof Long) {
                                    ca = new LongArray();
                                    setmodes[n - 1] = 2;
                                } else if (v instanceof Boolean) {
                                    ca = new BoolArray();
                                    setmodes[n - 1] = 12;
                                } else if (v instanceof Double) {
                                    ca = new DoubleArray();
                                    setmodes[n - 1] = 6;
                                } else {
                                    ca = v instanceof Date ? new DateArray() : (v instanceof String ? new StringArray() : new ObjectArray());
                                }
                            }
                            if (ca != null) {
                                for (int i = 0; i < count; ++i) {
                                    ca.add(null);
                                }
                            }
                        }
                        if (ca == null) continue;
                        ca.add(v);
                        cas[n - 1] = ca;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!nolimit && --recordLimit == 0) {
                    return DatabaseUtil.getPureTable(ds, cas, table);
                }
                if (!oneRecord) continue;
                return DatabaseUtil.getPureTable(ds, cas, table);
            }
            return DatabaseUtil.getPureTable(ds, cas, table);
        }
        while (rs.next()) {
            BaseRecord record = table.newLast();
            for (int n = 1; n <= colCount; ++n) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(n);
                }
                try {
                    Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                    record.set(n - 1, obj);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!nolimit && --recordLimit == 0) {
                return table;
            }
            if (!oneRecord) continue;
            return table;
        }
        return table;
    }

    public static PureTable getPureTable(DataStruct ds, IArray[] cas, Table table) {
        PureTable table1 = new PureTable(ds, cas);
        if (table instanceof PureTable) {
            table.append((Sequence)table1);
            return (PureTable)table;
        }
        return table1;
    }

    private static IArray _$1(Object v, int type, int count) {
        Object ca = null;
        if (v != null) {
            ca = v instanceof Integer ? new IntArray() : (v instanceof Long ? new LongArray() : (v instanceof Boolean ? new BoolArray() : (v instanceof Double ? new DoubleArray() : (v instanceof Date ? new DateArray() : (v instanceof String ? new StringArray() : new ObjectArray())))));
        } else if (type > 0) {
            // empty if block
        }
        if (ca != null) {
            for (int i = 0; i < count; ++i) {
                ca.add(null);
            }
        }
        return ca;
    }

    private static Sequence _$1(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, Table table, String opt) throws SQLException, UnsupportedEncodingException {
        if (rs == null) {
            return null;
        }
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        if (table == null) {
            int[] colTypes = new int[colCount];
            String[] colNames = new String[colCount];
            for (int c = 1; c <= colCount; ++c) {
                try {
                    colNames[c - 1] = DatabaseUtil._$1(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                colTypes[c - 1] = rsmd.getColumnType(c);
            }
            table = new Table(colNames);
        }
        Sequence series = new Sequence();
        while (rs.next()) {
            BaseRecord record = table.newLast();
            series.add((Object)record);
            for (int n = 1; n <= colCount; ++n) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(n);
                }
                try {
                    Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                    record.set(n - 1, obj);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return series;
    }

    private static Table _$2(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, String opt) throws SQLException, UnsupportedEncodingException {
        if (rs == null) {
            return null;
        }
        boolean pure = false;
        if (opt != null && opt.indexOf(118) > -1) {
            pure = true;
        }
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        int[] colTypes = new int[colCount];
        String[] colNames = new String[colCount];
        try {
            for (int c = 1; c <= colCount; ++c) {
                colNames[c - 1] = DatabaseUtil._$1(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                colTypes[c - 1] = rsmd.getColumnType(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataStruct ds = new DataStruct(colNames);
        if (pure) {
            IArray[] cas = new IArray[colCount];
            int count = 0;
            while (rs.next()) {
                ++count;
                for (int n = 1; n <= colCount; ++n) {
                    IArray ca = cas[n - 1];
                    int type = 0;
                    if (dbType == 1) {
                        type = rsmd.getColumnType(n);
                    }
                    try {
                        Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                        if (ca == null && obj != null) {
                            ca = DatabaseUtil._$1(obj, type, count - 1);
                        }
                        if (ca == null) continue;
                        ca.add(obj);
                        cas[n - 1] = ca;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            PureTable table1 = new PureTable(ds, cas);
            return table1;
        }
        Table table = new Table(ds);
        if (rs.next()) {
            BaseRecord record = table.newLast();
            for (int n = 1; n <= colCount; ++n) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(n);
                }
                try {
                    Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                    record.set(n - 1, obj);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return table;
        }
        return null;
    }

    public static Object execute(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        return com.scudata.util.DatabaseUtil.execute((String)sql, (Object[])params, (byte[])types, (DBSession)dbs, (String)opt);
    }

    public static void execute2old(String sql, Object[][] paramsGroup, byte[] types, DBSession dbs, boolean interrupt) {
        com.scudata.util.DatabaseUtil.execute2old((String)sql, (Object[][])paramsGroup, (byte[])types, (DBSession)dbs, (boolean)interrupt);
    }

    public static void execute2(String sql, Object[][] paramsGroup, byte[] types, DBSession dbs, boolean interrupt) {
        com.scudata.util.DatabaseUtil.execute2old((String)sql, (Object[][])paramsGroup, (byte[])types, (DBSession)dbs, (boolean)interrupt);
    }

    public static Sequence query(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        Table tbl = DatabaseUtil._$1(sql, params, types, dbs, opt, -1);
        boolean single = false;
        boolean pure = false;
        if (opt != null) {
            if (opt.indexOf(105) > -1) {
                single = true;
            }
            if (opt.indexOf(118) > -1) {
                pure = true;
            }
        }
        if (single && tbl != null && tbl.dataStruct().getFieldCount() == 1) {
            if (pure && tbl instanceof PureTable) {
                PureTable pt = (PureTable)tbl;
                IArray ca = pt.getFieldValueArray(0);
                return new Sequence(ca);
            }
            return tbl.fieldValues(0);
        }
        return tbl;
    }

    public static Sequence query(String sql, Object[] params, byte[] types, DBSession dbs, String opt, Context ctx) {
        return DatabaseUtil.query(sql, params, types, dbs, opt, -1, ctx);
    }

    public static Sequence query(String sql, Object[] params, byte[] types, DBSession dbs, String opt, int recordLimit, Context ctx) {
        Table tbl = DatabaseUtil._$1(sql, params, types, dbs, opt, recordLimit);
        boolean single = false;
        boolean pure = false;
        if (opt != null) {
            if (opt.indexOf(105) > -1) {
                single = true;
            }
            if (opt.indexOf(118) > -1) {
                pure = true;
            }
        }
        if (single && tbl != null && tbl.dataStruct().getFieldCount() == 1) {
            if (pure && tbl instanceof PureTable) {
                PureTable pt = (PureTable)tbl;
                IArray ca = pt.getFieldValueArray(0);
                return new Sequence(ca);
            }
            return tbl.fieldValues(0);
        }
        return tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence queryGroup(String sql, Object[][] params, byte[] types, DBSession dbs, Context ctx, String opt) throws RQException {
        if (params == null || params.length < 1) {
            return DatabaseUtil.query(sql, null, types, dbs, null);
        }
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            Object[] modeParams;
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", (Object)name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = (modeParams = params[0]) == null ? 0 : modeParams.length;
            byte[] argTypes = null;
            if (paramCount > 0) {
                argTypes = new byte[paramCount];
                for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                }
            }
            try {
                pst = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name2, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            Sequence resultSeries = new Sequence();
            Object[] args = new Object[paramCount];
            Table table = null;
            for (Object[] thisParams : params) {
                if (paramCount > 0) {
                    for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                        args[paramIndex] = thisParams[paramIndex];
                        if (args[paramIndex] == null || !(args[paramIndex] instanceof String) || !tranSQL) continue;
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                    }
                }
                if (args != null && args.length > 0) {
                    for (int iArg = 0; iArg < args.length; ++iArg) {
                        try {
                            byte type = argTypes[iArg];
                            SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)(iArg + 1), (Object)args[iArg], (int)type);
                            continue;
                        }
                        catch (Exception e) {
                            String name3 = "";
                            DBInfo info = dbs.getInfo();
                            if (info != null) {
                                name3 = info.getName();
                            }
                            try {
                                if (con != null) {
                                    con.close();
                                }
                            }
                            catch (Exception e1) {
                                throw new RQException(e1.getMessage(), (Throwable)e1);
                            }
                            throw new RQException(mm.getMessage("error.argIndex", (Object)name3, (Object)Integer.toString(iArg + 1)));
                        }
                    }
                }
                ResultSet rs = null;
                if (tranContent && (toCharset == null || toCharset.trim().length() == 0)) {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e1) {
                        throw new RQException(e1.getMessage(), (Throwable)e1);
                    }
                    throw new RQException(mm.getMessage("error.toCharset"));
                }
                boolean bb = true;
                if (toCharset != null) {
                    bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
                }
                try {
                    rs = pst.executeQuery();
                    if (table == null) {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int colCount = rsmd.getColumnCount();
                        int[] colTypes = new int[colCount];
                        String[] colNames = new String[colCount];
                        for (int c = 1; c <= colCount; ++c) {
                            colNames[c - 1] = DatabaseUtil._$1(rsmd.getColumnLabel(c), tranContent, dbCharset, toCharset, bb, opt);
                            colTypes[c - 1] = rsmd.getColumnType(c);
                        }
                        table = new Table(colNames);
                    }
                    resultSeries.add((Object)DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, table, opt));
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                        continue;
                    }
                    String name4 = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name4 = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.sqlException", (Object)name4, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            Sequence sequence = resultSeries;
            return sequence;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Table query(String tableName, String[] fields, String[] keyNames, Object[][] keyValues, DBSession dbs, Context ctx) {
        String sql = "select ";
        int size = fields.length;
        String fieldAll = null;
        String field = null;
        for (int i = 0; i < size; ++i) {
            field = DatabaseUtil._$2(fields[i], dbs);
            if (field == null || field.trim().length() <= 0) continue;
            fieldAll = fieldAll == null ? field : fieldAll + ", " + field;
        }
        if (fieldAll == null || fieldAll.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidField"));
        }
        size = keyNames.length;
        int colCount = keyValues.length;
        String conditions = null;
        String key = "";
        Object v = null;
        ArrayList<Object> params = new ArrayList<Object>();
        for (int n = 0; n < colCount; ++n) {
            Object[] rValues = keyValues[n];
            String condition = null;
            for (int i = 0; i < size; ++i) {
                key = keyNames[i];
                if (key == null || key.trim().length() <= 0) continue;
                v = null;
                if (i < rValues.length) {
                    v = rValues[i];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    params.add(v);
                    continue;
                }
                condition = condition + " and (" + key + " = ?)";
                params.add(v);
            }
            if (condition == null || condition.trim().length() <= 0) continue;
            conditions = conditions == null ? "(" + condition + ")" : conditions + " or (" + condition + ")";
        }
        if (conditions == null || conditions.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        sql = sql + fieldAll + " from " + DatabaseUtil._$2(tableName, dbs) + " where " + conditions;
        return DatabaseUtil._$1(sql, params.toArray(), null, dbs, null, -1);
    }

    public static Sequence query(String tableName, String[] fields, String[] keyNames, Object[] keyValues, DBSession dbs, Context ctx, String opt) {
        String sql = "select ";
        int size = fields.length;
        String fieldAll = null;
        String field = null;
        for (int i = 0; i < size; ++i) {
            field = DatabaseUtil._$2(fields[i], dbs);
            if (field == null || field.trim().length() <= 0) continue;
            fieldAll = fieldAll == null ? field : fieldAll + ", " + field;
        }
        if (fieldAll == null || fieldAll.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidField"));
        }
        size = keyNames.length;
        String key = "";
        Object v = null;
        String condition = null;
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            key = keyNames[i];
            if (key == null || key.trim().length() <= 0) continue;
            v = null;
            if (i < keyValues.length) {
                v = keyValues[i];
            }
            if (condition == null) {
                condition = "(" + key + " = ?)";
                params.add(v);
                continue;
            }
            condition = condition + " and (" + key + " = ?)";
            params.add(v);
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        Table tbl = DatabaseUtil._$1(sql = sql + fieldAll + " from " + DatabaseUtil._$2(tableName, dbs) + " where " + condition, params.toArray(), null, dbs, ctx, opt);
        if (tbl != null && tbl.dataStruct().getFieldCount() == 1 && opt != null && opt.indexOf(105) != -1) {
            return tbl.fieldValues(0);
        }
        return tbl;
    }

    public static Sequence query(String tableName, String[] keyNames, Object[] keyValues, DBSession dbs, Context ctx, String opt) {
        String[] fields = new String[]{"*"};
        return DatabaseUtil.query(tableName, fields, keyNames, keyValues, dbs, ctx, opt);
    }

    public static Table query(String tableName, String[] keyNames, Object[][] keyValues, DBSession dbs, Context ctx) {
        String[] fields = new String[]{"*"};
        return DatabaseUtil.query(tableName, fields, keyNames, keyValues, dbs, ctx);
    }

    public static void update(String tableName, Object[] keyValues, String[] fields, Object[] values, DBSession dbs) {
        com.scudata.util.DatabaseUtil.update((String)tableName, (Object[])keyValues, (String[])fields, (Object[])values, null, (DBSession)dbs);
    }

    public static Object update(String tableName, Object[] keyValues, String[] fields, Object[] values, String opt, DBSession dbs) {
        return com.scudata.util.DatabaseUtil.update((String)tableName, (Object[])keyValues, (String[])fields, (Object[])values, (String)opt, (DBSession)dbs);
    }

    public static Object tranData(int type, int dbType, ResultSet rs, int index, boolean needTranContent, String dbCharset, String toCharset, boolean bb) throws Exception {
        return com.scudata.util.DatabaseUtil.tranData((int)type, (int)dbType, (ResultSet)rs, (int)index, (boolean)needTranContent, (String)dbCharset, (String)toCharset, (boolean)bb, null);
    }

    public static Object tranData(int type, int dbType, ResultSet rs, int index, boolean needTranContent, String dbCharset, String toCharset, boolean bb, String opt) throws Exception {
        return com.scudata.util.DatabaseUtil.tranData((int)type, (int)dbType, (ResultSet)rs, (int)index, (boolean)needTranContent, (String)dbCharset, (String)toCharset, (boolean)bb, (String)opt);
    }

    private static String _$1(String name, boolean needTranContent, String dbCharset, String toCharset, boolean bb, String opt) throws Exception {
        String result = name;
        if (name != null && !bb) {
            try {
                if (needTranContent) {
                    result = new String(name.getBytes(dbCharset), toCharset);
                }
            }
            catch (Exception e) {
                MessageManager mm = DataSetMessage.get();
                throw new RQException(mm.getMessage("error.charset", (Object)dbCharset, (Object)toCharset));
            }
        }
        if (result != null && opt != null && opt.indexOf("l") > -1) {
            result = result.toLowerCase();
        }
        return result;
    }

    private static String[] _$1(Connection conn, String tableName) {
        if (conn == null || tableName == null || tableName.trim().length() < 1) {
            return null;
        }
        ResultSet rs = null;
        try {
            Object seqObj;
            DatabaseMetaData dmd = conn.getMetaData();
            rs = dmd.getPrimaryKeys(conn.getCatalog(), null, tableName);
            int count = 0;
            ArrayList<String> nameList = new ArrayList<String>();
            ArrayList<Object> seqList = new ArrayList<Object>();
            while (rs.next()) {
                String keyName = rs.getString("COLUMN_NAME");
                seqObj = rs.getObject("KEY_SEQ");
                if (keyName == null || keyName.trim().length() <= 0) continue;
                nameList.add(keyName);
                seqList.add(seqObj);
                ++count;
            }
            if (count > 0) {
                int i;
                Object[] names0 = nameList.toArray();
                if (names0 == null || names0.length < 1) {
                    seqObj = null;
                    return seqObj;
                }
                String[] names = new String[count];
                int[] seqs = new int[count];
                for (i = 0; i < count; ++i) {
                    seqs[i] = Integer.parseInt(seqList.get(i).toString());
                    names[i] = names0[i].toString();
                }
                for (i = 0; i < count - 1; ++i) {
                    for (int j = 0; j < count - 1 - i; ++j) {
                        if (seqs[j] <= seqs[j + 1]) continue;
                        int tmp = seqs[j];
                        String tmps = names[j];
                        seqs[j] = seqs[j + 1];
                        names[j] = names[j + 1];
                        seqs[j + 1] = tmp;
                        names[j + 1] = tmps;
                    }
                }
                String[] stringArray = names;
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException((Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Sequence select(String tableName, String str, Object[] keyValues, DBSession dbs, String opt) {
        return DatabaseUtil.select(tableName, str, null, keyValues, dbs, opt);
    }

    public static Sequence select(String tableName, String str, String[] keyNames, Object[] keyValues, DBSession dbs, String opt) {
        DBInfo info = dbs.getInfo();
        String dbName = "";
        if (info != null) {
            dbName = info.getName();
        }
        String sql = "select " + str;
        Connection con = null;
        try {
            Object session;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                throw new RQException(mm.getMessage("error.conClosed", (Object)dbName));
            }
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException((Throwable)e);
        }
        if (keyNames == null) {
            keyNames = DatabaseUtil._$1(con, tableName);
        }
        if (keyNames == null) {
            return null;
        }
        int size = keyNames.length;
        String key = "";
        Object v = null;
        String condition = null;
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            key = keyNames[i];
            if (key == null || key.trim().length() <= 0) continue;
            v = null;
            if (i < keyValues.length) {
                v = keyValues[i];
            }
            if (condition == null) {
                condition = "(" + key + " = ?)";
                params.add(v);
                continue;
            }
            condition = condition + " and (" + key + " = ?)";
            params.add(v);
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        sql = sql + " from " + DatabaseUtil._$2(tableName, dbs) + " where " + condition;
        return DatabaseUtil._$1(sql, params.toArray(), null, dbs, opt);
    }

    public static Sequence select(String tableName, String[] strs, String[] keyNames, Object[] keyValues, DBSession dbs, String opt) {
        DBInfo info = dbs.getInfo();
        String dbName = "";
        if (info != null) {
            dbName = info.getName();
        }
        String sql = "select ";
        int size = strs.length;
        String fieldAll = null;
        String field = null;
        for (int i = 0; i < size; ++i) {
            field = strs[i];
            if (field == null || field.trim().length() <= 0) continue;
            fieldAll = fieldAll == null ? field : fieldAll + ", " + field;
        }
        if (fieldAll == null || fieldAll.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidFieldValue"));
        }
        Connection con = null;
        try {
            Object session;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                throw new RQException(mm.getMessage("error.conClosed", (Object)dbName));
            }
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException((Throwable)e);
        }
        if (keyNames == null) {
            keyNames = DatabaseUtil._$1(con, tableName);
        }
        if (keyNames == null) {
            return null;
        }
        size = keyNames.length;
        String key = "";
        Object v = null;
        String condition = null;
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            key = keyNames[i];
            if (key == null || key.trim().length() <= 0) continue;
            v = null;
            if (i < keyValues.length) {
                v = keyValues[i];
            }
            if (condition == null) {
                condition = "(" + key + " = ?)";
                params.add(v);
                continue;
            }
            condition = condition + " and (" + key + " = ?)";
            params.add(v);
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        sql = sql + fieldAll + " from " + DatabaseUtil._$2(tableName, dbs) + " where " + condition;
        return DatabaseUtil._$1(sql, params.toArray(), null, dbs, opt);
    }

    public static Sequence select(String tableName, String[] strs, Object[] keyValues, DBSession dbs, String opt) {
        return DatabaseUtil.select(tableName, strs, null, keyValues, dbs, opt);
    }

    private static Sequence _$1(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        ResultSet rs = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", (Object)name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                    pos = Sentence.indexOf((String)sql, (String)"?", (int)(pos + 1), (int)18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] == null) continue;
                    if (args[paramIndex] instanceof Sequence && tranContent) {
                        Sequence l = (Sequence)args[paramIndex];
                        int size = l.length();
                        for (int i = 1; i <= size; ++i) {
                            Object o = l.get(i);
                            if (!(o instanceof String) || !tranSQL) continue;
                            o = new String(((String)o).getBytes(), dbCharset);
                            l.set(i, o);
                        }
                    } else if (args[paramIndex] instanceof String && tranSQL) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                    }
                    if (!(args[paramIndex] instanceof Sequence)) continue;
                    Object[] objs = ((Sequence)args[paramIndex]).toArray();
                    int objCount = objs.length;
                    StringBuffer sb = new StringBuffer(2 * objCount);
                    for (int iObj = 0; iObj < objCount; ++iObj) {
                        sb.append("?,");
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    if (sb.length() > 1) {
                        sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                    }
                    pos += sb.length();
                }
            }
            try {
                pst = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name2, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                for (int iArg = 0; iArg < args.length; ++iArg) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            for (int iObj = 0; iObj < objs.length; ++iObj) {
                                SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)objs[iObj], (int)type);
                                ++pos;
                            }
                            --pos;
                            continue;
                        }
                        SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)args[iArg], (int)type);
                        continue;
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", (Object)name3, (Object)Integer.toString(iArg + 1)));
                    }
                }
            }
            try {
                rs = pst.executeQuery();
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(mm.getMessage("error.sqlException", (Object)name4, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
            }
            Sequence sequence = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, opt);
            return sequence;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Sequence _$1(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, String opt) throws SQLException, UnsupportedEncodingException {
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        Sequence series = new Sequence();
        int size = 0;
        Object value = null;
        while (rs.next()) {
            if (colCount == 1) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(1);
                }
                try {
                    value = DatabaseUtil.tranData(type, dbType, rs, 1, needTranContent, dbCharset, toCharset, bb, opt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                series.add(value);
            } else {
                Sequence sub = new Sequence();
                for (int n = 1; n <= colCount; ++n) {
                    int type = 0;
                    if (dbType == 1) {
                        type = rsmd.getColumnType(n);
                    }
                    try {
                        Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                        sub.add(obj);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                value = sub;
                series.add(value);
            }
            ++size;
        }
        if (size < 2) {
            Sequence ser = new Sequence();
            ser.add(value);
            return ser;
        }
        return series;
    }

    public static Object update(String tableName, String str, Object[] params, byte[] types, Object[] keyValues, DBSession dbs) {
        return com.scudata.util.DatabaseUtil.update((String)tableName, (String)str, (Object[])params, (byte[])types, (Object[])keyValues, (DBSession)dbs);
    }

    public static Object update(String tableName, String[] strs, String[] keyNames, Object[] keyValues, DBSession dbs) {
        return com.scudata.util.DatabaseUtil.update((String)tableName, (String[])strs, (String[])keyNames, (Object[])keyValues, (DBSession)dbs);
    }

    public static Sequence proc(String sql, Object[] params, byte[] modes, byte[] types, String[] outVariables, DBSession dbs, Context ctx) {
        Statement pst = null;
        ResultSet rs = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        boolean hasOutParam = false;
        try {
            String outName;
            String[] outTables;
            Sequence dsPosGroup;
            int outCursor;
            String name;
            MessageManager mm;
            DBInfo dsInfo;
            block118: {
                Object session;
                dsInfo = null;
                mm = DataSetMessage.get();
                if (dbs != null && dbs.getInfo() instanceof DBInfo) {
                    dsInfo = dbs.getInfo();
                }
                if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                    con = (Connection)session;
                }
                name = "";
                if (dsInfo != null) {
                    name = dsInfo.getName();
                }
                if (con == null || con.isClosed()) {
                    throw new RQException(mm.getMessage("error.conClosed", (Object)name));
                }
                if (dsInfo != null) {
                    dbCharset = dsInfo.getDBCharset();
                    tranSQL = dsInfo.getNeedTranSentence();
                    tranContent = dsInfo.getNeedTranContent();
                    if ((tranContent || tranSQL) && dbCharset == null) {
                        throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                    }
                    toCharset = dsInfo.getClientCharset();
                    if ((tranContent || tranSQL) && toCharset == null) {
                        throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                    }
                    dbType = dsInfo.getDBType();
                } else {
                    tranContent = false;
                }
                if (tranSQL) {
                    sql = new String(sql.getBytes(), dbCharset);
                }
                if (sql.trim().startsWith("call")) {
                    sql = "{" + sql + "}";
                }
                if (tranSQL) {
                    sql = new String(sql.getBytes(), dbCharset);
                }
                int paramCount = params == null ? 0 : params.length;
                Object[] args = null;
                int outCount = 0;
                outCursor = 0;
                if (paramCount > 0) {
                    args = new Object[paramCount];
                    int pos = 0;
                    for (int i = 0; i < paramCount; ++i) {
                        pos = Sentence.indexOf((String)sql, (String)"?", (int)(pos + 1), (int)18);
                        byte mode = modes[i];
                        if (mode == PROC_MODE_OUT || mode == PROC_MODE_INOUT) {
                            hasOutParam = true;
                            if (types[i] != 101) {
                                ++outCount;
                            } else {
                                ++outCursor;
                            }
                        }
                        if (mode != PROC_MODE_IN && mode != PROC_MODE_INOUT) continue;
                        args[i] = params[i];
                        if (!(args[i] instanceof Sequence)) continue;
                        Sequence l = (Sequence)args[i];
                        int count = l.length();
                        StringBuffer sb = new StringBuffer(2 * count);
                        for (int n = 0; n < count; ++n) {
                            sb.append("?,");
                        }
                        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        if (sb.length() > 1) {
                            sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                        }
                        pos += sb.length();
                    }
                }
                int dsPos = -1;
                dsPosGroup = new Sequence();
                String[] outParams = new String[outCount];
                int[] outParamsIndex = new int[outCount];
                int outIndex = -1;
                outTables = new String[outCursor];
                int cursorIndex = -1;
                if (hasOutParam) {
                    try {
                        pst = con.prepareCall(sql);
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        throw new RQException(mm.getMessage("error.sqlException", (Object)name, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        pst = con.prepareStatement(sql);
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        throw new RQException(mm.getMessage("error.sqlException", (Object)name, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                    }
                }
                int paramIndex = 0;
                for (int iArg = 0; iArg < paramCount; ++iArg) {
                    Object o;
                    byte mode = modes[iArg];
                    if (mode == PROC_MODE_IN) {
                        if (args[iArg] instanceof Sequence) {
                            Object o2;
                            int i;
                            int size;
                            Sequence l = (Sequence)args[iArg];
                            if (tranSQL) {
                                size = l.length();
                                for (i = 1; i <= size; ++i) {
                                    o2 = l.get(i);
                                    if (o2 instanceof String) {
                                        o2 = new String(((String)o2).getBytes(), dbCharset);
                                    }
                                    SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)(++paramIndex), (Object)o2, (int)types[iArg]);
                                }
                                continue;
                            }
                            size = l.length();
                            for (i = 1; i <= size; ++i) {
                                o2 = l.get(i);
                                SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)(++paramIndex), (Object)o2, (int)types[iArg]);
                            }
                            continue;
                        }
                        o = args[iArg];
                        if (tranSQL && o instanceof String) {
                            o = new String(((String)o).getBytes(), dbCharset);
                        }
                        SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)(++paramIndex), (Object)o, (int)types[iArg]);
                        continue;
                    }
                    if (mode == PROC_MODE_OUT) {
                        ++paramIndex;
                        if (101 == types[iArg]) {
                            if (dbType == 1) {
                                try {
                                    Class<?> c = Class.forName("oracle.jdbc.driver.OracleTypes");
                                    Field f = c.getField("CURSOR");
                                    ((CallableStatement)pst).registerOutParameter(paramIndex, f.getInt(null));
                                }
                                catch (Exception e) {
                                    try {
                                        if (con != null) {
                                            con.close();
                                        }
                                    }
                                    catch (Exception e1) {
                                        throw new RQException(e1.getMessage(), (Throwable)e1);
                                    }
                                    throw new RQException(mm.getMessage("error.cursorException"));
                                }
                                if (dsPos < 0) {
                                    dsPos = paramIndex;
                                } else {
                                    dsPosGroup.add((Object)new Integer(paramIndex));
                                }
                                if (dsPos < 0) {
                                    try {
                                        if (con != null) {
                                            con.close();
                                        }
                                    }
                                    catch (Exception e1) {
                                        throw new RQException(e1.getMessage(), (Throwable)e1);
                                    }
                                    throw new RQException(mm.getMessage("error.noResultSet"));
                                }
                                outTables[++cursorIndex] = outVariables[iArg];
                                continue;
                            }
                            if (dbType != 15 && dbType != 20) continue;
                            ((CallableStatement)pst).registerOutParameter(paramIndex, 1111);
                            if (dsPos < 0) {
                                dsPos = paramIndex;
                            } else {
                                dsPosGroup.add((Object)new Integer(paramIndex));
                            }
                            if (dsPos >= 0) continue;
                            try {
                                if (con != null) {
                                    con.close();
                                }
                            }
                            catch (Exception e1) {
                                throw new RQException(e1.getMessage(), (Throwable)e1);
                            }
                            throw new RQException(mm.getMessage("error.noResultSet"));
                        }
                        outParams[++outIndex] = outVariables[iArg];
                        outParamsIndex[outIndex] = paramIndex;
                        com.scudata.util.DatabaseUtil.registerOtherParameter((CallableStatement)((CallableStatement)pst), (int)paramIndex, (int)types[iArg], (MessageManager)mm);
                        continue;
                    }
                    o = args[iArg];
                    if (tranContent && o instanceof String) {
                        o = new String(((String)o).getBytes(), dbCharset);
                    }
                    SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)(++paramIndex), (Object)o, (int)types[iArg]);
                    outParams[++outIndex] = outVariables[iArg];
                    outParamsIndex[outIndex] = paramIndex;
                    com.scudata.util.DatabaseUtil.registerOtherParameter((CallableStatement)((CallableStatement)pst), (int)paramIndex, (int)types[iArg], (MessageManager)mm);
                }
                if (hasOutParam) {
                    if ((dbType == 15 || dbType == 20) && dsPos > 0) {
                        ((CallableStatement)pst).execute();
                    } else {
                        rs = ((CallableStatement)pst).executeQuery();
                    }
                    try {
                        int count = outParams.length;
                        for (int i = 0; i < count; ++i) {
                            Object value = ((CallableStatement)pst).getObject(outParamsIndex[i]);
                            ctx.setParamValue(outParams[i], value);
                        }
                    }
                    catch (Exception e) {
                        throw new RQException(mm.getMessage("error.outParam"));
                    }
                }
                try {
                    if (dbType == 1 && dsPos > 0) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (Exception e1) {
                            throw new RQException(e1.getMessage(), (Throwable)e1);
                        }
                        rs = (ResultSet)((CallableStatement)pst).getObject(dsPos);
                        break block118;
                    }
                    if ((dbType == 15 || dbType == 20) && dsPos > 0) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (Exception e1) {
                            throw new RQException(e1.getMessage(), (Throwable)e1);
                        }
                        rs = (ResultSet)((CallableStatement)pst).getObject(dsPos);
                        break block118;
                    }
                    if (hasOutParam) break block118;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e1) {
                        throw new RQException(e1.getMessage(), (Throwable)e1);
                    }
                    rs = pst.executeQuery();
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(mm.getMessage("error.sqlException", (Object)name, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                }
            }
            if (dsInfo == null) {
                tranContent = false;
            }
            Table se = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
            if (outCursor > 0 && (outName = outTables[0]) != null && outName.trim().length() > 0) {
                ctx.setParamValue(outName, (Object)se);
            }
            if (dsPosGroup.length() > 0) {
                Sequence mul_dataset = new Sequence();
                mul_dataset.add((Object)se);
                int size = dsPosGroup.length();
                for (int i = 0; i < size; ++i) {
                    int loc = (Integer)dsPosGroup.get(i + 1);
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        rs = (ResultSet)((CallableStatement)pst).getObject(loc);
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        try {
                            if (con != null) {
                                con.close();
                            }
                        }
                        catch (Exception e1) {
                            throw new RQException(e1.getMessage(), (Throwable)e1);
                        }
                        throw new RQException(mm.getMessage("error.sqlException", (Object)name, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                    }
                    Table se_add = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
                    mul_dataset.add((Object)se_add);
                    if (outCursor <= 0) continue;
                    String outName2 = null;
                    if (i < outTables.length - 1) {
                        outName2 = outTables[i + 1];
                    }
                    if (outName2 == null || outName2.trim().length() <= 0) continue;
                    ctx.setParamValue(outName2, (Object)se_add);
                }
                if (mul_dataset.length() > 1) {
                    Sequence i = mul_dataset;
                    return i;
                }
            } else if (pst.getMoreResults()) {
                Sequence mul_dataset = new Sequence();
                mul_dataset.add((Object)se);
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rs = pst.getResultSet();
                Table se_add = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
                mul_dataset.add((Object)se_add);
                boolean more = pst.getMoreResults();
                while (more || pst.getUpdateCount() != -1) {
                    if (!more) {
                        more = pst.getMoreResults();
                        continue;
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    rs = pst.getResultSet();
                    se_add = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
                    mul_dataset.add((Object)se_add);
                    more = pst.getMoreResults();
                }
                if (mul_dataset.length() > 1) {
                    Sequence sequence = mul_dataset;
                    return sequence;
                }
            }
            Table table = se;
            return table;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String _$2(String field, DBSession dbs) {
        DBConfig dbc;
        if (dbs != null && dbs.getInfo() instanceof DBConfig && (dbc = (DBConfig)dbs.getInfo()).isAddTilde()) {
            int dbType = dbc.getDBType();
            field = DBTypes.getLeftTilde((int)dbType) + field + DBTypes.getRightTilde((int)dbType);
        }
        return field;
    }

    private static String _$1(String field, DBSession dbs) {
        DBConfig dbc;
        if (field == null || field.trim().length() < 1) {
            return field;
        }
        if (dbs != null && dbs.getInfo() instanceof DBConfig && (dbc = (DBConfig)dbs.getInfo()).isAddTilde()) {
            int dbType = dbc.getDBType();
            if (field.substring(0, 1).equals(DBTypes.getLeftTilde((int)dbType))) {
                field = field.substring(1);
            }
            if (field.substring(field.length() - 1).equals(DBTypes.getRightTilde((int)dbType))) {
                field = field.substring(0, field.length() - 1);
            }
        }
        return field;
    }

    public static Table queryGroup(String inisql, Object[][] valueGroup, byte[] types, DBSession dbs, String opt, Context ctx) {
        ResultSet rs = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", (Object)name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", (Object)name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", (Object)name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                inisql = new String(inisql.getBytes(), dbCharset);
            }
            Table table = null;
            boolean addTable = false;
            if (opt != null && opt.indexOf("f") > -1) {
                addTable = true;
            }
            boolean oneRecord = false;
            if (opt != null && opt.indexOf("1") > -1) {
                oneRecord = true;
            }
            int queryCount = valueGroup == null ? 0 : valueGroup.length;
            for (int qi = 0; qi < queryCount; ++qi) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        rs = null;
                    }
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                }
                catch (Exception e) {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e1) {
                        throw new RQException(e1.getMessage(), (Throwable)e1);
                    }
                    throw new RQException(e.getMessage(), (Throwable)e);
                }
                String sql = inisql;
                Object[] params = valueGroup[qi];
                int paramCount = params == null ? 0 : params.length;
                Object[] args = null;
                byte[] argTypes = null;
                if (paramCount > 0) {
                    args = new Object[paramCount];
                    argTypes = new byte[paramCount];
                    int pos = 0;
                    for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
                        pos = Sentence.indexOf((String)sql, (String)"?", (int)(pos + 1), (int)18);
                        args[paramIndex] = params[paramIndex];
                        argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                        if (args[paramIndex] == null) continue;
                        if (args[paramIndex] instanceof Sequence && tranContent) {
                            Sequence l = (Sequence)args[paramIndex];
                            int size = l.length();
                            for (int i = 1; i <= size; ++i) {
                                Object o = l.get(i);
                                if (!(o instanceof String) || !tranSQL) continue;
                                o = new String(((String)o).getBytes(), dbCharset);
                                l.set(i, o);
                            }
                        } else if (args[paramIndex] instanceof String && tranSQL) {
                            args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                        }
                        if (!(args[paramIndex] instanceof Sequence)) continue;
                        Object[] objs = ((Sequence)args[paramIndex]).toArray();
                        int objCount = objs.length;
                        StringBuffer sb = new StringBuffer(2 * objCount);
                        for (int iObj = 0; iObj < objCount; ++iObj) {
                            sb.append("?,");
                        }
                        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        if (sb.length() > 1) {
                            sql = sql.substring(0, pos) + sb.toString() + sql.substring(pos + 1);
                        }
                        pos += sb.length();
                    }
                }
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    String name2 = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name2 = info.getName();
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e1) {
                        throw new RQException(e1.getMessage(), (Throwable)e1);
                    }
                    throw new RQException(mm.getMessage("error.sqlException", (Object)name2, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                }
                if (args != null && args.length > 0) {
                    int pos = 0;
                    for (int iArg = 0; iArg < args.length; ++iArg) {
                        ++pos;
                        try {
                            byte type = argTypes[iArg];
                            if (args[iArg] != null && args[iArg] instanceof Sequence) {
                                Object[] objs = ((Sequence)args[iArg]).toArray();
                                for (int iObj = 0; iObj < objs.length; ++iObj) {
                                    SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)objs[iObj], (int)type);
                                    ++pos;
                                }
                                --pos;
                                continue;
                            }
                            SQLTool.setObject((int)dbType, (PreparedStatement)pst, (int)pos, (Object)args[iArg], (int)type);
                            continue;
                        }
                        catch (Exception e) {
                            String name3 = "";
                            DBInfo info = dbs.getInfo();
                            if (info != null) {
                                name3 = info.getName();
                            }
                            try {
                                if (con != null) {
                                    con.close();
                                }
                            }
                            catch (Exception e1) {
                                throw new RQException(e1.getMessage(), (Throwable)e1);
                            }
                            throw new RQException(mm.getMessage("error.argIndex", (Object)name3, (Object)Integer.toString(iArg + 1)));
                        }
                    }
                }
                try {
                    rs = pst.executeQuery();
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    String name4 = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name4 = info.getName();
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e1) {
                        throw new RQException(e1.getMessage(), (Throwable)e1);
                    }
                    throw new RQException(mm.getMessage("error.sqlException", (Object)name4, (Object)sql) + " : " + e.getMessage(), (Throwable)e);
                }
                if (oneRecord) {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e1) {
                        throw new RQException(e1.getMessage(), (Throwable)e1);
                    }
                    Table table2 = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, addTable, table, oneRecord, -1, opt);
                    return table2;
                }
                table = DatabaseUtil._$1(rs, dbCharset, tranContent, toCharset, dbType, addTable, table, oneRecord, -1, opt);
            }
            Table table3 = table;
            return table3;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static int update(ICursor cs, String table, String[] fields, String[] fopts, Expression[] exps, String opt, DBSession dbs, Context ctx) {
        return com.scudata.util.DatabaseUtil.update((ICursor)cs, (String)table, (String[])fields, (String[])fopts, (Expression[])exps, (String)opt, (DBSession)dbs, (Context)ctx);
    }

    public static int update(Sequence srcSeq, Sequence compSeq, String table, String[] fields, String[] fopts, Expression[] exps, String opt, DBSession dbs, Context ctx) {
        return com.scudata.util.DatabaseUtil.update((Sequence)srcSeq, (Sequence)compSeq, (String)table, (String[])fields, (String[])fopts, (Expression[])exps, (String)opt, (DBSession)dbs, (Context)ctx);
    }

    public static int update(Sequence srcSeries, String table, String[] fields, String[] fopts, Expression[] exps, String opt, DBSession dbs, Context ctx) {
        return com.scudata.util.DatabaseUtil.update((Sequence)srcSeries, (String)table, (String[])fields, (String[])fopts, (Expression[])exps, (String)opt, (DBSession)dbs, (Context)ctx);
    }

    public static Sequence query(Sequence srcSeries, String sql, Expression[] params, byte[] types, String opt, Context ctx, DBSession dbs) {
        return DatabaseUtil._$1(srcSeries, sql, params, types, opt, ctx, dbs, null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Sequence _$1(Sequence srcSeries, String sql, Expression[] params, byte[] types, String opt, Context ctx, DBSession dbs, String[] nullSqls, ArrayList<Integer> nullKeys, int keysize) {
        int i;
        if (srcSeries == null || srcSeries.length() == 0 || params == null || params.length == 0) {
            return DatabaseUtil.query(sql, null, null, opt, ctx, dbs);
        }
        int pCount = params.length;
        int keyStart = pCount - keysize;
        int len = srcSeries.length();
        ArrayList<ArrayList<Object>> vgs = new ArrayList<ArrayList<Object>>(len);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(srcSeries);
        stack.push((IComputeItem)current);
        int nulls = nullSqls == null ? 0 : nullSqls.length;
        boolean nkeys = nullKeys != null && nullKeys.size() > 0 && nulls > 0;
        ArrayList nullParams = null;
        int[] res = new int[len];
        if (nkeys) {
            nullParams = new ArrayList(nulls);
            for (i = 0; i < nulls; ++i) {
                nullParams.add(new ArrayList());
            }
        }
        try {
            for (i = 1; i <= len; ++i) {
                current.setCurrent(i);
                ArrayList<Object> pValues = new ArrayList<Object>();
                int nloc = 0;
                for (int p = 0; p < pCount; ++p) {
                    if (params[p] == null) continue;
                    Object pv = params[p].calculate(ctx);
                    if (nkeys && p >= keyStart && pv == null) {
                        int kloc = nullKeys.indexOf(p - keyStart);
                        nloc += 1 << kloc;
                    }
                    pValues.add(pv);
                }
                if (nloc > 0) {
                    nloc = nulls - nloc;
                    ((ArrayList)nullParams.get(nloc)).add(pValues);
                    res[i - 1] = nloc + 1;
                    continue;
                }
                vgs.add(pValues);
            }
        }
        finally {
            stack.pop();
        }
        Object[][] valueGroup = DatabaseUtil._$1(vgs);
        Table tbl = DatabaseUtil.queryGroup(sql, valueGroup, types, dbs, opt, ctx);
        if (nkeys) {
            ArrayList<Table> nTbls = new ArrayList<Table>(nulls);
            Table tbli = null;
            for (int i2 = 0; i2 < nulls; ++i2) {
                ArrayList nullParam = (ArrayList)nullParams.get(i2);
                valueGroup = DatabaseUtil._$1(nullParam, keyStart);
                if (valueGroup != null) {
                    tbli = DatabaseUtil.queryGroup(nullSqls[i2], valueGroup, null, dbs, opt, ctx);
                } else if (nullSqls[i2].indexOf("?") < 0) {
                    valueGroup = new Object[][]{null};
                    tbli = DatabaseUtil.queryGroup(nullSqls[i2], valueGroup, null, dbs, opt, ctx);
                }
                nTbls.add(tbli);
            }
            Sequence result = new Sequence(len);
            int[] locs = new int[nulls + 1];
            Object o = null;
            for (int i3 = 0; i3 < len; ++i3) {
                Table ot;
                int ri = res[i3];
                locs[ri] = locs[ri] + 1;
                o = ri <= 0 ? tbl.get(locs[ri]) : ((ot = (Table)nTbls.get(ri - 1)) == null ? null : ot.get(locs[ri]));
                result.add(o);
            }
            return result;
        }
        return tbl;
    }

    private static Object[][] _$1(ArrayList<ArrayList<Object>> lvalues) {
        int len = lvalues.size();
        if (len < 1) {
            return null;
        }
        ArrayList<Object> o1 = lvalues.get(0);
        int len2 = o1.size();
        if (len2 < 1) {
            return null;
        }
        Object[][] result = new Object[len][len2];
        for (int i = 0; i < len; ++i) {
            o1 = lvalues.get(i);
            for (int j = 0; j < len2; ++j) {
                result[i][j] = o1.get(j);
            }
        }
        return result;
    }

    private static Object[][] _$1(ArrayList<ArrayList<Object>> lvalues, int keyStart) {
        int len2;
        int len = lvalues.size();
        if (len < 1) {
            return null;
        }
        ArrayList<Object> o1 = lvalues.get(0);
        int len22 = len2 = o1.size();
        for (int i = keyStart; i < len2; ++i) {
            Object o = o1.get(i);
            if (o != null) continue;
            --len22;
        }
        if (len22 < 1) {
            return null;
        }
        Object[][] result = new Object[len][len22];
        for (int i = 0; i < len; ++i) {
            o1 = lvalues.get(i);
            int col = 0;
            for (int j = 0; j < len2; ++j) {
                Object o = o1.get(j);
                if (o == null) continue;
                result[i][col] = o;
                ++col;
            }
        }
        return result;
    }

    public static Sequence query(String sql, Object[] params, byte[] types, String opt, Context ctx, DBSession dbs) {
        return DatabaseUtil.query(sql, params, types, dbs, opt, ctx);
    }

    public static void execute(Sequence srcSeries, String sql, Expression[] params, byte[] types, Context ctx, DBSession dbs) {
        com.scudata.util.DatabaseUtil.execute((Sequence)srcSeries, (String)sql, (Expression[])params, (byte[])types, (Context)ctx, (DBSession)dbs);
    }

    public static void execute(ICursor cs, String sql, Expression[] params, byte[] types, Context ctx, DBSession dbs) {
        com.scudata.util.DatabaseUtil.execute((ICursor)cs, (String)sql, (Expression[])params, (byte[])types, (Context)ctx, (DBSession)dbs);
    }

    public static void connectAutoDBs(Context ctx, List<String> startDsNames) {
        com.scudata.util.DatabaseUtil.connectAutoDBs((Context)ctx, startDsNames);
    }

    public static void closeAutoDBs(Context ctx) {
        com.scudata.util.DatabaseUtil.closeAutoDBs((Context)ctx);
    }
}

