/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.op.Operation;
import com.scudata.expression.Expression;
import com.scudata.pdm.IIIIlIIIlIIllIll;
import com.scudata.pdm.IIlIlIllllIIllll;
import com.scudata.pdm.IIllIllIlllIlIII;
import com.scudata.pdm.IIllllIIIIIlIlII;
import com.scudata.pdm.IlIIIIIIlllIllll;
import com.scudata.pdm.PureTable;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.Job;
import com.scudata.thread.MultithreadUtil;
import com.scudata.thread.ThreadPool;

public final class ParallelUtil {
    public static Sequence calc(PureTable table, Expression exp, Context ctx) {
        if (exp == null) {
            return table;
        }
        int len = table.length();
        int parallelNum = Env.getParallelNum();
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            return table.calc(exp, ctx);
        }
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        IIIIlIIIlIIllIll[] jobs = new IIIIlIIIlIIllIll[threadCount];
        int start = 1;
        for (int i = 0; i < threadCount; ++i) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression tmpExp = exp.newExpression(tmpCtx);
            Table curTable = table.get(start, end);
            jobs[i] = new IIIIlIIIlIIllIll(curTable, tmpExp, tmpCtx);
            pool.submit((Job)jobs[i]);
            start = end;
        }
        IArray result = null;
        for (int i = 0; i < threadCount; ++i) {
            IArray temp = jobs[i].getResult();
            if (i == 0) {
                if (temp.isTemporary()) {
                    result = temp;
                    result.ensureCapacity(len);
                    continue;
                }
                result = temp.reserve(false);
                continue;
            }
            result.addAll(temp);
        }
        result.setTemporary(false);
        return new Sequence(result);
    }

    public static Table derive(PureTable table, DataStruct newDs, Expression[] exps, String opt, Context ctx) {
        int len = table.length();
        int parallelNum = Env.getParallelNum();
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            opt = opt.replace("m", "");
            return table.derive(newDs, exps, opt, ctx);
        }
        opt = opt.replace('m', 'o');
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        IIllIllIlllIlIII[] jobs = new IIllIllIlllIlIII[threadCount];
        int start = 1;
        for (int i = 0; i < threadCount; ++i) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = Operation.dupExpressions((Expression[])exps, (Context)tmpCtx);
            Table curTable = table.get(start, end);
            jobs[i] = new IIllIllIlllIlIII(curTable, newDs, tmpExps, opt, tmpCtx);
            pool.submit((Job)jobs[i]);
            start = end;
        }
        Table result = null;
        for (int i = 0; i < threadCount; ++i) {
            Table temp = jobs[i].getResult();
            if (i == 0) {
                result = temp;
                continue;
            }
            result.append((Sequence)temp);
        }
        return result;
    }

    public static Object select(PureTable table, Expression exp, String opt, Context ctx) {
        int len = table.length();
        int parallelNum = Env.getParallelNum();
        opt = opt.replace("m", "");
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            return table.select(exp, opt, ctx);
        }
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        IIlIlIllllIIllll[] jobs = new IIlIlIllllIIllll[threadCount];
        int start = 1;
        for (int i = 0; i < threadCount; ++i) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression tmpExp = exp.newExpression(tmpCtx);
            Table curTable = table.get(start, end);
            jobs[i] = new IIlIlIllllIIllll(curTable, tmpExp, opt, tmpCtx);
            pool.submit((Job)jobs[i]);
            start = end;
        }
        Sequence result = null;
        for (int i = 0; i < threadCount; ++i) {
            Sequence temp = jobs[i].getResult();
            if (result == null) {
                result = temp;
                continue;
            }
            result.append(temp);
        }
        return result;
    }

    public static Object select(PureTable table, Expression[] fltExps, Object[] vals, String opt, Context ctx) {
        int len = table.length();
        int parallelNum = Env.getParallelNum();
        opt = opt.replace("m", "");
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            return table.select(fltExps, vals, opt, ctx);
        }
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        IIlIlIllllIIllll[] jobs = new IIlIlIllllIIllll[threadCount];
        int start = 1;
        for (int i = 0; i < threadCount; ++i) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = Operation.dupExpressions((Expression[])fltExps, (Context)ctx);
            Table curTable = table.get(start, end);
            jobs[i] = new IIlIlIllllIIllll(curTable, tmpExps, vals, opt, tmpCtx);
            pool.submit((Job)jobs[i]);
            start = end;
        }
        Sequence result = null;
        for (int i = 0; i < threadCount; ++i) {
            Sequence temp = jobs[i].getResult();
            if (result == null) {
                result = temp;
                continue;
            }
            result.append(temp);
        }
        return result;
    }

    public static PureTable newTable(PureTable table, DataStruct ds, Expression[] exps, String opt, Context ctx) {
        int len = table.length();
        int parallelNum = Env.getParallelNum();
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            opt = opt.replace("m", "");
            return table.newTable(ds, exps, opt, ctx);
        }
        opt = opt.replace("m", "o");
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        IlIIIIIIlllIllll[] jobs = new IlIIIIIIlllIllll[threadCount];
        int start = 1;
        for (int i = 0; i < threadCount; ++i) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = Operation.dupExpressions((Expression[])exps, (Context)ctx);
            PureTable curTable = (PureTable)table.get(start, end);
            jobs[i] = new IlIIIIIIlllIllll(curTable, ds, tmpExps, opt, tmpCtx);
            pool.submit((Job)jobs[i]);
            start = end;
        }
        PureTable result = null;
        for (int i = 0; i < threadCount; ++i) {
            PureTable temp = jobs[i].getResult();
            if (result == null) {
                result = temp;
                continue;
            }
            result.append((Sequence)temp);
        }
        return result;
    }

    public static void run(PureTable src, Expression[] assignExps, Expression[] exps, Context ctx) {
        int i;
        if (exps == null || exps.length == 0) {
            return;
        }
        int colCount = exps.length;
        if (assignExps == null) {
            assignExps = new Expression[colCount];
        } else if (assignExps.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("run" + mm.getMessage("function.invalidParam"));
        }
        DataStruct ds = src.dataStruct();
        for (int i2 = 0; i2 < colCount; ++i2) {
            if (assignExps[i2] == null) {
                MultithreadUtil.run((Sequence)src, (Expression[])assignExps, (Expression[])exps, (Context)ctx);
                return;
            }
            if (assignExps[i2].getFieldIndex(ds) >= 0) continue;
            MultithreadUtil.run((Sequence)src, (Expression[])assignExps, (Expression[])exps, (Context)ctx);
            return;
        }
        int len = src.length();
        int parallelNum = Env.getParallelNum();
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            src.run(assignExps, exps, ctx);
            return;
        }
        int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        IIllllIIIIIlIlII[] jobs = new IIllllIIIIIlIlII[threadCount];
        int start = 1;
        for (i = 0; i < threadCount; ++i) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tempAssignExps = new Expression[colCount];
            Expression[] tmpExps = new Expression[colCount];
            for (int k = 0; k < colCount; ++k) {
                tempAssignExps[k] = assignExps[k].newExpression(tmpCtx);
                tmpExps[k] = exps[k].newExpression(tmpCtx);
            }
            jobs[i] = new IIllllIIIIIlIlII(src, start, end - 1, tempAssignExps, tmpExps, tmpCtx);
            pool.submit((Job)jobs[i]);
            start = end;
        }
        for (i = 0; i < threadCount; ++i) {
            jobs[i].join();
        }
    }
}

