/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm;

import com.scudata.array.IArray;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.expression.Expression;
import com.scudata.pdm.PureTable;
import com.scudata.thread.Job;

class RunJob
extends Job {
    private PureTable src;
    private Context ctx;
    private Expression[] assignExps;
    private Expression[] exps;
    private int start;
    private int end;

    public RunJob(PureTable src, int start, int end, Expression[] assignExps, Expression[] exps, Context ctx) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.assignExps = assignExps;
        this.exps = exps;
        this.ctx = ctx;
    }

    public void run() {
        PureTable sub = this.src.getSubset(this.start, this.end);
        DataStruct ds = this.src.dataStruct();
        IArray[] colDatas = (IArray[])sub.getColDatas().clone();
        int colCount = this.assignExps.length;
        int[] fields = new int[colCount];
        int i = 0;
        while (i < colCount) {
            fields[i] = this.assignExps[i].getFieldIndex(ds);
            ++i;
        }
        sub.run(this.assignExps, this.exps, this.ctx);
        IArray[] newColDatas = sub.getColDatas();
        int i2 = 0;
        while (i2 < colCount) {
            int f = fields[i2];
            IArray oldCol = colDatas[f];
            IArray newCol = newColDatas[f];
            if (oldCol != newCol) {
                IArray arr = this.src.getColDatas()[f];
                int j = this.start;
                int k = 1;
                int end = this.end;
                while (j <= end) {
                    arr.set(j, newCol, k);
                    ++j;
                    ++k;
                }
            }
            ++i2;
        }
    }
}

