/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArraySubset
extends DoubleArray {
    private static final long serialVersionUID = 1L;
    private DoubleArray _$7;
    private double[] _$6;
    private boolean[] _$5;
    private int _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public DoubleArraySubset(DoubleArray array, int start, int end) {
        super(array.getDatas(), array.getSigns(), array.size());
        this._$6 = array.getDatas();
        this._$5 = array.getSigns();
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
        this._$7 = array;
    }

    public double[] getDatas() {
        int len = this._$2 + 1;
        double[] newDatas = new double[len];
        System.arraycopy(this._$6, this._$4, newDatas, 0, len);
        return newDatas;
    }

    public boolean[] getSigns() {
        int len = this._$2 + 1;
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[len];
            System.arraycopy(this._$5, this._$4, newSigns, 0, len);
        }
        return newSigns;
    }

    public boolean getSign(int index) {
        return this._$5[index + this._$1];
    }

    public IArray dup() {
        int len = this._$2 + 1;
        double[] newDatas = new double[len];
        System.arraycopy(this._$6, this._$4, newDatas, 0, len);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[len];
            System.arraycopy(this._$5, this._$4, newSigns, 0, len);
        }
        return new DoubleArray(newDatas, newSigns, this._$2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new RuntimeException();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public byte[] serialize() throws IOException {
        throw new RuntimeException();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public IArray newInstance(int count) {
        return new DoubleArray(count);
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertDouble(int index, double o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        this.set(curIndex, array.get(index));
    }

    public void addDouble(double n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(double n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushDouble(double n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public Object get(int index) {
        if (this._$5 == null || !this._$5[index += this._$1]) {
            return this._$6[index];
        }
        return null;
    }

    public int getInt(int index) {
        return (int)this._$6[index + this._$1];
    }

    public long getLong(int index) {
        return (long)this._$6[index + this._$1];
    }

    public double getDouble(int index) {
        return this._$6[index + this._$1];
    }

    public IArray get(int[] indexArray) {
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = indexArray.length;
        DoubleArray result = new DoubleArray(len);
        int offset = this._$1;
        if (signs == null) {
            for (int i : indexArray) {
                result.pushDouble(datas[i += offset]);
            }
        } else {
            for (int i : indexArray) {
                if (signs[i += offset]) {
                    result.pushNull();
                    continue;
                }
                result.pushDouble(datas[i]);
            }
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = end - start + 1;
        int offset = this._$1;
        if (doCheck) {
            DoubleArray result = new DoubleArray(len);
            if (signs == null) {
                while (start <= end) {
                    int q = indexArray[start];
                    if (q > 0) {
                        result.pushDouble(datas[q + offset]);
                    } else {
                        result.pushNull();
                    }
                    ++start;
                }
            } else {
                while (start <= end) {
                    int q = indexArray[start];
                    if (q < 1 || signs[q + offset]) {
                        result.pushNull();
                    } else {
                        result.pushDouble(datas[q + offset]);
                    }
                    ++start;
                }
            }
            return result;
        }
        if (signs == null) {
            double[] resultDatas = new double[len + 1];
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start] + offset];
                ++start;
            }
            return new DoubleArray(resultDatas, null, len);
        }
        DoubleArray result = new DoubleArray(len);
        while (start <= end) {
            int q = indexArray[start];
            if (signs[q + offset]) {
                result.pushNull();
            } else {
                result.pushDouble(datas[q + offset]);
            }
            ++start;
        }
        return result;
    }

    public IArray get(IArray indexArray) {
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = indexArray.size();
        DoubleArray result = new DoubleArray(len);
        if (signs == null) {
            for (int i = 1; i <= len; ++i) {
                result.pushDouble(datas[indexArray.getInt(i) + this._$1]);
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                int index = indexArray.getInt(i);
                if (signs[index + this._$1]) {
                    result.pushNull();
                    continue;
                }
                result.pushDouble(datas[index + this._$1]);
            }
        }
        return result;
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        double[] newDatas = new double[newSize + 1];
        System.arraycopy(this._$6, start + this._$1, newDatas, 1, newSize);
        if (this._$5 == null) {
            return new DoubleArray(newDatas, null, newSize);
        }
        boolean[] newSigns = new boolean[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newSigns, 1, newSize);
        return new DoubleArray(newDatas, newSigns, newSize);
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5 != null && this._$5[index + this._$1];
    }

    public BoolArray isTrue() {
        int i;
        boolean[] signs = this._$5;
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        if (signs == null) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = !signs[off];
                ++i;
                ++off;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        if (this._$5 == null) {
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = false;
            }
        } else {
            System.arraycopy(this._$5, this._$4, resultDatas, 1, size);
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return this._$5 == null || !this._$5[index + this._$1];
    }

    public boolean isFalse(int index) {
        return this._$5 != null && this._$5[index + this._$1];
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public int count() {
        boolean[] signs = this._$5;
        int size = this._$2;
        int end = this._$3;
        if (signs == null) {
            return size;
        }
        int count = size;
        for (int i = this._$4; i <= end; ++i) {
            if (!signs[i]) continue;
            --count;
        }
        return count;
    }

    public boolean containTrue() {
        int size = this._$2;
        if (size == 0) {
            return false;
        }
        boolean[] signs = this._$5;
        if (signs == null) {
            return true;
        }
        int end = this._$3;
        for (int i = this._$4; i <= end; ++i) {
            if (signs[i]) continue;
            return true;
        }
        return false;
    }

    public Object ifn() {
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        boolean[] signs = this._$5;
        if (signs == null) {
            return this._$6[this._$4];
        }
        int end = this._$3;
        for (int i = this._$4; i <= end; ++i) {
            if (signs[i]) continue;
            return this._$6[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index, Object obj) {
        index += this._$1;
        if (obj == null) {
            if (this._$5 == null) {
                DoubleArray doubleArray = this._$7;
                synchronized (doubleArray) {
                    if (super.getSigns() != null) {
                        this._$5 = super.getSigns();
                    } else {
                        this._$5 = new boolean[this._$6.length];
                        this._$7.setSigns(this._$5);
                        super.setSigns(this._$5);
                    }
                }
            }
            this._$5[index] = true;
        } else if (obj instanceof Double) {
            this._$6[index] = (Double)obj;
            if (this._$5 != null) {
                this._$5[index] = false;
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", (Object)mm.getMessage("DataType.Double"), (Object)Variant.getDataType((Object)obj)));
        }
    }

    public void clear() {
        throw new RuntimeException();
    }

    public int binarySearch(Object elem) {
        int idx = super.binarySearch(elem, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(double v, int start, int end) {
        int idx = super.binarySearch(v, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(double v) {
        int idx = super.binarySearch(v, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(Object elem) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            double v = number.doubleValue();
            if (DoubleArraySubset.compare((double)v, (Object)number) != 0) {
                return false;
            }
            double[] datas = this._$6;
            boolean[] signs = this._$5;
            int end = this._$3;
            if (signs == null) {
                for (int i = this._$4; i <= end; ++i) {
                    if (Double.compare(datas[i], v) != 0) continue;
                    return true;
                }
            } else {
                for (int i = this._$4; i <= end; ++i) {
                    if (signs[i] || Double.compare(datas[i], v) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return false;
            }
            int end = this._$3;
            for (int i = this._$4; i <= end; ++i) {
                if (!signs[i]) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean contains(double v) {
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int end = this._$3;
        if (signs == null) {
            for (int i = this._$4; i <= end; ++i) {
                if (Double.compare(datas[i], v) != 0) continue;
                return true;
            }
        } else {
            for (int i = this._$4; i <= end; ++i) {
                if (signs[i] || Double.compare(datas[i], v) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (array instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)array;
            if (isSorted) {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i)) continue;
                    if (numberArray.isNull(i)) {
                        if (this.binarySearch(null) >= 1) continue;
                        result.set(i, false);
                        continue;
                    }
                    if (this.binarySearch(numberArray.getDouble(i)) >= 1) continue;
                    result.set(i, false);
                }
            } else {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i)) continue;
                    if (numberArray.isNull(i)) {
                        if (this.contains(null)) continue;
                        result.set(i, false);
                        continue;
                    }
                    if (this.contains(numberArray.getDouble(i))) continue;
                    result.set(i, false);
                }
            }
        } else if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            double v = number.doubleValue();
            if (DoubleArraySubset.compare((double)v, (Object)number) != 0) {
                return 0;
            }
            boolean[] signs = this._$5;
            int size = this._$2;
            if (signs == null) {
                for (int i = start; i <= size; ++i) {
                    if (Double.compare(this.getDouble(i), v) != 0) continue;
                    return i;
                }
            } else {
                for (int i = start; i <= size; ++i) {
                    if (this.getSign(i) || Double.compare(this.getDouble(i), v) != 0) continue;
                    return i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return 0;
            }
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (!this.getSign(i)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public int firstIndexOf(double v, int start) {
        boolean[] signs = this._$5;
        int size = this._$2;
        if (signs == null) {
            for (int i = start; i <= size; ++i) {
                if (Double.compare(this.getDouble(i), v) != 0) continue;
                return i;
            }
        } else {
            for (int i = start; i <= size; ++i) {
                if (this.getSign(i) || Double.compare(this.getDouble(i), v) != 0) continue;
                return i;
            }
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            double v = number.doubleValue();
            if (DoubleArraySubset.compare((double)v, (Object)number) != 0) {
                return 0;
            }
            boolean[] signs = this._$5;
            if (signs == null) {
                for (int i = start; i > 0; --i) {
                    if (Double.compare(this.getDouble(i), v) != 0) continue;
                    return i;
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (this.getSign(i) || Double.compare(this.getDouble(i), v) != 0) continue;
                    return i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return 0;
            }
            for (int i = start; i > 0; --i) {
                if (!this.getSign(i)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        boolean[] signs = this._$5;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (signs != null) {
                if (isSorted) {
                    if (isFromHead) {
                        for (int i = start; i <= size && this.getSign(i); ++i) {
                            result.addInt(i);
                        }
                    } else {
                        for (int i = start; i > 0; --i) {
                            if (!this.getSign(i)) continue;
                            result.addInt(i);
                        }
                    }
                } else if (isFromHead) {
                    for (int i = start; i <= size; ++i) {
                        if (!this.getSign(i)) continue;
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (!this.getSign(i)) continue;
                        result.addInt(i);
                    }
                }
            }
            return result;
        }
        if (!(elem instanceof Number)) {
            return new IntArray(1);
        }
        Number number = (Number)elem;
        if (isSorted) {
            int last;
            int first;
            int index;
            int end = size;
            if (isFromHead) {
                end = start;
                start = 1;
            }
            if ((index = this.binarySearch(number, start, end)) < 1) {
                return new IntArray(1);
            }
            double v = number.doubleValue();
            for (first = index; !(first <= start || signs != null && this.getSign(first - 1) || this.getDouble(first - 1) != v); --first) {
            }
            for (last = index; !(last >= end || signs != null && this.getSign(last + 1) || this.getDouble(last + 1) != v); ++last) {
            }
            IntArray result = new IntArray(last - first + 1);
            if (isFromHead) {
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
            } else {
                while (last >= first) {
                    result.pushInt(last);
                    --last;
                }
            }
            return result;
        }
        double v = number.doubleValue();
        if (DoubleArraySubset.compare((double)v, (Object)number) != 0) {
            return new IntArray(1);
        }
        IntArray result = new IntArray(7);
        if (isFromHead) {
            for (int i = start; i <= size; ++i) {
                if (signs != null && this.getSign(i) || this.getDouble(i) != v) continue;
                result.addInt(i);
            }
        } else {
            for (int i = start; i > 0; --i) {
                if (signs != null && this.getSign(i) || this.getDouble(i) != v) continue;
                result.addInt(i);
            }
        }
        return result;
    }

    public IArray abs() {
        int size = this._$2;
        boolean[] signs = null;
        double[] datas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, datas, 1, size);
        if (this._$5 != null) {
            signs = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, signs, 1, size);
        }
        DoubleArray result = new DoubleArray(datas, signs, size);
        result.setTemporary(true);
        if (signs == null) {
            for (int i = 1; i <= size; ++i) {
                if (!(datas[i] <= 0.0)) continue;
                datas[i] = 0.0 - datas[i];
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (signs[i] || !(datas[i] <= 0.0)) continue;
                datas[i] = 0.0 - datas[i];
            }
        }
        return result;
    }

    public IArray negate() {
        int size = this._$2;
        double[] datas = this._$6;
        double[] newDatas = new double[size + 1];
        int offset = this._$4;
        for (int i = 1; i <= size; ++i) {
            newDatas[i] = -datas[offset++];
        }
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result;
    }

    public IArray not() {
        boolean[] signs = this._$5;
        int size = this._$2;
        if (signs == null) {
            return new ConstArray((Object)Boolean.FALSE, size);
        }
        boolean[] newDatas = new boolean[size + 1];
        System.arraycopy(signs, this._$4, newDatas, 1, size);
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        return true;
    }

    public IArray memberAdd(IArray array) {
        if (array instanceof IntArray) {
            return this.memberAdd((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberAdd((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberAdd((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberAdd((IArray)this);
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).memberAdd((IArray)this);
        }
        if (array instanceof StringArray) {
            return ((StringArray)array).memberAdd((NumberArray)this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        if (value instanceof String) {
            value = Variant.parseNumber((String)((String)value));
        }
        if (value == null) {
            return this;
        }
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = v.add(new BigDecimal(datas[off++]));
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = signs[off] ? v : v.add(new BigDecimal(datas[off]));
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = v + datas[off++];
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = signs[off] ? v : v + datas[off];
                    ++off;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Date) {
            int i;
            Date v = (Date)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = Variant.elapse((Date)v, (int)((int)datas[off++]), null);
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = signs[off] ? v : Variant.elapse((Date)v, (int)((int)datas[off]), null);
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    public DoubleArray memberAdd(IntArray array) {
        int size = this._$2;
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result.memberAdd(array);
    }

    public DoubleArray memberAdd(LongArray array) {
        int size = this._$2;
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result.memberAdd(array);
    }

    public DoubleArray memberAdd(DoubleArray array) {
        int size = this._$2;
        if (array.isTemporary()) {
            return array.memberAdd((DoubleArray)this);
        }
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result.memberAdd(array);
    }

    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this._$4((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$4((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$4((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$4(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$4((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray _$4(Object value) {
        if (value == null) {
            return this;
        }
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = new BigDecimal(datas[off++]).subtract(v);
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = signs[off] ? v.negate() : new BigDecimal(datas[off]).subtract(v);
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int off = this._$4;
                    for (int i2 = 1; i2 <= size; ++i2) {
                        int n = off++;
                        datas[n] = datas[n] - v;
                    }
                } else {
                    int off = this._$4;
                    for (int i3 = 1; i3 <= size; ++i3) {
                        if (signs[off]) {
                            datas[off] = -v;
                        } else {
                            int n = off;
                            datas[n] = datas[n] - v;
                        }
                        ++off;
                    }
                    this._$5 = null;
                }
                return this;
            }
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = datas[off++] - v;
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = signs[off] ? -v : datas[off] - v;
                    ++off;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illSubtract"));
    }

    private DoubleArray _$4(IntArray array) {
        Object resultSigns;
        double[] resultDatas;
        DoubleArraySubset result;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            resultSigns = s1;
        } else {
            resultDatas = new double[size + 1];
            resultSigns = s1 != null && array.hasSigns() ? new boolean[size + 1] : null;
            result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (s1 == null) {
            if (!array.hasSigns()) {
                int off = this._$4;
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = d1[off++] - (double)array.getInt(i);
                }
            } else {
                int off = this._$4;
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = array.isNull(i) ? d1[off] : d1[off] - (double)array.getInt(i);
                    ++off;
                }
            }
            result.setSigns(null);
        } else if (!array.hasSigns()) {
            int off = this._$4;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = s1[off] ? (double)(-array.getInt(i)) : d1[off] - (double)array.getInt(i);
                ++off;
            }
            result.setSigns(null);
        } else {
            int off = this._$4;
            for (int i = 1; i <= size; ++i) {
                if (s1[off]) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -array.getInt(i);
                    }
                } else {
                    resultDatas[i] = array.isNull(i) ? d1[off] : d1[off] - (double)array.getInt(i);
                }
                ++off;
            }
        }
        return result;
    }

    private DoubleArray _$4(LongArray array) {
        Object resultSigns;
        double[] resultDatas;
        DoubleArraySubset result;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        if (this.isTemporary()) {
            result = this;
            resultDatas = d1;
            resultSigns = s1;
        } else {
            resultDatas = new double[size + 1];
            resultSigns = s1 != null && array.hasSigns() ? new boolean[size + 1] : null;
            result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
        }
        if (s1 == null) {
            if (!array.hasSigns()) {
                int off = this._$4;
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = d1[off++] - (double)array.getLong(i);
                }
            } else {
                int off = this._$4;
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = array.isNull(i) ? d1[off] : d1[off] - (double)array.getLong(i);
                    ++off;
                }
            }
            result.setSigns(null);
        } else if (!array.hasSigns()) {
            int off = this._$4;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = s1[off] ? (double)(-array.getLong(i)) : d1[off] - (double)array.getLong(i);
                ++off;
            }
            result.setSigns(null);
        } else {
            int off = this._$4;
            for (int i = 1; i <= size; ++i) {
                if (s1[off]) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -array.getLong(i);
                    }
                } else {
                    resultDatas[i] = array.isNull(i) ? d1[off] : d1[off] - (double)array.getLong(i);
                }
                ++off;
            }
        }
        return result;
    }

    private DoubleArray _$4(DoubleArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        double[] resultDatas = new double[size + 1];
        boolean[] resultSigns = s1 != null && array.hasSigns() ? new boolean[size + 1] : null;
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (s1 == null) {
            if (!array.hasSigns()) {
                int off = this._$4;
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = d1[off++] - array.getDouble(i);
                }
            } else {
                int off = this._$4;
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = array.isNull(i) ? d1[off] : d1[off] - array.getDouble(i);
                    ++off;
                }
            }
            result.setSigns(null);
        } else if (!array.hasSigns()) {
            int off = this._$4;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = s1[off] ? -array.getDouble(i) : d1[off] - array.getDouble(i);
                ++off;
            }
            result.setSigns(null);
        } else {
            int off = this._$4;
            for (int i = 1; i <= size; ++i) {
                if (s1[off]) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -array.getDouble(i);
                    }
                } else {
                    resultDatas[i] = array.isNull(i) ? d1[off] : d1[off] - array.getDouble(i);
                }
                ++off;
            }
        }
        return result;
    }

    private ObjectArray _$4(ObjectArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int off = this._$4;
        for (int i = 1; i <= size; ++i) {
            Object v = array.get(i);
            if (v == null) {
                if (s1 == null || !s1[off]) {
                    resultDatas[i] = d1[off];
                }
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = s1 == null || !s1[off] ? new BigDecimal(d1[off]).subtract((BigDecimal)v) : ((BigDecimal)v).negate();
            } else if (v instanceof BigInteger) {
                resultDatas[i] = s1 == null || !s1[off] ? new BigDecimal(d1[off]).subtract(new BigDecimal((BigInteger)v)) : new BigDecimal((BigInteger)v).negate();
            } else if (v instanceof Number) {
                resultDatas[i] = s1 == null || !s1[off] ? Double.valueOf(d1[off] - ((Number)v).doubleValue()) : Double.valueOf(-((Number)v).doubleValue());
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illSubtract"));
            }
            ++off;
        }
        return result;
    }

    public IArray memberMultiply(IArray array) {
        if (array instanceof IntArray) {
            return this.memberMultiply((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberMultiply((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberMultiply((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberMultiply(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberMultiply((IArray)this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = v.multiply(new BigDecimal(datas[off++]));
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    if (!signs[off]) {
                        resultDatas[i] = v.multiply(new BigDecimal(datas[off]));
                    }
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int off = this._$4;
                    for (int i2 = 1; i2 <= size; ++i2) {
                        int n = off++;
                        datas[n] = datas[n] * v;
                    }
                } else {
                    int off = this._$4;
                    for (int i3 = 1; i3 <= size; ++i3) {
                        if (!signs[off]) {
                            int n = off;
                            datas[n] = datas[n] * v;
                        }
                        ++off;
                    }
                }
                return this;
            }
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = v * datas[off++];
                }
            } else {
                resultSigns = new boolean[size + 1];
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    if (signs[off]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v * datas[off];
                    }
                    ++off;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        if (value instanceof Sequence) {
            int i;
            Sequence sequence = (Sequence)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = sequence.multiply((int)datas[off++]);
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = signs[off] ? null : sequence.multiply((int)datas[off]);
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMultiply"));
    }

    public DoubleArray memberMultiply(IntArray array) {
        int size = this._$2;
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result.memberMultiply(array);
    }

    public DoubleArray memberMultiply(LongArray array) {
        int size = this._$2;
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result.memberMultiply(array);
    }

    public DoubleArray memberMultiply(DoubleArray array) {
        int size = this._$2;
        if (array.isTemporary()) {
            return array.memberMultiply((DoubleArray)this);
        }
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result.memberMultiply(array);
    }

    public IArray memberDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$3((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$3((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$3((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$3(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$3((ObjectArray)array);
        }
        if (array instanceof StringArray) {
            return this._$1((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray _$3(Object value) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    BigDecimal decimal = new BigDecimal(datas[off++]);
                    resultDatas[i] = decimal.divide(v, 16, 4);
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    if (!signs[off]) {
                        BigDecimal decimal = new BigDecimal(datas[off]);
                        resultDatas[i] = decimal.divide(v, 16, 4);
                    }
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int off = this._$4;
                    for (int i2 = 1; i2 <= size; ++i2) {
                        int n = off++;
                        datas[n] = datas[n] / v;
                    }
                } else {
                    int off = this._$4;
                    for (int i3 = 1; i3 <= size; ++i3) {
                        if (!signs[off]) {
                            int n = off;
                            datas[n] = datas[n] / v;
                        }
                        ++off;
                    }
                }
                return this;
            }
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = datas[off++] / v;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    if (signs[off]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = datas[off] / v;
                    }
                    ++off;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof String) {
            int i;
            String str = (String)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = datas[off++] + str;
                }
            } else {
                int off = this._$4;
                for (i = 1; i <= size; ++i) {
                    if (!signs[off]) {
                        resultDatas[i] = datas[off] + str;
                    }
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illDivide"));
    }

    private DoubleArray _$3(IntArray array) {
        int size = this._$2;
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return (DoubleArray)result.memberDivide((IArray)array);
    }

    private DoubleArray _$3(LongArray array) {
        int size = this._$2;
        double[] newDatas = new double[size + 1];
        System.arraycopy(this._$6, this._$4, newDatas, 1, size);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return (DoubleArray)result.memberDivide((IArray)array);
    }

    private DoubleArray _$3(DoubleArray array) {
        int off;
        boolean[] s2;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        double[] resultDatas = new double[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                s2 = array.getSigns();
                System.arraycopy(s2, 1, resultSigns, 1, size);
                int off2 = this._$4;
                for (int i = 1; i <= size; ++i) {
                    if (!s1[off2++]) continue;
                    resultSigns[i] = true;
                }
            } else {
                System.arraycopy(s1, this._$4, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            s2 = array.getSigns();
            resultSigns = new boolean[size + 1];
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            off = this._$4;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = d1[off++] / array.getDouble(i);
            }
        } else {
            off = this._$4;
            for (int i = 1; i <= size; ++i) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[off] / array.getDouble(i);
                }
                ++off;
            }
        }
        return result;
    }

    private StringArray _$1(StringArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            if (array.getString(i) != null) {
                resultDatas[i] = s1 == null || !s1[off] ? d1[off] + array.getString(i) : array.getString(i);
            } else if (s1 == null || !s1[off]) {
                resultDatas[i] = Double.toString(d1[off]);
            }
            ++i;
            ++off;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray _$3(ObjectArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            BigDecimal decimal;
            Object v = array.get(i);
            if (v instanceof BigDecimal) {
                if (s1 == null || !s1[off]) {
                    decimal = new BigDecimal(d1[off]);
                    resultDatas[i] = decimal.divide((BigDecimal)v, 16, 4);
                } else {
                    resultDatas[i] = null;
                }
            } else if (v instanceof BigInteger) {
                if (s1 == null || !s1[off]) {
                    decimal = new BigDecimal(d1[off]);
                    resultDatas[i] = decimal.divide(new BigDecimal((BigInteger)v), 16, 4);
                } else {
                    resultDatas[i] = null;
                }
            } else if (v instanceof Number) {
                resultDatas[i] = s1 == null || !s1[off] ? Double.valueOf(d1[off] / ((Number)v).doubleValue()) : null;
            } else if (v instanceof String) {
                resultDatas[i] = s1 == null || !s1[off] ? d1[off] + (String)v : v;
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++off;
        }
        return result;
    }

    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$2((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$2((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$2((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$2(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$2((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private LongArray _$2(IntArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        if (s1 == null) {
            if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[off] / (long)array.getInt(i);
                    ++i;
                    ++off;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (long)d1[off] / (long)array.getInt(i);
                    }
                    ++i;
                    ++off;
                }
            }
        } else if (!array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (s1[off]) {
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = (long)d1[off] / (long)array.getInt(i);
                }
                ++i;
                ++off;
            }
        } else {
            resultSigns = new boolean[size + 1];
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (s1[off] || array.isNull(i)) {
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = (long)d1[off] / (long)array.getInt(i);
                }
                ++i;
                ++off;
            }
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private LongArray _$2(LongArray array) {
        int off;
        boolean[] s2;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        long[] resultDatas = new long[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                s2 = array.getSigns();
                System.arraycopy(s2, 1, resultSigns, 1, size);
                int i = 1;
                int off2 = this._$4;
                while (i <= size) {
                    if (s1[off2]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++off2;
                }
            } else {
                System.arraycopy(s1, this._$4, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            s2 = array.getSigns();
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                resultDatas[i] = (long)d1[off] / (long)array.getInt(i);
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (long)d1[off] / (long)array.getInt(i);
                }
                ++i;
                ++off;
            }
        }
        return result;
    }

    private LongArray _$2(DoubleArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        if (s1 == null) {
            if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[off] / (long)array.getDouble(i);
                    ++i;
                    ++off;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (long)d1[off] / (long)array.getDouble(i);
                    }
                    ++i;
                    ++off;
                }
            }
        } else if (!array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (s1[off]) {
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = (long)d1[off] / (long)array.getDouble(i);
                }
                ++i;
                ++off;
            }
        } else {
            resultSigns = new boolean[size + 1];
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (s1[off] || array.isNull(i)) {
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = (long)d1[off] / (long)array.getDouble(i);
                }
                ++i;
                ++off;
            }
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private IArray _$2(Object value) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigInteger v = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : (BigInteger)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    BigInteger bi = BigInteger.valueOf((long)datas[off]);
                    resultDatas[i] = new BigDecimal(bi.divide(v));
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!signs[off]) {
                        BigInteger bi = BigInteger.valueOf((long)datas[off]);
                        resultDatas[i] = new BigDecimal(bi.divide(v));
                    }
                    ++i;
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)datas[off] / v;
                    ++i;
                    ++off;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (long)datas[off] / v;
                    }
                    ++i;
                    ++off;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illDivide"));
    }

    private IArray _$2(ObjectArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            BigInteger bi1;
            Object v = array.get(i);
            if (v == null || s1 != null && s1[off]) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                bi1 = BigInteger.valueOf((long)d1[off]);
                BigInteger bi2 = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                bi1 = BigInteger.valueOf((long)d1[off]);
                resultDatas[i] = new BigDecimal(bi1.divide((BigInteger)v));
            } else if (v instanceof Number) {
                resultDatas[i] = (long)d1[off] / ((Number)v).longValue();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++off;
        }
        return result;
    }

    public IArray memberMod(IArray array) {
        if (array instanceof IntArray) {
            return this._$1((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$1((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$1((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$1(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$1((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private DoubleArray _$1(IntArray array) {
        int off;
        boolean[] s2;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        double[] resultDatas = new double[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                s2 = array.getSigns();
                System.arraycopy(s2, 1, resultSigns, 1, size);
                int i = 1;
                int off2 = this._$4;
                while (i <= size) {
                    if (s1[off2]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++off2;
                }
            } else {
                System.arraycopy(s1, this._$4, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            s2 = array.getSigns();
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[off] % (double)array.getInt(i);
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[off] % (double)array.getInt(i);
                }
                ++i;
                ++off;
            }
        }
        return result;
    }

    private DoubleArray _$1(LongArray array) {
        int off;
        boolean[] s2;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        double[] resultDatas = new double[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                s2 = array.getSigns();
                System.arraycopy(s2, 1, resultSigns, 1, size);
                int i = 1;
                int off2 = this._$4;
                while (i <= size) {
                    if (s1[off2]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++off2;
                }
            } else {
                System.arraycopy(s1, this._$4, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            s2 = array.getSigns();
            resultSigns = new boolean[size + 1];
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[off] % (double)array.getLong(i);
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[off] % (double)array.getLong(i);
                }
                ++i;
                ++off;
            }
        }
        return result;
    }

    private DoubleArray _$1(DoubleArray array) {
        int off;
        boolean[] s2;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        double[] resultDatas = new double[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                s2 = array.getSigns();
                System.arraycopy(s2, 1, resultSigns, 1, size);
                int i = 1;
                int off2 = this._$4;
                while (i <= size) {
                    if (s1[off2]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++off2;
                }
            } else {
                System.arraycopy(s1, this._$4, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            s2 = array.getSigns();
            System.arraycopy(s2, 1, resultSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[off] % array.getDouble(i);
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            off = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[off] % array.getDouble(i);
                }
                ++i;
                ++off;
            }
        }
        return result;
    }

    private IArray _$1(Object value) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigInteger v = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : (BigInteger)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    BigInteger bi = BigInteger.valueOf((long)datas[off]);
                    resultDatas[i] = new BigDecimal(bi.mod(v));
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!signs[off]) {
                        BigInteger bi = BigInteger.valueOf((long)datas[off]);
                        resultDatas[i] = new BigDecimal(bi.mod(v));
                    }
                    ++i;
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[off] % v;
                    ++i;
                    ++off;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = datas[off] % v;
                    }
                    ++i;
                    ++off;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMod"));
    }

    private IArray _$1(ObjectArray array) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            BigInteger bi1;
            Object v = array.get(i);
            if (v == null || s1 != null && s1[off]) {
                resultDatas[i] = null;
            } else if (v instanceof BigDecimal) {
                bi1 = BigInteger.valueOf((long)d1[off]);
                BigInteger bi2 = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi1.mod(bi2));
            } else if (v instanceof BigInteger) {
                bi1 = BigInteger.valueOf((long)d1[off]);
                resultDatas[i] = new BigDecimal(bi1.mod((BigInteger)v));
            } else if (v instanceof Number) {
                resultDatas[i] = d1[off] % ((Number)v).doubleValue();
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illMod"));
            }
            ++i;
            ++off;
        }
        return result;
    }

    public IntArray memberCompare(NumberArray rightArray) {
        IntArray array;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        int[] resultDatas = new int[size + 1];
        if (rightArray instanceof IntArray) {
            array = (IntArray)rightArray;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[f] ? (!array.hasSigns() || !array.isNull(i) ? Double.compare(d1[f], array.getInt(i)) : 1) : (!array.hasSigns() || !array.isNull(i) ? -1 : 0);
                ++i;
                ++f;
            }
        } else if (rightArray instanceof LongArray) {
            array = (LongArray)rightArray;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[f] ? (!array.hasSigns() || !array.isNull(i) ? Double.compare(d1[f], array.getLong(i)) : 1) : (!array.hasSigns() || !array.isNull(i) ? -1 : 0);
                ++i;
                ++f;
            }
        } else {
            array = (DoubleArray)rightArray;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[f] ? (!array.hasSigns() || !array.isNull(i) ? Double.compare(d1[f], array.getDouble(i)) : 1) : (!array.hasSigns() || !array.isNull(i) ? -1 : 0);
                ++i;
                ++f;
            }
        }
        IntArray result = new IntArray(resultDatas, null, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DoubleArray) {
            return this._$1((DoubleArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DateArray) {
            return this.calcRelation((DateArray)array, relation);
        }
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        return array.calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof BigDecimal) {
            return this._$1((BigDecimal)value, relation);
        }
        if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            return this._$1(decimal, relation);
        }
        if (value instanceof Number) {
            return this._$1(((Number)value).doubleValue(), relation);
        }
        if (value == null) {
            return this.dup().calcRelation(value, relation);
        }
        boolean b = Variant.isTrue((Object)value);
        int size = this._$2;
        boolean[] s1 = this._$5;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else if (s1 == null) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b || s1 == null) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
    }

    private BoolArray _$1(DoubleArray array, int relation) {
        int i;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[off], array.getDouble(i)) == 0;
                        ++i;
                        ++off;
                    }
                } else {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : Double.compare(d1[off], array.getDouble(i)) == 0;
                        ++i;
                        ++off;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : Double.compare(d1[off], array.getDouble(i)) == 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? array.isNull(i) : (array.isNull(i) ? false : Double.compare(d1[off], array.getDouble(i)) == 0);
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[off], array.getDouble(i)) > 0;
                        ++i;
                        ++off;
                    }
                } else {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : Double.compare(d1[off], array.getDouble(i)) > 0;
                        ++i;
                        ++off;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : Double.compare(d1[off], array.getDouble(i)) > 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : (array.isNull(i) ? true : Double.compare(d1[off], array.getDouble(i)) > 0);
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[off], array.getDouble(i)) >= 0;
                        ++i;
                        ++off;
                    }
                } else {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : Double.compare(d1[off], array.getDouble(i)) >= 0;
                        ++i;
                        ++off;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : Double.compare(d1[off], array.getDouble(i)) >= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? array.isNull(i) : (array.isNull(i) ? true : Double.compare(d1[off], array.getDouble(i)) >= 0);
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[off], array.getDouble(i)) < 0;
                        ++i;
                        ++off;
                    }
                } else {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : Double.compare(d1[off], array.getDouble(i)) < 0;
                        ++i;
                        ++off;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : Double.compare(d1[off], array.getDouble(i)) < 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? !array.isNull(i) : (array.isNull(i) ? false : Double.compare(d1[off], array.getDouble(i)) < 0);
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[off], array.getDouble(i)) <= 0;
                        ++i;
                        ++off;
                    }
                } else {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : Double.compare(d1[off], array.getDouble(i)) <= 0;
                        ++i;
                        ++off;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : Double.compare(d1[off], array.getDouble(i)) <= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : (array.isNull(i) ? false : Double.compare(d1[off], array.getDouble(i)) <= 0);
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[off], array.getDouble(i)) != 0;
                        ++i;
                        ++off;
                    }
                } else {
                    i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : Double.compare(d1[off], array.getDouble(i)) != 0;
                        ++i;
                        ++off;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : Double.compare(d1[off], array.getDouble(i)) != 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? !array.isNull(i) : (array.isNull(i) ? true : Double.compare(d1[off], array.getDouble(i)) != 0);
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = true;
                    }
                } else {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = !array.isNull(i);
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[off];
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[off] && !array.isNull(i);
                    ++i;
                    ++off;
                }
            }
        } else if (s1 == null || !array.hasSigns()) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[off] || !array.isNull(i);
                ++i;
                ++off;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(double value, int relation) {
        int i;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[off], value) == 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : Double.compare(d1[off], value) == 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[off], value) > 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : Double.compare(d1[off], value) > 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[off], value) >= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : Double.compare(d1[off], value) >= 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[off], value) < 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : Double.compare(d1[off], value) < 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[off], value) <= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : Double.compare(d1[off], value) <= 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[off], value) != 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : Double.compare(d1[off], value) != 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[off];
                    ++i;
                    ++off;
                }
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(BigDecimal value, int relation) {
        int i;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[off]).compareTo(value) == 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : new BigDecimal(d1[off]).compareTo(value) == 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[off]).compareTo(value) > 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : new BigDecimal(d1[off]).compareTo(value) > 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[off]).compareTo(value) >= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : new BigDecimal(d1[off]).compareTo(value) >= 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[off]).compareTo(value) < 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : new BigDecimal(d1[off]).compareTo(value) < 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[off]).compareTo(value) <= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : new BigDecimal(d1[off]).compareTo(value) <= 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[off]).compareTo(value) != 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : new BigDecimal(d1[off]).compareTo(value) != 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[off];
                    ++i;
                    ++off;
                }
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(DateArray array, int relation) {
        boolean[] s1 = this._$5;
        if (relation == 7) {
            int i;
            boolean[] resultDatas = new boolean[this._$2 + 1];
            if (s1 == null) {
                for (i = 1; i <= this._$2; ++i) {
                    resultDatas[i] = array.getDate(i) != null;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= this._$2) {
                    resultDatas[i] = !s1[off] && array.getDate(i) != null;
                    ++i;
                    ++off;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this._$2);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            int i;
            boolean[] resultDatas = new boolean[this._$2 + 1];
            if (s1 == null) {
                for (i = 1; i <= this._$2; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= this._$2) {
                    resultDatas[i] = !s1[off] || array.getDate(i) != null;
                    ++i;
                    ++off;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this._$2);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
    }

    protected BoolArray calcRelation(StringArray array, int relation) {
        boolean[] s1 = this._$5;
        if (relation == 7) {
            int i;
            boolean[] resultDatas = new boolean[this._$2 + 1];
            if (s1 == null) {
                for (i = 1; i <= this._$2; ++i) {
                    resultDatas[i] = array.get(i) != null;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= this._$2) {
                    resultDatas[i] = !s1[off] && array.get(i) != null;
                    ++i;
                    ++off;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this._$2);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            int i;
            boolean[] resultDatas = new boolean[this._$2 + 1];
            if (s1 == null) {
                for (i = 1; i <= this._$2; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= this._$2) {
                    resultDatas[i] = !s1[off] || array.get(i) != null;
                    ++i;
                    ++off;
                }
            }
            BoolArray result = new BoolArray(resultDatas, this._$2);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) == 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? array.get(i) == null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) == 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) > 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? false : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) > 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) >= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? array.get(i) == null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) >= 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) < 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? array.get(i) != null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) < 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) <= 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? true : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) <= 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) != 0;
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[off] ? array.get(i) != null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) != 0;
                    ++i;
                    ++off;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = Variant.isTrue((Object)array.get(i));
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[off] && Variant.isTrue((Object)array.get(i));
                    ++i;
                    ++off;
                }
            }
        } else if (s1 == null) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[off] || Variant.isTrue((Object)array.get(i));
                ++i;
                ++off;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compareTo(IArray array) {
        int off;
        int result;
        int size;
        boolean[] s1;
        double[] d1;
        block38: {
            int off2;
            block37: {
                int off3;
                double d2;
                block36: {
                    int off4;
                    BigDecimal d22;
                    block34: {
                        int off5;
                        BigDecimal d23;
                        block32: {
                            int off6;
                            DoubleArray array2;
                            block29: {
                                int off7;
                                LongArray array22;
                                block27: {
                                    int off8;
                                    IntArray array23;
                                    block25: {
                                        block30: {
                                            Object value;
                                            block35: {
                                                block33: {
                                                    block31: {
                                                        block28: {
                                                            block26: {
                                                                block24: {
                                                                    int size1 = this._$2;
                                                                    int size2 = array.size();
                                                                    d1 = this._$6;
                                                                    s1 = this._$5;
                                                                    size = size1;
                                                                    result = 0;
                                                                    if (size1 < size2) {
                                                                        result = -1;
                                                                    } else if (size1 > size2) {
                                                                        result = 1;
                                                                        size = size2;
                                                                    }
                                                                    if (!(array instanceof IntArray)) break block24;
                                                                    array23 = (IntArray)array;
                                                                    off8 = this._$4;
                                                                    break block25;
                                                                }
                                                                if (!(array instanceof LongArray)) break block26;
                                                                array22 = (LongArray)array;
                                                                off7 = this._$4;
                                                                break block27;
                                                            }
                                                            if (!(array instanceof DoubleArray)) break block28;
                                                            array2 = (DoubleArray)array;
                                                            off6 = this._$4;
                                                            break block29;
                                                        }
                                                        if (!(array instanceof ConstArray)) break block30;
                                                        value = array.get(1);
                                                        if (!(value instanceof BigDecimal)) break block31;
                                                        d23 = (BigDecimal)value;
                                                        off5 = this._$4;
                                                        break block32;
                                                    }
                                                    if (!(value instanceof BigInteger)) break block33;
                                                    d22 = new BigDecimal((BigInteger)value);
                                                    off4 = this._$4;
                                                    break block34;
                                                }
                                                if (!(value instanceof Number)) break block35;
                                                d2 = ((Number)value).doubleValue();
                                                off3 = this._$4;
                                                break block36;
                                            }
                                            if (value != null) {
                                                MessageManager mm = EngineMessage.get();
                                                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)array.getDataType()));
                                            }
                                            if (s1 == null) {
                                                return 1;
                                            }
                                            off2 = this._$4;
                                            break block37;
                                        }
                                        if (!(array instanceof ObjectArray)) {
                                            MessageManager mm = EngineMessage.get();
                                            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
                                        }
                                        off = this._$4;
                                        break block38;
                                    }
                                    for (int i = 1; i <= size; ++i, ++off8) {
                                        if (s1 == null || !s1[off8]) {
                                            if (array23.hasSigns() && array.isNull(i)) {
                                                return 1;
                                            }
                                            int cmp = Double.compare(d1[off8], array23.getInt(i));
                                            if (cmp == 0) continue;
                                            return cmp;
                                        }
                                        if (array23.hasSigns() && array.isNull(i)) continue;
                                        return -1;
                                    }
                                    return result;
                                }
                                for (int i = 1; i <= size; ++i, ++off7) {
                                    if (s1 == null || !s1[off7]) {
                                        if (array22.hasSigns() && array.isNull(i)) {
                                            return 1;
                                        }
                                        int cmp = Double.compare(d1[off7], array22.getLong(i));
                                        if (cmp == 0) continue;
                                        return cmp;
                                    }
                                    if (array22.hasSigns() && array.isNull(i)) continue;
                                    return -1;
                                }
                                return result;
                            }
                            for (int i = 1; i <= size; ++i, ++off6) {
                                if (s1 == null || !s1[off6]) {
                                    if (array2.hasSigns() && array.isNull(i)) {
                                        return 1;
                                    }
                                    int cmp = Double.compare(d1[off6], array2.getDouble(i));
                                    if (cmp == 0) continue;
                                    return cmp;
                                }
                                if (array2.hasSigns() && array.isNull(i)) continue;
                                return -1;
                            }
                            return result;
                        }
                        for (int i = 1; i <= size; ++i, ++off5) {
                            if (s1 != null && s1[off5]) {
                                return -1;
                            }
                            int cmp = new BigDecimal(d1[off5]).compareTo(d23);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        return result;
                    }
                    for (int i = 1; i <= size; ++i, ++off4) {
                        if (s1 != null && s1[off4]) {
                            return -1;
                        }
                        int cmp = new BigDecimal(d1[off4]).compareTo(d22);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return result;
                }
                for (int i = 1; i <= size; ++i, ++off3) {
                    if (s1 != null && s1[off3]) {
                        return -1;
                    }
                    int cmp = Double.compare(d1[off3], d2);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return result;
            }
            for (int i = 1; i <= size; ++i, ++off2) {
                if (s1[off2]) continue;
                return 1;
            }
            return result;
        }
        for (int i = 1; i <= size; ++i, ++off) {
            if (s1 == null || !s1[off]) {
                int cmp = DoubleArraySubset.compare((double)d1[off], (Object)array.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            if (array.get(i) == null) continue;
            return -1;
        }
        return result;
    }

    public int memberCompare(int index1, int index2) {
        index1 += this._$1;
        index2 += this._$1;
        if (this._$5 == null) {
            return Double.compare(this._$6[index1], this._$6[index2]);
        }
        if (this._$5[index1]) {
            return this._$5[index2] ? 0 : -1;
        }
        if (this._$5[index2]) {
            return 1;
        }
        return Double.compare(this._$6[index1], this._$6[index2]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        index1 += this._$1;
        index2 += this._$1;
        if (this._$5 == null) {
            return Double.compare(this._$6[index1], this._$6[index2]) == 0;
        }
        if (this._$5[index1]) {
            return this._$5[index2];
        }
        if (this._$5[index2]) {
            return false;
        }
        return Double.compare(this._$6[index1], this._$6[index2]) == 0;
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        if (array instanceof NumberArray) {
            return Double.compare(this._$6[curIndex += this._$1], ((NumberArray)array).getDouble(index)) == 0;
        }
        return DoubleArraySubset.compare((double)this._$6[curIndex += this._$1], (Object)array.get(index)) == 0;
    }

    public boolean isEquals(int curIndex, Object value) {
        if (this._$5 == null || !this._$5[curIndex += this._$1]) {
            return DoubleArraySubset.compare((double)this._$6[curIndex], (Object)value) == 0;
        }
        return value == null;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index) ? 0 : -1;
        }
        if (array.isNull(index)) {
            return 1;
        }
        if (array instanceof NumberArray) {
            return Double.compare(this._$6[curIndex += this._$1], ((NumberArray)array).getDouble(index));
        }
        return DoubleArraySubset.compare((double)this._$6[curIndex += this._$1], (Object)array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        if (this.isNull(curIndex)) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return 1;
        }
        return DoubleArraySubset.compare((double)this._$6[curIndex += this._$1], (Object)value);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        if (array.isNull(index)) {
            return this;
        }
        if (array instanceof NumberArray) {
            if (this._$5 == null || !this._$5[curIndex += this._$1]) {
                int n = curIndex;
                this._$6[n] = this._$6[n] + ((NumberArray)array).getDouble(index);
            } else {
                this._$6[curIndex] = ((NumberArray)array).getDouble(index);
                this._$5[curIndex] = false;
            }
            return this;
        }
        Object obj = array.get(index);
        if (obj instanceof BigDecimal || obj instanceof BigInteger) {
            ObjectArray result = this.toObjectArray();
            if (this._$5 == null || !this._$5[curIndex + this._$1]) {
                obj = Variant.add((Object)this._$6[curIndex + this._$1], (Object)obj);
            }
            result.set(curIndex, obj);
            return result;
        }
        if (obj instanceof Number) {
            if (this._$5 == null || !this._$5[curIndex += this._$1]) {
                int n = curIndex;
                this._$6[n] = this._$6[n] + ((Number)obj).doubleValue();
            } else {
                this._$6[curIndex] = ((Number)obj).doubleValue();
                this._$5[curIndex] = false;
            }
            return this;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public static int hashCode(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public int hashCode(int index) {
        if (this._$5 == null || !this._$5[index += this._$1]) {
            long bits = Double.doubleToLongBits(this._$6[index]);
            return (int)(bits ^ bits >>> 32);
        }
        return 0;
    }

    public Object sum() {
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int size = this._$2;
        double sum = 0.0;
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                sum += datas[off];
                ++i;
                ++off;
            }
            return sum;
        }
        boolean sign = false;
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            if (!signs[off]) {
                sum += datas[off];
                sign = true;
            }
            ++i;
            ++off;
        }
        return sign ? Double.valueOf(sum) : null;
    }

    public Object average() {
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int size = this._$2;
        double sum = 0.0;
        int count = 0;
        if (signs == null) {
            count = size;
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                sum += datas[off];
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    sum += datas[off];
                    ++count;
                }
                ++i;
                ++off;
            }
        }
        if (count != 0) {
            return sum / (double)count;
        }
        return null;
    }

    public Object max() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        if (signs == null) {
            double max = datas[1 + offset];
            for (int i2 = 2; i2 <= size; ++i2) {
                if (Double.compare(max, datas[i2 + offset]) >= 0) continue;
                max = datas[i2 + offset];
            }
            return max;
        }
        double max = 0.0;
        for (i = 1; i <= size; ++i) {
            if (signs[i + offset]) continue;
            max = datas[i + offset];
            break;
        }
        if (i > size) {
            return null;
        }
        ++i;
        while (i <= size) {
            if (!signs[i + offset] && Double.compare(max, datas[i + offset]) < 0) {
                max = datas[i + offset];
            }
            ++i;
        }
        return max;
    }

    public Object min() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        if (signs == null) {
            double min = datas[1 + offset];
            for (int i2 = 2; i2 <= size; ++i2) {
                if (Double.compare(min, datas[i2 + offset]) <= 0) continue;
                min = datas[i2 + offset];
            }
            return min;
        }
        double min = 0.0;
        for (i = 1; i <= size; ++i) {
            if (signs[i + offset]) continue;
            min = datas[i + offset];
            break;
        }
        if (i > size) {
            return null;
        }
        ++i;
        while (i <= size) {
            if (!signs[i + offset] && Double.compare(min, datas[i + offset]) > 0) {
                min = datas[i + offset];
            }
            ++i;
        }
        return min;
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof IntArray) {
            ((IntArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof LongArray) {
            ((LongArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof DoubleArray) {
            this._$1((DoubleArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
    }

    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof BigDecimal) {
            this._$1((BigDecimal)value, relation, result, isAnd);
        } else if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            this._$1(decimal, relation, result, isAnd);
        } else if (value instanceof Number) {
            this._$1(((Number)value).doubleValue(), relation, result, isAnd);
        } else if (value == null) {
            this.dup().calcRelations(value, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(DoubleArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) != 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                        return;
                    } else {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) != 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || Double.compare(d1[off], array.getDouble(i)) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] != array.isNull(i) || !s1[i] && Double.compare(d1[off], array.getDouble(i)) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                        return;
                    } else {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || Double.compare(d1[off], array.getDouble(i)) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                        return;
                    } else {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || Double.compare(d1[off], array.getDouble(i)) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !array.isNull(i) && (s1[off] || Double.compare(d1[off], array.getDouble(i)) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) >= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                        return;
                    } else {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) >= 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && Double.compare(d1[off], array.getDouble(i)) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (array.isNull(i) || !s1[off] && Double.compare(d1[off], array.getDouble(i)) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) > 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                        return;
                    } else {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) > 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && Double.compare(d1[off], array.getDouble(i)) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) > 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) == 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                        return;
                    } else {
                        int i = 1;
                        int off = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) == 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++off;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && Double.compare(d1[off], array.getDouble(i)) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && s1[off] == array.isNull(i) && (s1[off] || Double.compare(d1[off], array.getDouble(i)) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) == 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) == 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && Double.compare(d1[off], array.getDouble(i)) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] ? array.isNull(i) : !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) > 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) > 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && Double.compare(d1[off], array.getDouble(i)) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[off] || !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) >= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) >= 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && Double.compare(d1[off], array.getDouble(i)) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (array.isNull(i) || !s1[off] && Double.compare(d1[off], array.getDouble(i)) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || Double.compare(d1[off], array.getDouble(i)) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || array.isNull(i) || !s1[off] && Double.compare(d1[off], array.getDouble(i)) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || Double.compare(d1[off], array.getDouble(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || !array.isNull(i) && Double.compare(d1[off], array.getDouble(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[off], array.getDouble(i)) != 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) != 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || Double.compare(d1[off], array.getDouble(i)) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] ? !array.isNull(i) : array.isNull(i) || Double.compare(d1[off], array.getDouble(i)) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(double value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[off], value) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || Double.compare(d1[off], value) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[off], value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || Double.compare(d1[off], value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    for (int i = 1; i <= size; ++i) {
                        if (!resultDatas[i] || Double.compare(d1[i], value) >= 0) continue;
                        resultDatas[i] = false;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || Double.compare(d1[off], value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[off], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && Double.compare(d1[off], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[off], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && Double.compare(d1[off], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[off], value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && Double.compare(d1[off], value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[off], value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && Double.compare(d1[off], value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[off], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && Double.compare(d1[off], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[off], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && Double.compare(d1[off], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[off], value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || Double.compare(d1[off], value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[off], value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || Double.compare(d1[off], value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[off], value) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || Double.compare(d1[off], value) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(BigDecimal value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || new BigDecimal(d1[off]).compareTo(value) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || new BigDecimal(d1[off]).compareTo(value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || new BigDecimal(d1[off]).compareTo(value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && new BigDecimal(d1[off]).compareTo(value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && new BigDecimal(d1[off]).compareTo(value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && new BigDecimal(d1[off]).compareTo(value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && new BigDecimal(d1[off]).compareTo(value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && new BigDecimal(d1[off]).compareTo(value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && new BigDecimal(d1[off]).compareTo(value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || new BigDecimal(d1[off]).compareTo(value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || new BigDecimal(d1[off]).compareTo(value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[off]).compareTo(value) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || new BigDecimal(d1[off]).compareTo(value) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] ? array.get(i) != null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] || DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] ? array.get(i) != null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] ? array.get(i) == null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[off] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                    return;
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[off] ? array.get(i) == null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++off;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] ? array.get(i) == null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[off] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (array.get(i) == null || !s1[off] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && array.get(i) != null && (s1[off] || DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] || DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
                return;
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[off] ? array.get(i) != null : DoubleArraySubset.compare((double)d1[off], (Object)array.get(i)) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++off;
                }
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (array instanceof NumberArray) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] & array.getLong(i));
                    }
                    ++i;
                    ++off;
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] & array.getLong(i));
                    }
                    ++i;
                    ++off;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("and" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)value).longValue();
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    result.pushLong((long)datas[off] & n);
                    ++i;
                    ++off;
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off]) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] & n);
                    }
                    ++i;
                    ++off;
                }
            }
            return result;
        }
        return array.bitwiseAnd((IArray)this);
    }

    public IArray bitwiseOr(IArray array) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (array instanceof NumberArray) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] | array.getLong(i));
                    }
                    ++i;
                    ++off;
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] | array.getLong(i));
                    }
                    ++i;
                    ++off;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("or" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)value).longValue();
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    result.pushLong((long)datas[off] | n);
                    ++i;
                    ++off;
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off]) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] | n);
                    }
                    ++i;
                    ++off;
                }
            }
            return result;
        }
        return array.bitwiseOr((IArray)this);
    }

    public IArray bitwiseXOr(IArray array) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (array instanceof NumberArray) {
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] ^ array.getLong(i));
                    }
                    ++i;
                    ++off;
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] ^ array.getLong(i));
                    }
                    ++i;
                    ++off;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)value).longValue();
            LongArray result = new LongArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    result.pushLong((long)datas[off] ^ n);
                    ++i;
                    ++off;
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signs[off]) {
                        result.pushNull();
                    } else {
                        result.pushLong((long)datas[off] ^ n);
                    }
                    ++i;
                    ++off;
                }
            }
            return result;
        }
        return array.bitwiseXOr((IArray)this);
    }

    public IArray bitwiseNot() {
        int i;
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        if (signs == null) {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = (long)datas[off] ^ 0xFFFFFFFFFFFFFFFFL;
                ++i;
                ++off;
            }
        } else {
            resultSigns = new boolean[size + 1];
            System.arraycopy(signs, this._$4, resultSigns, 1, size);
            i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    resultDatas[i] = (long)datas[off] ^ 0xFFFFFFFFFFFFFFFFL;
                }
                ++i;
                ++off;
            }
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        double[] resultDatas = new double[size + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                if (!array.hasSigns()) {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (array.getBool(i)) {
                            resultDatas[++resultSize] = d1[off];
                        }
                        ++i;
                        ++off;
                    }
                } else {
                    int i = 1;
                    int off = this._$4;
                    while (i <= size) {
                        if (!array.isNull(i) && array.getBool(i)) {
                            resultDatas[++resultSize] = d1[off];
                        }
                        ++i;
                        ++off;
                    }
                }
            } else {
                int i = 1;
                int off = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[off];
                    }
                    ++i;
                    ++off;
                }
            }
            return new DoubleArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[off]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[off];
                }
            }
            ++i;
            ++off;
        }
        return new DoubleArray(resultDatas, resultSigns, resultSize);
    }

    public IArray select(int start, int end, IArray signArray) {
        double[] d1 = this._$6;
        boolean[] s1 = this._$5;
        double[] resultDatas = new double[(end += this._$1) - (start += this._$1) + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                if (!array.hasSigns()) {
                    for (int i = start; i < end; ++i) {
                        if (!array.getBool(i)) continue;
                        resultDatas[++resultSize] = d1[i];
                    }
                } else {
                    for (int i = start; i < end; ++i) {
                        if (array.isNull(i) || !array.getBool(i)) continue;
                        resultDatas[++resultSize] = d1[i];
                    }
                }
            } else {
                for (int i = start; i < end; ++i) {
                    if (!signArray.isTrue(i)) continue;
                    resultDatas[++resultSize] = d1[i];
                }
            }
            return new DoubleArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[end - start + 1];
        for (int i = start; i < end; ++i) {
            if (!signArray.isTrue(i)) continue;
            ++resultSize;
            if (s1[i]) {
                resultSigns[resultSize] = true;
                continue;
            }
            resultDatas[resultSize] = d1[i];
        }
        return new DoubleArray(resultDatas, resultSigns, resultSize);
    }

    public Object[] toArray() {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] result = new Object[size];
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                result[i - 1] = datas[off];
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    result[i - 1] = datas[off];
                }
                ++i;
                ++off;
            }
        }
        return result;
    }

    public void toArray(Object[] result) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                result[i - 1] = datas[off];
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    result[i - 1] = datas[off];
                }
                ++i;
                ++off;
            }
        }
    }

    public IArray split(int pos) {
        int size = this._$2;
        boolean[] signs = this._$5;
        int resultSize = size - pos + 1;
        double[] resultDatas = new double[resultSize + 1];
        System.arraycopy(this._$6, pos + this._$1, resultDatas, 1, resultSize);
        if (signs == null) {
            this._$2 = pos - 1;
            return new DoubleArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[resultSize + 1];
        System.arraycopy(signs, pos + this._$1, resultSigns, 1, resultSize);
        for (int i = pos + this._$1; i <= size; ++i) {
            signs[i] = false;
        }
        this._$2 = pos - 1;
        return new DoubleArray(resultDatas, resultSigns, resultSize);
    }

    public IArray split(int from, int to) {
        throw new RuntimeException();
    }

    public void sort() {
        int size = this._$2;
        boolean[] signs = this._$5;
        if (signs == null) {
            MultithreadUtil.sort((double[])this._$6, (int)(1 + this._$1), (int)(size + 1 + this._$1));
            return;
        }
        int nullCount = 0;
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            if (signs[off]) {
                ++nullCount;
            }
            ++i;
            ++off;
        }
        if (nullCount == 0) {
            MultithreadUtil.sort((double[])this._$6, (int)(1 + this._$1), (int)(size + 1 + this._$1));
            this._$5 = null;
        } else if (nullCount != size) {
            int i2;
            double[] datas = this._$6;
            int offset = this._$1;
            int q = size;
            for (i2 = size; i2 > 0; --i2) {
                if (signs[i2 + offset]) {
                    signs[i2 + offset] = false;
                    continue;
                }
                datas[q-- + offset] = datas[i2 + offset];
            }
            MultithreadUtil.sort((double[])datas, (int)(nullCount + 1 + offset), (int)(size + 1 + offset));
            for (i2 = 1; i2 <= nullCount; ++i2) {
                signs[i2 + offset] = true;
            }
        }
    }

    public void sort(Comparator<Object> comparator) {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] values = new Double[size + 1];
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                values[i] = datas[off];
                ++i;
                ++off;
            }
            MultithreadUtil.sort((Object[])values, (int)1, (int)(size + 1), comparator);
            i = 1;
            off = this._$4;
            while (i <= size) {
                datas[off] = (Double)values[i];
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    values[i] = datas[off];
                }
                ++i;
                ++off;
            }
            MultithreadUtil.sort((Object[])values, (int)1, (int)(size + 1), comparator);
            i = 1;
            off = this._$4;
            while (i <= size) {
                if (values[i] != null) {
                    datas[off] = (Double)values[i];
                    signs[off] = false;
                } else {
                    signs[off] = true;
                }
                ++i;
                ++off;
            }
        }
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        double[] resultDatas = new double[size + 1];
        int offset = this._$1;
        if (signs == null) {
            int q = size;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = datas[q-- + offset];
            }
            return new DoubleArray(resultDatas, null, size);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            if (signs[q + offset]) {
                resultSigns[i] = true;
            } else {
                resultDatas[i] = datas[q + offset];
            }
            ++i;
            --q;
        }
        return new DoubleArray(resultDatas, resultSigns, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        int size = this._$2;
        if (size == 0) {
            return new IntArray(0);
        }
        return this.dup().ptop(count, isAll, isLast, ignoreNull);
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] resultDatas = new Object[size + 1];
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = datas[off];
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    resultDatas[i] = datas[off];
                }
                ++i;
                ++off;
            }
        }
        return new ObjectArray(resultDatas, size);
    }

    public IArray toPureArray() {
        return this;
    }

    public void setDouble(int index, double value) {
        this._$6[index + this._$1] = value;
    }

    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        DoubleArraySubset result;
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (other instanceof NumberArray) {
            NumberArray otherArray = (NumberArray)other;
            if (this.isTemporary()) {
                result = this;
                for (int i = 1; i <= size; ++i) {
                    if (!signArray.isFalse(i)) continue;
                    if (otherArray.isNull(i)) {
                        if (signs == null) {
                            this._$5 = signs = new boolean[size + 1];
                        }
                        signs[i] = true;
                        continue;
                    }
                    datas[i] = otherArray.getDouble(i);
                    if (signs == null) continue;
                    signs[i] = false;
                }
            } else {
                DoubleArray resultArray = new DoubleArray(size);
                result = resultArray;
                if (signs == null) {
                    for (int i = 1; i <= size; ++i) {
                        if (signArray.isTrue(i)) {
                            resultArray.pushDouble(datas[i]);
                            continue;
                        }
                        if (otherArray.isNull(i)) {
                            resultArray.pushNull();
                            continue;
                        }
                        resultArray.pushDouble(otherArray.getDouble(i));
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        if (signArray.isTrue(i)) {
                            if (signs[i]) {
                                resultArray.pushNull();
                                continue;
                            }
                            resultArray.pushDouble(datas[i]);
                            continue;
                        }
                        if (otherArray.isNull(i)) {
                            resultArray.pushNull();
                            continue;
                        }
                        resultArray.pushDouble(otherArray.getDouble(i));
                    }
                }
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = signArray.isTrue(i) ? Double.valueOf(datas[i]) : other.get(i);
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    if (signArray.isTrue(i)) {
                        if (signs[i]) continue;
                        resultDatas[i] = datas[i];
                        continue;
                    }
                    resultDatas[i] = other.get(i);
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    public IArray combine(IArray signArray, Object value) {
        DoubleArraySubset result;
        int size = this._$2;
        double[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Double || value instanceof Long || value instanceof Integer) {
            double v = ((Number)value).doubleValue();
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    for (int i = 1; i <= size; ++i) {
                        if (!signArray.isFalse(i)) continue;
                        datas[i] = v;
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        if (!signArray.isFalse(i)) continue;
                        datas[i] = v;
                        signs[i] = false;
                    }
                }
            } else {
                double[] resultDatas = new double[size + 1];
                boolean[] resultSigns = null;
                if (signs == null) {
                    for (int i = 1; i <= size; ++i) {
                        resultDatas[i] = signArray.isTrue(i) ? datas[i] : v;
                    }
                } else {
                    resultSigns = new boolean[size + 1];
                    for (int i = 1; i <= size; ++i) {
                        if (signArray.isTrue(i)) {
                            if (signs[i]) {
                                resultSigns[i] = true;
                                continue;
                            }
                            resultDatas[i] = datas[i];
                            continue;
                        }
                        resultDatas[i] = v;
                    }
                }
                result = new DoubleArray(resultDatas, resultSigns, size);
            }
        } else if (value == null) {
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    this._$5 = signs = new boolean[size + 1];
                }
                for (int i = 1; i <= size; ++i) {
                    if (!signArray.isFalse(i)) continue;
                    signs[i] = true;
                }
            } else {
                boolean[] resultSigns = new boolean[size + 1];
                double[] resultDatas = new double[size + 1];
                for (int i = 1; i <= size; ++i) {
                    if (signArray.isTrue(i) && (signs == null || !signs[i])) {
                        resultDatas[i] = datas[i];
                        continue;
                    }
                    resultSigns[i] = true;
                }
                result = new DoubleArray(resultDatas, resultSigns, size);
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                for (int i = 1; i <= size; ++i) {
                    resultDatas[i] = signArray.isTrue(i) ? Double.valueOf(datas[i]) : value;
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    if (signArray.isTrue(i)) {
                        if (signs[i]) continue;
                        resultDatas[i] = datas[i];
                        continue;
                    }
                    resultDatas[i] = value;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    public Object pos(IArray array, String opt) {
        if (array instanceof NumberArray) {
            int len = this._$2;
            NumberArray numberArray = (NumberArray)array;
            int subLen = numberArray.size();
            if (len < subLen) {
                return null;
            }
            boolean isSorted = false;
            boolean isIncre = false;
            boolean isContinuous = false;
            if (opt != null) {
                if (opt.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (opt.indexOf(105) != -1) {
                    isIncre = true;
                }
                if (opt.indexOf(99) != -1) {
                    isContinuous = true;
                }
            }
            if (isIncre) {
                IntArray result = new IntArray(subLen);
                if (isSorted) {
                    int pos = 1;
                    for (int t = 1; t <= subLen; ++t) {
                        pos = numberArray.isNull(t) ? this.binarySearch(null, pos, len) : this.binarySearch(numberArray.getDouble(t), pos, len);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                            continue;
                        }
                        return null;
                    }
                } else {
                    int pos = 1;
                    for (int t = 1; t <= subLen; ++t) {
                        pos = numberArray.isNull(t) ? this.firstIndexOf(null, pos) : this.firstIndexOf(numberArray.getDouble(t), pos);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                            continue;
                        }
                        return null;
                    }
                }
                return new Sequence((IArray)result);
            }
            if (isContinuous) {
                int maxCandidate = len - subLen + 1;
                if (isSorted) {
                    int candidate = 1;
                    block2: while (candidate <= maxCandidate) {
                        int result = this.compareTo(candidate, (IArray)numberArray, 1);
                        if (result < 0) {
                            ++candidate;
                            continue;
                        }
                        if (result == 0) {
                            int i = 2;
                            int j = candidate + 1;
                            while (i <= subLen) {
                                if (!this.isEquals(j, (IArray)numberArray, i)) {
                                    ++candidate;
                                    continue block2;
                                }
                                ++i;
                                ++j;
                            }
                            return candidate;
                        }
                        return null;
                    }
                } else {
                    block4: for (int candidate = 1; candidate <= maxCandidate; ++candidate) {
                        int i = 1;
                        int j = candidate;
                        while (i <= subLen) {
                            if (!this.isEquals(j, (IArray)numberArray, i)) continue block4;
                            ++i;
                            ++j;
                        }
                        return candidate;
                    }
                }
                return null;
            }
            IntArray result = new IntArray(subLen);
            if (isSorted) {
                for (int t = 1; t <= subLen; ++t) {
                    int pos = numberArray.isNull(t) ? this.binarySearch(null) : this.binarySearch(numberArray.getDouble(t));
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                }
            } else {
                for (int t = 1; t <= subLen; ++t) {
                    int pos = numberArray.isNull(t) ? this.firstIndexOf(null, 1) : this.firstIndexOf(numberArray.getDouble(t), 1);
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                }
            }
            return new Sequence((IArray)result);
        }
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }
}

