/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleDictArray
extends DoubleArray {
    private static final long serialVersionUID = 1L;
    private double[] _$5;
    private byte[] _$4;
    private boolean _$3;
    private int _$2;
    private DoubleArray _$1;

    public DoubleDictArray(double[] dict, byte[] pos, boolean sign) {
        this._$5 = dict;
        this._$4 = pos;
        this._$3 = sign;
        this._$2 = pos.length;
    }

    public DoubleArray toDoubleArray() {
        int len = this._$2 + 1;
        double[] newDatas = new double[len];
        for (int i = 1; i < len; ++i) {
            newDatas[i] = this._$5[this._$4[i]];
        }
        boolean[] newSigns = null;
        if (this._$3) {
            newSigns = new boolean[len];
            for (int i = 0; i < len; ++i) {
                newSigns[i] = this._$4[i] == 0;
            }
        }
        return new DoubleArray(newDatas, newSigns, this._$2);
    }

    public double[] getDatas() {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.getDatas();
    }

    public boolean[] getSigns() {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.getSigns();
    }

    public void setSigns(boolean[] signs) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.setSigns(signs);
    }

    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Double");
    }

    public IArray dup() {
        return this.toDoubleArray();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.readExternal(in);
    }

    public byte[] serialize() throws IOException {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.serialize();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public IArray newInstance(int count) {
        return new DoubleArray(count);
    }

    public void add(Object o) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.add(o);
    }

    public void addAll(IArray array) {
        int size2 = array.size();
        if (size2 != 0 && array instanceof DoubleDictArray) {
            DoubleDictArray inArray = (DoubleDictArray)array;
            if (this._$5 == inArray._$5) {
                this.ensureCapacity(this._$2 + size2);
                System.arraycopy(inArray._$4, 1, this._$4, this._$2 + 1, size2);
                if (inArray._$3) {
                    this._$3 = true;
                }
                this._$2 += size2;
                return;
            }
        }
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.addAll(array);
    }

    public void addAll(IArray array, int count) {
        if (count != 0 && array instanceof DoubleDictArray) {
            DoubleDictArray inArray = (DoubleDictArray)array;
            if (this._$5 == inArray._$5) {
                this.ensureCapacity(this._$2 + count);
                System.arraycopy(inArray._$4, 1, this._$4, this._$2 + 1, count);
                if (inArray._$3) {
                    this._$3 = true;
                }
                this._$2 += count;
                return;
            }
        }
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.addAll(array, count);
    }

    public void addAll(Object[] array) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.addAll(array);
    }

    public void insert(int index, Object o) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.insert(index, o);
    }

    public void insertAll(int pos, IArray array) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.insert(pos, (Object)array);
    }

    public void insertAll(int pos, Object[] array) {
        throw new RuntimeException();
    }

    public void push(Object o) {
        throw new RuntimeException();
    }

    public void push(IArray array, int index) {
        throw new RuntimeException();
    }

    public void add(IArray array, int index) {
        throw new RuntimeException();
    }

    public void set(int curIndex, IArray array, int index) {
        throw new RuntimeException();
    }

    public void addDouble(double n) {
        throw new RuntimeException();
    }

    public void pushNull() {
        throw new RuntimeException();
    }

    public void push(double n) {
        throw new RuntimeException();
    }

    public void pushDouble(double n) {
        throw new RuntimeException();
    }

    public Object get(int index) {
        if (this._$1 != null) {
            return this._$1.get(index);
        }
        if (!this._$3 || this._$4[index] != 0) {
            return this._$5[this._$4[index]];
        }
        return null;
    }

    public int getInt(int index) {
        throw new RuntimeException();
    }

    public long getLong(int index) {
        throw new RuntimeException();
    }

    public double getDouble(int index) {
        throw new RuntimeException();
    }

    public IArray get(int[] indexArray) {
        if (this._$1 != null) {
            return this._$1.get(indexArray);
        }
        double[] dict = this._$5;
        boolean sign = this._$3;
        int len = indexArray.length;
        DoubleArray result = new DoubleArray(len);
        if (!sign) {
            for (int i : indexArray) {
                result.pushDouble(dict[this._$4[i]]);
            }
        } else {
            for (int i : indexArray) {
                if (0 == this._$4[i]) {
                    result.pushNull();
                    continue;
                }
                result.pushDouble(dict[this._$4[i]]);
            }
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.get(indexArray, start, end, doCheck);
    }

    public IArray get(IArray indexArray) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.get(indexArray);
    }

    public IArray get(int start, int end) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.get(start, end);
    }

    public void ensureCapacity(int minCapacity) {
        if (this._$1 != null) {
            this._$1.ensureCapacity(minCapacity);
            return;
        }
        if (this._$4.length <= minCapacity) {
            int newCapacity = this._$4.length * 3 / 2;
            if (newCapacity <= minCapacity) {
                newCapacity = minCapacity + 1;
            }
            byte[] newPos = new byte[newCapacity];
            System.arraycopy(this._$4, 0, newPos, 0, this._$2 + 1);
            this._$4 = newPos;
        }
    }

    public void trimToSize() {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.trimToSize();
    }

    public boolean isNull(int index) {
        if (this._$1 != null) {
            return this._$1.isNull(index);
        }
        return this._$3 && this._$4[index] == 0;
    }

    public BoolArray isTrue() {
        int i;
        if (this._$1 != null) {
            return this._$1.isTrue();
        }
        boolean sign = this._$3;
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        byte[] pos = this._$4;
        if (!sign) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = pos[i] != 0;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int i;
        if (this._$1 != null) {
            return this._$1.isFalse();
        }
        boolean sign = this._$3;
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        byte[] pos = this._$4;
        if (!sign) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = false;
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = pos[i] == 0;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        if (this._$1 != null) {
            return this._$1.isTrue(index);
        }
        return !this._$3 || this._$4[index] != 0;
    }

    public boolean isFalse(int index) {
        if (this._$1 != null) {
            return this._$1.isFalse(index);
        }
        return this._$3 && this._$4[index] == 0;
    }

    public boolean isTemporary() {
        if (this._$1 != null) {
            return this._$1.isTemporary();
        }
        return this._$4[0] == 1;
    }

    public void setTemporary(boolean ifTemporary) {
        if (this._$1 != null) {
            this._$1.setTemporary(ifTemporary);
        } else {
            this._$4[0] = (byte)(ifTemporary ? 1 : 0);
        }
    }

    public void removeLast() {
        throw new RuntimeException();
    }

    public void remove(int index) {
        throw new RuntimeException();
    }

    public void removeRange(int fromIndex, int toIndex) {
        throw new RuntimeException();
    }

    public void remove(int[] seqs) {
        throw new RuntimeException();
    }

    public void reserve(int start, int end) {
        throw new RuntimeException();
    }

    public int size() {
        if (this._$1 != null) {
            return this._$1.size();
        }
        return this._$2;
    }

    public int count() {
        throw new RuntimeException();
    }

    public boolean containTrue() {
        throw new RuntimeException();
    }

    public Object ifn() {
        throw new RuntimeException();
    }

    public void set(int index, Object obj) {
        throw new RuntimeException();
    }

    public void clear() {
        this._$4 = null;
        this._$1 = null;
        this._$3 = false;
        this._$2 = 0;
    }

    public int binarySearch(Object elem) {
        throw new RuntimeException();
    }

    public int binarySearch(Object elem, int start, int end) {
        throw new RuntimeException();
    }

    public int binarySearch(double v) {
        throw new RuntimeException();
    }

    public boolean contains(Object elem) {
        if (this._$1 != null) {
            return this._$1.contains(elem);
        }
        byte[] pos = this._$4;
        if (elem instanceof Number) {
            Number number = (Number)elem;
            double v = number.doubleValue();
            if (DoubleDictArray.compare((double)v, (Object)number) != 0) {
                return false;
            }
            double[] dict = this._$5;
            boolean sign = this._$3;
            int size = dict.length;
            if (!sign) {
                for (int i = 1; i <= size; ++i) {
                    if (Double.compare(dict[i], v) != 0) continue;
                    return true;
                }
            } else {
                size = this._$2;
                for (int i = 1; i <= size; ++i) {
                    if (pos[i] == 0 || Double.compare(dict[pos[i]], v) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        if (elem == null) {
            boolean sign = this._$3;
            if (!sign) {
                return false;
            }
            int size = this._$2;
            for (int i = 1; i <= size; ++i) {
                if (pos[i] != 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean contains(double v) {
        if (this._$1 != null) {
            return this._$1.contains(v);
        }
        byte[] pos = this._$4;
        double[] dict = this._$5;
        boolean sign = this._$3;
        int size = this._$2;
        if (!sign) {
            size = dict.length;
            for (int i = 1; i <= size; ++i) {
                if (Double.compare(dict[i], v) != 0) continue;
                return true;
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (pos[i] == 0 || Double.compare(dict[pos[i]], v) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.contains(isSorted, array, result);
    }

    public boolean objectContains(Object elem) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        return this._$1.contains(elem);
    }

    public int firstIndexOf(Object elem, int start) {
        throw new RuntimeException();
    }

    public int lastIndexOf(Object elem, int start) {
        throw new RuntimeException();
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        throw new RuntimeException();
    }

    public IArray abs() {
        throw new RuntimeException();
    }

    public IArray negate() {
        throw new RuntimeException();
    }

    public IArray not() {
        throw new RuntimeException();
    }

    public boolean isNumberArray() {
        return true;
    }

    public IArray memberAdd(IArray array) {
        if (array instanceof IntArray) {
            return this.memberAdd((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this.memberAdd((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this.memberAdd((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberAdd((IArray)this);
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).memberAdd((IArray)this);
        }
        if (array instanceof StringArray) {
            return ((StringArray)array).memberAdd((NumberArray)this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        if (this._$1 != null) {
            return this._$1.memberAdd(this._$1);
        }
        if (value instanceof String) {
            value = Variant.parseNumber((String)((String)value));
        }
        if (value == null) {
            return this;
        }
        int size = this._$2;
        double[] dict = this._$5;
        boolean sign = this._$3;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (!sign) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = v.add(new BigDecimal(dict[this._$4[i]]));
                }
            } else {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = this._$4[i] == 0 ? v : v.add(new BigDecimal(dict[this._$4[i]]));
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            if (this.isTemporary()) {
                size = dict.length;
                int i2 = 1;
                while (i2 < size) {
                    int n = i2++;
                    dict[n] = dict[n] + v;
                }
                return this;
            }
            double[] resultDatas = new double[size + 1];
            if (!sign) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = v + dict[this._$4[i]];
                }
            } else {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = this._$4[i] == 0 ? v : v + dict[this._$4[i]];
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Date) {
            int i;
            Date v = (Date)value;
            Object[] resultDatas = new Object[size + 1];
            if (!sign) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = Variant.elapse((Date)v, (int)((int)dict[this._$4[i]]), null);
                }
            } else {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = this._$4[i] == 0 ? v : Variant.elapse((Date)v, (int)((int)dict[this._$4[i]]), null);
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    public DoubleArray memberAdd(IntArray array) {
        throw new RuntimeException();
    }

    public DoubleArray memberAdd(LongArray array) {
        throw new RuntimeException();
    }

    public DoubleArray memberAdd(DoubleArray array) {
        throw new RuntimeException();
    }

    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this._$2((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$2((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$2((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$2(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$2((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray _$2(Object value) {
        throw new RuntimeException();
    }

    private DoubleArray _$2(IntArray array) {
        throw new RuntimeException();
    }

    private DoubleArray _$2(LongArray array) {
        throw new RuntimeException();
    }

    private DoubleArray _$2(DoubleArray array) {
        throw new RuntimeException();
    }

    private ObjectArray _$2(ObjectArray array) {
        throw new RuntimeException();
    }

    public IArray memberMultiply(IArray array) {
        throw new RuntimeException();
    }

    public IArray memberMultiply(Object value) {
        throw new RuntimeException();
    }

    public DoubleArray memberMultiply(IntArray array) {
        throw new RuntimeException();
    }

    public DoubleArray memberMultiply(LongArray array) {
        throw new RuntimeException();
    }

    public DoubleArray memberMultiply(DoubleArray array) {
        throw new RuntimeException();
    }

    public IArray memberDivide(IArray array) {
        throw new RuntimeException();
    }

    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$1((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$1((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$1((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$1(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$1((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private LongArray _$1(IntArray array) {
        throw new RuntimeException();
    }

    private LongArray _$1(LongArray array) {
        throw new RuntimeException();
    }

    private LongArray _$1(DoubleArray array) {
        throw new RuntimeException();
    }

    private IArray _$1(Object value) {
        throw new RuntimeException();
    }

    private IArray _$1(ObjectArray array) {
        throw new RuntimeException();
    }

    public IArray memberMod(IArray array) {
        throw new RuntimeException();
    }

    public IntArray memberCompare(NumberArray rightArray) {
        throw new RuntimeException();
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DoubleArray) {
            return this.calcRelation((IArray)((DoubleArray)array), relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DateArray) {
            return this.calcRelation((DateArray)array, relation);
        }
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        return array.calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof BigDecimal) {
            return this._$1((BigDecimal)value, relation);
        }
        if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            return this._$1(decimal, relation);
        }
        if (value instanceof Number) {
            return this._$1(((Number)value).doubleValue(), relation);
        }
        if (value == null) {
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    private BoolArray _$1(double value, int relation) {
        int i;
        int size = this._$2;
        double[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int dictLen = this._$5.length;
        boolean[] dictResult = new boolean[dictLen];
        if (relation == 1) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) != 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 2) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) <= 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 3) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) < 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 4) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) >= 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 5) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) > 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 6) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) == 0) continue;
                dictResult[i] = true;
            }
        } else {
            throw new RuntimeException();
        }
        dictResult[0] = false;
        for (i = 1; i <= size; ++i) {
            resultDatas[i] = dictResult[this._$4[i]];
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(BigDecimal value, int relation) {
        throw new RuntimeException();
    }

    protected BoolArray calcRelation(DateArray array, int relation) {
        throw new RuntimeException();
    }

    protected BoolArray calcRelation(StringArray array, int relation) {
        throw new RuntimeException();
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        throw new RuntimeException();
    }

    public int compareTo(IArray array) {
        throw new RuntimeException();
    }

    public int memberCompare(int index1, int index2) {
        if (!this._$3) {
            return Double.compare(this._$5[this._$4[index1]], this._$5[this._$4[index2]]);
        }
        if (this._$4[index1] == 0) {
            return this._$4[index2] == 0 ? 0 : -1;
        }
        if (this._$4[index2] == 0) {
            return 1;
        }
        return Double.compare(this._$5[this._$4[index1]], this._$5[this._$4[index2]]);
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        if (array instanceof NumberArray) {
            return Double.compare(this._$5[this._$4[curIndex]], ((NumberArray)array).getDouble(index)) == 0;
        }
        return DoubleDictArray.compare((double)this._$5[this._$4[curIndex]], (Object)array.get(index)) == 0;
    }

    public boolean isEquals(int curIndex, Object value) {
        if (!this._$3 || this._$4[curIndex] != 0) {
            return DoubleDictArray.compare((double)this._$5[this._$4[curIndex]], (Object)value) == 0;
        }
        return value == null;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index) ? 0 : -1;
        }
        if (array.isNull(index)) {
            return 1;
        }
        if (array instanceof NumberArray) {
            return Double.compare(this._$5[this._$4[curIndex]], ((NumberArray)array).getDouble(index));
        }
        return DoubleDictArray.compare((double)this._$5[this._$4[curIndex]], (Object)array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        if (this.isNull(curIndex)) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return 1;
        }
        return DoubleDictArray.compare((double)this._$5[this._$4[curIndex]], (Object)value);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        throw new RuntimeException();
    }

    public int hashCode(int index) {
        if (!this._$3 || this._$4[index] != 0) {
            long bits = Double.doubleToLongBits(this._$5[this._$4[index]]);
            return (int)(bits ^ bits >>> 32);
        }
        return 0;
    }

    public Object sum() {
        throw new RuntimeException();
    }

    public Object average() {
        throw new RuntimeException();
    }

    public Object max() {
        throw new RuntimeException();
    }

    public Object min() {
        throw new RuntimeException();
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof IntArray) {
            ((IntArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof LongArray) {
            ((LongArray)array).calcRelations((IArray)this, Relation.getInverseRelation((int)relation), result, isAnd);
        } else if (array instanceof DoubleArray) {
            this._$1((DoubleArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
    }

    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof BigDecimal) {
            this._$1((BigDecimal)value, relation, result, isAnd);
        } else if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            this._$1(decimal, relation, result, isAnd);
        } else if (value instanceof Number) {
            this._$1(((Number)value).doubleValue(), relation, result, isAnd);
        } else {
            if (value == null) {
                throw new RuntimeException();
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    private void _$1(DoubleArray array, int relation, BoolArray result, boolean isAnd) {
        if (this._$1 == null) {
            this._$1 = this.toDoubleArray();
        }
        this._$1.calcRelations((IArray)array, relation, result, isAnd);
    }

    private void _$1(double value, int relation, BoolArray result, boolean isAnd) {
        int i;
        int size = this._$2;
        double[] d1 = this._$5;
        byte[] pos = this._$4;
        boolean s1 = this._$3;
        boolean[] resultDatas = result.getDatas();
        int dictLen = this._$5.length;
        boolean[] dictResult = new boolean[dictLen];
        if (relation == 1) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) != 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 2) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) <= 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 3) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) < 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 4) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) >= 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 5) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) > 0) continue;
                dictResult[i] = true;
            }
        } else if (relation == 6) {
            for (i = 1; i < dictLen; ++i) {
                if (Double.compare(d1[i], value) == 0) continue;
                dictResult[i] = true;
            }
        } else {
            throw new RuntimeException();
        }
        if (s1) {
            dictResult[0] = false;
        }
        if (isAnd) {
            for (i = 1; i <= size; ++i) {
                if (!resultDatas[i] || dictResult[pos[i]]) continue;
                resultDatas[i] = false;
            }
        } else {
            for (i = 1; i <= size; ++i) {
                if (resultDatas[i] || !dictResult[pos[i]]) continue;
                resultDatas[i] = true;
            }
        }
    }

    private void _$1(BigDecimal value, int relation, BoolArray result, boolean isAnd) {
        throw new RuntimeException();
    }

    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        throw new RuntimeException();
    }

    public IArray bitwiseAnd(IArray array) {
        throw new RuntimeException();
    }

    public IArray select(IArray signArray) {
        if (this._$1 != null) {
            return this._$1.select(signArray);
        }
        int size = this._$2;
        double[] d1 = this._$5;
        byte[] pos = this._$4;
        boolean s1 = this._$3;
        DoubleArray result = new DoubleArray(size);
        if (!s1) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                boolean[] d2 = array.getDatas();
                boolean[] s2 = array.getSigns();
                if (s2 == null) {
                    for (int i = 1; i <= size; ++i) {
                        if (!d2[i]) continue;
                        result.pushDouble(d1[pos[i]]);
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        if (s2[i] || !d2[i]) continue;
                        result.pushDouble(d1[pos[i]]);
                    }
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    if (!signArray.isTrue(i)) continue;
                    result.pushDouble(d1[pos[i]]);
                }
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (!signArray.isTrue(i)) continue;
                if (pos[i] == 0) {
                    result.pushNull();
                    continue;
                }
                result.pushDouble(d1[pos[i]]);
            }
        }
        return result;
    }

    public Object[] toArray() {
        throw new RuntimeException();
    }

    public void toArray(Object[] result) {
        throw new RuntimeException();
    }

    public IArray split(int pos) {
        throw new RuntimeException();
    }

    public IArray split(int from, int to) {
        throw new RuntimeException();
    }

    public void sort() {
        throw new RuntimeException();
    }

    public void sort(Comparator<Object> comparator) {
        throw new RuntimeException();
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        throw new RuntimeException();
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast) {
        throw new RuntimeException();
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        throw new RuntimeException();
    }

    public IArray toPureArray() {
        return this;
    }

    public void setDouble(int index, double value) {
        throw new RuntimeException();
    }

    public IArray reserve(boolean refOrigin) {
        if (this.isTemporary()) {
            this.setTemporary(false);
            return this;
        }
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }
}

