/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArraySubset
extends IntArray {
    private static final long serialVersionUID = 1L;
    private IntArray _$7;
    private int[] _$6;
    private boolean[] _$5;
    private int _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public IntArraySubset(IntArray array, int start, int end) {
        super(array.getDatas(), array.getSigns(), array.size());
        this._$6 = array.getDatas();
        this._$5 = array.getSigns();
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
        this._$7 = array;
    }

    public int[] getDatas() {
        int len = this._$2 + 1;
        int[] newDatas = new int[len];
        System.arraycopy(this._$6, this._$4, newDatas, 0, len);
        return newDatas;
    }

    public boolean[] getSigns() {
        int len = this._$2 + 1;
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[len];
            System.arraycopy(this._$5, this._$4, newSigns, 0, len);
        }
        return newSigns;
    }

    public boolean getSign(int index) {
        return this._$5[index + this._$1];
    }

    private static int _$1(int n1, Object o2) {
        if (o2 instanceof Integer) {
            int n2 = (Integer)o2;
            return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
        }
        if (o2 instanceof Long) {
            long n2 = (Long)o2;
            return (long)n1 < n2 ? -1 : ((long)n1 > n2 ? 1 : 0);
        }
        if (o2 instanceof BigDecimal) {
            return new BigDecimal(n1).compareTo((BigDecimal)o2);
        }
        if (o2 instanceof BigInteger) {
            return BigInteger.valueOf(n1).compareTo((BigInteger)o2);
        }
        if (o2 instanceof Number) {
            return Double.compare(n1, ((Number)o2).doubleValue());
        }
        if (o2 == null) {
            return 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", (Object)n1, o2, (Object)mm.getMessage("DataType.Integer"), (Object)Variant.getDataType((Object)o2)));
    }

    private static int _$2(int n1, int n2) {
        return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
    }

    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.Integer");
    }

    public IntArray dup() {
        int len = this._$2 + 1;
        int[] newDatas = new int[len];
        System.arraycopy(this._$6, this._$4, newDatas, 0, len);
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[len];
            System.arraycopy(this._$5, this._$4, newSigns, 0, len);
        }
        return new IntArray(newDatas, newSigns, this._$2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new RuntimeException();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public byte[] serialize() throws IOException {
        throw new RuntimeException();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        throw new RuntimeException();
    }

    public IArray newInstance(int count) {
        return new IntArray(count);
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray insertInt(int index, int o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        this.set(curIndex, array.get(index));
    }

    public void addInt(int n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(int n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushInt(int n) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public Object get(int index) {
        if (this._$5 == null || !this._$5[index += this._$1]) {
            return ObjectCache.getInteger((int)this._$6[index]);
        }
        return null;
    }

    public int getInt(int index) {
        return this._$6[index + this._$1];
    }

    public long getLong(int index) {
        return this._$6[index + this._$1];
    }

    public double getDouble(int index) {
        return this._$6[index + this._$1];
    }

    public IArray get(int[] indexArray) {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = indexArray.length;
        IntArray result = new IntArray(len);
        int offset = this._$1;
        if (signs == null) {
            for (int i : indexArray) {
                result.pushInt(datas[i += offset]);
            }
        } else {
            for (int i : indexArray) {
                if (signs[i += offset]) {
                    result.pushNull();
                    continue;
                }
                result.pushInt(datas[i]);
            }
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = end - start + 1;
        int offset = this._$1;
        if (doCheck) {
            IntArray result = new IntArray(len);
            if (signs == null) {
                while (start <= end) {
                    int q = indexArray[start];
                    if (q > 0) {
                        result.pushInt(datas[q + offset]);
                    } else {
                        result.pushNull();
                    }
                    ++start;
                }
            } else {
                while (start <= end) {
                    int q = indexArray[start];
                    if (q < 1 || signs[q + offset]) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[q + offset]);
                    }
                    ++start;
                }
            }
            return result;
        }
        if (signs == null) {
            int[] resultDatas = new int[len + 1];
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start] + offset];
                ++start;
            }
            return new IntArray(resultDatas, null, len);
        }
        IntArray result = new IntArray(len);
        while (start <= end) {
            int q = indexArray[start];
            if (signs[q + offset]) {
                result.pushNull();
            } else {
                result.pushInt(datas[q + offset]);
            }
            ++start;
        }
        return result;
    }

    public IArray get(IArray indexArray) {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int len = indexArray.size();
        IntArray result = new IntArray(len);
        if (signs == null) {
            for (int i = 1; i <= len; ++i) {
                result.pushInt(datas[indexArray.getInt(i) + this._$1]);
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                int index = indexArray.getInt(i);
                if (signs[index + this._$1]) {
                    result.pushNull();
                    continue;
                }
                result.pushInt(datas[index + this._$1]);
            }
        }
        return result;
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        int[] newDatas = new int[newSize + 1];
        System.arraycopy(this._$6, start + this._$1, newDatas, 1, newSize);
        if (this._$5 == null) {
            return new IntArray(newDatas, null, newSize);
        }
        boolean[] newSigns = new boolean[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newSigns, 1, newSize);
        return new IntArray(newDatas, newSigns, newSize);
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5 != null && this._$5[index + this._$1];
    }

    public BoolArray isTrue() {
        int i;
        boolean[] signs = this._$5;
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        if (signs == null) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = !signs[off];
                ++i;
                ++off;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int size = this._$2;
        boolean[] resultDatas = new boolean[size + 1];
        if (this._$5 == null) {
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = false;
            }
        } else {
            System.arraycopy(this._$5, this._$4, resultDatas, 1, size);
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return this._$5 == null || !this._$5[index + this._$1];
    }

    public boolean isFalse(int index) {
        return this._$5 != null && this._$5[index + this._$1];
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public int count() {
        boolean[] signs = this._$5;
        int size = this._$2;
        int end = this._$3;
        if (signs == null) {
            return size;
        }
        int count = size;
        for (int i = this._$4; i <= end; ++i) {
            if (!signs[i]) continue;
            --count;
        }
        return count;
    }

    public boolean containTrue() {
        int size = this._$2;
        if (size == 0) {
            return false;
        }
        boolean[] signs = this._$5;
        if (signs == null) {
            return true;
        }
        int end = this._$3;
        for (int i = this._$4; i <= end; ++i) {
            if (signs[i]) continue;
            return true;
        }
        return false;
    }

    public Object ifn() {
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        boolean[] signs = this._$5;
        if (signs == null) {
            return this._$6[this._$4];
        }
        int end = this._$3;
        for (int i = this._$4; i <= end; ++i) {
            if (signs[i]) continue;
            return this._$6[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index, Object obj) {
        index += this._$1;
        if (obj == null) {
            if (this._$5 == null) {
                IntArray intArray = this._$7;
                synchronized (intArray) {
                    if (super.getSigns() != null) {
                        this._$5 = super.getSigns();
                    } else {
                        this._$5 = new boolean[this._$6.length];
                        this._$7.setSigns(this._$5);
                        super.setSigns(this._$5);
                    }
                }
            }
            this._$6[index] = 0;
            this._$5[index] = true;
        } else if (obj instanceof Integer) {
            this._$6[index] = (Integer)obj;
            if (this._$5 != null) {
                this._$5[index] = false;
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", (Object)mm.getMessage("DataType.Integer"), (Object)Variant.getDataType((Object)obj)));
        }
    }

    public void clear() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int binarySearch(Object elem) {
        int idx = super.binarySearch(elem, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    private int _$1(int v, int low, int high) {
        int idx = super.binarySearch((Object)v, this._$4 + this._$1, this._$3 + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(int v) {
        int idx = super.binarySearch((Object)v, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(Object elem) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            int v = number.intValue();
            if (IntArraySubset._$1(v, number) != 0) {
                return false;
            }
            int[] datas = this._$6;
            boolean[] signs = this._$5;
            int end = this._$3;
            if (signs == null) {
                for (int i = this._$4; i <= end; ++i) {
                    if (datas[i] != v) continue;
                    return true;
                }
            } else {
                for (int i = this._$4; i <= end; ++i) {
                    if (signs[i] || datas[i] != v) continue;
                    return true;
                }
            }
            return false;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return false;
            }
            int end = this._$3;
            for (int i = this._$4; i <= end; ++i) {
                if (!signs[i]) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean contains(int v) {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int end = this._$3;
        if (signs == null) {
            for (int i = this._$4; i <= end; ++i) {
                if (datas[i] != v) continue;
                return true;
            }
        } else {
            for (int i = this._$4; i <= end; ++i) {
                if (signs[i] || datas[i] != v) continue;
                return true;
            }
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (array instanceof IntArray) {
            if (isSorted) {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i)) continue;
                    if (array.isNull(i)) {
                        if (this.binarySearch(null) >= 1) continue;
                        result.set(i, false);
                        continue;
                    }
                    if (this.binarySearch(array.getInt(i)) >= 1) continue;
                    result.set(i, false);
                }
            } else {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i)) continue;
                    if (array.isNull(i)) {
                        if (this.contains(null)) continue;
                        result.set(i, false);
                        continue;
                    }
                    if (this.contains(array.getInt(i))) continue;
                    result.set(i, false);
                }
            }
        } else if (array instanceof LongArray) {
            if (isSorted) {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i)) continue;
                    if (array.isNull(i)) {
                        if (this.binarySearch(null) >= 1) continue;
                        result.set(i, false);
                        continue;
                    }
                    int n = array.getInt(i);
                    if ((long)n == array.getLong(i) && this.binarySearch(n) >= 1) continue;
                    result.set(i, false);
                }
            } else {
                for (int i = 1; i <= resultSize; ++i) {
                    if (!result.isTrue(i)) continue;
                    if (array.isNull(i)) {
                        if (this.contains(null)) continue;
                        result.set(i, false);
                        continue;
                    }
                    int n = array.getInt(i);
                    if ((long)n == array.getLong(i) && this.contains(n)) continue;
                    result.set(i, false);
                }
            }
        } else if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            int v = number.intValue();
            if (IntArraySubset._$1(v, number) != 0) {
                return 0;
            }
            boolean[] signs = this._$5;
            int size = this._$2;
            if (signs == null) {
                for (int i = start; i <= size; ++i) {
                    if (this.getInt(i) != v) continue;
                    return i;
                }
            } else {
                for (int i = start; i <= size; ++i) {
                    if (this.getSign(i) || this.getInt(i) != v) continue;
                    return i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return 0;
            }
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (!this.getSign(i)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    private int _$1(int v, int start) {
        boolean[] signs = this._$5;
        int size = this._$2;
        if (signs == null) {
            for (int i = start; i <= size; ++i) {
                if (this.getInt(i) != v) continue;
                return i;
            }
        } else {
            for (int i = start; i <= size; ++i) {
                if (this.getSign(i) || this.getInt(i) != v) continue;
                return i;
            }
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        if (elem instanceof Number) {
            Number number = (Number)elem;
            int v = number.intValue();
            if (IntArraySubset._$1(v, number) != 0) {
                return 0;
            }
            boolean[] signs = this._$5;
            if (signs == null) {
                for (int i = start; i > 0; --i) {
                    if (this.getInt(i) != v) continue;
                    return i;
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (this.getSign(i) || this.getInt(i) != v) continue;
                    return i;
                }
            }
            return 0;
        }
        if (elem == null) {
            boolean[] signs = this._$5;
            if (signs == null) {
                return 0;
            }
            for (int i = start; i > 0; --i) {
                if (!this.getSign(i)) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        boolean[] signs = this._$5;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (signs != null) {
                if (isSorted) {
                    if (isFromHead) {
                        for (int i = start; i <= size && this.getSign(i); ++i) {
                            result.addInt(i);
                        }
                    } else {
                        for (int i = start; i > 0; --i) {
                            if (!this.getSign(i)) continue;
                            result.addInt(i);
                        }
                    }
                } else if (isFromHead) {
                    for (int i = start; i <= size; ++i) {
                        if (!this.getSign(i)) continue;
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (!this.getSign(i)) continue;
                        result.addInt(i);
                    }
                }
            }
            return result;
        }
        if (!(elem instanceof Number)) {
            return new IntArray(1);
        }
        Number number = (Number)elem;
        if (isSorted) {
            int last;
            int first;
            int index;
            int end = size;
            if (isFromHead) {
                end = start;
                start = 1;
            }
            if ((index = this.binarySearch(number, start, end)) < 1) {
                return new IntArray(1);
            }
            int v = number.intValue();
            for (first = index; !(first <= start || signs != null && this.getSign(first - 1) || this.getInt(first - 1) != v); --first) {
            }
            for (last = index; !(last >= end || signs != null && this.getSign(last + 1) || this.getInt(last + 1) != v); ++last) {
            }
            IntArray result = new IntArray(last - first + 1);
            if (isFromHead) {
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
            } else {
                while (last >= first) {
                    result.pushInt(last);
                    --last;
                }
            }
            return result;
        }
        int v = number.intValue();
        if (IntArraySubset._$1(v, number) != 0) {
            return new IntArray(1);
        }
        IntArray result = new IntArray(7);
        if (isFromHead) {
            for (int i = start; i <= size; ++i) {
                if (signs != null && this.getSign(i) || this.getInt(i) != v) continue;
                result.addInt(i);
            }
        } else {
            for (int i = start; i > 0; --i) {
                if (signs != null && this.getSign(i) || this.getInt(i) != v) continue;
                result.addInt(i);
            }
        }
        return result;
    }

    public IArray abs() {
        int size = this._$2;
        int[] datas = new int[size + 1];
        System.arraycopy(this._$6, this._$4, datas, 1, size);
        boolean[] signs = null;
        if (this._$5 != null) {
            signs = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, signs, 1, size);
        }
        IntArray result = new IntArray(datas, signs, size);
        result.setTemporary(true);
        for (int i = 1; i <= size; ++i) {
            if (datas[i] >= 0) continue;
            datas[i] = -datas[i];
        }
        return result;
    }

    public IArray negate() {
        int size = this._$2;
        int[] datas = this._$6;
        if (this.isTemporary()) {
            int end = this._$3;
            for (int i = this._$4; i <= end; ++i) {
                datas[i] = -datas[i];
            }
            return this;
        }
        int[] newDatas = new int[size + 1];
        int offset = this._$4;
        for (int i = 1; i <= size; ++i) {
            newDatas[i] = -datas[offset++];
        }
        boolean[] newSigns = null;
        if (this._$5 != null) {
            newSigns = new boolean[size + 1];
            System.arraycopy(this._$5, this._$4, newSigns, 1, size);
        }
        IntArray result = new IntArray(newDatas, newSigns, size);
        result.setTemporary(true);
        return result;
    }

    public IArray not() {
        boolean[] signs = this._$5;
        int size = this._$2;
        if (signs == null) {
            return new ConstArray((Object)Boolean.FALSE, size);
        }
        boolean[] newDatas = new boolean[size + 1];
        System.arraycopy(signs, this._$4, newDatas, 1, size);
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        return true;
    }

    public IArray memberAdd(IArray array) {
        if (array instanceof IntArray) {
            return this._$6((IntArray)array);
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).memberAdd((IArray)this);
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).memberAdd((IntArray)this);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberAdd((IArray)this);
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).memberAdd((IArray)this);
        }
        if (array instanceof StringArray) {
            return ((StringArray)array).memberAdd((NumberArray)this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        if (value instanceof String) {
            value = Variant.parseNumber((String)((String)value));
        }
        if (value == null) {
            return this;
        }
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = v + (double)datas[off];
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[off] ? v : v + (double)datas[off];
                    ++i;
                    ++off;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = v.add(new BigDecimal(datas[off]));
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[off] ? v : v.add(new BigDecimal(datas[off]));
                    ++i;
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            long[] resultDatas = new long[size + 1];
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = v + (long)datas[off];
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[off] ? v : v + (long)datas[off];
                    ++i;
                    ++off;
                }
            }
            LongArray result = new LongArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Date) {
            int i;
            Date v = (Date)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = Variant.elapse((Date)v, (int)datas[off], null);
                    ++i;
                    ++off;
                }
            } else {
                i = 1;
                int off = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[off] ? v : Variant.elapse((Date)v, (int)datas[off], null);
                    ++i;
                    ++off;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    private LongArray _$6(IntArray array) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        long[] datas = new long[size + 1];
        boolean[] signs = null;
        if (s1 == null) {
            if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    datas[i] = (long)d1[f] + (long)array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    datas[i] = array.isNull(i) ? (long)d1[f] : (long)d1[f] + (long)array.getInt(i);
                    ++i;
                    ++f;
                }
            }
        } else if (!array.hasSigns()) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                datas[i] = s1[f] ? (long)array.getInt(i) : (long)d1[f] + (long)array.getInt(i);
                ++i;
                ++f;
            }
        } else {
            signs = new boolean[size + 1];
            i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f]) {
                    if (array.isNull(i)) {
                        signs[i] = true;
                    } else {
                        datas[i] = array.getInt(i);
                    }
                } else {
                    datas[i] = array.isNull(i) ? (long)d1[f] : (long)d1[f] + (long)array.getInt(i);
                }
                ++i;
                ++f;
            }
        }
        LongArray result = new LongArray(datas, signs, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberSubtract(IArray array) {
        if (array instanceof IntArray) {
            return this._$5((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$4((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$4((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$4(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$4((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    private IArray _$4(Object value) {
        if (value == null) {
            return this;
        }
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Long) {
            int i;
            long v = (Long)value;
            long[] resultDatas = new long[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)datas[f] - v;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[f] ? -v : (long)datas[f] - v;
                    ++i;
                    ++f;
                }
            }
            LongArray result = new LongArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (double)datas[f] - v;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[f] ? -v : (double)datas[f] - v;
                    ++i;
                    ++f;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(datas[f]).subtract(v);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[f] ? v.negate() : new BigDecimal(datas[f]).subtract(v);
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            int v = ((Number)value).intValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int f = this._$4;
                    for (int i2 = 1; i2 <= size; ++i2) {
                        int n = f++;
                        datas[n] = datas[n] - v;
                    }
                } else {
                    int i3 = 1;
                    int f = this._$4;
                    while (i3 <= size) {
                        if (signs[f]) {
                            datas[f] = -v;
                        } else {
                            int n = f;
                            datas[n] = datas[n] - v;
                        }
                        ++i3;
                        ++f;
                    }
                    this._$5 = null;
                }
                return this;
            }
            int[] resultDatas = new int[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] - v;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[f] ? -v : datas[f] - v;
                    ++i;
                    ++f;
                }
            }
            IntArray result = new IntArray(resultDatas, null, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illSubtract"));
    }

    private IntArray _$5(IntArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        int[] resultDatas = new int[size + 1];
        boolean[] resultSigns = s1 != null && array.hasSigns() ? new boolean[size + 1] : null;
        IntArray result = new IntArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (s1 == null) {
            if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = d1[f] - array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = array.isNull(i) ? d1[f] : d1[f] - array.getInt(i);
                    ++i;
                    ++f;
                }
            }
            result.setSigns(null);
        } else if (!array.hasSigns()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1[f] ? -array.getInt(i) : d1[f] - array.getInt(i);
                ++i;
                ++f;
            }
            result.setSigns(null);
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f]) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -array.getInt(i);
                    }
                } else {
                    resultDatas[i] = array.isNull(i) ? d1[f] : d1[f] - array.getInt(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private LongArray _$4(LongArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = s1 != null && array.hasSigns() ? new boolean[size + 1] : null;
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (s1 == null) {
            if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] - array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = array.isNull(i) ? (long)d1[f] : (long)d1[f] - array.getLong(i);
                    ++i;
                    ++f;
                }
            }
            result.setSigns(null);
        } else if (!array.hasSigns()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1[f] ? -array.getLong(i) : (long)d1[f] - array.getLong(i);
                ++i;
                ++f;
            }
            result.setSigns(null);
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f]) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -array.getLong(i);
                    }
                } else {
                    resultDatas[i] = array.isNull(i) ? (long)d1[f] : (long)d1[f] - array.getLong(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private DoubleArray _$4(DoubleArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        double[] resultDatas = new double[size + 1];
        boolean[] resultSigns = s1 != null && array.hasSigns() ? new boolean[size + 1] : null;
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (s1 == null) {
            if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (double)d1[f] - array.getDouble(i);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = array.isNull(i) ? (double)d1[f] : (double)d1[f] - array.getDouble(i);
                    ++i;
                    ++f;
                }
            }
            result.setSigns(null);
        } else if (!array.hasSigns()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1[f] ? -array.getDouble(i) : (double)d1[f] - array.getDouble(i);
                ++i;
                ++f;
            }
            result.setSigns(null);
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f]) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = -array.getDouble(i);
                    }
                } else {
                    resultDatas[i] = array.isNull(i) ? (double)d1[f] : (double)d1[f] - array.getDouble(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private ObjectArray _$4(ObjectArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Object v = array.get(i);
            if (v == null) {
                if (s1 == null || !s1[f]) {
                    resultDatas[i] = d1[f];
                }
            } else if (v instanceof Long) {
                resultDatas[i] = s1 == null || !s1[f] ? Long.valueOf((long)d1[f] - (Long)v) : Long.valueOf(-((Long)v).longValue());
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = s1 == null || !s1[f] ? Double.valueOf((double)d1[f] - ((Number)v).doubleValue()) : Double.valueOf(-((Number)v).doubleValue());
            } else if (v instanceof BigDecimal) {
                resultDatas[i] = s1 == null || !s1[f] ? new BigDecimal(d1[f]).subtract((BigDecimal)v) : ((BigDecimal)v).negate();
            } else if (v instanceof BigInteger) {
                resultDatas[i] = s1 == null || !s1[f] ? new BigDecimal(d1[f]).subtract(new BigDecimal((BigInteger)v)) : new BigDecimal((BigInteger)v).negate();
            } else if (v instanceof Number) {
                resultDatas[i] = s1 == null || !s1[f] ? Integer.valueOf(d1[f] - ((Number)v).intValue()) : Integer.valueOf(-((Number)v).intValue());
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illSubtract"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    public IArray memberMultiply(IArray array) {
        if (array instanceof IntArray) {
            return this._$4((IntArray)array);
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).memberMultiply((IArray)this);
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).memberMultiply((IntArray)this);
        }
        if (array instanceof ConstArray) {
            return this.memberMultiply(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberMultiply((IArray)this);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = v * (double)datas[f];
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v * (double)datas[f];
                    }
                    ++i;
                    ++f;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            Object[] resultDatas = new Object[size + 1];
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = v.multiply(new BigDecimal(datas[f]));
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!signs[f]) {
                        resultDatas[i] = v.multiply(new BigDecimal(datas[f]));
                    }
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            long v = ((Number)value).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = v * (long)datas[f];
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = v * (long)datas[f];
                    }
                    ++i;
                    ++f;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        if (value instanceof Sequence) {
            int i;
            Sequence sequence = (Sequence)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = sequence.multiply(datas[f]);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signs[f] ? null : sequence.multiply(datas[f]);
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMultiply"));
    }

    private LongArray _$4(IntArray array) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        long[] datas = new long[size + 1];
        boolean[] signs = null;
        if (s1 == null) {
            if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    datas[i] = (long)d1[f] * (long)array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                signs = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        signs[i] = true;
                    } else {
                        datas[i] = (long)d1[f] * (long)array.getInt(i);
                    }
                    ++i;
                    ++f;
                }
            }
        } else if (!array.hasSigns()) {
            signs = new boolean[size + 1];
            i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f]) {
                    signs[i] = true;
                } else {
                    datas[i] = (long)d1[f] * (long)array.getInt(i);
                }
                ++i;
                ++f;
            }
        } else {
            signs = new boolean[size + 1];
            i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f] || array.isNull(i)) {
                    signs[i] = true;
                } else {
                    datas[i] = (long)d1[f] * (long)array.getInt(i);
                }
                ++i;
                ++f;
            }
        }
        LongArray result = new LongArray(datas, signs, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$3((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$3((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$3((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$3(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$3((ObjectArray)array);
        }
        if (array instanceof StringArray) {
            return this._$1((StringArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IArray _$3(Object value) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigDecimal v = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((BigInteger)value);
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    BigDecimal decimal = new BigDecimal(datas[f]);
                    resultDatas[i] = decimal.divide(v, 16, 4);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!signs[f]) {
                        BigDecimal decimal = new BigDecimal(datas[f]);
                        resultDatas[i] = decimal.divide(v, 16, 4);
                    }
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (double)datas[f] / v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (double)datas[f] / v;
                    }
                    ++i;
                    ++f;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof String) {
            int i;
            String str = (String)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] + str;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!signs[f]) {
                        resultDatas[i] = datas[f] + str;
                    }
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illDivide"));
    }

    private DoubleArray _$3(IntArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        double[] resultDatas = new double[size + 1];
        boolean[] resultSigns = null;
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = (double)d1[f] / (double)array.getInt(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[f] / (double)array.getInt(i);
                }
                ++i;
                ++f;
            }
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private DoubleArray _$3(LongArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        double[] resultDatas = new double[size + 1];
        boolean[] resultSigns = null;
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.hasSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = (double)d1[f] / (double)array.getLong(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[f] / (double)array.getLong(i);
                }
                ++i;
                ++f;
            }
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private DoubleArray _$3(DoubleArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        double[] resultDatas = new double[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = (double)d1[f] / array.getDouble(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[f] / array.getDouble(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private StringArray _$1(StringArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (array.getString(i) != null) {
                resultDatas[i] = s1 == null || !s1[f] ? d1[f] + array.getString(i) : array.getString(i);
            } else if (s1 == null || !s1[f]) {
                resultDatas[i] = Integer.toString(d1[f]);
            }
            ++i;
            ++f;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private ObjectArray _$3(ObjectArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            BigDecimal decimal;
            Object v = array.get(i);
            if (v instanceof BigDecimal) {
                if (s1 == null || !s1[f]) {
                    decimal = new BigDecimal(d1[f]);
                    resultDatas[i] = decimal.divide((BigDecimal)v, 16, 4);
                } else {
                    resultDatas[i] = null;
                }
            } else if (v instanceof BigInteger) {
                if (s1 == null || !s1[f]) {
                    decimal = new BigDecimal(d1[f]);
                    resultDatas[i] = decimal.divide(new BigDecimal((BigInteger)v), 16, 4);
                } else {
                    resultDatas[i] = null;
                }
            } else if (v instanceof Number) {
                resultDatas[i] = s1 == null || !s1[f] ? Double.valueOf((double)d1[f] / ((Number)v).doubleValue()) : null;
            } else if (v instanceof String) {
                resultDatas[i] = s1 == null || !s1[f] ? d1[f] + (String)v : v;
            } else if (v != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    public IArray memberMod(IArray array) {
        if (array instanceof IntArray) {
            return this._$2((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$2((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$2((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$2(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$2((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    private IntArray _$2(IntArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        int[] resultDatas = new int[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        IntArray result = new IntArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] % array.getInt(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[f] % array.getInt(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private LongArray _$2(LongArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        long[] resultDatas = new long[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = (long)d1[f] % array.getLong(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (long)d1[f] % array.getLong(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private DoubleArray _$2(DoubleArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        double[] resultDatas = new double[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = (double)d1[f] % array.getDouble(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (double)d1[f] % array.getDouble(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private IArray _$2(Object value) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Long) {
            int i;
            long v = ((Number)value).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)datas[f] % v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (long)datas[f] % v;
                    }
                    ++i;
                    ++f;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Double || value instanceof Float) {
            int i;
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (double)datas[f] % v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (double)datas[f] % v;
                    }
                    ++i;
                    ++f;
                }
            }
            DoubleArray result = new DoubleArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigInteger v = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : (BigInteger)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    BigInteger bi = BigInteger.valueOf(datas[f]);
                    resultDatas[i] = new BigDecimal(bi.mod(v));
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!signs[f]) {
                        BigInteger bi = BigInteger.valueOf(datas[f]);
                        resultDatas[i] = new BigDecimal(bi.mod(v));
                    }
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            int v = ((Number)value).intValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int f = this._$4;
                    for (int i2 = 1; i2 <= size; ++i2) {
                        int n = f++;
                        datas[n] = datas[n] % v;
                    }
                } else {
                    int i3 = 1;
                    int f = this._$4;
                    while (i3 <= size) {
                        if (!signs[f]) {
                            int n = f;
                            datas[n] = datas[n] % v;
                        }
                        ++i3;
                        ++f;
                    }
                }
                return this;
            }
            int[] resultDatas = new int[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] % v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = datas[f] % v;
                    }
                    ++i;
                    ++f;
                }
            }
            IntArray result = new IntArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMod"));
    }

    private IArray _$2(ObjectArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            BigInteger bi1;
            Object v = array.get(i);
            if (v == null || s1 != null && s1[f]) {
                resultDatas[i] = null;
            } else if (v instanceof Long) {
                resultDatas[i] = (long)d1[f] % ((Number)v).longValue();
            } else if (v instanceof Double || v instanceof Float) {
                resultDatas[i] = (double)d1[f] % ((Number)v).doubleValue();
            } else if (v instanceof BigDecimal) {
                bi1 = BigInteger.valueOf(d1[f]);
                BigInteger bi2 = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi1.mod(bi2));
            } else if (v instanceof BigInteger) {
                bi1 = BigInteger.valueOf(d1[f]);
                resultDatas[i] = new BigDecimal(bi1.mod((BigInteger)v));
            } else if (v instanceof Number) {
                resultDatas[i] = ObjectCache.getInteger((int)(d1[f] % ((Number)v).intValue()));
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illMod"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    public IArray memberIntDivide(IArray array) {
        if (array instanceof IntArray) {
            return this._$1((IntArray)array);
        }
        if (array instanceof LongArray) {
            return this._$1((LongArray)array);
        }
        if (array instanceof DoubleArray) {
            return this._$1((DoubleArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$1(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return this._$1((ObjectArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    private IntArray _$1(IntArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        int[] resultDatas = new int[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        IntArray result = new IntArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] / array.getInt(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = d1[f] / array.getInt(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private LongArray _$1(LongArray array) {
        int f;
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultSigns = null;
        long[] resultDatas = new long[size + 1];
        if (s1 != null) {
            resultSigns = new boolean[size + 1];
            if (array.hasSigns()) {
                System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
                i = 1;
                f = this._$4;
                while (i <= size) {
                    if (s1[f]) {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                System.arraycopy(s1, 1, resultSigns, 1, size);
            }
        } else if (array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            System.arraycopy(array.getSigns(), 1, resultSigns, 1, size);
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        if (resultSigns == null) {
            i = 1;
            f = this._$4;
            while (i <= size) {
                resultDatas[i] = (long)d1[f] / array.getLong(i);
                ++i;
                ++f;
            }
        } else {
            i = 1;
            f = this._$4;
            while (i <= size) {
                if (!resultSigns[i]) {
                    resultDatas[i] = (long)d1[f] / array.getLong(i);
                }
                ++i;
                ++f;
            }
        }
        return result;
    }

    private LongArray _$1(DoubleArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        long[] resultDatas = new long[size + 1];
        boolean[] resultSigns = null;
        if (s1 == null) {
            if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] / (long)array.getDouble(i);
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (long)d1[f] / (long)array.getDouble(i);
                    }
                    ++i;
                    ++f;
                }
            }
        } else if (!array.hasSigns()) {
            resultSigns = new boolean[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f]) {
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = (long)d1[f] / (long)array.getDouble(i);
                }
                ++i;
                ++f;
            }
        } else {
            resultSigns = new boolean[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (s1[f] || array.isNull(i)) {
                    resultSigns[i] = true;
                } else {
                    resultDatas[i] = (long)d1[f] / (long)array.getDouble(i);
                }
                ++i;
                ++f;
            }
        }
        LongArray result = new LongArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    private IArray _$1(Object value) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Long || value instanceof Double || value instanceof Float) {
            int i;
            long v = ((Number)value).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)datas[f] / v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = (long)datas[f] / v;
                    }
                    ++i;
                    ++f;
                }
            }
            LongArray result = new LongArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            int i;
            BigInteger v = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : (BigInteger)value;
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    BigInteger bi = BigInteger.valueOf(datas[f]);
                    resultDatas[i] = new BigDecimal(bi.divide(v));
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!signs[f]) {
                        BigInteger bi = BigInteger.valueOf(datas[f]);
                        resultDatas[i] = new BigDecimal(bi.divide(v));
                    }
                    ++i;
                    ++f;
                }
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            int i;
            int v = ((Number)value).intValue();
            if (this.isTemporary()) {
                if (signs == null) {
                    int f = this._$4;
                    for (int i2 = 1; i2 <= size; ++i2) {
                        int n = f++;
                        datas[n] = datas[n] / v;
                    }
                } else {
                    int i3 = 1;
                    int f = this._$4;
                    while (i3 <= size) {
                        if (!signs[f]) {
                            int n = f;
                            datas[n] = datas[n] / v;
                        }
                        ++i3;
                        ++f;
                    }
                }
                return this;
            }
            int[] resultDatas = new int[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] / v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        resultSigns[i] = true;
                    } else {
                        resultDatas[i] = datas[f] / v;
                    }
                    ++i;
                    ++f;
                }
            }
            IntArray result = new IntArray(resultDatas, resultSigns, size);
            result.setTemporary(true);
            return result;
        }
        if (value == null) {
            return new ConstArray(null, size);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illDivide"));
    }

    private IArray _$1(ObjectArray array) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        Object[] resultDatas = new Object[size + 1];
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            BigInteger bi1;
            Object v = array.get(i);
            if (v == null || s1 != null && s1[f]) {
                resultDatas[i] = null;
            } else if (v instanceof Long || v instanceof Double || v instanceof Float) {
                resultDatas[i] = (long)d1[f] / ((Number)v).longValue();
            } else if (v instanceof BigDecimal) {
                bi1 = BigInteger.valueOf(d1[f]);
                BigInteger bi2 = ((BigDecimal)v).toBigInteger();
                resultDatas[i] = new BigDecimal(bi1.divide(bi2));
            } else if (v instanceof BigInteger) {
                bi1 = BigInteger.valueOf(d1[f]);
                resultDatas[i] = new BigDecimal(bi1.divide((BigInteger)v));
            } else if (v instanceof Number) {
                resultDatas[i] = ObjectCache.getInteger((int)(d1[f] / ((Number)v).intValue()));
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)v) + mm.getMessage("Variant2.illDivide"));
            }
            ++i;
            ++f;
        }
        return result;
    }

    public IntArray memberCompare(NumberArray rightArray) {
        IntArray array;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean s2HasSigns = rightArray.hasSigns();
        int[] resultDatas = this.isTemporary() ? d1 : new int[size + 1];
        if (rightArray instanceof IntArray) {
            array = (IntArray)rightArray;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[f] ? (!s2HasSigns || !rightArray.isNull(i) ? (d1[f] < array.getInt(i) ? -1 : (d1[f] == array.getInt(i) ? 0 : 1)) : 1) : (!s2HasSigns || !rightArray.isNull(i) ? -1 : 0);
                ++i;
                ++f;
            }
        } else if (rightArray instanceof LongArray) {
            array = (LongArray)rightArray;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[f] ? (!s2HasSigns || !rightArray.isNull(i) ? ((long)d1[f] < array.getLong(i) ? -1 : ((long)d1[f] == array.getLong(i) ? 0 : 1)) : 1) : (!s2HasSigns || !rightArray.isNull(i) ? -1 : 0);
                ++i;
                ++f;
            }
        } else {
            array = (DoubleArray)rightArray;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = s1 == null || !s1[f] ? (!s2HasSigns || !rightArray.isNull(i) ? Double.compare(d1[f], array.getDouble(i)) : 1) : (!s2HasSigns || !rightArray.isNull(i) ? -1 : 0);
                ++i;
                ++f;
            }
        }
        IntArray result = new IntArray(resultDatas, null, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof IntArray) {
            return this._$1((IntArray)array, relation);
        }
        if (array instanceof LongArray) {
            return this.calcRelation((LongArray)array, relation);
        }
        if (array instanceof DoubleArray) {
            return this.calcRelation((DoubleArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DateArray) {
            return this.calcRelation((DateArray)array, relation);
        }
        if (array instanceof StringArray) {
            return this.calcRelation((StringArray)array, relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        return array.calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof Double || value instanceof Float) {
            return this._$1(((Number)value).doubleValue(), relation);
        }
        if (value instanceof BigDecimal) {
            return this._$1((BigDecimal)value, relation);
        }
        if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            return this._$1(decimal, relation);
        }
        if (value instanceof Number) {
            return this._$1(((Number)value).longValue(), relation);
        }
        if (value == null) {
            return this.dup().calcRelation(value, relation);
        }
        boolean b = Variant.isTrue((Object)value);
        int size = this._$2;
        boolean[] s1 = this._$5;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else if (s1 == null) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b || s1 == null) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
    }

    private BoolArray _$1(IntArray array, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] == array.getInt(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : d1[f] == array.getInt(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : d1[f] == array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.isNull(i) : (array.isNull(i) ? false : d1[f] == array.getInt(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] > array.getInt(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : d1[f] > array.getInt(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : d1[f] > array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (array.isNull(i) ? true : d1[f] > array.getInt(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] >= array.getInt(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : d1[f] >= array.getInt(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : d1[f] >= array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.isNull(i) : (array.isNull(i) ? true : d1[f] >= array.getInt(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] < array.getInt(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : d1[f] < array.getInt(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : d1[f] < array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? !array.isNull(i) : (array.isNull(i) ? false : d1[f] < array.getInt(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] <= array.getInt(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : d1[f] <= array.getInt(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : d1[f] <= array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (array.isNull(i) ? false : d1[f] <= array.getInt(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = d1[f] != array.getInt(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : d1[f] != array.getInt(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : d1[f] != array.getInt(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? !array.isNull(i) : (array.isNull(i) ? true : d1[f] != array.getInt(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = true;
                    }
                } else {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = !array.isNull(i);
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && !array.isNull(i);
                    ++i;
                    ++f;
                }
            }
        } else if (s1 == null || !array.hasSigns()) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[f] || !array.isNull(i);
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(LongArray array, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = (long)d1[f] == array.getLong(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : (long)d1[f] == array.getLong(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (long)d1[f] == array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.isNull(i) : (array.isNull(i) ? false : (long)d1[f] == array.getLong(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = (long)d1[f] > array.getLong(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : (long)d1[f] > array.getLong(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (long)d1[f] > array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (array.isNull(i) ? true : (long)d1[f] > array.getLong(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = (long)d1[f] >= array.getLong(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : (long)d1[f] >= array.getLong(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (long)d1[f] >= array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.isNull(i) : (array.isNull(i) ? true : (long)d1[f] >= array.getLong(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = (long)d1[f] < array.getLong(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : (long)d1[f] < array.getLong(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (long)d1[f] < array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? !array.isNull(i) : (array.isNull(i) ? false : (long)d1[f] < array.getLong(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = (long)d1[f] <= array.getLong(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : (long)d1[f] <= array.getLong(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (long)d1[f] <= array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (array.isNull(i) ? false : (long)d1[f] <= array.getLong(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = (long)d1[f] != array.getLong(i);
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : (long)d1[f] != array.getLong(i);
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (long)d1[f] != array.getLong(i);
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? !array.isNull(i) : (array.isNull(i) ? true : (long)d1[f] != array.getLong(i));
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = true;
                    }
                } else {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = !array.isNull(i);
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && !array.isNull(i);
                    ++i;
                    ++f;
                }
            }
        } else if (s1 == null || !array.hasSigns()) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[f] || !array.isNull(i);
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(DoubleArray array, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[f], array.getDouble(i)) == 0;
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : Double.compare(d1[f], array.getDouble(i)) == 0;
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : Double.compare(d1[f], array.getDouble(i)) == 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.isNull(i) : (array.isNull(i) ? false : Double.compare(d1[f], array.getDouble(i)) == 0);
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[f], array.getDouble(i)) > 0;
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : Double.compare(d1[f], array.getDouble(i)) > 0;
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : Double.compare(d1[f], array.getDouble(i)) > 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (array.isNull(i) ? true : Double.compare(d1[f], array.getDouble(i)) > 0);
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[f], array.getDouble(i)) >= 0;
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : Double.compare(d1[f], array.getDouble(i)) >= 0;
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : Double.compare(d1[f], array.getDouble(i)) >= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.isNull(i) : (array.isNull(i) ? true : Double.compare(d1[f], array.getDouble(i)) >= 0);
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[f], array.getDouble(i)) < 0;
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : Double.compare(d1[f], array.getDouble(i)) < 0;
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : Double.compare(d1[f], array.getDouble(i)) < 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? !array.isNull(i) : (array.isNull(i) ? false : Double.compare(d1[f], array.getDouble(i)) < 0);
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[f], array.getDouble(i)) <= 0;
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? false : Double.compare(d1[f], array.getDouble(i)) <= 0;
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : Double.compare(d1[f], array.getDouble(i)) <= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (array.isNull(i) ? false : Double.compare(d1[f], array.getDouble(i)) <= 0);
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = Double.compare(d1[f], array.getDouble(i)) != 0;
                        ++i;
                        ++f;
                    }
                } else {
                    i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = array.isNull(i) ? true : Double.compare(d1[f], array.getDouble(i)) != 0;
                        ++i;
                        ++f;
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : Double.compare(d1[f], array.getDouble(i)) != 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? !array.isNull(i) : (array.isNull(i) ? true : Double.compare(d1[f], array.getDouble(i)) != 0);
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = true;
                    }
                } else {
                    for (i = 1; i <= size; ++i) {
                        resultDatas[i] = !array.isNull(i);
                    }
                }
            } else if (!array.hasSigns()) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && !array.isNull(i);
                    ++i;
                    ++f;
                }
            }
        } else if (s1 == null || !array.hasSigns()) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[f] || !array.isNull(i);
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(long value, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] == value;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (long)d1[f] == value;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] > value;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (long)d1[f] > value;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] >= value;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : (long)d1[f] >= value;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] < value;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (long)d1[f] < value;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] <= value;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (long)d1[f] <= value;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = (long)d1[f] != value;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : (long)d1[f] != value;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(double value, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[f], value) == 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : Double.compare(d1[f], value) == 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[f], value) > 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : Double.compare(d1[f], value) > 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[f], value) >= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : Double.compare(d1[f], value) >= 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[f], value) < 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : Double.compare(d1[f], value) < 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[f], value) <= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : Double.compare(d1[f], value) <= 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = Double.compare(d1[f], value) != 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : Double.compare(d1[f], value) != 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(BigDecimal value, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[f]).compareTo(value) == 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : new BigDecimal(d1[f]).compareTo(value) == 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[f]).compareTo(value) > 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : new BigDecimal(d1[f]).compareTo(value) > 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[f]).compareTo(value) >= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : new BigDecimal(d1[f]).compareTo(value) >= 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[f]).compareTo(value) < 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : new BigDecimal(d1[f]).compareTo(value) < 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[f]).compareTo(value) <= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : new BigDecimal(d1[f]).compareTo(value) <= 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = new BigDecimal(d1[f]).compareTo(value) != 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : new BigDecimal(d1[f]).compareTo(value) != 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f];
                    ++i;
                    ++f;
                }
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(DateArray array, int relation) {
        int size = this._$2;
        boolean[] s1 = this._$5;
        if (relation == 7) {
            int i;
            boolean[] resultDatas = new boolean[size + 1];
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = array.getDate(i) != null;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && array.getDate(i) != null;
                    ++i;
                    ++f;
                }
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            int i;
            boolean[] resultDatas = new boolean[size + 1];
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] || array.getDate(i) != null;
                    ++i;
                    ++f;
                }
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
    }

    protected BoolArray calcRelation(StringArray array, int relation) {
        int size = this._$2;
        boolean[] s1 = this._$5;
        if (relation == 7) {
            int i;
            boolean[] resultDatas = new boolean[size + 1];
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = array.getString(i) != null;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && array.getString(i) != null;
                    ++i;
                    ++f;
                }
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            int i;
            boolean[] resultDatas = new boolean[size + 1];
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = true;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] || array.getString(i) != null;
                    ++i;
                    ++f;
                }
            }
            BoolArray result = new BoolArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = IntArraySubset._$1(d1[f], array.get(i)) == 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.get(i) == null : IntArraySubset._$1(d1[f], array.get(i)) == 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 2) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = IntArraySubset._$1(d1[f], array.get(i)) > 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? false : IntArraySubset._$1(d1[f], array.get(i)) > 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 3) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = IntArraySubset._$1(d1[f], array.get(i)) >= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.get(i) == null : IntArraySubset._$1(d1[f], array.get(i)) >= 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 4) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = IntArraySubset._$1(d1[f], array.get(i)) < 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.get(i) != null : IntArraySubset._$1(d1[f], array.get(i)) < 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 5) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = IntArraySubset._$1(d1[f], array.get(i)) <= 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? true : IntArraySubset._$1(d1[f], array.get(i)) <= 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 6) {
            if (s1 == null) {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = IntArraySubset._$1(d1[f], array.get(i)) != 0;
                    ++i;
                    ++f;
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = s1[f] ? array.get(i) != null : IntArraySubset._$1(d1[f], array.get(i)) != 0;
                    ++i;
                    ++f;
                }
            }
        } else if (relation == 7) {
            if (s1 == null) {
                for (i = 1; i <= size; ++i) {
                    resultDatas[i] = Variant.isTrue((Object)array.get(i));
                }
            } else {
                i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = !s1[f] && Variant.isTrue((Object)array.get(i));
                    ++i;
                    ++f;
                }
            }
        } else if (s1 == null) {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = !s1[f] || Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compareTo(IArray array) {
        int f;
        ObjectArray array2;
        int result;
        int size;
        boolean[] s1;
        int[] d1;
        block50: {
            int f2;
            block49: {
                int f3;
                int d2;
                block48: {
                    int f4;
                    BigInteger d22;
                    block46: {
                        int f5;
                        BigDecimal d23;
                        block44: {
                            int f6;
                            double d24;
                            block42: {
                                int f7;
                                long d25;
                                block40: {
                                    int f8;
                                    boolean s2HasSigns;
                                    DoubleArray array22;
                                    block37: {
                                        int f9;
                                        boolean s2HasSigns2;
                                        LongArray array23;
                                        block35: {
                                            int f10;
                                            boolean s2HasSigns3;
                                            IntArray array24;
                                            block33: {
                                                block38: {
                                                    Object value;
                                                    block47: {
                                                        block45: {
                                                            block43: {
                                                                block41: {
                                                                    block39: {
                                                                        block36: {
                                                                            block34: {
                                                                                block32: {
                                                                                    int size1 = this._$2;
                                                                                    int size2 = array.size();
                                                                                    d1 = this._$6;
                                                                                    s1 = this._$5;
                                                                                    size = size1;
                                                                                    result = 0;
                                                                                    if (size1 < size2) {
                                                                                        result = -1;
                                                                                    } else if (size1 > size2) {
                                                                                        result = 1;
                                                                                        size = size2;
                                                                                    }
                                                                                    if (!(array instanceof IntArray)) break block32;
                                                                                    array24 = (IntArray)array;
                                                                                    s2HasSigns3 = array24.hasSigns();
                                                                                    f10 = this._$4;
                                                                                    break block33;
                                                                                }
                                                                                if (!(array instanceof LongArray)) break block34;
                                                                                array23 = (LongArray)array;
                                                                                s2HasSigns2 = array23.hasSigns();
                                                                                f9 = this._$4;
                                                                                break block35;
                                                                            }
                                                                            if (!(array instanceof DoubleArray)) break block36;
                                                                            array22 = (DoubleArray)array;
                                                                            s2HasSigns = array22.hasSigns();
                                                                            f8 = this._$4;
                                                                            break block37;
                                                                        }
                                                                        if (!(array instanceof ConstArray)) break block38;
                                                                        value = array.get(1);
                                                                        if (!(value instanceof Long)) break block39;
                                                                        d25 = ((Number)value).longValue();
                                                                        f7 = this._$4;
                                                                        break block40;
                                                                    }
                                                                    if (!(value instanceof Double) && !(value instanceof Float)) break block41;
                                                                    d24 = ((Number)value).doubleValue();
                                                                    f6 = this._$4;
                                                                    break block42;
                                                                }
                                                                if (!(value instanceof BigDecimal)) break block43;
                                                                d23 = (BigDecimal)value;
                                                                f5 = this._$4;
                                                                break block44;
                                                            }
                                                            if (!(value instanceof BigInteger)) break block45;
                                                            d22 = (BigInteger)value;
                                                            f4 = this._$4;
                                                            break block46;
                                                        }
                                                        if (!(value instanceof Number)) break block47;
                                                        d2 = ((Number)value).intValue();
                                                        f3 = this._$4;
                                                        break block48;
                                                    }
                                                    if (value != null) {
                                                        MessageManager mm = EngineMessage.get();
                                                        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)array.getDataType()));
                                                    }
                                                    if (s1 == null) {
                                                        return 1;
                                                    }
                                                    f2 = this._$4;
                                                    break block49;
                                                }
                                                if (!(array instanceof ObjectArray)) {
                                                    MessageManager mm = EngineMessage.get();
                                                    throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
                                                }
                                                array2 = (ObjectArray)array;
                                                f = this._$4;
                                                break block50;
                                            }
                                            for (int i = 1; i <= size; ++i, ++f10) {
                                                if (s1 == null || !s1[f10]) {
                                                    if (s2HasSigns3 && array24.isNull(i)) {
                                                        return 1;
                                                    }
                                                    if (d1[f10] > array.getInt(i)) {
                                                        return 1;
                                                    }
                                                    if (d1[f10] >= array24.getInt(i)) continue;
                                                    return -1;
                                                }
                                                if (s2HasSigns3 && array24.isNull(i)) continue;
                                                return -1;
                                            }
                                            return result;
                                        }
                                        for (int i = 1; i <= size; ++i, ++f9) {
                                            if (s1 == null || !s1[f9]) {
                                                if (s2HasSigns2 && array23.isNull(i)) {
                                                    return 1;
                                                }
                                                if ((long)d1[f9] > array.getLong(i)) {
                                                    return 1;
                                                }
                                                if ((long)d1[f9] >= array23.getLong(i)) continue;
                                                return -1;
                                            }
                                            if (s2HasSigns2 && array23.isNull(i)) continue;
                                            return -1;
                                        }
                                        return result;
                                    }
                                    for (int i = 1; i <= size; ++i, ++f8) {
                                        if (s1 == null || !s1[f8]) {
                                            if (s2HasSigns && array22.isNull(i)) {
                                                return 1;
                                            }
                                            int cmp = Double.compare(d1[f8], array22.getDouble(i));
                                            if (cmp == 0) continue;
                                            return cmp;
                                        }
                                        if (s2HasSigns && array22.isNull(i)) continue;
                                        return -1;
                                    }
                                    return result;
                                }
                                for (int i = 1; i <= size; ++i, ++f7) {
                                    if (s1 != null && s1[f7]) {
                                        return -1;
                                    }
                                    if ((long)d1[f7] > d25) {
                                        return 1;
                                    }
                                    if ((long)d1[f7] >= d25) continue;
                                    return -1;
                                }
                                return result;
                            }
                            for (int i = 1; i <= size; ++i, ++f6) {
                                if (s1 != null && s1[f6]) {
                                    return -1;
                                }
                                int cmp = Double.compare(d1[f6], d24);
                                if (cmp == 0) continue;
                                return cmp;
                            }
                            return result;
                        }
                        for (int i = 1; i <= size; ++i, ++f5) {
                            if (s1 != null && s1[f5]) {
                                return -1;
                            }
                            int cmp = new BigDecimal(d1[f5]).compareTo(d23);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        return result;
                    }
                    for (int i = 1; i <= size; ++i, ++f4) {
                        if (s1 != null && s1[f4]) {
                            return -1;
                        }
                        int cmp = BigInteger.valueOf(d1[f4]).compareTo(d22);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return result;
                }
                for (int i = 1; i <= size; ++i, ++f3) {
                    if (s1 != null && s1[f3]) {
                        return -1;
                    }
                    if (d1[f3] > d2) {
                        return 1;
                    }
                    if (d1[f3] >= d2) continue;
                    return -1;
                }
                return result;
            }
            for (int i = 1; i <= size; ++i, ++f2) {
                if (s1[f2]) continue;
                return 1;
            }
            return result;
        }
        for (int i = 1; i <= size; ++i, ++f) {
            if (s1 == null || !s1[f]) {
                int cmp = IntArraySubset._$1(d1[f], array2.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            if (array.get(i) == null) continue;
            return -1;
        }
        return result;
    }

    public int memberCompare(int index1, int index2) {
        index1 += this._$1;
        index2 += this._$1;
        if (this._$5 == null) {
            return IntArraySubset._$2(this._$6[index1], this._$6[index2]);
        }
        if (this._$5[index1]) {
            return this._$5[index2] ? 0 : -1;
        }
        if (this._$5[index2]) {
            return 1;
        }
        return IntArraySubset._$2(this._$6[index1], this._$6[index2]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        index1 += this._$1;
        index2 += this._$1;
        if (this._$5 == null) {
            return this._$6[index1] == this._$6[index2];
        }
        if (this._$5[index1]) {
            return this._$5[index2];
        }
        if (this._$5[index2]) {
            return false;
        }
        return this._$6[index1] == this._$6[index2];
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        if (array instanceof IntArray) {
            return this._$6[curIndex + this._$1] == array.getInt(index);
        }
        if (array instanceof LongArray) {
            return (long)this._$6[curIndex + this._$1] == array.getLong(index);
        }
        if (array instanceof DoubleArray) {
            return Double.compare(this._$6[curIndex + this._$1], ((DoubleArray)array).getDouble(index)) == 0;
        }
        return IntArraySubset._$1(this._$6[curIndex + this._$1], array.get(index)) == 0;
    }

    public boolean isEquals(int curIndex, IntArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index);
        }
        if (array.isNull(index)) {
            return false;
        }
        return this._$6[curIndex + this._$1] == array.getInt(index);
    }

    public boolean isEquals(int curIndex, Object value) {
        if (this._$5 == null || !this._$5[curIndex += this._$1]) {
            if (value instanceof Integer) {
                return (Integer)value == this._$6[curIndex];
            }
            if (value instanceof Long) {
                return (Long)value == (long)this._$6[curIndex];
            }
            if (value instanceof BigDecimal) {
                return new BigDecimal(this._$6[curIndex]).equals(value);
            }
            if (value instanceof BigInteger) {
                return BigInteger.valueOf(this._$6[curIndex]).equals(value);
            }
            if (value instanceof Number) {
                return Double.compare(this._$6[curIndex], ((Number)value).doubleValue()) == 0;
            }
            return false;
        }
        return value == null;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        if (this.isNull(curIndex)) {
            return array.isNull(index) ? 0 : -1;
        }
        if (array.isNull(index)) {
            return 1;
        }
        if (array instanceof IntArray) {
            return IntArraySubset._$2(this._$6[curIndex + this._$1], array.getInt(index));
        }
        if (array instanceof LongArray) {
            return LongArray.compare((long)this._$6[curIndex + this._$1], (long)array.getLong(index));
        }
        if (array instanceof DoubleArray) {
            return Double.compare(this._$6[curIndex + this._$1], ((DoubleArray)array).getDouble(index));
        }
        return IntArraySubset._$1(this._$6[curIndex + this._$1], array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        if (this.isNull(curIndex)) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return 1;
        }
        return IntArraySubset._$1(this._$6[curIndex + this._$1], value);
    }

    public int hashCode(int index) {
        if (this._$5 == null || !this._$5[index += this._$1]) {
            return this._$6[index];
        }
        return 0;
    }

    public Object sum() {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int size = this._$2;
        long sum = 0L;
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                sum += (long)datas[f];
                ++i;
                ++f;
            }
            return sum;
        }
        boolean sign = false;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (!signs[f]) {
                sum += (long)datas[f];
                sign = true;
            }
            ++i;
            ++f;
        }
        return sign ? Long.valueOf(sum) : null;
    }

    public Object average() {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int size = this._$2;
        long sum = 0L;
        int count = 0;
        if (signs == null) {
            count = size;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                sum += (long)datas[f];
                ++i;
                ++f;
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    sum += (long)datas[f];
                    ++count;
                }
                ++i;
                ++f;
            }
        }
        if (count != 0) {
            return (double)sum / (double)count;
        }
        return null;
    }

    public Object max() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        if (signs == null) {
            int max = datas[1 + offset];
            for (int i2 = 2; i2 <= size; ++i2) {
                if (max >= datas[i2 + offset]) continue;
                max = datas[i2 + offset];
            }
            return ObjectCache.getInteger((int)max);
        }
        int max = 0;
        for (i = 1; i <= size; ++i) {
            if (signs[i + offset]) continue;
            max = datas[i + offset];
            break;
        }
        if (i > size) {
            return null;
        }
        ++i;
        while (i <= size) {
            if (!signs[i + offset] && max < datas[i + offset]) {
                max = datas[i + offset];
            }
            ++i;
        }
        return ObjectCache.getInteger((int)max);
    }

    public Object min() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        if (signs == null) {
            int min = datas[1 + offset];
            for (int i2 = 2; i2 <= size; ++i2) {
                if (min <= datas[i2 + offset]) continue;
                min = datas[i2 + offset];
            }
            return ObjectCache.getInteger((int)min);
        }
        int min = 0;
        for (i = 1; i <= size; ++i) {
            if (signs[i + offset]) continue;
            min = datas[i + offset];
            break;
        }
        if (i > size) {
            return null;
        }
        ++i;
        while (i <= size) {
            if (!signs[i + offset] && min > datas[i + offset]) {
                min = datas[i + offset];
            }
            ++i;
        }
        return ObjectCache.getInteger((int)min);
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof IntArray) {
            this._$1((IntArray)array, relation, result, isAnd);
        } else if (array instanceof LongArray) {
            this.calcRelations((LongArray)array, relation, result, isAnd);
        } else if (array instanceof DoubleArray) {
            this.calcRelations((DoubleArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
    }

    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof Double || value instanceof Float) {
            this._$1(((Number)value).doubleValue(), relation, result, isAnd);
        } else if (value instanceof BigDecimal) {
            this._$1((BigDecimal)value, relation, result, isAnd);
        } else if (value instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)value);
            this._$1(decimal, relation, result, isAnd);
        } else if (value instanceof Number) {
            this._$1(((Number)value).longValue(), relation, result, isAnd);
        } else if (value == null) {
            ArrayUtil.calcRelationsNull((boolean[])this._$5, (int)this._$2, (int)relation, (BoolArray)result, (boolean)isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(IntArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] != array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || d1[f] != array.getInt(i))) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || d1[f] != array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] != array.isNull(i) || !s1[f] && d1[f] != array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] <= array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && d1[f] <= array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || d1[f] <= array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || !array.isNull(i) && d1[f] <= array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] < array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && d1[f] < array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || d1[f] < array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !array.isNull(i) && (s1[f] || d1[f] < array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] >= array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || d1[f] >= array.getInt(i))) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && d1[f] >= array.getInt(i)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (array.isNull(i) || !s1[f] && d1[f] >= array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] > array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || d1[f] > array.getInt(i))) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && d1[f] > array.getInt(i)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (array.isNull(i) || d1[f] > array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && d1[f] == array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && d1[f] == array.getInt(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && d1[f] == array.getInt(i)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && s1[f] == array.isNull(i) && (s1[f] || d1[f] == array.getInt(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] == array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && d1[f] == array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && d1[f] == array.getInt(i)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? array.isNull(i) : !array.isNull(i) && d1[f] == array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] > array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || d1[f] > array.getInt(i))) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && d1[f] > array.getInt(i)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[f] || !array.isNull(i) && d1[f] <= array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] >= array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || d1[f] >= array.getInt(i))) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && d1[f] >= array.getInt(i)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (array.isNull(i) || !s1[f] && d1[f] >= array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] < array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && d1[f] < array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || d1[f] < array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || array.isNull(i) || !s1[f] && d1[f] >= array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] <= array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && d1[f] <= array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || d1[f] <= array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || !array.isNull(i) && d1[f] <= array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && d1[f] != array.getInt(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || d1[f] != array.getInt(i))) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || d1[f] != array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? !array.isNull(i) : array.isNull(i) || d1[f] != array.getInt(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(LongArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (long)d1[f] != array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || (long)d1[f] != array.getLong(i))) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || (long)d1[f] != array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] != array.isNull(i) || !s1[f] && (long)d1[f] != array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (long)d1[f] <= array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && (long)d1[f] <= array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || (long)d1[f] <= array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || !array.isNull(i) && (long)d1[f] <= array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (long)d1[f] < array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && (long)d1[f] < array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || (long)d1[f] < array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !array.isNull(i) && (s1[f] || (long)d1[f] < array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (long)d1[f] >= array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || (long)d1[f] >= array.getLong(i))) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (long)d1[f] >= array.getLong(i)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (array.isNull(i) || !s1[f] && (long)d1[f] >= array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (long)d1[f] > array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || (long)d1[f] > array.getLong(i))) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (long)d1[f] > array.getLong(i)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (array.isNull(i) || (long)d1[f] > array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (long)d1[f] == array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && (long)d1[f] == array.getLong(i)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (long)d1[f] == array.getLong(i)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && s1[f] == array.isNull(i) && (s1[f] || (long)d1[f] == array.getLong(i))) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (long)d1[f] == array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && (long)d1[f] == array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && (long)d1[f] == array.getLong(i)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? array.isNull(i) : !array.isNull(i) && (long)d1[f] == array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (long)d1[f] > array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || (long)d1[f] > array.getLong(i))) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && (long)d1[f] > array.getLong(i)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[f] || !array.isNull(i) && (long)d1[f] <= array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (long)d1[f] >= array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || (long)d1[f] >= array.getLong(i))) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && (long)d1[f] >= array.getLong(i)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (array.isNull(i) || !s1[f] && (long)d1[f] >= array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (long)d1[f] < array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && (long)d1[f] < array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || (long)d1[f] < array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || array.isNull(i) || !s1[f] && (long)d1[f] >= array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (long)d1[f] <= array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && (long)d1[f] <= array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || (long)d1[f] <= array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || !array.isNull(i) && (long)d1[f] <= array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (long)d1[f] != array.getLong(i)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || (long)d1[f] != array.getLong(i))) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || (long)d1[f] != array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? !array.isNull(i) : array.isNull(i) || (long)d1[f] != array.getLong(i))) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(DoubleArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) != 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) != 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Double.compare(d1[f], array.getDouble(i)) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] != array.isNull(i) || !s1[f] && Double.compare(d1[f], array.getDouble(i)) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) <= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Double.compare(d1[f], array.getDouble(i)) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) < 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Double.compare(d1[f], array.getDouble(i)) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !array.isNull(i) && (s1[f] || Double.compare(d1[f], array.getDouble(i)) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) >= 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) >= 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Double.compare(d1[f], array.getDouble(i)) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (array.isNull(i) || !s1[f] && Double.compare(d1[f], array.getDouble(i)) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) > 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) > 0)) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Double.compare(d1[f], array.getDouble(i)) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) > 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    if (!array.hasSigns()) {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) == 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                        return;
                    } else {
                        int i = 1;
                        int f = this._$4;
                        while (i <= size) {
                            if (resultDatas[i] && !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) == 0) {
                                resultDatas[i] = false;
                            }
                            ++i;
                            ++f;
                        }
                    }
                    return;
                } else if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Double.compare(d1[f], array.getDouble(i)) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && s1[f] == array.isNull(i) && (s1[f] || Double.compare(d1[f], array.getDouble(i)) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) == 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) == 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Double.compare(d1[f], array.getDouble(i)) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? array.isNull(i) : !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) > 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) > 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Double.compare(d1[f], array.getDouble(i)) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || s1[f] || !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) >= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) >= 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Double.compare(d1[f], array.getDouble(i)) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (array.isNull(i) || !s1[f] && Double.compare(d1[f], array.getDouble(i)) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) < 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Double.compare(d1[f], array.getDouble(i)) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!(resultDatas[i] || array.isNull(i) || !s1[f] && Double.compare(d1[f], array.getDouble(i)) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) <= 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Double.compare(d1[f], array.getDouble(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || !array.isNull(i) && Double.compare(d1[f], array.getDouble(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && Double.compare(d1[f], array.getDouble(i)) != 0) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!resultDatas[i] && (array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) != 0)) {
                            resultDatas[i] = true;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (!array.hasSigns()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Double.compare(d1[f], array.getDouble(i)) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? !array.isNull(i) : array.isNull(i) || Double.compare(d1[f], array.getDouble(i)) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(long value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (long)d1[f] != value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || (long)d1[f] != value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (long)d1[f] <= value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || (long)d1[f] <= value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (long)d1[f] < value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || (long)d1[f] < value)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (long)d1[f] >= value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (long)d1[f] >= value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (long)d1[f] > value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (long)d1[f] > value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (long)d1[f] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && (long)d1[f] == value) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (long)d1[f] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && (long)d1[f] == value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (long)d1[f] > value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && (long)d1[f] > value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (long)d1[f] >= value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && (long)d1[f] >= value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (long)d1[f] < value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || (long)d1[f] < value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (long)d1[f] <= value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || (long)d1[f] <= value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (long)d1[f] != value) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || (long)d1[f] != value)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(double value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[f], value) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Double.compare(d1[f], value) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[f], value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Double.compare(d1[f], value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[f], value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || Double.compare(d1[f], value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[f], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Double.compare(d1[f], value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[f], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Double.compare(d1[f], value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && Double.compare(d1[f], value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && Double.compare(d1[f], value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[f], value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Double.compare(d1[f], value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[f], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Double.compare(d1[f], value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[f], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && Double.compare(d1[f], value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[f], value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Double.compare(d1[f], value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[f], value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Double.compare(d1[f], value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && Double.compare(d1[f], value) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || Double.compare(d1[f], value) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(BigDecimal value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || new BigDecimal(d1[f]).compareTo(value) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || new BigDecimal(d1[f]).compareTo(value) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || new BigDecimal(d1[f]).compareTo(value) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && new BigDecimal(d1[f]).compareTo(value) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && new BigDecimal(d1[f]).compareTo(value) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && new BigDecimal(d1[f]).compareTo(value) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && new BigDecimal(d1[f]).compareTo(value) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && new BigDecimal(d1[f]).compareTo(value) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && new BigDecimal(d1[f]).compareTo(value) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || new BigDecimal(d1[f]).compareTo(value) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || new BigDecimal(d1[f]).compareTo(value) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && new BigDecimal(d1[f]).compareTo(value) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || new BigDecimal(d1[f]).compareTo(value) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) != 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] ? array.get(i) != null : IntArraySubset._$1(d1[f], array.get(i)) != 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 2) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) <= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] || IntArraySubset._$1(d1[f], array.get(i)) <= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 3) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) < 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] ? array.get(i) != null : IntArraySubset._$1(d1[f], array.get(i)) < 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 4) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) >= 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] ? array.get(i) == null : IntArraySubset._$1(d1[f], array.get(i)) >= 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else if (relation == 5) {
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && !s1[f] && IntArraySubset._$1(d1[f], array.get(i)) > 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                if (s1 == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) == 0) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                    return;
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (resultDatas[i] && (s1[f] ? array.get(i) == null : IntArraySubset._$1(d1[f], array.get(i)) == 0)) {
                            resultDatas[i] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            }
            return;
        } else if (relation == 1) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) == 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? array.get(i) == null : IntArraySubset._$1(d1[f], array.get(i)) == 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 2) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && !s1[f] && IntArraySubset._$1(d1[f], array.get(i)) > 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 3) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) >= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (array.get(i) == null || !s1[f] && IntArraySubset._$1(d1[f], array.get(i)) >= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 4) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) < 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && array.get(i) != null && (s1[f] || IntArraySubset._$1(d1[f], array.get(i)) < 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 5) {
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) <= 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] || IntArraySubset._$1(d1[f], array.get(i)) <= 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            if (s1 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && IntArraySubset._$1(d1[f], array.get(i)) != 0) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!resultDatas[i] && (s1[f] ? array.get(i) != null : IntArraySubset._$1(d1[f], array.get(i)) != 0)) {
                        resultDatas[i] = true;
                    }
                    ++i;
                    ++f;
                }
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (array instanceof IntArray) {
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] & array.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] & array.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("and" + mm.getMessage("function.paramTypeError"));
            }
            int n = ((Number)value).intValue();
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    result.pushInt(datas[f] & n);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] & n);
                    }
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        return array.bitwiseAnd((IArray)this);
    }

    public IArray bitwiseOr(IArray array) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (array instanceof IntArray) {
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] | array.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] | array.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("or" + mm.getMessage("function.paramTypeError"));
            }
            int n = ((Number)value).intValue();
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    result.pushInt(datas[f] | n);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] | n);
                    }
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        return array.bitwiseOr((IArray)this);
    }

    public IArray bitwiseXOr(IArray array) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (array instanceof IntArray) {
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] ^ array.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f] || array.isNull(i)) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] ^ array.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object value = array.get(1);
            if (value == null) {
                return new ConstArray(null, size);
            }
            if (!(value instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
            }
            int n = ((Number)value).intValue();
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    result.pushInt(datas[f] ^ n);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signs[f]) {
                        result.pushNull();
                    } else {
                        result.pushInt(datas[f] ^ n);
                    }
                    ++i;
                    ++f;
                }
            }
            return result;
        }
        return array.bitwiseXOr((IArray)this);
    }

    public IArray bitwiseNot() {
        int i;
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (this.isTemporary()) {
            if (signs == null) {
                int i2 = 1;
                int f = this._$4;
                while (i2 <= size) {
                    datas[f] = ~datas[f];
                    ++i2;
                    ++f;
                }
            } else {
                int i3 = 1;
                int f = this._$4;
                while (i3 <= size) {
                    if (!signs[f]) {
                        datas[f] = ~datas[f];
                    }
                    ++i3;
                    ++f;
                }
            }
            return this;
        }
        int[] resultDatas = new int[size + 1];
        boolean[] resultSigns = null;
        if (signs == null) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = ~datas[f];
                ++i;
                ++f;
            }
        } else {
            resultSigns = new boolean[size + 1];
            System.arraycopy(signs, this._$4, resultSigns, 1, size);
            i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    resultDatas[i] = ~datas[f];
                }
                ++i;
                ++f;
            }
        }
        IntArray result = new IntArray(resultDatas, resultSigns, size);
        result.setTemporary(true);
        return result;
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        int[] resultDatas = new int[size + 1];
        int resultSize = 0;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                if (!array.hasSigns()) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (array.getBool(i)) {
                            resultDatas[++resultSize] = d1[f];
                        }
                        ++i;
                        ++f;
                    }
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (!array.isNull(i) && array.getBool(i)) {
                            resultDatas[++resultSize] = d1[f];
                        }
                        ++i;
                        ++f;
                    }
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultDatas[++resultSize] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            }
            return new IntArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (signArray.isTrue(i)) {
                ++resultSize;
                if (s1[f]) {
                    resultSigns[resultSize] = true;
                } else {
                    resultDatas[resultSize] = d1[f];
                }
            }
            ++i;
            ++f;
        }
        return new IntArray(resultDatas, resultSigns, resultSize);
    }

    public IArray select(int start, int end, IArray signArray) {
        int[] d1 = this._$6;
        boolean[] s1 = this._$5;
        int[] resultDatas = new int[end - start + 1];
        int resultSize = 0;
        int offset = this._$1;
        if (s1 == null) {
            if (signArray instanceof BoolArray) {
                BoolArray array = (BoolArray)signArray;
                if (!array.hasSigns()) {
                    for (int i = start; i < end; ++i) {
                        if (!array.getBool(i)) continue;
                        resultDatas[++resultSize] = d1[i + offset];
                    }
                } else {
                    for (int i = start; i < end; ++i) {
                        if (array.isNull(i) || !array.getBool(i)) continue;
                        resultDatas[++resultSize] = d1[i + offset];
                    }
                }
            } else {
                for (int i = start; i < end; ++i) {
                    if (!signArray.isTrue(i)) continue;
                    resultDatas[++resultSize] = d1[i + offset];
                }
            }
            return new IntArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[end - start + 1];
        for (int i = start; i < end; ++i) {
            if (!signArray.isTrue(i)) continue;
            ++resultSize;
            if (s1[i + offset]) {
                resultSigns[resultSize] = true;
                continue;
            }
            resultDatas[resultSize] = d1[i + offset];
        }
        return new IntArray(resultDatas, resultSigns, resultSize);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public Object[] toArray() {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        Object[] result = new Object[size];
        if (signs == null) {
            for (int i = 1; i <= size; ++i) {
                result[i - 1] = ObjectCache.getInteger((int)datas[i + offset]);
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (signs[i + offset]) continue;
                result[i - 1] = ObjectCache.getInteger((int)datas[i + offset]);
            }
        }
        return result;
    }

    public void toArray(Object[] result) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int offset = this._$1;
        if (signs == null) {
            for (int i = 1; i <= size; ++i) {
                result[i - 1] = ObjectCache.getInteger((int)datas[i + offset]);
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (signs[i + offset]) continue;
                result[i - 1] = ObjectCache.getInteger((int)datas[i + offset]);
            }
        }
    }

    public IArray split(int pos) {
        int size = this._$2;
        boolean[] signs = this._$5;
        int resultSize = size - pos + 1;
        int[] resultDatas = new int[resultSize + 1];
        int offset = this._$1;
        System.arraycopy(this._$6, pos + offset, resultDatas, 1, resultSize);
        if (signs == null) {
            this._$2 = pos - 1;
            return new IntArray(resultDatas, null, resultSize);
        }
        boolean[] resultSigns = new boolean[resultSize + 1];
        System.arraycopy(signs, pos + offset, resultSigns, 1, resultSize);
        for (int i = pos; i <= size; ++i) {
            signs[i + offset] = false;
        }
        this._$2 = pos - 1;
        return new IntArray(resultDatas, resultSigns, resultSize);
    }

    public IArray split(int from, int to) {
        throw new RuntimeException();
    }

    public void sort() {
        int size = this._$2;
        boolean[] signs = this._$5;
        if (signs == null) {
            MultithreadUtil.sort((int[])this._$6, (int)(1 + this._$1), (int)(size + 1 + this._$1));
            return;
        }
        int nullCount = 0;
        int i = 1;
        int off = this._$4;
        while (i <= size) {
            if (signs[off]) {
                ++nullCount;
            }
            ++i;
            ++off;
        }
        if (nullCount == 0) {
            MultithreadUtil.sort((int[])this._$6, (int)(1 + this._$1), (int)(size + 1 + this._$1));
            this._$5 = null;
        } else if (nullCount != size) {
            int i2;
            int[] datas = this._$6;
            int offset = this._$1;
            int q = size;
            for (i2 = size; i2 > 0; --i2) {
                if (signs[i2 + offset]) {
                    signs[i2 + offset] = false;
                    continue;
                }
                datas[q-- + offset] = datas[i2 + offset];
            }
            MultithreadUtil.sort((int[])datas, (int)(nullCount + 1 + offset), (int)(size + 1 + offset));
            for (i2 = 1; i2 <= nullCount; ++i2) {
                signs[i2 + offset] = true;
            }
        }
    }

    public void sort(Comparator<Object> comparator) {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] values = new Integer[size + 1];
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                values[i] = datas[off];
                ++i;
                ++off;
            }
            MultithreadUtil.sort((Object[])values, (int)1, (int)(size + 1), comparator);
            i = 1;
            off = this._$4;
            while (i <= size) {
                datas[off] = (Integer)values[i];
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    values[i] = datas[off];
                }
                ++i;
                ++off;
            }
            MultithreadUtil.sort((Object[])values, (int)1, (int)(size + 1), comparator);
            i = 1;
            off = this._$4;
            while (i <= size) {
                if (values[i] != null) {
                    datas[off] = (Integer)values[i];
                    signs[off] = false;
                } else {
                    signs[off] = true;
                }
                ++i;
                ++off;
            }
        }
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int[] resultDatas = new int[size + 1];
        int offset = this._$1;
        if (signs == null) {
            int q = size;
            for (int i = 1; i <= size; ++i) {
                resultDatas[i] = datas[q-- + offset];
            }
            return new IntArray(resultDatas, null, size);
        }
        boolean[] resultSigns = new boolean[size + 1];
        int i = 1;
        int q = size;
        while (i <= size) {
            if (signs[q + offset]) {
                resultSigns[i] = true;
            } else {
                resultDatas[i] = datas[q + offset];
            }
            ++i;
            --q;
        }
        return new IntArray(resultDatas, resultSigns, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        int size = this._$2;
        if (size == 0) {
            return new IntArray(0);
        }
        return this.dup().ptop(count, isAll, isLast, ignoreNull);
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        Object[] resultDatas = new Object[size + 1];
        if (signs == null) {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                resultDatas[i] = ObjectCache.getInteger((int)datas[off]);
                ++i;
                ++off;
            }
        } else {
            int i = 1;
            int off = this._$4;
            while (i <= size) {
                if (!signs[off]) {
                    resultDatas[i] = ObjectCache.getInteger((int)datas[off]);
                }
                ++i;
                ++off;
            }
        }
        return new ObjectArray(resultDatas, size);
    }

    public IArray toPureArray() {
        return this;
    }

    public void setInt(int index, int value) {
        this._$6[index + this._$1] = value;
    }

    public IArray reserve(boolean refOrigin) {
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        IntArray result;
        if (other instanceof ConstArray) {
            return this.combine(signArray, ((ConstArray)other).getData());
        }
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (other instanceof IntArray) {
            IntArray resultArray;
            IntArray otherArray = (IntArray)other;
            result = resultArray = new IntArray(size);
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultArray.pushInt(datas[f]);
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushInt(otherArray.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[f]) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushInt(datas[f]);
                        }
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushInt(otherArray.getInt(i));
                    }
                    ++i;
                    ++f;
                }
            }
        } else if (other instanceof LongArray) {
            LongArray otherArray = (LongArray)other;
            LongArray resultArray = new LongArray(size);
            result = resultArray;
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultArray.pushLong((long)datas[f]);
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushLong(otherArray.getLong(i));
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[f]) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushLong((long)datas[f]);
                        }
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushLong(otherArray.getLong(i));
                    }
                    ++i;
                    ++f;
                }
            }
        } else if (other instanceof DoubleArray) {
            DoubleArray otherArray = (DoubleArray)other;
            DoubleArray resultArray = new DoubleArray(size);
            result = resultArray;
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        resultArray.pushDouble((double)datas[f]);
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushDouble(otherArray.getDouble(i));
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[f]) {
                            resultArray.pushNull();
                        } else {
                            resultArray.pushDouble((double)datas[f]);
                        }
                    } else if (otherArray.isNull(i)) {
                        resultArray.pushNull();
                    } else {
                        resultArray.pushDouble(otherArray.getDouble(i));
                    }
                    ++i;
                    ++f;
                }
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? ObjectCache.getInteger((int)datas[f]) : other.get(i);
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (!signs[f]) {
                            resultDatas[i] = ObjectCache.getInteger((int)datas[f]);
                        }
                    } else {
                        resultDatas[i] = other.get(i);
                    }
                    ++i;
                    ++f;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    public IArray combine(IArray signArray, Object value) {
        IntArraySubset result;
        int size = this._$2;
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        if (value instanceof Integer) {
            int v = ((Number)value).intValue();
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (signArray.isFalse(i)) {
                            datas[f] = v;
                        }
                        ++i;
                        ++f;
                    }
                } else {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (signArray.isFalse(i)) {
                            datas[f] = v;
                            signs[f] = false;
                        }
                        ++i;
                        ++f;
                    }
                }
            } else {
                int[] resultDatas = new int[size + 1];
                boolean[] resultSigns = null;
                if (signs == null) {
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        resultDatas[i] = signArray.isTrue(i) ? datas[f] : v;
                        ++i;
                        ++f;
                    }
                } else {
                    resultSigns = new boolean[size + 1];
                    int i = 1;
                    int f = this._$4;
                    while (i <= size) {
                        if (signArray.isTrue(i)) {
                            if (signs[f]) {
                                resultSigns[i] = true;
                            } else {
                                resultDatas[i] = datas[f];
                            }
                        } else {
                            resultDatas[i] = v;
                        }
                        ++i;
                        ++f;
                    }
                }
                result = new IntArray(resultDatas, resultSigns, size);
            }
        } else if (value instanceof Long) {
            long v = ((Number)value).longValue();
            long[] resultDatas = new long[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? (long)datas[f] : v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[f]) {
                            resultSigns[i] = true;
                        } else {
                            resultDatas[i] = datas[f];
                        }
                    } else {
                        resultDatas[i] = v;
                    }
                    ++i;
                    ++f;
                }
            }
            result = new LongArray(resultDatas, resultSigns, size);
        } else if (value instanceof Double) {
            double v = ((Number)value).doubleValue();
            double[] resultDatas = new double[size + 1];
            boolean[] resultSigns = null;
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? (double)datas[f] : v;
                    ++i;
                    ++f;
                }
            } else {
                resultSigns = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (signs[f]) {
                            resultSigns[i] = true;
                        } else {
                            resultDatas[i] = datas[f];
                        }
                    } else {
                        resultDatas[i] = v;
                    }
                    ++i;
                    ++f;
                }
            }
            result = new DoubleArray(resultDatas, resultSigns, size);
        } else if (value == null) {
            if (this.isTemporary()) {
                result = this;
                if (signs == null) {
                    this._$5 = signs = new boolean[size + 1];
                }
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isFalse(i)) {
                        signs[f] = true;
                    }
                    ++i;
                    ++f;
                }
            } else {
                boolean[] resultSigns = new boolean[size + 1];
                int[] resultDatas = new int[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i) && (signs == null || !signs[f])) {
                        resultDatas[i] = datas[f];
                    } else {
                        resultSigns[i] = true;
                    }
                    ++i;
                    ++f;
                }
                result = new IntArray(resultDatas, resultSigns, size);
            }
        } else {
            Object[] resultDatas = new Object[size + 1];
            if (signs == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = signArray.isTrue(i) ? ObjectCache.getInteger((int)datas[f]) : value;
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (signArray.isTrue(i)) {
                        if (!signs[f]) {
                            resultDatas[i] = ObjectCache.getInteger((int)datas[f]);
                        }
                    } else {
                        resultDatas[i] = value;
                    }
                    ++i;
                    ++f;
                }
            }
            result = new ObjectArray(resultDatas, size);
        }
        result.setTemporary(true);
        return result;
    }

    public Object pos(IArray array, String opt) {
        if (array instanceof IntArray) {
            int len = this._$2;
            IntArray intArray = (IntArray)array;
            int subLen = intArray.size();
            if (len < subLen) {
                return null;
            }
            boolean isSorted = false;
            boolean isIncre = false;
            boolean isContinuous = false;
            if (opt != null) {
                if (opt.indexOf(98) != -1) {
                    isSorted = true;
                }
                if (opt.indexOf(105) != -1) {
                    isIncre = true;
                }
                if (opt.indexOf(99) != -1) {
                    isContinuous = true;
                }
            }
            if (isIncre) {
                IntArray result = new IntArray(subLen);
                if (isSorted) {
                    int pos = 1;
                    for (int t = 1; t <= subLen; ++t) {
                        pos = intArray.isNull(t) ? this.binarySearch(null, pos, len) : this._$1(intArray.getInt(t), pos, len);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                            continue;
                        }
                        return null;
                    }
                } else {
                    int pos = 1;
                    for (int t = 1; t <= subLen; ++t) {
                        pos = intArray.isNull(t) ? this.firstIndexOf(null, pos) : this._$1(intArray.getInt(t), pos);
                        if (pos > 0) {
                            result.pushInt(pos);
                            ++pos;
                            continue;
                        }
                        return null;
                    }
                }
                return new Sequence((IArray)result);
            }
            if (isContinuous) {
                int maxCandidate = len - subLen + 1;
                if (isSorted) {
                    int candidate = 1;
                    block2: while (candidate <= maxCandidate) {
                        int result = this.compareTo(candidate, (IArray)intArray, 1);
                        if (result < 0) {
                            ++candidate;
                            continue;
                        }
                        if (result == 0) {
                            int i = 2;
                            int j = candidate + 1;
                            while (i <= subLen) {
                                if (!this.isEquals(j, intArray, i)) {
                                    ++candidate;
                                    continue block2;
                                }
                                ++i;
                                ++j;
                            }
                            return candidate;
                        }
                        return null;
                    }
                } else {
                    block4: for (int candidate = 1; candidate <= maxCandidate; ++candidate) {
                        int i = 1;
                        int j = candidate;
                        while (i <= subLen) {
                            if (!this.isEquals(j, intArray, i)) continue block4;
                            ++i;
                            ++j;
                        }
                        return candidate;
                    }
                }
                return null;
            }
            IntArray result = new IntArray(subLen);
            if (isSorted) {
                for (int t = 1; t <= subLen; ++t) {
                    int pos = intArray.isNull(t) ? this.binarySearch(null) : this.binarySearch(intArray.getInt(t));
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                }
            } else {
                for (int t = 1; t <= subLen; ++t) {
                    int pos = intArray.isNull(t) ? this.firstIndexOf(null, 1) : this._$1(intArray.getInt(t), 1);
                    if (pos <= 0) {
                        return null;
                    }
                    result.pushInt(pos);
                }
            }
            return new Sequence((IArray)result);
        }
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        int[] datas = this._$6;
        boolean[] signs = this._$5;
        int size = this._$2;
        int sum = 0;
        if (signs == null) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                sum += Integer.bitCount(datas[f]);
                ++i;
                ++f;
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!signs[f]) {
                    sum += Integer.bitCount(datas[f]);
                }
                ++i;
                ++f;
            }
        }
        return sum;
    }
}

