/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.array;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArraySubset
extends StringArray {
    private static final long serialVersionUID = 1L;
    private String[] _$5;
    private int _$4;
    private int _$3;
    private int _$2;
    private int _$1;

    public StringArraySubset(String[] datas, boolean[] signs, int start, int end) {
        this._$5 = datas;
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public StringArraySubset(StringArray array, int start, int end) {
        super(array.getDatas(), array.size());
        this._$5 = array.getDatas();
        this._$4 = start;
        this._$3 = end;
        this._$2 = end - start + 1;
        this._$1 = start - 1;
    }

    public String[] getDatas() {
        int len = this._$2 + 1;
        String[] newDatas = new String[len];
        System.arraycopy(this._$5, this._$4, newDatas, 0, len);
        return newDatas;
    }

    public static int compare(String d1, String d2) {
        if (d1 == null) {
            return d2 == null ? 0 : -1;
        }
        if (d2 == null) {
            return 1;
        }
        int cmp = d1.compareTo(d2);
        return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
    }

    private static int _$1(String d1, Object d2) {
        if (d2 instanceof String) {
            if (d1 == null) {
                return -1;
            }
            int cmp = d1.compareTo((String)d2);
            return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
        }
        if (d2 == null) {
            return d1 == null ? 0 : 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", (Object)d1, d2, (Object)mm.getMessage("DataType.String"), (Object)Variant.getDataType((Object)d2)));
    }

    public String getDataType() {
        MessageManager mm = EngineMessage.get();
        return mm.getMessage("DataType.String");
    }

    public IArray dup() {
        int len = this._$2 + 1;
        String[] newDatas = new String[len];
        System.arraycopy(this._$5, this._$4, newDatas, 0, len);
        return new StringArray(newDatas, this._$2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public byte[] serialize() throws IOException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray newInstance(int count) {
        return new StringArray(count);
    }

    public void add(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(IArray array, int index, int count) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void addAll(Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insert(int index, Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void insertAll(int pos, Object[] array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(String str) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushString(String str) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(Object o) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void pushNull() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void push(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void add(IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void set(int curIndex, IArray array, int index) {
        this.set(curIndex, array.get(index));
    }

    public Object get(int index) {
        return this._$5[index + this._$1];
    }

    public String getString(int index) {
        return this._$5[index + this._$1];
    }

    public int getInt(int index) {
        throw new RuntimeException();
    }

    public long getLong(int index) {
        throw new RuntimeException();
    }

    public IArray get(int[] indexArray) {
        String[] datas = this._$5;
        int len = indexArray.length;
        StringArray result = new StringArray(len);
        int offset = this._$1;
        for (int i : indexArray) {
            result.pushString(datas[i + offset]);
        }
        return result;
    }

    public IArray get(int[] indexArray, int start, int end, boolean doCheck) {
        String[] datas = this._$5;
        int len = end - start + 1;
        String[] resultDatas = new String[len + 1];
        int offset = this._$1;
        if (doCheck) {
            int i = 1;
            while (start <= end) {
                int q = indexArray[start];
                if (q > 0) {
                    resultDatas[i] = datas[q + offset];
                }
                ++start;
                ++i;
            }
        } else {
            int i = 1;
            while (start <= end) {
                resultDatas[i++] = datas[indexArray[start] + offset];
                ++start;
            }
        }
        return new StringArray(resultDatas, len);
    }

    public IArray get(IArray indexArray) {
        String[] datas = this._$5;
        int len = indexArray.size();
        StringArray result = new StringArray(len);
        for (int i = 1; i <= len; ++i) {
            result.pushString(datas[indexArray.getInt(i) + this._$1]);
        }
        return result;
    }

    public IArray get(int start, int end) {
        int newSize = end - start;
        String[] newDatas = new String[newSize + 1];
        System.arraycopy(this._$5, start + this._$1, newDatas, 1, newSize);
        return new StringArray(newDatas, newSize);
    }

    public void ensureCapacity(int minCapacity) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void trimToSize() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public boolean isNull(int index) {
        return this._$5[index + this._$1] == null;
    }

    public BoolArray isTrue() {
        int size = this._$2;
        String[] datas = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = datas[f] != null;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public BoolArray isFalse() {
        int size = this._$2;
        String[] datas = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = datas[f] == null;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isTrue(int index) {
        return this._$5[index + this._$1] != null;
    }

    public boolean isFalse(int index) {
        return this._$5[index + this._$1] == null;
    }

    public boolean isTemporary() {
        return false;
    }

    public void setTemporary(boolean ifTemporary) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeLast() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void removeRange(int fromIndex, int toIndex) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void remove(int[] seqs) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void reserve(int start, int end) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int size() {
        return this._$2;
    }

    public int count() {
        int size;
        String[] datas = this._$5;
        int count = size = this._$2;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] == null) {
                --count;
            }
            ++i;
            ++f;
        }
        return count;
    }

    public boolean containTrue() {
        int size = this._$2;
        if (size == 0) {
            return false;
        }
        String[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                return true;
            }
            ++i;
            ++f;
        }
        return false;
    }

    public Object ifn() {
        int size = this._$2;
        String[] datas = this._$5;
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                return datas[f];
            }
            ++i;
            ++f;
        }
        return null;
    }

    public void set(int index, Object obj) {
        index += this._$1;
        if (obj instanceof String) {
            this._$5[index] = (String)obj;
        } else if (obj == null) {
            this._$5[index] = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("pdm.arrayTypeError", (Object)mm.getMessage("DataType.String"), (Object)Variant.getDataType((Object)obj)));
        }
    }

    public void clear() {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public int binarySearch(Object elem) {
        int idx = super.binarySearch(elem, this._$4, this._$3);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public int binarySearch(Object elem, int start, int end) {
        int idx = super.binarySearch(elem, start + this._$1, end + this._$1);
        if (idx < 0) {
            idx = -idx;
            return -(idx - this._$1);
        }
        return idx - this._$1;
    }

    public boolean contains(Object elem) {
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this._$5;
            int size = this._$2;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null && datas[f].equals(v)) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        if (elem == null) {
            int size = this._$2;
            String[] datas = this._$5;
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] == null) {
                    return true;
                }
                ++i;
                ++f;
            }
            return false;
        }
        return false;
    }

    public void contains(boolean isSorted, IArray array, BoolArray result) {
        int resultSize = result.size();
        if (isSorted) {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.binarySearch(array.get(i)) >= 1) continue;
                result.set(i, false);
            }
        } else {
            for (int i = 1; i <= resultSize; ++i) {
                if (!result.isTrue(i) || this.contains(array.get(i))) continue;
                result.set(i, false);
            }
        }
    }

    public boolean objectContains(Object elem) {
        String[] datas = this._$5;
        int offset = this._$1;
        int size = this._$2;
        for (int i = 1; i <= size; ++i) {
            if (datas[i + offset] != elem) continue;
            return true;
        }
        return false;
    }

    public int firstIndexOf(Object elem, int start) {
        int offset = this._$1;
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this._$5;
            int size = this._$2;
            for (int i = start; i <= size; ++i) {
                if (datas[i + offset] == null || !datas[i + offset].equals(v)) continue;
                return i;
            }
            return 0;
        }
        if (elem == null) {
            int size = this._$2;
            String[] datas = this._$5;
            for (int i = start; i <= size; ++i) {
                if (datas[i + offset] != null) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public int lastIndexOf(Object elem, int start) {
        int offset = this._$1;
        if (elem instanceof String) {
            String v = (String)elem;
            String[] datas = this._$5;
            for (int i = start; i > 0; --i) {
                if (datas[i + offset] == null || !datas[i + offset].equals(v)) continue;
                return i;
            }
            return 0;
        }
        if (elem == null) {
            String[] datas = this._$5;
            for (int i = start; i > 0; --i) {
                if (datas[i + offset] != null) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    public IntArray indexOfAll(Object elem, int start, boolean isSorted, boolean isFromHead) {
        int size = this._$2;
        String[] datas = this._$5;
        int offset = this._$1;
        if (elem == null) {
            IntArray result = new IntArray(7);
            if (isSorted) {
                if (isFromHead) {
                    for (int i = start; i <= size && datas[i + offset] == null; ++i) {
                        result.addInt(i);
                    }
                } else {
                    for (int i = start; i > 0; --i) {
                        if (datas[i + offset] != null) continue;
                        result.addInt(i);
                    }
                }
            } else if (isFromHead) {
                for (int i = start; i <= size; ++i) {
                    if (datas[i + offset] != null) continue;
                    result.addInt(i);
                }
            } else {
                for (int i = start; i > 0; --i) {
                    if (datas[i + offset] != null) continue;
                    result.addInt(i);
                }
            }
            return result;
        }
        if (!(elem instanceof String)) {
            return new IntArray(1);
        }
        String str = (String)elem;
        if (isSorted) {
            int last;
            int first;
            int index;
            int end = size;
            if (isFromHead) {
                end = start;
                start = 1;
            }
            if ((index = this.binarySearch(str, start, end)) < 1) {
                return new IntArray(1);
            }
            for (first = index; first > start && StringArraySubset.compare(datas[first - 1 + offset], str) == 0; --first) {
            }
            for (last = index; last < end && StringArraySubset.compare(datas[last + 1 + offset], str) == 0; ++last) {
            }
            IntArray result = new IntArray(last - first + 1);
            if (isFromHead) {
                while (first <= last) {
                    result.pushInt(first);
                    ++first;
                }
            } else {
                while (last >= first) {
                    result.pushInt(last);
                    --last;
                }
            }
            return result;
        }
        IntArray result = new IntArray(7);
        if (isFromHead) {
            for (int i = start; i <= size; ++i) {
                if (StringArraySubset.compare(datas[i + offset], str) != 0) continue;
                result.addInt(i);
            }
        } else {
            for (int i = start; i > 0; --i) {
                if (StringArraySubset.compare(datas[i + offset], str) != 0) continue;
                result.addInt(i);
            }
        }
        return result;
    }

    public IArray abs() {
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(this.getDataType() + mm.getMessage("Variant2.illAbs"));
    }

    public IArray negate() {
        int size = this._$2;
        String[] datas = this._$5;
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    datas[f] = Variant.negate((String)datas[f]);
                }
                ++i;
                ++f;
            }
            return this;
        }
        String[] newDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                newDatas[i] = Variant.negate((String)datas[f]);
            }
            ++i;
            ++f;
        }
        StringArray result = new StringArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray not() {
        String[] datas = this._$5;
        int size = this._$2;
        boolean[] newDatas = new boolean[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            newDatas[i] = datas[f] == null;
            ++i;
            ++f;
        }
        BoolArray result = new BoolArray(newDatas, size);
        result.setTemporary(true);
        return result;
    }

    public boolean isNumberArray() {
        return false;
    }

    public IArray memberAdd(IArray array) {
        if (array instanceof StringArray) {
            return this._$2((StringArray)array);
        }
        if (array instanceof ConstArray) {
            return this.memberAdd(array.get(1));
        }
        if (array instanceof ObjectArray) {
            return ((ObjectArray)array).memberAdd((IArray)this);
        }
        if (array instanceof NumberArray) {
            return this.memberAdd((NumberArray)array);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public IArray memberAdd(Object value) {
        if (value == null) {
            return this;
        }
        int size = this._$2;
        String[] datas = this._$5;
        if (value instanceof String) {
            String str = (String)value;
            if (this.isTemporary()) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (datas[f] != null) {
                        int n = f;
                        datas[n] = datas[n] + str;
                    } else {
                        datas[f] = str;
                    }
                    ++i;
                    ++f;
                }
                return this;
            }
            String[] newDatas = new String[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[i] != null) {
                    newDatas[i] = datas[f] + str;
                } else {
                    newDatas[f] = str;
                }
                ++i;
                ++f;
            }
            StringArray result = new StringArray(newDatas, size);
            result.setTemporary(true);
            return result;
        }
        if (value instanceof Number) {
            Number n2 = (Number)value;
            Object[] resultDatas = new Object[size + 1];
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                Number n1;
                resultDatas[i] = datas[f] != null ? (Number)((n1 = Variant.parseNumber((String)datas[f])) == null ? (Number)n2 : (Number)Variant.addNum((Number)n1, (Number)n2)) : (Number)n2;
                ++i;
                ++f;
            }
            ObjectArray result = new ObjectArray(resultDatas, size);
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illAdd"));
    }

    private StringArray _$2(StringArray array) {
        StringArraySubset result;
        String[] newDatas;
        int size = this._$2;
        String[] d1 = this._$5;
        if (this.isTemporary()) {
            newDatas = d1;
            result = this;
        } else if (array.isTemporary()) {
            newDatas = array.getDatas();
            result = array;
        } else {
            newDatas = new String[size + 1];
            result = new StringArray(newDatas, size);
        }
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            newDatas[i] = d1[f] != null ? (array.getString(i) != null ? d1[f] + array.getString(i) : d1[f]) : array.getString(i);
            ++i;
            ++f;
        }
        return result;
    }

    public ObjectArray memberAdd(NumberArray array) {
        int size = this._$2;
        String[] datas = this._$5;
        Object[] resultDatas = new Object[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            Number n1;
            resultDatas[i] = datas[f] != null ? ((n1 = Variant.parseNumber((String)datas[f])) == null ? array.get(i) : Variant.addNum((Number)n1, (Number)((Number)array.get(i)))) : array.get(i);
            ++i;
            ++f;
        }
        ObjectArray result = new ObjectArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberSubtract(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illSubtract"));
    }

    public IArray memberMultiply(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberMultiply(Object value) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + Variant.getDataType((Object)value) + mm.getMessage("Variant2.illMultiply"));
    }

    public IArray memberDivide(IArray array) {
        if (array instanceof StringArray) {
            return this._$1((StringArray)array);
        }
        if (array instanceof ConstArray) {
            return this._$1(array.get(1));
        }
        int size = this._$2;
        String[] datas = this._$5;
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!array.isNull(i)) {
                    if (datas[f] != null) {
                        int n = f;
                        datas[n] = datas[n] + array.get(i);
                    } else {
                        datas[f] = array.get(i).toString();
                    }
                }
                ++i;
                ++f;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            if (datas[f] != null) {
                resultDatas[i] = !array.isNull(i) ? datas[f] + array.get(i) : datas[f];
            } else if (!array.isNull(i)) {
                resultDatas[i] = array.get(i).toString();
            }
            ++i;
            ++f;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray _$1(Object value) {
        if (value == null) {
            return this;
        }
        String str = value.toString();
        int size = this._$2;
        String[] datas = this._$5;
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (datas[f] != null) {
                    int n = f;
                    datas[n] = datas[n] + str;
                } else {
                    datas[f] = str;
                }
                ++i;
                ++f;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = datas[f] != null ? datas[f] + str : str;
            ++i;
            ++f;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private StringArray _$1(StringArray array) {
        int size = this._$2;
        String[] d1 = this._$5;
        if (this.isTemporary()) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (array.getString(i) != null) {
                    if (d1[f] != null) {
                        int n = f;
                        d1[n] = d1[n] + array.getString(i);
                    } else {
                        d1[f] = array.getString(i);
                    }
                }
                ++i;
                ++f;
            }
            return this;
        }
        String[] resultDatas = new String[size + 1];
        int i = 1;
        int f = this._$4;
        while (i <= size) {
            resultDatas[i] = d1[f] != null ? (array.getString(i) != null ? d1[f] + array.getString(i) : d1[f]) : array.getString(i);
            ++i;
            ++f;
        }
        StringArray result = new StringArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    public IArray memberMod(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illMod"));
    }

    public IArray memberIntDivide(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illDivide"));
    }

    public BoolArray calcRelation(IArray array, int relation) {
        if (array instanceof StringArray) {
            return this._$1((StringArray)array, relation);
        }
        if (array instanceof ConstArray) {
            return this.calcRelation(array.get(1), relation);
        }
        if (array instanceof ObjectArray) {
            return this.calcRelation((ObjectArray)array, relation);
        }
        if (array instanceof BoolArray) {
            return ((BoolArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof IntArray) {
            return ((IntArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof LongArray) {
            return ((LongArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DoubleArray) {
            return ((DoubleArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        if (array instanceof DateArray) {
            return ((DateArray)array).calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
        }
        return array.calcRelation((IArray)this, Relation.getInverseRelation((int)relation));
    }

    public BoolArray calcRelation(Object value, int relation) {
        if (value instanceof String) {
            return this._$1((String)value, relation);
        }
        if (value == null) {
            return ArrayUtil.calcRelationNull((Object[])this._$5, (int)this._$4, (int)this._$3, (int)this._$2, (int)relation);
        }
        boolean b = Variant.isTrue((Object)value);
        int size = this._$2;
        String[] datas = this._$5;
        if (relation == 7) {
            BoolArray result;
            if (!b) {
                result = new BoolArray(false, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] != null;
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        if (relation == 8) {
            BoolArray result;
            if (b) {
                result = new BoolArray(true, size);
            } else {
                boolean[] resultDatas = new boolean[size + 1];
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    resultDatas[i] = datas[f] != null;
                    ++i;
                    ++f;
                }
                result = new BoolArray(resultDatas, size);
            }
            result.setTemporary(true);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
    }

    private BoolArray _$1(String value, int relation) {
        int i;
        int size = this._$2;
        String[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], value) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], value) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], value) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], value) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], value) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], value) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null;
                ++i;
                ++f;
            }
        } else {
            for (i = 1; i <= size; ++i) {
                resultDatas[i] = true;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    private BoolArray _$1(StringArray array, int relation) {
        int i;
        int size = this._$2;
        String[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], array.getString(i)) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], array.getString(i)) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], array.getString(i)) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], array.getString(i)) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], array.getString(i)) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset.compare(d1[f], array.getString(i)) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null && array.getString(i) != null;
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null || array.getString(i) != null;
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    protected BoolArray calcRelation(ObjectArray array, int relation) {
        int i;
        int size = this._$2;
        String[] d1 = this._$5;
        boolean[] resultDatas = new boolean[size + 1];
        if (relation == 1) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset._$1(d1[f], array.get(i)) == 0;
                ++i;
                ++f;
            }
        } else if (relation == 2) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset._$1(d1[f], array.get(i)) > 0;
                ++i;
                ++f;
            }
        } else if (relation == 3) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset._$1(d1[f], array.get(i)) >= 0;
                ++i;
                ++f;
            }
        } else if (relation == 4) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset._$1(d1[f], array.get(i)) < 0;
                ++i;
                ++f;
            }
        } else if (relation == 5) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset._$1(d1[f], array.get(i)) <= 0;
                ++i;
                ++f;
            }
        } else if (relation == 6) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = StringArraySubset._$1(d1[f], array.get(i)) != 0;
                ++i;
                ++f;
            }
        } else if (relation == 7) {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null && Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        } else {
            i = 1;
            int f = this._$4;
            while (i <= size) {
                resultDatas[i] = d1[f] != null || Variant.isTrue((Object)array.get(i));
                ++i;
                ++f;
            }
        }
        BoolArray result = new BoolArray(resultDatas, size);
        result.setTemporary(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compareTo(IArray array) {
        int f;
        ObjectArray array2;
        int result;
        int size;
        String[] d1;
        block15: {
            int f2;
            block14: {
                int f3;
                String d2;
                block13: {
                    int f4;
                    StringArray array22;
                    block10: {
                        block11: {
                            Object value;
                            block12: {
                                block9: {
                                    int size1 = this._$2;
                                    int size2 = array.size();
                                    d1 = this._$5;
                                    size = size1;
                                    result = 0;
                                    if (size1 < size2) {
                                        result = -1;
                                    } else if (size1 > size2) {
                                        result = 1;
                                        size = size2;
                                    }
                                    if (!(array instanceof StringArray)) break block9;
                                    array22 = (StringArray)array;
                                    f4 = this._$4;
                                    break block10;
                                }
                                if (!(array instanceof ConstArray)) break block11;
                                value = array.get(1);
                                if (!(value instanceof String)) break block12;
                                d2 = (String)value;
                                f3 = this._$4;
                                break block13;
                            }
                            if (value != null) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)array.getDataType()));
                            }
                            f2 = this._$4;
                            break block14;
                        }
                        if (!(array instanceof ObjectArray)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
                        }
                        array2 = (ObjectArray)array;
                        f = this._$4;
                        break block15;
                    }
                    for (int i = 1; i <= size; ++i, ++f4) {
                        int cmp = StringArraySubset.compare(d1[f4], array22.getString(i));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return result;
                }
                for (int i = 1; i <= size; ++i, ++f3) {
                    int cmp = StringArraySubset.compare(d1[f3], d2);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return result;
            }
            for (int i = 1; i <= size; ++i, ++f2) {
                if (d1[f2] == null) continue;
                return 1;
            }
            return result;
        }
        for (int i = 1; i <= size; ++i, ++f) {
            int cmp = StringArraySubset._$1(d1[f], array2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return result;
    }

    public int memberCompare(int index1, int index2) {
        return StringArraySubset.compare(this._$5[index1 + this._$1], this._$5[index2 + this._$1]);
    }

    public boolean isMemberEquals(int index1, int index2) {
        index2 += this._$1;
        if (this._$5[index1 += this._$1] == null) {
            return this._$5[index2] == null;
        }
        if (this._$5[index2] == null) {
            return false;
        }
        return this._$5[index1].equals(this._$5[index2]);
    }

    public boolean isEquals(int curIndex, IArray array, int index) {
        curIndex += this._$1;
        Object value = array.get(index);
        if (value instanceof String) {
            return ((String)value).equals(this._$5[curIndex]);
        }
        if (value == null) {
            return this._$5[curIndex] == null;
        }
        return false;
    }

    public boolean isEquals(int curIndex, Object value) {
        curIndex += this._$1;
        if (value instanceof String) {
            return ((String)value).equals(this._$5[curIndex]);
        }
        if (value == null) {
            return this._$5[curIndex] == null;
        }
        return false;
    }

    public int compareTo(int curIndex, IArray array, int index) {
        return StringArraySubset._$1(this._$5[curIndex += this._$1], array.get(index));
    }

    public int compareTo(int curIndex, Object value) {
        return StringArraySubset._$1(this._$5[curIndex += this._$1], value);
    }

    public int hashCode(int index) {
        if (this._$5[index += this._$1] != null) {
            return this._$5[index].hashCode();
        }
        return 0;
    }

    public Object sum() {
        int size = this._$2;
        if (size < 1) {
            return null;
        }
        int offset = this._$1;
        String[] datas = this._$5;
        String result = datas[1];
        for (int i = 2; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            result = result == null ? datas[i + offset] : result + datas[i + offset];
        }
        return result;
    }

    public Object average() {
        return null;
    }

    public Object max() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        String[] datas = this._$5;
        String max = null;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            max = datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] != null && max.compareTo(datas[i + offset]) < 0) {
                max = datas[i + offset];
            }
            ++i;
        }
        return max;
    }

    public Object min() {
        int i;
        int size = this._$2;
        if (size == 0) {
            return null;
        }
        String[] datas = this._$5;
        String min = null;
        int offset = this._$1;
        for (i = 1; i <= size; ++i) {
            if (datas[i + offset] == null) continue;
            min = datas[i + offset];
            break;
        }
        ++i;
        while (i <= size) {
            if (datas[i + offset] != null && min.compareTo(datas[i + offset]) > 0) {
                min = datas[i + offset];
            }
            ++i;
        }
        return min;
    }

    public void calcRelations(IArray array, int relation, BoolArray result, boolean isAnd) {
        if (array instanceof StringArray) {
            this._$1((StringArray)array, relation, result, isAnd);
        } else if (array instanceof ConstArray) {
            this.calcRelations(array.get(1), relation, result, isAnd);
        } else if (array instanceof ObjectArray) {
            this.calcRelations((ObjectArray)array, relation, result, isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), array.get(1), (Object)this.getDataType(), (Object)array.getDataType()));
        }
    }

    public void calcRelations(Object value, int relation, BoolArray result, boolean isAnd) {
        if (value instanceof String) {
            this._$1((String)value, relation, result, isAnd);
        } else if (value == null) {
            ArrayUtil.calcRelationsNull((Object[])this._$5, (int)this._$2, (int)relation, (BoolArray)result, (boolean)isAnd);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", this.get(1), value, (Object)this.getDataType(), (Object)Variant.getDataType((Object)value)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(String value, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        String[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], value) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], value) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], value) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], value) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], value) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], value) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], value) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], value) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], value) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], value) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], value) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], value) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _$1(StringArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        String[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset.compare(d1[f], array.getString(i)) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void calcRelations(ObjectArray array, int relation, BoolArray result, boolean isAnd) {
        int size = this._$2;
        String[] d1 = this._$5;
        boolean[] resultDatas = result.getDatas();
        if (isAnd) {
            if (relation == 1) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) != 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 2) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) <= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 3) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) < 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 4) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) >= 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else if (relation == 5) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) > 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
                return;
            } else {
                if (relation != 6) throw new RuntimeException();
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) == 0) {
                        resultDatas[i] = false;
                    }
                    ++i;
                    ++f;
                }
            }
            return;
        } else if (relation == 1) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) == 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 2) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) > 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 3) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) >= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 4) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) < 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else if (relation == 5) {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) <= 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
            return;
        } else {
            if (relation != 6) throw new RuntimeException();
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (!resultDatas[i] && StringArraySubset._$1(d1[f], array.get(i)) != 0) {
                    resultDatas[i] = true;
                }
                ++i;
                ++f;
            }
        }
    }

    public IArray bitwiseAnd(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("and" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("or" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseXOr(IArray array) {
        MessageManager mm = EngineMessage.get();
        throw new RQException("xor" + mm.getMessage("function.paramTypeError"));
    }

    public IArray bitwiseNot() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("not" + mm.getMessage("function.paramTypeError"));
    }

    public IArray select(IArray signArray) {
        int size = signArray.size();
        String[] d1 = this._$5;
        String[] resultDatas = new String[size + 1];
        int count = 0;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (d2[i]) {
                        resultDatas[++count] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            } else {
                int i = 1;
                int f = this._$4;
                while (i <= size) {
                    if (!s2[i] && d2[i]) {
                        resultDatas[++count] = d1[f];
                    }
                    ++i;
                    ++f;
                }
            }
        } else {
            int i = 1;
            int f = this._$4;
            while (i <= size) {
                if (signArray.isTrue(i)) {
                    resultDatas[++count] = d1[f];
                }
                ++i;
                ++f;
            }
        }
        return new StringArray(resultDatas, count);
    }

    public IArray select(int start, int end, IArray signArray) {
        String[] d1 = this._$5;
        String[] resultDatas = new String[end - start + 1];
        int count = 0;
        int offset = this._$1;
        if (signArray instanceof BoolArray) {
            BoolArray array = (BoolArray)signArray;
            boolean[] d2 = array.getDatas();
            boolean[] s2 = array.getSigns();
            if (s2 == null) {
                for (int i = start; i < end; ++i) {
                    if (!d2[i]) continue;
                    resultDatas[++count] = d1[i + offset];
                }
            } else {
                for (int i = start; i < end; ++i) {
                    if (s2[i] || !d2[i]) continue;
                    resultDatas[++count] = d1[i + offset];
                }
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!signArray.isTrue(i)) continue;
                resultDatas[++count] = d1[i + offset];
            }
        }
        return new StringArray(resultDatas, count);
    }

    public IArray memberAdd(int curIndex, IArray array, int index) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.getDataType() + mm.getMessage("Variant2.with") + array.getDataType() + mm.getMessage("Variant2.illAdd"));
    }

    public Object[] toArray() {
        Object[] result = new Object[this._$2];
        System.arraycopy(this._$5, this._$4, result, 0, this._$2);
        return result;
    }

    public void toArray(Object[] result) {
        System.arraycopy(this._$5, this._$4, result, 0, this._$2);
    }

    public IArray split(int pos) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public IArray split(int from, int to) {
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("pdm.modifyError"));
    }

    public void sort() {
        MultithreadUtil.sort((String[])this._$5, (int)this._$4, (int)(this._$3 + 1));
    }

    public void sort(Comparator<Object> comparator) {
        MultithreadUtil.sort((Object[])this._$5, (int)this._$4, (int)(this._$3 + 1), comparator);
    }

    public boolean hasRecord() {
        return false;
    }

    public boolean isPmt(boolean isPure) {
        return false;
    }

    public IArray rvs() {
        int size = this._$2;
        String[] datas = this._$5;
        String[] resultDatas = new String[size + 1];
        int offset = this._$1;
        int q = size;
        for (int i = 1; i <= size; ++i) {
            resultDatas[i] = datas[q-- + offset];
        }
        return new StringArray(resultDatas, size);
    }

    public IntArray ptop(int count, boolean isAll, boolean isLast, boolean ignoreNull) {
        throw new RuntimeException();
    }

    public void setSize(int size) {
        this._$2 = size;
    }

    public ObjectArray toObjectArray() {
        Object[] resultDatas = new Object[this._$2 + 1];
        System.arraycopy(this._$5, this._$4, resultDatas, 1, this._$2);
        return new ObjectArray(resultDatas, this._$2);
    }

    public IArray toPureArray() {
        return this.dup();
    }

    public IArray reserve(boolean refOrigin) {
        if (refOrigin) {
            return this;
        }
        return this.dup();
    }

    public IArray combine(IArray signArray, IArray other) {
        return this.dup().combine(signArray, other);
    }

    public IArray combine(IArray signArray, Object value) {
        return this.dup().combine(signArray, value);
    }

    public Object pos(IArray array, String opt) {
        return ArrayUtil.pos((IArray)this.dup(), (IArray)array, (String)opt);
    }

    public int bit1() {
        MessageManager mm = EngineMessage.get();
        throw new RQException("bit1" + mm.getMessage("function.paramTypeError"));
    }
}

