/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.column.reader;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.PhyTable;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Moves;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.operator.DotOperator;
import com.scudata.pdm.column.gather.AttachColumnAvg;
import com.scudata.pdm.column.gather.AttachColumnCount;
import com.scudata.pdm.column.gather.AttachColumnField;
import com.scudata.pdm.column.gather.AttachColumnGather;
import com.scudata.pdm.column.gather.AttachColumnMax;
import com.scudata.pdm.column.gather.AttachColumnMin;
import com.scudata.pdm.column.gather.AttachColumnSum;
import com.scudata.pdm.column.reader.AttachColumnsMetaDataReader;
import com.scudata.pdm.column.reader.AttachRowCountReader;
import com.scudata.pdm.column.reader.ColumnMetaDataReader;
import com.scudata.pdm.column.reader.GuideColumnReader;
import com.scudata.pdm.column.reader.IColumnMetaDataReader;
import com.scudata.pdm.column.reader.RowCountReader;
import com.scudata.resources.EngineMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachColumnMetaDataReader
extends ColumnMetaDataReader {
    private AttachRowCountReader _$8;
    private RowCountReader _$7;
    private AttachColumnGather _$6;
    private String _$5;

    public AttachColumnMetaDataReader(ColumnMetaData column, RowCountReader baseRowCountReader, AttachRowCountReader attachRowCountReader, AttachColumnGather gather, Context ctx) {
        super(column, attachRowCountReader);
        this._$8 = attachRowCountReader;
        this._$7 = baseRowCountReader;
        this._$6 = gather;
    }

    public static IColumnMetaDataReader newInstance(PhyTable baseTable, RowCountReader baseRowCountReader, List<RowCountReader> AttachRowCountReaderList, Expression exp, Context ctx) {
        ColumnMetaData column;
        Node home = exp.getHome();
        if (!(home instanceof DotOperator) && !(home instanceof Moves)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(exp.getIdentifierName() + mm.getMessage("ds.fieldNotExist"));
        }
        Node obj = home.getLeft();
        String tableName = ((UnknownSymbol)obj).getName();
        ColPhyTable table = (ColPhyTable)baseTable.getAnnexTable(tableName);
        if (table == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(tableName + mm.getMessage("dw.tableNotExist"));
        }
        try {
            table.appendCache();
        }
        catch (IOException e) {
            throw new RQException((Throwable)e);
        }
        AttachRowCountReader attachRowCountReader = null;
        if (AttachRowCountReaderList.size() != 0) {
            for (RowCountReader reader : AttachRowCountReaderList) {
                if (!tableName.equals(reader.getTableName())) continue;
                attachRowCountReader = (AttachRowCountReader)reader;
                break;
            }
        }
        if (attachRowCountReader == null) {
            ColumnMetaData guideColumn = table.getGuideColumn();
            GuideColumnReader guideReader = new GuideColumnReader(guideColumn);
            attachRowCountReader = new AttachRowCountReader(table.getSegmentReader(), guideReader);
            attachRowCountReader.setTableName(tableName);
            AttachRowCountReaderList.add(attachRowCountReader);
        }
        obj = exp.getHome().getRight();
        String field = null;
        if (home instanceof Moves) {
            IParam fieldParam = ((Moves)home).getParam();
            ParamInfo2 pi = ParamInfo2.parse((IParam)fieldParam, (String)"cursor", (boolean)false, (boolean)false);
            String[] subFields = pi.getExpressionStrs1();
            String[] subNames = pi.getExpressionStrs2();
            if (subFields == null) {
                subFields = table.getColNames();
                subNames = subFields;
            } else {
                int colCount = subNames.length;
                for (int i = 0; i < colCount; ++i) {
                    if (subNames[i] != null && subNames[i].length() != 0) continue;
                    if (subFields[i] == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    subNames[i] = subFields[i];
                }
            }
            ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
            for (String name : subNames) {
                columns.add(table.getColumn(name));
            }
            return new AttachColumnsMetaDataReader(columns, baseRowCountReader, attachRowCountReader);
        }
        if (obj instanceof FieldRef) {
            field = ((FieldRef)obj).getName();
            column = table.getColumn(field);
            return new AttachColumnMetaDataReader(column, baseRowCountReader, attachRowCountReader, new AttachColumnField(), ctx);
        }
        if (obj instanceof Function) {
            field = ((Function)obj).getParamString();
            column = table.getColumn(field);
            String fname = ((Function)obj).getFunctionName();
            if (fname.equals("sum")) {
                return new AttachColumnMetaDataReader(column, baseRowCountReader, attachRowCountReader, new AttachColumnSum(), ctx);
            }
            if (fname.equals("count")) {
                return new AttachColumnMetaDataReader(column, baseRowCountReader, attachRowCountReader, new AttachColumnCount(), ctx);
            }
            if (fname.equals("max")) {
                return new AttachColumnMetaDataReader(column, baseRowCountReader, attachRowCountReader, new AttachColumnMax(), ctx);
            }
            if (fname.equals("min")) {
                return new AttachColumnMetaDataReader(column, baseRowCountReader, attachRowCountReader, new AttachColumnMin(), ctx);
            }
            if (fname.equals("avg")) {
                return new AttachColumnMetaDataReader(column, baseRowCountReader, attachRowCountReader, new AttachColumnAvg(), ctx);
            }
        }
        return null;
    }

    private IArray _$1(int baseRecordCount, IArray attachArray, IntArray guideArray) throws IOException {
        IArray resultArray = this._$6.gather(baseRecordCount, attachArray, guideArray);
        return resultArray;
    }

    @Override
    public IArray readNextArray() throws IOException {
        IntArray guideArray = this._$8.readGuideArray(this._$7.getCurBlockNum());
        IArray arr = super.readNextArray();
        return this._$1(this._$7.getCurBlockRowCount(), arr, guideArray);
    }

    @Override
    public IArray readArray() throws IOException {
        IntArray guideArray = this._$8.readGuideArray(this._$7.getCurBlockNum());
        IArray arr = super.readArray();
        return this._$1(this._$7.getCurBlockRowCount(), arr, guideArray);
    }

    @Override
    public IArray readArray(IArray match) throws IOException {
        IntArray guideArray = this._$8.readGuideArray(this._$7.getCurBlockNum());
        IArray attachMatch = AttachColumnsMetaDataReader.toAttachMatch(guideArray, match);
        IArray arr = super.readArray(attachMatch);
        return this._$1(this._$7.getCurBlockRowCount(), arr, guideArray);
    }

    @Override
    public IArray readSkipArray(IArray match, int matchCount) throws IOException {
        IntArray guideArray = this._$8.readGuideArray(this._$7.getCurBlockNum());
        IArray attachMatch = AttachColumnsMetaDataReader.toAttachMatch(guideArray, match);
        IArray arr = super.readArray(attachMatch);
        arr = this._$1(this._$7.getCurBlockRowCount(), arr, guideArray);
        return arr.select(match);
    }

    @Override
    public String getColumnName() {
        return this._$5;
    }

    @Override
    public void setColumnName(String columnName) {
        this._$5 = columnName;
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this._$7 != null) {
                this._$7.close();
            }
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            this._$7 = null;
        }
    }
}

