/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.column.reader;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dw.ColumnMetaData;
import com.scudata.pdm.PureTable;
import com.scudata.pdm.column.reader.AttachRowCountReader;
import com.scudata.pdm.column.reader.ColumnMetaDataReader;
import com.scudata.pdm.column.reader.IColumnMetaDataReader;
import com.scudata.pdm.column.reader.RowCountReader;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachColumnsMetaDataReader
implements IColumnMetaDataReader {
    private ColumnMetaDataReader[] _$6;
    private ColumnMetaDataReader _$5;
    private AttachRowCountReader _$4;
    private RowCountReader _$3;
    private DataStruct _$2;
    private String _$1;

    public AttachColumnsMetaDataReader(List<ColumnMetaData> columns, RowCountReader baseRowCountReader, AttachRowCountReader attachRowCountReader) {
        int size = columns.size();
        ColumnMetaDataReader[] columnReaders = new ColumnMetaDataReader[size];
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            ColumnMetaData column = columns.get(i);
            columnReaders[i] = new ColumnMetaDataReader(column, attachRowCountReader);
            names[i] = column.getColName();
        }
        this._$5 = columnReaders[0];
        this._$2 = new DataStruct(names);
        this._$3 = baseRowCountReader;
        this._$4 = attachRowCountReader;
        this._$6 = columnReaders;
    }

    @Override
    public String getColumnName() {
        return this._$1;
    }

    @Override
    public void setColumnName(String columnName) {
        this._$1 = columnName;
    }

    @Override
    public int readBlockRowCount(int blockNum) throws IOException {
        return this._$5.readBlockRowCount(blockNum);
    }

    @Override
    public void readSegmentInfoAndSeek() throws IOException {
        for (ColumnMetaDataReader reader : this._$6) {
            reader.readSegmentInfoAndSeek();
        }
    }

    @Override
    public void readSegmentInfo() throws IOException {
        for (ColumnMetaDataReader reader : this._$6) {
            reader.readSegmentInfo();
        }
    }

    @Override
    public void skipSegmentInfo() throws IOException {
        for (ColumnMetaDataReader reader : this._$6) {
            reader.skipSegmentInfo();
        }
    }

    @Override
    public Object getCurBlockMaxValue() {
        throw new RuntimeException();
    }

    @Override
    public Object getCurBlockMinValue() {
        throw new RuntimeException();
    }

    @Override
    public Object getCurBlockStartValue() {
        throw new RuntimeException();
    }

    @Override
    public IArray readNextArray() throws IOException {
        IntArray guideArray = this._$4.readGuideArray(this._$3.getCurBlockNum());
        int baseRecordCount = this._$3.getCurBlockRowCount();
        ColumnMetaDataReader[] columnReaders = this._$6;
        int len = columnReaders.length;
        IArray[] arrays = new IArray[len];
        for (int i = 0; i < len; ++i) {
            arrays[i] = columnReaders[i].readNextArray();
        }
        return this._$1(baseRecordCount, arrays, guideArray);
    }

    @Override
    public IArray readArray() throws IOException {
        IntArray guideArray = this._$4.readGuideArray(this._$3.getCurBlockNum());
        int baseRecordCount = this._$3.getCurBlockRowCount();
        ColumnMetaDataReader[] columnReaders = this._$6;
        int len = columnReaders.length;
        IArray[] arrays = new IArray[len];
        for (int i = 0; i < len; ++i) {
            arrays[i] = columnReaders[i].readArray();
        }
        return this._$1(baseRecordCount, arrays, guideArray);
    }

    @Override
    public IArray readArray(IArray match) throws IOException {
        IntArray guideArray = this._$4.readGuideArray(this._$3.getCurBlockNum());
        int baseRecordCount = this._$3.getCurBlockRowCount();
        IArray attachMatch = AttachColumnsMetaDataReader.toAttachMatch(guideArray, match);
        ColumnMetaDataReader[] columnReaders = this._$6;
        int len = columnReaders.length;
        IArray[] arrays = new IArray[len];
        for (int i = 0; i < len; ++i) {
            arrays[i] = columnReaders[i].readArray(attachMatch);
        }
        return this._$1(baseRecordCount, arrays, guideArray, match);
    }

    @Override
    public IArray readSkipArray(IArray match, int matchCount) throws IOException {
        IntArray guideArray = this._$4.readGuideArray(this._$3.getCurBlockNum());
        int baseRecordCount = this._$3.getCurBlockRowCount();
        IArray attachMatch = AttachColumnsMetaDataReader.toAttachMatch(guideArray, match);
        ColumnMetaDataReader[] columnReaders = this._$6;
        int len = columnReaders.length;
        IArray[] arrays = new IArray[len];
        for (int i = 0; i < len; ++i) {
            arrays[i] = columnReaders[i].readArray(attachMatch);
        }
        return this._$1(baseRecordCount, arrays, guideArray, match).select(match);
    }

    @Override
    public void close() {
        try {
            for (ColumnMetaDataReader reader : this._$6) {
                reader.close();
            }
            if (this._$3 != null) {
                this._$3.close();
            }
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        finally {
            this._$3 = null;
            this._$6 = null;
        }
    }

    protected static IArray toAttachMatch(IntArray guideArray, IArray baseMatch) {
        int size = guideArray.size();
        BoolArray attachMatch = new BoolArray(false, size);
        boolean[] baseMatchData = baseMatch.isTrue().getDatas();
        boolean[] attachMatchData = attachMatch.getDatas();
        int[] guideData = guideArray.getDatas();
        for (int i = 1; i <= size; ++i) {
            attachMatchData[i] = baseMatchData[guideData[i]];
        }
        return attachMatch;
    }

    private IArray _$1(int baseRecordCount, IArray[] attachArrays, IntArray guideArray) throws IOException {
        ObjectArray resultArray = new ObjectArray(baseRecordCount);
        resultArray.setSize(baseRecordCount);
        int[] guideData = guideArray.getDatas();
        PureTable seq = null;
        int len = guideArray.size();
        if (len == 0) {
            return resultArray;
        }
        DataStruct ds = this._$2;
        int fcount = attachArrays.length;
        int last = guideData[1];
        int from = 1;
        int to = 0;
        for (int i = 1; i <= len; ++i) {
            int pos = guideData[i];
            if (pos != last) {
                to = i;
                IArray[] resultDatas = new IArray[fcount];
                for (int f = 0; f < fcount; ++f) {
                    resultDatas[f] = attachArrays[f].get(from, to);
                }
                seq = new PureTable(ds, resultDatas);
                resultArray.set(last, (Object)seq);
                from = i;
            }
            last = pos;
        }
        IArray[] resultDatas = new IArray[fcount];
        for (int f = 0; f < fcount; ++f) {
            resultDatas[f] = attachArrays[f].get(from, len + 1);
        }
        seq = new PureTable(ds, resultDatas);
        resultArray.set(last, (Object)seq);
        return resultArray;
    }

    private IArray _$1(int baseRecordCount, IArray[] attachArrays, IntArray guideArray, IArray match) throws IOException {
        ObjectArray resultArray = new ObjectArray(baseRecordCount);
        resultArray.setSize(baseRecordCount);
        int[] guideData = guideArray.getDatas();
        PureTable seq = null;
        int len = guideArray.size();
        if (len == 0) {
            return resultArray;
        }
        DataStruct ds = this._$2;
        int fcount = attachArrays.length;
        int last = guideData[1];
        int from = 1;
        int to = 0;
        boolean[] matchData = match.isTrue().getDatas();
        for (int i = 1; i <= len; ++i) {
            int pos = guideData[i];
            if (pos != last) {
                to = i;
                if (matchData[last]) {
                    IArray[] resultDatas = new IArray[fcount];
                    for (int f = 0; f < fcount; ++f) {
                        resultDatas[f] = attachArrays[f].get(from, to);
                    }
                    seq = new PureTable(ds, resultDatas);
                    resultArray.set(last, (Object)seq);
                }
                from = i;
            }
            last = pos;
        }
        if (matchData[last]) {
            IArray[] resultDatas = new IArray[fcount];
            for (int f = 0; f < fcount; ++f) {
                resultDatas[f] = attachArrays[f].get(from, len + 1);
            }
            seq = new PureTable(ds, resultDatas);
            resultArray.set(last, (Object)seq);
        }
        return resultArray;
    }

    @Override
    public void setTemporary(boolean b) {
    }

    @Override
    public IArray[] readArrayAndDict() throws IOException {
        return new IArray[]{this.readArray(), null, null};
    }
}

