/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.mfn.cursor;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dw.MemoryTable;
import com.scudata.dw.PhyTable;
import com.scudata.expression.CursorFunction;
import com.scudata.expression.IParam;
import com.scudata.pdm.PureMemoryTable;
import com.scudata.pdm.PureTable;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;

public class PureMemory
extends CursorFunction {
    public Object calculate(Context ctx) {
        String[] keys = null;
        String distribute = null;
        Integer partition = null;
        PhyTable tmd = CursorUtil.getTableMetaData((ICursor)this.cursor);
        if (tmd != null) {
            distribute = tmd.getDistribute();
            partition = tmd.getGroupTable().getPartition();
        }
        if (this.param != null) {
            if (this.param.isLeaf()) {
                keys = new String[]{this.param.getLeafExpression().getIdentifierName()};
            } else {
                int size = this.param.getSubSize();
                keys = new String[size];
                for (int i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("memory" + mm.getMessage("function.invalidParam"));
                    }
                    keys[i] = sub.getLeafExpression().getIdentifierName();
                }
            }
        }
        if (this.option != null && this.option.indexOf(122) != -1) {
            MemoryTable table = new MemoryTable(this.cursor);
            if (keys != null) {
                table.setPrimary(keys);
            }
            if (partition != null) {
                table.setDistribute(distribute);
                table.setPart(partition.intValue());
            }
            return table;
        }
        Sequence seq = this.cursor.fetch();
        PureTable table = null;
        if (seq instanceof PureTable) {
            table = (PureTable)seq;
        } else {
            if (seq == null) {
                return null;
            }
            DataStruct ds = seq.dataStruct();
            if (ds != null) {
                int fcount = ds.getFieldCount();
                IArray[] arrays = new IArray[fcount];
                for (int f = 0; f < fcount; ++f) {
                    arrays[f] = seq.getFieldValueArray(f);
                    arrays[f] = arrays[f].toPureArray();
                }
                table = new PureTable(ds, arrays);
            } else {
                return new MemoryTable(seq.derive("o"));
            }
        }
        PureMemoryTable result = new PureMemoryTable(table);
        if (keys != null) {
            result.setPrimary(keys);
        }
        if (partition != null) {
            result.setDistribute(distribute);
            result.setPart(partition);
        }
        return result;
    }

    public boolean isLeftTypeMatch(Object obj) {
        if (obj instanceof ICursor) {
            boolean hasV;
            boolean bl = hasV = this.option != null && this.option.indexOf(118) != -1;
            if (hasV) {
                return true;
            }
        }
        return false;
    }
}

