/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.pdm.mfn.dw;

import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.MergeCursor2;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Operation;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.ComTable;
import com.scudata.dw.IDWCursor;
import com.scudata.dw.IFilter;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableGroup;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.PhyTableFunction;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.operator.And;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.pdm.IPureCursor;
import com.scudata.pdm.cursor.MergeConjCursor;
import com.scudata.pdm.cursor.MergeConjCursor2;
import com.scudata.pdm.cursor.MergeConjCursor3;
import com.scudata.pdm.cursor.PureCursor;
import com.scudata.pdm.cursor.PureCursor2;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCursor
extends PhyTableFunction {
    public Object calculate(Context ctx) {
        ICursor cs;
        SplEditorSE.checkColumn();
        if (this.table instanceof ColPhyTable) {
            cs = CreateCursor.createCursor((ColPhyTable)this.table, this.param, this.option, ctx);
        } else if (this.table instanceof PhyTableGroup && ((PhyTableGroup)this.table).isColumnStored()) {
            cs = CreateCursor.createCursor((PhyTableGroup)this.table, this.param, this.option, ctx);
        } else {
            return com.scudata.expression.mfn.dw.CreateCursor.createCursor((IPhyTable)this.table, (IParam)this.param, (String)this.option, (Context)ctx);
        }
        if (this.option != null && this.option.indexOf(120) != -1) {
            CreateCursor.setOptionX(cs, this.option);
        }
        return cs;
    }

    private static void _$1(IParam param, ArrayList<Expression> expList, ArrayList<String> fieldList, ArrayList<Sequence> codeList, ArrayList<String> optList, Context ctx) {
        if (param != null) {
            if (param.isLeaf()) {
                expList.add(param.getLeafExpression());
            } else if (param.getType() == ':') {
                int subSize = param.getSubSize();
                if (subSize > 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                IParam sub0 = param.getSub(0);
                IParam sub1 = param.getSub(1);
                if (sub0 == null || sub1 == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                String fkName = sub0.getLeafExpression().getIdentifierName();
                fieldList.add(fkName);
                Object val = sub1.getLeafExpression().calculate(ctx);
                if (val instanceof Sequence) {
                    codeList.add((Sequence)val);
                } else if (val == null) {
                    codeList.add(new Sequence());
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                }
                if (subSize > 2) {
                    IParam sub2 = param.getSub(2);
                    if (sub2 != null) {
                        String opt = sub2.getLeafExpression().toString();
                        optList.add(opt);
                    } else {
                        optList.add(null);
                    }
                } else {
                    optList.add(null);
                }
            }
        }
    }

    public static ICursor createCursor(ColPhyTable table, IParam param, String opt, Context ctx) {
        boolean isMultiThread;
        if (!table.getGroupTable().isPureFormat()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.oldVersion"));
        }
        boolean bl = isMultiThread = opt != null && opt.indexOf(109) != -1;
        if (param == null && !isMultiThread) {
            return CreateCursor.cursor(table);
        }
        IParam fieldParam = null;
        Expression filter = null;
        String[] fkNames = null;
        Sequence[] codes = null;
        String[] opts = null;
        MultipathCursors mcs = null;
        int segSeq = 0;
        int segCount = 0;
        if (isMultiThread) {
            segCount = Env.getCursorParallelNum();
        }
        if (param != null && param.getType() == ';') {
            IParam segParam;
            int size = param.getSubSize();
            if (size > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            fieldParam = param.getSub(0);
            IParam expParam = param.getSub(1);
            if (expParam != null) {
                if (expParam.isLeaf()) {
                    filter = expParam.getLeafExpression();
                } else {
                    int expCount;
                    ArrayList<Expression> expList = new ArrayList<Expression>();
                    ArrayList<String> fieldList = new ArrayList<String>();
                    ArrayList<Sequence> codeList = new ArrayList<Sequence>();
                    ArrayList<String> optList = new ArrayList<String>();
                    if (expParam.getType() == ':') {
                        CreateCursor._$1(expParam, expList, fieldList, codeList, optList, ctx);
                    } else {
                        int psize = expParam.getSubSize();
                        for (int p = 0; p < psize; ++p) {
                            IParam sub = expParam.getSub(p);
                            CreateCursor._$1(sub, expList, fieldList, codeList, optList, ctx);
                        }
                    }
                    int fieldCount = fieldList.size();
                    if (fieldCount > 0) {
                        fkNames = new String[fieldCount];
                        codes = new Sequence[fieldCount];
                        opts = new String[fieldCount];
                        fieldList.toArray(fkNames);
                        codeList.toArray(codes);
                        optList.toArray(opts);
                    }
                    if ((expCount = expList.size()) == 1) {
                        filter = expList.get(0);
                    } else if (expCount > 1) {
                        Expression exp = expList.get(0);
                        Node home = exp.getHome();
                        for (int i = 1; i < expCount; ++i) {
                            exp = expList.get(i);
                            And and = new And();
                            and.setLeft(home);
                            and.setRight(exp.getHome());
                            home = and;
                        }
                        filter = new Expression(home);
                    }
                }
            }
            if (size > 2 && (segParam = param.getSub(2)) != null) {
                if (segParam.isLeaf()) {
                    Object obj = segParam.getLeafExpression().calculate(ctx);
                    if (obj instanceof MultipathCursors) {
                        mcs = (MultipathCursors)obj;
                    } else if (obj instanceof ICursor) {
                        isMultiThread = false;
                    } else {
                        MessageManager mm;
                        if (!isMultiThread) {
                            mm = EngineMessage.get();
                            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                        }
                        if (!(obj instanceof Number)) {
                            mm = EngineMessage.get();
                            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                        }
                        segCount = ((Number)obj).intValue();
                    }
                } else {
                    if (segParam.getSubSize() != 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    IParam sub0 = segParam.getSub(0);
                    IParam sub1 = segParam.getSub(1);
                    if (sub0 == null || sub1 == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    Object obj = sub0.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    segSeq = ((Number)obj).intValue();
                    obj = sub1.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    segCount = ((Number)obj).intValue();
                    if (segSeq < 1 || segSeq > segCount) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    isMultiThread = false;
                }
            }
        } else {
            fieldParam = param;
        }
        Expression[] exps = null;
        String[] names = null;
        if (fieldParam != null) {
            ParamInfo2 pi = ParamInfo2.parse((IParam)fieldParam, (String)"cursor", (boolean)false, (boolean)false);
            exps = pi.getExpressions1();
            names = pi.getExpressionStrs2();
            int len = exps.length;
            for (int i = 0; i < len; ++i) {
                if (names[i] != null || exps[i] == null) continue;
                names[i] = exps[i].getIdentifierName();
            }
        }
        if (mcs != null) {
            return CreateCursor.cursor(table, exps, names, filter, fkNames, codes, opts, mcs, opt, ctx);
        }
        if (isMultiThread && segCount > 1) {
            return CreateCursor.cursor(table, exps, names, filter, fkNames, codes, opts, segCount, opt, ctx);
        }
        if (segSeq < 1) {
            return CreateCursor.cursor(table, exps, names, filter, fkNames, codes, opts, ctx);
        }
        return CreateCursor.cursor(table, exps, names, filter, fkNames, codes, opts, segSeq, segCount, ctx);
    }

    public boolean isLeftTypeMatch(Object obj) {
        return obj instanceof IPhyTable && this.option != null && this.option.indexOf(118) != -1;
    }

    public static ICursor cursor(ColPhyTable table) {
        IPureCursor cs = CreateCursor._$1(table, null, null, null, null, null) ? new PureCursor2(table) : new PureCursor(table);
        PhyTable tmd = CreateCursor._$1(table, false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = CreateCursor.cursor((ColPhyTable)tmd);
        return CreateCursor._$1((ICursor)cs, cs2);
    }

    public static ICursor cursor(ColPhyTable table, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, Context ctx) {
        IPureCursor cs = CreateCursor._$1(table, exps, fields, filter, fkNames, ctx) ? new PureCursor2(table, exps, fields, filter, fkNames, codes, opts, ctx) : new PureCursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
        PhyTable tmd = CreateCursor._$1(table, false);
        if (tmd == null) {
            return cs;
        }
        ICursor cs2 = CreateCursor.cursor((ColPhyTable)tmd, exps, fields, filter, fkNames, codes, opts, ctx);
        return CreateCursor._$1((ICursor)cs, cs2);
    }

    public static ICursor cursor(ColPhyTable table, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathCount, String opt, Context ctx) {
        ICursor[] cursors;
        if (pathCount < 2) {
            return CreateCursor.cursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
        }
        PhyTable tmd = CreateCursor._$1(table, false);
        int blockCount = table.getDataBlockCount();
        if (blockCount == 0) {
            if (tmd == null) {
                return new MemoryCursor(null);
            }
            return CreateCursor.cursor((ColPhyTable)tmd, exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        }
        IFilter[] filters = null;
        if (filter != null && table.getParent() == null && (opt == null || opt.indexOf(119) == -1)) {
            filters = table.getSortedFieldFilters(filter, ctx);
        }
        blockCount = table.getDataBlockCount();
        if (filters == null) {
            int avg = blockCount / pathCount;
            if (avg < 1) {
                avg = 1;
                pathCount = blockCount;
            }
            int mod = blockCount % pathCount;
            cursors = new ICursor[pathCount];
            int start = 0;
            for (int i = 0; i < pathCount; ++i) {
                int end = start + avg;
                if (i < mod) {
                    ++end;
                }
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                IPureCursor cursor = CreateCursor._$1(table, exps, fields, filter, fkNames, ctx) ? new PureCursor2(table, exps, fields, filter, fkNames, codes, opts, ctx) : new PureCursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                cursor.setSegment(start, end);
                cursors[i] = cursor;
                start = end;
            }
        } else {
            IntArrayList list = new IntArrayList();
            int filterCount = filters.length;
            ObjectReader[] readers = new ObjectReader[filterCount];
            for (int f = 0; f < filterCount; ++f) {
                ColumnMetaData column = filters[f].getColumn();
                readers[f] = column.getSegmentReader();
            }
            try {
                for (int i = 0; i < blockCount; ++i) {
                    boolean match = true;
                    for (int f = 0; f < filterCount; ++f) {
                        readers[f].readLong40();
                        Object minValue = readers[f].readObject();
                        Object maxValue = readers[f].readObject();
                        readers[f].skipObject();
                        if (!match || filters[f].match(minValue, maxValue)) continue;
                        match = false;
                    }
                    if (!match) continue;
                    list.addInt(i);
                }
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), (Throwable)e);
            }
            blockCount = list.size();
            if (blockCount == 0) {
                return new MemoryCursor(null);
            }
            int avg = blockCount / pathCount;
            if (avg < 1) {
                cursors = new ICursor[blockCount];
                for (int i = 0; i < blockCount; ++i) {
                    IPureCursor cursor = CreateCursor._$1(table, exps, fields, filter = filter.newExpression(ctx), fkNames, ctx) ? new PureCursor2(table, exps, fields, filter, fkNames, codes, opts, ctx) : new PureCursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                    int b = list.getInt(i);
                    cursor.setSegment(b, b + 1);
                    cursors[i] = cursor;
                }
            } else {
                int mod = blockCount % pathCount;
                cursors = new ICursor[pathCount];
                int start = 0;
                for (int i = 0; i < pathCount; ++i) {
                    int end = start + avg;
                    if (i < mod) {
                        ++end;
                    }
                    IPureCursor cursor = CreateCursor._$1(table, exps, fields, filter = filter.newExpression(ctx), fkNames, ctx) ? new PureCursor2(table, exps, fields, filter, fkNames, codes, opts, ctx) : new PureCursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                    cursor.setSegment(list.getInt(start), list.getInt(end - 1) + 1);
                    cursors[i] = cursor;
                    start = end;
                }
            }
        }
        MultipathCursors mcs = new MultipathCursors(cursors, ctx);
        if (tmd == null) {
            return mcs;
        }
        String[] sortFields = ((IDWCursor)cursors[0]).getSortFields();
        if (sortFields != null) {
            ICursor cs2 = CreateCursor.cursor((ColPhyTable)tmd, exps, fields, filter, fkNames, codes, opts, mcs, null, ctx);
            return CreateCursor._$1(mcs, (MultipathCursors)cs2, sortFields);
        }
        ICursor cs2 = CreateCursor.cursor((ColPhyTable)tmd, exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
        return CreateCursor._$1(mcs, cs2);
    }

    public static ICursor cursor(ColPhyTable table, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int segSeq, int segCount, Context ctx) {
        if (filter != null) {
            filter = filter.newExpression(ctx);
        }
        IPureCursor cursor = CreateCursor._$1(table, exps, fields, filter, fkNames, ctx) ? new PureCursor2(table, exps, fields, filter, fkNames, codes, opts, ctx) : new PureCursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
        if (segCount < 2) {
            return cursor;
        }
        int dataBlockCount = table.getDataBlockCount();
        int startBlock = 0;
        int endBlock = -1;
        int avg = dataBlockCount / segCount;
        if (avg < 1) {
            if (segSeq <= dataBlockCount) {
                startBlock = segSeq - 1;
                endBlock = segSeq;
            }
        } else if (segSeq > 1) {
            endBlock = segSeq * avg;
            startBlock = endBlock - avg;
            int mod = dataBlockCount % segCount;
            int n = mod - (segCount - segSeq);
            if (n > 0) {
                endBlock += n;
                startBlock += n - 1;
            }
        } else {
            endBlock = avg;
        }
        cursor.setSegment(startBlock, endBlock);
        return cursor;
    }

    public static ICursor cursor(ColPhyTable table, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, MultipathCursors mcs, String opt, Context ctx) {
        ICursor cs2;
        ColumnMetaData[] sortedCols;
        String[] dimFields;
        table.getGroupTable().checkReadable();
        ICursor[] srcCursors = mcs.getParallelCursors();
        int segCount = srcCursors.length;
        if (segCount == 1) {
            ICursor cursor = CreateCursor.cursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
            MultipathCursors result = new MultipathCursors(new ICursor[]{cursor}, ctx);
            ColPhyTable tmd = (ColPhyTable)CreateCursor._$1(table, false);
            if (tmd == null) {
                return result;
            }
            String[] sortFields = ((IDWCursor)cursor).getSortFields();
            if (sortFields != null) {
                ICursor cs22 = CreateCursor.cursor(tmd, exps, fields, filter, fkNames, codes, opts, result, opt, ctx);
                return CreateCursor._$1(result, (MultipathCursors)cs22, sortFields);
            }
            ICursor cs23 = CreateCursor.cursor(tmd, exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
            return CreateCursor._$1(result, cs23);
        }
        Object[][] minValues = new Object[segCount][];
        int fcount = -1;
        for (int i = 1; i < segCount; ++i) {
            minValues[i] = srcCursors[i].getSegmentStartValues(opt);
            if (minValues[i] == null) continue;
            if (fcount == -1) {
                fcount = minValues[i].length;
                continue;
            }
            if (fcount == minValues[i].length) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        if (fcount == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        if (opt != null && opt.indexOf(107) != -1) {
            String[] keys = table.getAllKeyColNames();
            if (keys == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
            }
            fcount = 1;
            dimFields = new String[]{keys[0]};
            sortedCols = new ColumnMetaData[]{table.getColumn(keys[0])};
        } else {
            sortedCols = table.getAllSortedColumns();
            if (sortedCols.length < fcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
            }
            dimFields = new String[fcount];
            for (int f = 0; f < fcount; ++f) {
                dimFields[f] = sortedCols[f].getColName();
            }
        }
        int blockCount = table.getDataBlockCount();
        ICursor[] cursors = new ICursor[segCount];
        int startBlock = 0;
        int currentBlock = 0;
        int[] appendSegs = new int[segCount];
        for (int s = 0; s < segCount; ++s) {
            appendSegs[s] = -1;
        }
        try {
            ObjectReader[] readers = new ObjectReader[fcount];
            Object[] blockMinVals = new Object[fcount];
            Object[] blockMaxVals = new Object[fcount];
            Object[] prevMaxVals = new Object[fcount];
            for (int f = 0; f < fcount; ++f) {
                readers[f] = sortedCols[f].getSegmentReader();
                readers[f].readLong40();
                readers[f].skipObject();
                blockMaxVals[f] = readers[f].readObject();
                blockMinVals[f] = readers[f].readObject();
            }
            block6: for (int s = 0; s < segCount; ++s) {
                if (filter != null) {
                    filter = filter.newExpression(ctx);
                }
                Object[] nextMinValue = null;
                for (int nextSeg = s + 1; nextSeg < segCount && (nextMinValue = minValues[nextSeg]) == null; ++nextSeg) {
                }
                if (nextMinValue == null) {
                    cursors[s] = CreateCursor.cursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                    ((IDWCursor)cursors[s]).setSegment(startBlock, blockCount);
                    startBlock = blockCount;
                    continue;
                }
                while (currentBlock < blockCount) {
                    int cmp = Variant.compareArrays((Object[])blockMinVals, (Object[])nextMinValue);
                    if (cmp > 0) {
                        cursors[s] = CreateCursor.cursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                        if (currentBlock > 0) {
                            ((IDWCursor)cursors[s]).setSegment(startBlock, currentBlock - 1);
                            startBlock = currentBlock - 1;
                            appendSegs[nextSeg] = s;
                            continue block6;
                        }
                        ((IDWCursor)cursors[s]).setSegment(0, 0);
                        continue block6;
                    }
                    if (cmp == 0) {
                        cursors[s] = CreateCursor.cursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                        if (currentBlock > 0 && Variant.compareArrays((Object[])prevMaxVals, (Object[])nextMinValue) >= 0) {
                            ((IDWCursor)cursors[s]).setSegment(startBlock, currentBlock - 1);
                            startBlock = currentBlock - 1;
                            appendSegs[nextSeg] = s;
                            continue block6;
                        }
                        ((IDWCursor)cursors[s]).setSegment(startBlock, currentBlock);
                        startBlock = currentBlock;
                        continue block6;
                    }
                    if (++currentBlock >= blockCount) continue;
                    Object[] tmp = prevMaxVals;
                    prevMaxVals = blockMaxVals;
                    blockMaxVals = tmp;
                    for (int f = 0; f < fcount; ++f) {
                        readers[f].readLong40();
                        readers[f].skipObject();
                        blockMaxVals[f] = readers[f].readObject();
                        blockMinVals[f] = readers[f].readObject();
                    }
                }
                cursors[s] = CreateCursor.cursor(table, exps, fields, filter, fkNames, codes, opts, ctx);
                if (s + 1 == segCount) {
                    ((IDWCursor)cursors[s]).setSegment(startBlock, blockCount);
                    startBlock = blockCount;
                    continue;
                }
                ((IDWCursor)cursors[s]).setSegment(startBlock, blockCount - 1);
                startBlock = blockCount - 1;
                appendSegs[nextSeg] = s;
            }
            for (int i = segCount - 1; i > 0; --i) {
                if (appendSegs[i] == -1) continue;
                Sequence seq = ColPhyTable.fetchToValue((IDWCursor)((IDWCursor)cursors[i]), (String[])dimFields, (Object[])minValues[i]);
                ((IDWCursor)cursors[appendSegs[i]]).setAppendData(seq);
            }
        }
        catch (IOException e) {
            throw new RQException((Throwable)e);
        }
        MultipathCursors result = new MultipathCursors(cursors, ctx);
        ColPhyTable tmd = (ColPhyTable)CreateCursor._$1(table, false);
        if (tmd == null) {
            return result;
        }
        String[] sortFields = ((IDWCursor)cursors[0]).getSortFields();
        if (sortFields != null) {
            cs2 = CreateCursor.cursor(tmd, exps, fields, filter, fkNames, codes, opts, result, opt, ctx);
            return CreateCursor._$1(result, (MultipathCursors)cs2, sortFields);
        }
        cs2 = CreateCursor.cursor(tmd, exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
        return CreateCursor._$1(result, cs2);
    }

    private static boolean _$2(ColPhyTable table, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Context ctx) {
        int i$;
        int len$;
        if (exps == null && fields == null) {
            return true;
        }
        ArrayList expsList = null;
        if (exps != null) {
            Expression[] expressionArray = exps;
            len$ = expressionArray.length;
            for (i$ = 0; i$ < len$; ++i$) {
                Expression expression = expressionArray[i$];
                if (expression == null || !(expression.getHome() instanceof UnknownSymbol) || table.getColumn(expression.getIdentifierName()) == null) continue;
                return true;
            }
            expsList = table.getExpFields(exps);
            if (expsList != null) {
                return true;
            }
        } else {
            String[] stringArray = fields;
            len$ = stringArray.length;
            for (i$ = 0; i$ < len$; ++i$) {
                String string = stringArray[i$];
                if (table.getColumn(string) == null) continue;
                return true;
            }
        }
        if (filter != null) {
            ArrayList arrayList = new ArrayList();
            filter.getUsedFields(ctx, arrayList);
            for (String name : arrayList) {
                if (table.getColumn(name) == null) continue;
                return true;
            }
        }
        if (fkNames != null) {
            for (String string : fkNames) {
                if (table.getColumn(string) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean _$1(ColPhyTable table, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Context ctx) {
        ColPhyTable ptable = (ColPhyTable)table.getParent();
        if (ptable == null) {
            return false;
        }
        return CreateCursor._$2(ptable, exps, fields, filter, fkNames, ctx);
    }

    private static PhyTable _$1(ColPhyTable table, boolean isCreate) {
        ComTable sgt = table.getGroupTable().getSupplement(isCreate);
        if (sgt == null) {
            return null;
        }
        PhyTable tmd = sgt.getBaseTable();
        if (table.getParent() == null) {
            return tmd;
        }
        return tmd.getAnnexTable(table.getTableName());
    }

    private static ICursor _$1(ICursor cs, ICursor cs2) {
        String[] sortFields = ((IDWCursor)cs).getSortFields();
        if (sortFields != null) {
            int len = sortFields.length;
            int[] dims = new int[len];
            DataStruct ds = cs.getDataStruct();
            for (int i = 0; i < len; ++i) {
                dims[i] = ds.getFieldIndex(sortFields[i]);
            }
            return new MergeCursor2(cs, cs2, dims, null, new Context());
        }
        return new ConjxCursor(new ICursor[]{cs, cs2});
    }

    private static MultipathCursors _$1(MultipathCursors cs1, MultipathCursors cs2, String[] sortFields) {
        ICursor[] cursors1 = cs1.getCursors();
        ICursor[] cursors2 = cs2.getCursors();
        int count = cursors1.length;
        ICursor[] result = new ICursor[count];
        int len = sortFields.length;
        int[] dims = new int[len];
        DataStruct ds = cursors1[0].getDataStruct();
        for (int i = 0; i < len; ++i) {
            dims[i] = ds.getFieldIndex(sortFields[i]);
        }
        Context ctx = new Context();
        for (int i = 0; i < count; ++i) {
            result[i] = new MergeCursor2(cursors1[i], cursors2[i], dims, null, ctx);
        }
        return new MultipathCursors(result, ctx);
    }

    private static MultipathCursors _$1(MultipathCursors cs1, ICursor cs2) {
        ICursor[] cursors1 = cs1.getCursors();
        int count = cursors1.length;
        ICursor[] result = new ICursor[count];
        Context ctx = new Context();
        if (cs2 instanceof MultipathCursors) {
            MultipathCursors mcs2 = (MultipathCursors)cs2;
            ICursor[] cursors2 = mcs2.getCursors();
            int count2 = cursors2.length;
            for (int i = 0; i < count; ++i) {
                result[i] = i < count2 ? new ConjxCursor(new ICursor[]{cursors1[i], cursors2[i]}) : cursors1[i];
            }
        } else {
            result[0] = new ConjxCursor(new ICursor[]{cursors1[0], cs2});
            System.arraycopy(cursors1, 1, result, 1, count);
        }
        return new MultipathCursors(result, ctx);
    }

    public static ICursor createCursor(PhyTableGroup tableGroup, IParam param, String opt, Context ctx) {
        boolean isMultiThread;
        boolean bl = isMultiThread = opt.indexOf(109) != -1;
        if (param == null && !isMultiThread) {
            return CreateCursor.cursor(tableGroup, opt, ctx);
        }
        IParam fieldParam = null;
        Expression filter = null;
        String[] fkNames = null;
        Sequence[] codes = null;
        String[] opts = null;
        MultipathCursors mcs = null;
        int segSeq = 0;
        int segCount = 0;
        if (isMultiThread) {
            segCount = Env.getCursorParallelNum();
        }
        if (param != null && param.getType() == ';') {
            IParam segParam;
            int size = param.getSubSize();
            if (size > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            fieldParam = param.getSub(0);
            IParam expParam = param.getSub(1);
            if (expParam != null) {
                if (expParam.isLeaf()) {
                    filter = expParam.getLeafExpression();
                } else {
                    int expCount;
                    ArrayList<Expression> expList = new ArrayList<Expression>();
                    ArrayList<String> fieldList = new ArrayList<String>();
                    ArrayList<Sequence> codeList = new ArrayList<Sequence>();
                    ArrayList<String> optList = new ArrayList<String>();
                    if (expParam.getType() == ':') {
                        CreateCursor._$1(expParam, expList, fieldList, codeList, optList, ctx);
                    } else {
                        int psize = expParam.getSubSize();
                        for (int p = 0; p < psize; ++p) {
                            IParam sub = expParam.getSub(p);
                            CreateCursor._$1(sub, expList, fieldList, codeList, optList, ctx);
                        }
                    }
                    int fieldCount = fieldList.size();
                    if (fieldCount > 0) {
                        fkNames = new String[fieldCount];
                        codes = new Sequence[fieldCount];
                        opts = new String[fieldCount];
                        fieldList.toArray(fkNames);
                        codeList.toArray(codes);
                        optList.toArray(opts);
                    }
                    if ((expCount = expList.size()) == 1) {
                        filter = expList.get(0);
                    } else if (expCount > 1) {
                        Expression exp = expList.get(0);
                        Node home = exp.getHome();
                        for (int i = 1; i < expCount; ++i) {
                            exp = expList.get(i);
                            And and = new And();
                            and.setLeft(home);
                            and.setRight(exp.getHome());
                            home = and;
                        }
                        filter = new Expression(home);
                    }
                }
            }
            if (size > 2 && (segParam = param.getSub(2)) != null) {
                if (segParam.isLeaf()) {
                    Object obj = segParam.getLeafExpression().calculate(ctx);
                    if (obj instanceof MultipathCursors) {
                        mcs = (MultipathCursors)obj;
                    } else if (obj instanceof ICursor) {
                        isMultiThread = false;
                    } else {
                        MessageManager mm;
                        if (!isMultiThread) {
                            mm = EngineMessage.get();
                            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                        }
                        if (!(obj instanceof Number)) {
                            mm = EngineMessage.get();
                            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                        }
                        segCount = ((Number)obj).intValue();
                    }
                } else {
                    if (segParam.getSubSize() != 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    IParam sub0 = segParam.getSub(0);
                    IParam sub1 = segParam.getSub(1);
                    if (sub0 == null || sub1 == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    Object obj = sub0.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    segSeq = ((Number)obj).intValue();
                    obj = sub1.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    segCount = ((Number)obj).intValue();
                    if (segSeq < 1 || segSeq > segCount) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    isMultiThread = false;
                }
            }
        } else {
            fieldParam = param;
        }
        Expression[] exps = null;
        String[] names = null;
        if (fieldParam != null) {
            ParamInfo2 pi = ParamInfo2.parse((IParam)fieldParam, (String)"cursor", (boolean)false, (boolean)false);
            exps = pi.getExpressions1();
            names = pi.getExpressionStrs2();
        }
        if (mcs != null) {
            return CreateCursor.cursor(tableGroup, exps, names, filter, fkNames, codes, opts, mcs, opt, ctx);
        }
        if (isMultiThread && segCount > 1) {
            return CreateCursor.cursor(tableGroup, exps, names, filter, fkNames, codes, opts, segCount, opt, ctx);
        }
        if (segSeq < 1) {
            return CreateCursor.cursor(tableGroup, exps, names, filter, fkNames, codes, opts, opt, ctx);
        }
        return CreateCursor.cursor(tableGroup, exps, names, filter, fkNames, codes, opts, segSeq, segCount, opt, ctx);
    }

    public static ICursor cursor(PhyTableGroup tableGroup, String opt, Context ctx) {
        ICursor[] cursors;
        IPhyTable[] tables = tableGroup.getTables();
        int count = tables.length;
        Sequence memoryTable = tableGroup.getMemoryTable();
        if (memoryTable == null) {
            cursors = new ICursor[count];
        } else {
            cursors = new ICursor[count + 1];
            cursors[count] = memoryTable.cursor(null, null, null, null, null, null, ctx);
        }
        for (int i = 0; i < count; ++i) {
            cursors[i] = CreateCursor.cursor((ColPhyTable)tables[i]);
        }
        if (opt == null || opt.indexOf(111) == -1) {
            String[] sortFields = tables[0].getAllSortedColNames();
            if (sortFields == null || sortFields.length == 0) {
                return new ConjxCursor(cursors);
            }
            int fcount = sortFields.length;
            int[] fields = new int[fcount];
            for (int i = 0; i < fcount; ++i) {
                fields[i] = i;
            }
            DataStruct ds = cursors[0].getDataStruct();
            return CreateCursor._$1(cursors, fields, ds, opt);
        }
        return new ConjxCursor(cursors);
    }

    private static ICursor _$1(ICursor[] cursors, String opt) {
        String[] sortFields = cursors[0].getSortFields();
        if (sortFields == null || sortFields.length == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("grouptable.dataNeedSorted"));
        }
        DataStruct ds = cursors[0].getDataStruct();
        int fcount = sortFields.length;
        int[] mergeFields = new int[fcount];
        for (int i = 0; i < fcount; ++i) {
            mergeFields[i] = ds.getFieldIndex(sortFields[i]);
        }
        return CreateCursor._$1(cursors, mergeFields, ds, opt);
    }

    private static ICursor _$1(ICursor[] cursors, int[] mergeFields, DataStruct ds, String opt) {
        if (opt != null && opt.indexOf(112) != -1) {
            int field = mergeFields[0];
            if (cursors.length == 2) {
                return new MergeConjCursor2(cursors[0], cursors[1], field, ds, opt);
            }
            if (cursors.length == 3) {
                return new MergeConjCursor3(cursors[0], cursors[1], cursors[2], field, ds, opt);
            }
            if (mergeFields.length != 1) {
                mergeFields = new int[]{field};
            }
        }
        return new MergeConjCursor(cursors, mergeFields, ds, opt);
    }

    public static ICursor cursor(PhyTableGroup tableGroup, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, String opt, Context ctx) {
        ICursor[] cursors;
        IPhyTable[] tables = tableGroup.getTables();
        int count = tables.length;
        Sequence memoryTable = tableGroup.getMemoryTable();
        if (memoryTable == null) {
            cursors = new ICursor[count];
        } else {
            cursors = new ICursor[count + 1];
            exps = Operation.dupExpressions((Expression[])exps, (Context)ctx);
            filter = Operation.dupExpression((Expression)filter, (Context)ctx);
            cursors[count] = memoryTable.cursor(exps, fields, filter, fkNames, codes, opts, ctx);
        }
        for (int i = 0; i < count; ++i) {
            cursors[i] = CreateCursor.cursor((ColPhyTable)tables[i], exps, fields, filter, fkNames, codes, opts, ctx);
        }
        if (opt == null || opt.indexOf(111) == -1) {
            return CreateCursor._$1(cursors, opt);
        }
        return new ConjxCursor(cursors);
    }

    public static ICursor cursor(PhyTableGroup tableGroup, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int segSeq, int segCount, String opt, Context ctx) {
        IPhyTable[] tables = tableGroup.getTables();
        int count = tables.length;
        ICursor[] cursors = new ICursor[count];
        Sequence memoryTable = tableGroup.getMemoryTable();
        if (memoryTable == null) {
            cursors = new ICursor[count];
        } else {
            int end;
            int start;
            cursors = new ICursor[count + 1];
            int len = memoryTable.length();
            int blockSize = len / segCount;
            if (segSeq == segCount) {
                start = blockSize * (segSeq - 1) + 1;
                end = len + 1;
            } else {
                start = blockSize * (segSeq - 1) + 1;
                end = blockSize * segSeq + 1;
            }
            exps = Operation.dupExpressions((Expression[])exps, (Context)ctx);
            filter = Operation.dupExpression((Expression)filter, (Context)ctx);
            cursors[count] = memoryTable.cursor(start, end, exps, fields, filter, fkNames, codes, opts, ctx);
        }
        for (int i = 0; i < count; ++i) {
            cursors[i] = CreateCursor.cursor((ColPhyTable)tables[i], exps, fields, filter, fkNames, codes, opts, segSeq, segCount, ctx);
        }
        if (opt == null || opt.indexOf(111) == -1) {
            return CreateCursor._$1(cursors, opt);
        }
        return new ConjxCursor(cursors);
    }

    public static ICursor cursor(PhyTableGroup tableGroup, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, int pathCount, String opt, Context ctx) {
        int i;
        IPhyTable[] tables = tableGroup.getTables();
        int tableCount = tables.length;
        if (opt == null || opt.indexOf(111) == -1) {
            ICursor cs = CreateCursor.cursor((ColPhyTable)tables[0], exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
            MultipathCursors mcs = (MultipathCursors)cs;
            ICursor[] cursors = mcs.getCursors();
            pathCount = cursors.length;
            ArrayList[] lists = new ArrayList[pathCount];
            for (int p = 0; p < pathCount; ++p) {
                lists[p] = new ArrayList(tableCount);
                lists[p].add(cursors[p]);
            }
            for (int i2 = 1; i2 < tableCount; ++i2) {
                MultipathCursors mcs2 = (MultipathCursors)CreateCursor.cursor((ColPhyTable)tables[i2], exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
                cursors = mcs2.getCursors();
                for (int p = 0; p < pathCount; ++p) {
                    lists[p].add(cursors[p]);
                }
            }
            Sequence memoryTable = tableGroup.getMemoryTable();
            if (memoryTable != null) {
                String[] sortedFields = tableGroup.getAllSortedColNames();
                MultipathCursors mcs2 = memoryTable.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
                cursors = mcs2.getCursors();
                for (int p = 0; p < cursors.length; ++p) {
                    lists[p].add(cursors[p]);
                }
            }
            ICursor[] resultCursors = new ICursor[pathCount];
            for (int i3 = 0; i3 < pathCount; ++i3) {
                int size = lists[i3].size();
                if (size > 1) {
                    cursors = new ICursor[size];
                    lists[i3].toArray(cursors);
                    resultCursors[i3] = CreateCursor._$1(cursors, opt);
                    continue;
                }
                if (size != 1) continue;
                resultCursors[i3] = (ICursor)lists[i3].get(0);
            }
            return new MultipathCursors(resultCursors, ctx);
        }
        ArrayList[] lists = new ArrayList[pathCount];
        for (i = 0; i < pathCount; ++i) {
            lists[i] = new ArrayList(tableCount);
        }
        for (i = 0; i < tableCount; ++i) {
            ICursor cs = CreateCursor.cursor((ColPhyTable)tables[0], exps, fields, filter, fkNames, codes, opts, pathCount, opt, ctx);
            if (cs instanceof MultipathCursors) {
                MultipathCursors mcs = (MultipathCursors)cs;
                ICursor[] cursors = mcs.getCursors();
                for (int c = 0; c < cursors.length; ++c) {
                    lists[c].add(cursors[c]);
                }
                continue;
            }
            lists[0].add(cs);
        }
        Sequence memoryTable = tableGroup.getMemoryTable();
        if (memoryTable != null) {
            int len = memoryTable.length();
            int blockSize = len / pathCount;
            int start = 1;
            for (int i4 = 1; i4 <= pathCount; ++i4) {
                int end = i4 == pathCount ? len + 1 : blockSize * i4 + 1;
                exps = Operation.dupExpressions((Expression[])exps, (Context)ctx);
                filter = Operation.dupExpression((Expression)filter, (Context)ctx);
                ICursor cursor = memoryTable.cursor(start, end, exps, fields, filter, fkNames, codes, opts, ctx);
                lists[i4].add(cursor);
                start = end;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(pathCount);
        for (int i5 = 0; i5 < pathCount; ++i5) {
            int size = lists[i5].size();
            if (size > 1) {
                ICursor[] cursors = new ICursor[size];
                lists[i5].toArray(cursors);
                list.add(new ConjxCursor(cursors));
                continue;
            }
            if (size != 1) continue;
            list.add(lists[i5].get(0));
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (ICursor)list.get(0);
        }
        ICursor[] cursors = new ICursor[size];
        list.toArray(cursors);
        return new MultipathCursors(cursors, ctx);
    }

    public static ICursor cursor(PhyTableGroup tableGroup, Expression[] exps, String[] fields, Expression filter, String[] fkNames, Sequence[] codes, String[] opts, MultipathCursors mcs, String opt, Context ctx) {
        int i;
        IPhyTable[] tables = tableGroup.getTables();
        int tableCount = tables.length;
        int pathCount = mcs.getPathCount();
        if (opt == null || opt.indexOf(111) == -1) {
            ArrayList[] lists = new ArrayList[pathCount];
            for (int p = 0; p < pathCount; ++p) {
                lists[p] = new ArrayList(tableCount);
            }
            for (int i2 = 0; i2 < tableCount; ++i2) {
                ICursor cs = CreateCursor.cursor((ColPhyTable)tables[i2], exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
                ICursor[] cursors = ((MultipathCursors)cs).getCursors();
                for (int p = 0; p < pathCount; ++p) {
                    lists[p].add(cursors[p]);
                }
            }
            Sequence memoryTable = tableGroup.getMemoryTable();
            if (memoryTable != null) {
                String[] sortedFields = tableGroup.getAllSortedColNames();
                MultipathCursors mcs2 = memoryTable.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
                ICursor[] cursors = mcs2.getCursors();
                for (int c = 0; c < cursors.length; ++c) {
                    lists[c].add(cursors[c]);
                }
            }
            ICursor[] resultCursors = new ICursor[pathCount];
            for (int i3 = 0; i3 < pathCount; ++i3) {
                int size = lists[i3].size();
                if (size > 1) {
                    ICursor[] cursors = new ICursor[size];
                    lists[i3].toArray(cursors);
                    resultCursors[i3] = CreateCursor._$1(cursors, opt);
                    continue;
                }
                if (size != 1) continue;
                resultCursors[i3] = (ICursor)lists[i3].get(0);
            }
            return new MultipathCursors(resultCursors, ctx);
        }
        ArrayList[] lists = new ArrayList[pathCount];
        for (i = 0; i < pathCount; ++i) {
            lists[i] = new ArrayList(tableCount);
        }
        for (i = 0; i < tableCount; ++i) {
            ICursor cs = CreateCursor.cursor((ColPhyTable)tables[0], exps, fields, filter, fkNames, codes, opts, mcs, opt, ctx);
            if (cs instanceof MultipathCursors) {
                ICursor[] cursors = ((MultipathCursors)cs).getCursors();
                for (int c = 0; c < cursors.length; ++c) {
                    lists[c].add(cursors[c]);
                }
                continue;
            }
            lists[0].add(cs);
        }
        Sequence memoryTable = tableGroup.getMemoryTable();
        if (memoryTable != null) {
            String[] sortedFields = tableGroup.getAllSortedColNames();
            MultipathCursors mcs2 = memoryTable.cursor(mcs, sortedFields, exps, fields, filter, fkNames, codes, opts, opt, ctx);
            ICursor[] cursors = mcs2.getCursors();
            for (int c = 0; c < cursors.length; ++c) {
                lists[c].add(cursors[c]);
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(pathCount);
        for (int i4 = 0; i4 < pathCount; ++i4) {
            int size = lists[i4].size();
            if (size > 1) {
                ICursor[] cursors = new ICursor[size];
                lists[i4].toArray(cursors);
                list.add(new ConjxCursor(cursors));
                continue;
            }
            if (size != 1) continue;
            list.add(lists[i4].get(0));
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (ICursor)list.get(0);
        }
        ICursor[] cursors = new ICursor[size];
        list.toArray(cursors);
        return new MultipathCursors(cursors, ctx);
    }

    public static void setOptionX(ICursor cs, String opt) {
        block5: {
            ICursor[] cursors;
            block9: {
                ICursor[] cursors2;
                block8: {
                    block7: {
                        ICursor[] cursors3;
                        block6: {
                            ICursor[] cursors4;
                            block4: {
                                if (!(cs instanceof IDWCursor)) break block4;
                                ((IDWCursor)cs).setOption(opt);
                                break block5;
                            }
                            if (!(cs instanceof MultipathCursors)) break block6;
                            MultipathCursors mcs = (MultipathCursors)cs;
                            for (ICursor cursor : cursors4 = mcs.getCursors()) {
                                CreateCursor.setOptionX(cursor, opt);
                            }
                            break block5;
                        }
                        if (!(cs instanceof MergeCursor)) break block7;
                        MergeCursor mcs = (MergeCursor)cs;
                        for (ICursor cursor : cursors3 = mcs.getCursors()) {
                            CreateCursor.setOptionX(cursor, opt);
                        }
                        break block5;
                    }
                    if (!(cs instanceof MergeCursor2)) break block8;
                    MergeCursor2 mcs = (MergeCursor2)cs;
                    CreateCursor.setOptionX(mcs.getCursor1(), opt);
                    CreateCursor.setOptionX(mcs.getCursor2(), opt);
                    break block5;
                }
                if (!(cs instanceof ConjxCursor)) break block9;
                ConjxCursor mcs = (ConjxCursor)cs;
                for (ICursor cursor : cursors2 = mcs.getCursors()) {
                    CreateCursor.setOptionX(cursor, opt);
                }
                break block5;
            }
            if (!(cs instanceof MergeConjCursor)) break block5;
            MergeConjCursor mcs = (MergeConjCursor)cs;
            for (ICursor cursor : cursors = mcs.getCursors()) {
                CreateCursor.setOptionX(cursor, opt);
            }
        }
    }
}

