/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.jdbc;

import com.esproc.dql.jdbc.DQLConnection;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Escape;
import com.scudata.common.IOUtils;
import com.scudata.common.StringUtils;
import com.scudata.dm.LocalFile;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Visibility;
import com.scudata.dm.query.utils.IOUtil;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.resources.IdeSplSEMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLDriver
implements Driver,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long START_TIME;
    public static long overTime;
    private static final String _$13 = "user";
    private static final String _$12 = "password";
    private static final String _$11 = "querymode";
    private static final String _$10 = "debugmode";
    private static final String _$9 = "config";
    private static final String _$8 = "glmd";
    private static final String _$7 = "gdct";
    private static final String _$6 = "gvsb";
    public static final String KEY_HOME = "home";
    private static final String _$5 = "sql";
    private final String _$4 = "jdbc:esproc:dql://[host]:[port],[host]:[port],.../[serviceName]?querymode=[dql|sql]&[&user={userName}]&[password={password}]";
    private final String _$3 = "jdbc:esproc:dql://";
    private List<String> _$2 = null;
    public static RaqsoftConfig raqsoftConfig;
    private static final String _$1 = "raqsoftConfig.xml";
    protected String currentConfig = null;

    public DQLDriver() {
        JDBCUtil.log((String)"DQLDriver-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties urlParams;
        JDBCUtil.log((String)"DQLDriver-2");
        if (!this.acceptsURL(url)) {
            return null;
        }
        Vector<Object> vals = this._$1(url, info);
        List hostList = null;
        List portList = null;
        String serviceName = null;
        boolean isRemote = false;
        if (vals != null) {
            hostList = (List)vals.get(0);
            portList = (List)vals.get(1);
            serviceName = (String)vals.get(2);
            isRemote = (Boolean)vals.get(3);
            urlParams = (Properties)vals.get(4);
        } else {
            urlParams = new Properties();
        }
        String user = null;
        String password = null;
        String queryMode = null;
        user = urlParams.getProperty(_$13);
        password = urlParams.getProperty(_$12);
        queryMode = urlParams.getProperty(_$11);
        String sDebugMode = urlParams.getProperty(_$10);
        if (!StringUtils.isValidString((Object)queryMode)) {
            queryMode = urlParams.getProperty(_$11);
        }
        if (!StringUtils.isValidString((Object)sDebugMode)) {
            sDebugMode = urlParams.getProperty(_$10);
        }
        boolean isDqlMode = true;
        if (_$5.equalsIgnoreCase(queryMode)) {
            isDqlMode = false;
        }
        if (StringUtils.isValidString((Object)sDebugMode)) {
            try {
                boolean isDebugMode;
                JDBCUtil.isDebugMode = isDebugMode = Boolean.parseBoolean(sDebugMode);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            String lmdFile;
            String[] hosts = null;
            int[] posts = null;
            LogicMetaData lmd = null;
            if (isRemote) {
                int i;
                hosts = new String[hostList.size()];
                posts = new int[portList.size()];
                for (i = 0; i < hostList.size(); ++i) {
                    hosts[i] = (String)hostList.get(i);
                }
                for (i = 0; i < portList.size(); ++i) {
                    posts[i] = (Integer)portList.get(i);
                }
                return new DQLConnection(this, hosts, posts, serviceName, user, password, isDqlMode, url);
            }
            String sconfig = urlParams.getProperty(_$9);
            String homeKey = urlParams.getProperty(KEY_HOME);
            String home = null;
            if (StringUtils.isValidString((Object)homeKey)) {
                home = System.getProperty(homeKey);
            }
            if (!StringUtils.isValidString(home)) {
                home = null;
            }
            this.loadConfig(home, sconfig);
            if (raqsoftConfig != null) {
                String serialNo = raqsoftConfig.getEsprocSerialNo();
                try {
                    SplEditorSE.setSerialNo((int[])new int[]{7, 6}, (String)serialNo);
                }
                catch (Exception e) {
                    throw new SQLException(IdeSplSEMessage.get().getMessage("sn.novalidsn"));
                }
                if (SplEditorSE.isFree()) {
                    throw new SQLException(IdeSplSEMessage.get().getMessage("sn.novalidsn"));
                }
                if (!SplEditorSE.isTrial()) {
                    overTime = -1L;
                }
            }
            if (!StringUtils.isValidString((Object)(lmdFile = urlParams.getProperty(_$8)))) {
                throw new Exception(JDBCMessage.get().getMessage("driver.nolmd"));
            }
            InputStream in = null;
            try {
                in = ConfigUtil.getInputStream((String)home, (String)lmdFile);
                lmd = IOUtil.readLogicMetaData(in);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        com.scudata.common.Logger.error((Object)ex);
                    }
                }
            }
            in = null;
            String dctFile = urlParams.getProperty(_$7);
            Dictionary dct = null;
            if (StringUtils.isValidString((Object)dctFile)) {
                try {
                    in = ConfigUtil.getInputStream((String)home, (String)dctFile);
                    dct = IOUtil.readDictionary(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception ex) {
                            com.scudata.common.Logger.error((Object)ex);
                        }
                    }
                }
            }
            String vsbFile = urlParams.getProperty(_$6);
            Visibility vsb = null;
            if (StringUtils.isValidString((Object)vsbFile)) {
                try {
                    in = ConfigUtil.getInputStream((String)home, (String)vsbFile);
                    vsb = IOUtil.readVisibility(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception ex) {
                            com.scudata.common.Logger.error((Object)ex);
                        }
                    }
                }
            }
            return new DQLConnection(this, url, user, isDqlMode, lmd, dct, vsb, raqsoftConfig);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        JDBCUtil.log((String)"DQLDriver-3");
        return url.startsWith("jdbc:esproc:dql://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] dpis;
        JDBCUtil.log((String)"DQLDriver-4");
        if (!this.acceptsURL(url)) {
            return new DriverPropertyInfo[0];
        }
        Vector<Object> vals = this._$1(url, info);
        boolean isRemote = false;
        Properties urlParams = null;
        if (vals != null) {
            isRemote = (Boolean)vals.get(3);
            urlParams = (Properties)vals.get(4);
        }
        if (isRemote) {
            dpis = new DriverPropertyInfo[]{this._$1(urlParams, _$11), this._$1(urlParams, _$13), this._$1(urlParams, _$12)};
        } else {
            dpis = new DriverPropertyInfo[5];
            dpis[0] = this._$1(urlParams, _$11);
            dpis[1] = this._$1(urlParams, _$8);
            dpis[1].required = true;
            dpis[2] = this._$1(urlParams, _$7);
            dpis[3] = this._$1(urlParams, _$6);
            dpis[4] = this._$1(urlParams, _$9);
        }
        return dpis;
    }

    private DriverPropertyInfo _$1(Properties urlParams, String key) {
        return new DriverPropertyInfo(key, urlParams.getProperty(key));
    }

    @Override
    public int getMajorVersion() {
        JDBCUtil.log((String)"DQLDriver-5");
        return 1;
    }

    @Override
    public int getMinorVersion() {
        JDBCUtil.log((String)"DQLDriver-6");
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        JDBCUtil.log((String)"DQLDriver-7");
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        JDBCUtil.log((String)"DQLDriver-8");
        return null;
    }

    protected synchronized List<String> getValidParamNames() {
        if (this._$2 == null) {
            this._$2 = new ArrayList<String>();
            this._$2.add(_$13.toLowerCase());
            this._$2.add(_$12.toLowerCase());
            this._$2.add(_$11.toLowerCase());
            this._$2.add(_$10.toLowerCase());
            this._$2.add(_$8.toLowerCase());
            this._$2.add(_$6.toLowerCase());
            this._$2.add(_$7.toLowerCase());
            this._$2.add(_$9.toLowerCase());
            this._$2.add(KEY_HOME.toLowerCase());
        }
        return this._$2;
    }

    private Vector<Object> _$1(String urlString, Properties info) throws SQLException {
        urlString = urlString.substring("jdbc:esproc:dql://".length());
        ArrayList<String> hostList = new ArrayList<String>();
        ArrayList<Integer> portList = new ArrayList<Integer>();
        String serviceName = null;
        boolean isRemote = false;
        Properties urlParams = info;
        if (StringUtils.isValidString((Object)urlString)) {
            String[] ipPorts;
            urlString = urlString.trim();
            int pIndex = urlString.indexOf("?");
            String host = null;
            if (pIndex > -1 && pIndex < urlString.length() - 1) {
                if (pIndex > -1) {
                    host = urlString.substring(0, pIndex);
                }
                String paramStr = urlString.substring(pIndex + 1);
                urlParams = this.getProperties(paramStr, info);
            } else {
                host = urlString;
            }
            String strIpPorts = null;
            if (StringUtils.isValidString((Object)host)) {
                int sIndex = (host = host.replaceAll("\\\\", "/")).indexOf("/");
                if (sIndex > -1 && sIndex < host.length() - 1) {
                    if (sIndex > -1) {
                        strIpPorts = host.substring(0, sIndex);
                    }
                    serviceName = host.substring(sIndex + 1);
                } else {
                    serviceName = null;
                }
            }
            if (StringUtils.isValidString(strIpPorts) && (ipPorts = strIpPorts.split(",")) != null) {
                for (String ipPort : ipPorts) {
                    int splitIndex = ipPort.lastIndexOf(":");
                    if (splitIndex <= 0) continue;
                    String sip = ipPort.substring(0, splitIndex);
                    String shost = ipPort.substring(splitIndex + 1);
                    try {
                        hostList.add(sip.trim());
                        portList.add(new Integer(shost.trim()));
                    }
                    catch (Exception ex) {
                        throw new SQLException("URL format is incorrect.");
                    }
                }
            }
        }
        isRemote = !hostList.isEmpty() && !portList.isEmpty() && hostList.size() == portList.size();
        Vector<Object> vals = new Vector<Object>();
        vals.add(hostList);
        vals.add(portList);
        vals.add(serviceName);
        vals.add(isRemote);
        vals.add(urlParams);
        return vals;
    }

    protected Properties getProperties(String url, Properties info) {
        Properties props = new Properties();
        if (info != null) {
            props.putAll((Map<?, ?>)info);
        }
        if (url != null) {
            String[] parts;
            List<String> paramNames = this.getValidParamNames();
            for (String part : parts = url.split("&")) {
                for (String paramName : paramNames) {
                    int index = part.toLowerCase().indexOf(paramName + "=");
                    if (index < 0) continue;
                    String key = part.substring(index, index + paramName.length());
                    String value = part.substring(index + paramName.length() + 1);
                    try {
                        key = URLDecoder.decode(key, StandardCharsets.UTF_8.toString());
                        value = URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
                    }
                    catch (Exception ex) {
                        com.scudata.common.Logger.warn((Object)("Invalid URL parameter: " + part));
                        continue;
                    }
                    props.put(key, value);
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadConfig(String home, String sconfig) throws SQLException {
        String logConfig;
        Properties sps;
        if (raqsoftConfig != null) {
            if (StringUtils.isValidString((Object)sconfig) && (this.currentConfig == null || !this.currentConfig.equalsIgnoreCase(sconfig))) {
                com.scudata.common.Logger.info((Object)JDBCMessage.get().getMessage("server.configloadonce"));
            }
            return false;
        }
        InputStream is = null;
        String fileName = sconfig;
        try {
            if (StringUtils.isValidString((Object)sconfig)) {
                if ((sconfig = sconfig.trim()).startsWith("\"") && sconfig.endsWith("\"")) {
                    sconfig = Escape.removeEscAndQuote((String)sconfig, (char)'\"');
                } else if (sconfig.startsWith("'") && sconfig.endsWith("'")) {
                    sconfig = sconfig.substring(1, sconfig.length() - 1);
                }
                fileName = sconfig;
                is = ConfigUtil.getInputStream((String)home, (String)sconfig);
            } else {
                is = this.findResource(_$1);
                fileName = _$1;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (is != null) {
            try {
                raqsoftConfig = ConfigUtil.load((InputStream)is, (boolean)true, (boolean)true);
                this.currentConfig = sconfig;
                com.scudata.common.Logger.info((Object)JDBCMessage.get().getMessage("error.configloaded", (Object)fileName));
                com.scudata.common.Logger.debug((Object)("parallelNum=" + raqsoftConfig.getParallelNum()));
            }
            catch (Exception e) {
                String errorMessage = JDBCMessage.get().getMessage("error.loadconfigerror", (Object)fileName);
                throw new SQLException(errorMessage + " : " + e.getMessage(), e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        String errorMessage = JDBCMessage.get().getMessage("error.confignotfound", (Object)fileName);
        if (StringUtils.isValidString((Object)sconfig)) {
            throw new SQLException(errorMessage);
        }
        if (raqsoftConfig != null && (sps = raqsoftConfig.getServerProperties()) != null && StringUtils.isValidString((Object)(logConfig = sps.getProperty("logConfig")))) {
            logConfig = logConfig.trim();
            InputStream lcis = null;
            try {
                LocalFile logFile = new LocalFile(logConfig, "s");
                if (logFile.exists()) {
                    lcis = logFile.getInputStream();
                    if (lcis != null) {
                        Properties p = new Properties();
                        p.load(lcis);
                        com.scudata.common.Logger.setPropertyConfig((Properties)p);
                        com.scudata.common.Logger.debug((Object)JDBCMessage.get().getMessage("internaldriver.loadlogconfig", (Object)logConfig));
                    }
                } else {
                    com.scudata.common.Logger.debug((Object)JDBCMessage.get().getMessage("internaldriver.logconfignotfound", (Object)logConfig));
                }
            }
            catch (Exception e1) {
                com.scudata.common.Logger.error((Object)JDBCMessage.get().getMessage("internaldriver.loadlogconfigfailed", (Object)logConfig));
                com.scudata.common.Logger.error((Object)e1);
            }
            finally {
                if (lcis != null) {
                    try {
                        lcis.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return true;
    }

    protected InputStream findResource(String fileName) {
        InputStream in;
        block12: {
            ClassLoader cl;
            in = null;
            if (in == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                try {
                    URL url = cl.getResource(fileName);
                    if (url == null) break block12;
                    try {
                        in = url.openStream();
                        if (in != null) {
                            com.scudata.common.Logger.info((Object)("JDBC config load from : " + url.toString()));
                        }
                    }
                    catch (Exception e) {}
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (in == null) {
            try {
                URL url = IOUtils.class.getResource(fileName);
                if (url != null) {
                    try {
                        in = url.openStream();
                        com.scudata.common.Logger.info((Object)("JDBC config load from : " + url.toString()));
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }

    static {
        try {
            DriverManager.registerDriver(new DQLDriver());
        }
        catch (SQLException e) {
            JDBCUtil.log((String)"Can't register LogicDriver.");
        }
        START_TIME = System.currentTimeMillis();
        overTime = 172800000L;
        raqsoftConfig = null;
    }
}

