/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.jdbc;

import com.esproc.dql.jdbc.DQLConnection;
import com.esproc.dql.jdbc.DQLStatement;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.common.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLPreparedStatement
extends DQLStatement
implements PreparedStatement {
    private String _$5;
    protected ArrayList<Object> parameters = new ArrayList();

    public DQLPreparedStatement(DQLConnection con, String sql) {
        super(con);
        JDBCUtil.log((String)"DQLPreparedStatement-0");
        this._$5 = sql;
    }

    public ArrayList<Object> getParameters() {
        JDBCUtil.log((String)"DQLPreparedStatement-1");
        return this.parameters;
    }

    public void setParameters(ArrayList<Object> parameters) {
        JDBCUtil.log((String)"DQLPreparedStatement-2");
        this.parameters = parameters;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-3");
        if (this.con.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        if (sql.startsWith(">")) {
            throw new SQLException(JDBCMessage.get().getMessage("error.cantreturnrs"));
        }
        this._$5 = sql;
        this.parameters.clear();
        return this.executeQuery();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-4");
        if (this.con.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this._$5 = sql;
        this.parameters.clear();
        return this.execute();
    }

    @Override
    public boolean execute() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-5");
        if (this.con.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.resultSet = this.dqlQuery(this._$5, this.parameters);
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-6");
        if (this.con.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        this.resultSet = this.dqlQuery(this._$5, this.parameters);
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-7");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"executeUpdate()"));
        }
        return 0;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-8");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-9");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setAsciiStream(int parameterIndex, InputStream x, int length)"));
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-10");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-11");
        try {
            byte[] bs = new byte[length];
            x.read(bs);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, bs);
            } else {
                while (this.parameters.size() < parameterIndex - 1) {
                    this.parameters.add(null);
                }
                this.parameters.add(parameterIndex - 1, bs);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-12");
        byte[] bs = x.getBytes(1L, (int)x.length());
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, bs);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, bs);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-13");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Boolean(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Boolean(x));
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-14");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Byte(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Byte(x));
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-15");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-16");
        try {
            char[] cs = new char[length];
            reader.read(cs);
            String s = new String(cs);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, new String(s));
            } else {
                while (this.parameters.size() < parameterIndex - 1) {
                    this.parameters.add(null);
                }
                this.parameters.add(parameterIndex - 1, s);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-17");
        String s = JDBCUtil.clobToString((Clob)x);
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, s);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, s);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-18");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-19");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-20");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Double(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Double(x));
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-21");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Float(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Float(x));
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-21");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Integer(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Integer(x));
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-22");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Long(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Long(x));
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-23");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-24");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-25");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-26");
        this.setObject(parameterIndex, x, 1111);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-27");
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-28");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-29");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, new Short(x));
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, new Short(x));
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-30");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-31");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-32");
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-33");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-34");
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-35");
        if (this.parameters.size() > parameterIndex - 1) {
            this.parameters.set(parameterIndex - 1, x);
        } else {
            while (this.parameters.size() < parameterIndex - 1) {
                this.parameters.add(null);
            }
            this.parameters.add(parameterIndex - 1, x);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-36");
    }

    @Override
    public void clearParameters() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-37");
        this.parameters.clear();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-38");
        if (this.resultSet == null) {
            return null;
        }
        return this.resultSet.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-39");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"getParameterMetaData()"));
        }
        return null;
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-40");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setUnicodeStream(int parameterIndex, InputStream x, int length)"));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-43");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setAsciiStream(int parameterIndex, InputStream x)"));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-44");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setAsciiStream(int parameterIndex, InputStream x, long length)"));
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-45");
        try {
            byte[] bs = this._$1(x);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, bs);
            } else {
                while (this.parameters.size() < parameterIndex - 1) {
                    this.parameters.add(null);
                }
                this.parameters.add(parameterIndex - 1, bs);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$1(InputStream is) throws Exception {
        if (is == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[65536];
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream();
            while ((len = is.read(bytes)) != -1) {
                baos.write(bytes, 0, len);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e1) {}
            }
        }
        return baos.toByteArray();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-46");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setBinaryStream(int parameterIndex, InputStream x, long length)"));
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-47");
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-48");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setBlob(int parameterIndex, InputStream inputStream, long length)"));
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-49");
        try {
            String s = this._$1(reader);
            if (this.parameters.size() > parameterIndex - 1) {
                this.parameters.set(parameterIndex - 1, new String(s));
            } else {
                while (this.parameters.size() < parameterIndex - 1) {
                    this.parameters.add(null);
                }
                this.parameters.add(parameterIndex - 1, s);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _$1(Reader reader) throws Exception {
        if (reader == null) {
            return null;
        }
        char[] chars = new char[65536];
        StringWriter writer = null;
        try {
            int len;
            writer = new StringWriter();
            while ((len = reader.read(chars)) != -1) {
                writer.write(chars, 0, len);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e1) {}
            }
        }
        return writer.getBuffer().toString();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-50");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setCharacterStream(int parameterIndex, Reader reader, long length)"));
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-51");
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-52");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setClob(int parameterIndex, Reader reader, long length)"));
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-53");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNCharacterStream(int parameterIndex, Reader value)"));
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-54");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNCharacterStream(int parameterIndex, Reader value, long length)"));
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-55");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNClob(int parameterIndex, NClob value)"));
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-56");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNClob(int parameterIndex, Reader reader)"));
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-57");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNClob(int parameterIndex, Reader reader, long length)"));
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-58");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNString(int parameterIndex, String value)"));
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-59");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setRowId(int parameterIndex, RowId x)"));
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        JDBCUtil.log((String)"DQLPreparedStatement-60");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setSQLXML(int parameterIndex, SQLXML xmlObject)"));
        }
    }
}

