/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.jdbc;

import com.esproc.dql.jdbc.DQLResultSet;
import com.esproc.dql.jdbc.DQLResultSetMetaData;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.app.common.Section;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.dql.LogicList;
import com.scudata.dm.query.dql.sql.SQL;
import com.scudata.dm.query.metadata.ErrorData;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.metadata.TableVisibility;
import com.scudata.dm.query.metadata.Visibility;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLUtil
extends JDBCUtil {
    public static final int DEFAULT_FETCH_SIZE = 1000;
    public static final String KEY_LIST_METADATA = "list ";
    public static final String KEY_SEARCH = "search";
    public static final String KEY_METADATA = "metadata";
    private static final int _$1 = 0;
    public static boolean isDebugMode = false;
    public static final String TABLE_CAT = "TABLE_CAT";
    public static final String TABLE_SCHEM = "TABLE_SCHEM";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    public static final String PROCEDURE_FILE = "PROCEDURE_FILE";
    public static final String PARAM_LIST = "PARAM_LIST";
    public static final String PKTABLE_CAT = "PKTABLE_CAT";
    public static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    public static final String PKTABLE_NAME = "PKTABLE_NAME";
    public static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    public static final String FKTABLE_CAT = "FKTABLE_CAT";
    public static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    public static final String FKTABLE_NAME = "FKTABLE_NAME";
    public static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    public static final String FK_NAME = "FK_NAME";
    public static final String PK_NAME = "PK_NAME";
    public static final String KEY_SEQ = "KEY_SEQ";

    public static DQLResultSet generateResultSet(Object obj, int fetchSize) throws SQLException {
        return DQLUtil.generateResultSet(obj, "Field", fetchSize);
    }

    public static DQLResultSet generateResultSet(Object obj, String colName, int fetchSize) throws SQLException {
        if (obj == null) {
            return null;
        }
        String[] fields = null;
        int[] types = null;
        int[] dealTypes = null;
        ArrayList<ArrayList<Object>> datas = null;
        if (obj instanceof com.scudata.dm.Table) {
            com.scudata.dm.Table t = (com.scudata.dm.Table)obj;
            fields = t.dataStruct().getFieldNames();
            types = new int[fields.length];
            DQLUtil._$1(types);
            dealTypes = new int[fields.length];
            datas = new ArrayList<ArrayList<Object>>(t.length());
            for (int i = 1; i <= t.length(); ++i) {
                ArrayList<Object> row = new ArrayList<Object>(fields.length);
                Object seqi = t.get(i);
                if (seqi != null && seqi instanceof BaseRecord) {
                    BaseRecord r = (BaseRecord)t.get(i);
                    for (int j = 0; j < fields.length; ++j) {
                        Object o = r.getFieldValue(fields[j]);
                        row.add(o);
                        if (o == null || dealTypes[j] == 1) continue;
                        types[j] = DQLUtil.getType((Object)o, (int)types[j]);
                        dealTypes[j] = 1;
                    }
                } else {
                    for (int j = 0; j < fields.length; ++j) {
                        row.add(null);
                    }
                }
                datas.add(row);
            }
        } else if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            if (seq.length() == 0) {
                fields = new String[]{colName};
                types = new int[fields.length];
                DQLUtil._$1(types);
                datas = new ArrayList(seq.length());
            } else {
                Object first = seq.get(1);
                if (first == null || !(first instanceof BaseRecord)) {
                    fields = new String[]{colName};
                    types = new int[fields.length];
                    DQLUtil._$1(types);
                    dealTypes = new int[fields.length];
                    datas = new ArrayList(seq.length());
                    for (int i = 1; i <= seq.length(); ++i) {
                        Object o = seq.get(i);
                        ArrayList<Object> row = new ArrayList<Object>(1);
                        row.add(o);
                        datas.add(row);
                        if (o == null) continue;
                        types[0] = DQLUtil.getType((Object)o, (int)types[0]);
                        if (dealTypes[0] == 1) continue;
                        types[0] = DQLUtil.getType((Object)o, (int)types[0]);
                        dealTypes[0] = 1;
                    }
                } else {
                    fields = ((BaseRecord)first).dataStruct().getFieldNames();
                    types = new int[fields.length];
                    DQLUtil._$1(types);
                    dealTypes = new int[fields.length];
                    datas = new ArrayList(seq.length());
                    for (int i = 1; i <= seq.length(); ++i) {
                        ArrayList<Object> row = new ArrayList<Object>(fields.length);
                        Object seqi = seq.get(i);
                        if (seqi != null && seqi instanceof BaseRecord) {
                            BaseRecord r = (BaseRecord)seq.get(i);
                            for (int j = 0; j < fields.length; ++j) {
                                Object o = r.getFieldValue(fields[j]);
                                row.add(o);
                                if (o == null || dealTypes[j] == 1) continue;
                                types[j] = DQLUtil.getType((Object)o, (int)types[j]);
                                dealTypes[j] = 1;
                            }
                        } else {
                            for (int j = 0; j < fields.length; ++j) {
                                row.add(null);
                            }
                        }
                        datas.add(row);
                    }
                }
            }
        } else if (obj instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)obj;
            fields = r.dataStruct().getFieldNames();
            types = new int[fields.length];
            DQLUtil._$1(types);
            datas = new ArrayList(1);
            ArrayList<Object> row = new ArrayList<Object>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                Object o = r.getFieldValue(i);
                row.add(o);
                if (o == null) continue;
                types[i] = DQLUtil.getType((Object)o, (int)types[i]);
            }
            datas.add(row);
        } else {
            if (obj instanceof ICursor) {
                ICursor c = (ICursor)obj;
                DQLResultSet set = new DQLResultSet(c);
                return set;
            }
            fields = new String[]{colName};
            types = new int[1];
            DQLUtil._$1(types);
            datas = new ArrayList(1);
            ArrayList<Object> row = new ArrayList<Object>(1);
            row.add(obj);
            if (obj != null) {
                types[0] = DQLUtil.getType((Object)obj, (int)types[0]);
            }
            datas.add(row);
        }
        DQLResultSetMetaData metaData = new DQLResultSetMetaData(fields, types);
        DQLResultSet set = new DQLResultSet(datas, metaData);
        set.setFetchSize(fetchSize);
        return set;
    }

    private static void _$1(int[] types) {
        if (types == null || types.length == 0) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            types[i] = 0;
        }
    }

    public static void log(String info) {
        if (isDebugMode) {
            Logger.debug((Object)info);
        }
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("windows") > -1;
    }

    public static String getLineSeparator() {
        return DQLUtil.isWindowsOS() ? "\n" : System.getProperties().getProperty("line.separator");
    }

    public static DQLResultSet getEmptyResultSet() throws SQLException {
        return new DQLResultSet(0);
    }

    public static String getErrorString(List<ErrorData> result) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (ErrorData ed : result) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(ed.getErrMsg());
        }
        return buf.toString();
    }

    public static String toJSONString(String str) {
        if (str == null) {
            return "\"\"";
        }
        return Escape.addEscAndQuote((String)str);
    }

    public static com.scudata.dm.Table listMetaData(LogicMetaData lmd, String dql) {
        LogicList ll = new LogicList(dql, lmd);
        List<Object[]> vals = ll.getResult();
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        int rowCount = vals.size() - 1;
        Object[] titles = vals.get(0);
        int colCount = titles.length;
        String[] columnNames = new String[colCount];
        for (int i = 0; i < titles.length; ++i) {
            columnNames[i] = (String)titles[i];
        }
        com.scudata.dm.Table t = new com.scudata.dm.Table(columnNames);
        for (int i = 1; i <= rowCount; ++i) {
            t.newLast(vals.get(i));
        }
        return t;
    }

    public static String translateToDQL(LogicMetaData lmd, String strSql) {
        SQL sql = new SQL(lmd, strSql);
        return sql.toDQL();
    }

    public static com.scudata.dm.Table getTables(String schemaPattern, String tableNamePattern, LogicMetaData lmd, Visibility vis) {
        String[] tableNames = DQLUtil._$1(schemaPattern, tableNamePattern, lmd, vis);
        com.scudata.dm.Table t = new com.scudata.dm.Table(new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME});
        if (tableNames != null) {
            for (int i = 0; i < tableNames.length; ++i) {
                t.newLast(new Object[]{null, null, tableNames[i]});
            }
        }
        return t;
    }

    public static com.scudata.dm.Table getColumns(String schemaPattern, String tableNamePattern, String columnNamePattern, LogicMetaData lmd, Visibility vis) {
        Object[] tableColumns = DQLUtil._$1(schemaPattern, tableNamePattern, columnNamePattern, lmd, vis);
        com.scudata.dm.Table t = new com.scudata.dm.Table(new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE});
        if (tableColumns != null) {
            String[] tables = (String[])tableColumns[0];
            String[] columns = (String[])tableColumns[1];
            int[] colTypes = (int[])tableColumns[2];
            for (int i = 0; i < tables.length; ++i) {
                t.newLast(new Object[]{null, null, tables[i], columns[i], colTypes[i]});
            }
        }
        return t;
    }

    public static com.scudata.dm.Table getPrimaryKeys(String tableNamePattern, LogicMetaData lmd, Visibility vis) {
        TableList tl;
        com.scudata.dm.Table table = new com.scudata.dm.Table(new String[]{TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ});
        if (lmd != null && (tl = lmd.getTableList()) != null) {
            ArrayList<String> tables = new ArrayList<String>();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<Integer> seqs = new ArrayList<Integer>();
            for (int i = 0; i < tl.size(); ++i) {
                FieldList fl;
                Matcher m;
                Pattern p;
                Table t = (Table)tl.get(i);
                String tableName = t.getName();
                if (StringUtils.isValidString((Object)tableNamePattern) && (p = DQLUtil._$1(tableNamePattern)) != null && !(m = p.matcher(tableName)).matches()) continue;
                TableVisibility tv = null;
                if (vis != null && (tv = vis.getTableVisibility(tableName)) != null && tv.isVisible() == 0 || (fl = t.getFieldList()) == null) continue;
                List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
                for (int j = 0; j < fl.size(); ++j) {
                    Field f = (Field)fl.get(j);
                    if (ifList != null && ifList.contains(f.getName()) || !f.isPrimary()) continue;
                    tables.add(tableName);
                    columns.add(f.getName());
                    seqs.add(new Integer(j + 1));
                }
            }
            if (!tables.isEmpty()) {
                int size = tables.size();
                for (int i = 0; i < size; ++i) {
                    table.newLast(new Object[]{null, null, tables.get(i), columns.get(i), seqs.get(i)});
                }
            }
        }
        return table;
    }

    public static com.scudata.dm.Table getExportedKeys(String tableNamePattern, LogicMetaData lmd, Visibility vis) {
        TableList tl;
        com.scudata.dm.Table table = new com.scudata.dm.Table(new String[]{PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, FK_NAME});
        if (lmd != null && (tl = lmd.getTableList()) != null) {
            Section pkTables = new Section(true);
            Section pkCols = new Section(true);
            Section fkTables = new Section(true);
            Section fkCols = new Section(true);
            Section fkNames = new Section(true);
            for (int i = 0; i < tl.size(); ++i) {
                ForeignKeyList fkl;
                Table t = (Table)tl.get(i);
                String tableName = t.getName();
                TableVisibility tv = null;
                if (vis != null && (tv = vis.getTableVisibility(tableName)) != null && tv.isVisible() == 0 || (fkl = t.getForeignKeyList()) == null) continue;
                List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
                for (int f = 0; f < fkl.size(); ++f) {
                    Matcher m;
                    ForeignKey fk = (ForeignKey)fkl.get(f);
                    if (ifList != null && ifList.contains(fk.getName())) continue;
                    String refTable = fk.getRefTableName();
                    Pattern p = DQLUtil._$1(tableNamePattern);
                    if (p != null && !(m = p.matcher(refTable)).matches()) continue;
                    List<String> fList = fk.getFieldNameList();
                    List<String> refList = fk.getRefFieldNameList();
                    for (int k = 0; k < fList.size(); ++k) {
                        pkTables.addSection(t.getName());
                        pkCols.addSection(refList.get(k));
                        fkTables.addSection(fk.getRefTableName());
                        fkCols.addSection(fList.get(k));
                        fkNames.addSection(fk.getName());
                    }
                }
            }
            int size = pkTables.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    table.newLast(new Object[]{null, null, pkTables.get(i), pkCols.get(i), null, null, fkTables.get(i), fkCols.get(i), fkNames.get(i)});
                }
            }
        }
        return table;
    }

    public static com.scudata.dm.Table getImportedKeys(String tableNamePattern, LogicMetaData lmd, Visibility vis) {
        TableList tl;
        com.scudata.dm.Table table = new com.scudata.dm.Table(new String[]{PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, FK_NAME});
        if (lmd != null && (tl = lmd.getTableList()) != null) {
            Section pkTables = new Section(true);
            Section pkCols = new Section(true);
            Section fkTables = new Section(true);
            Section fkCols = new Section(true);
            Section fkNames = new Section(true);
            for (int l = 0; l < tl.size(); ++l) {
                ForeignKeyList fkl;
                Matcher m;
                Table t = (Table)tl.get(l);
                Pattern p = DQLUtil._$1(tableNamePattern);
                if (p != null && !(m = p.matcher(t.getName())).matches()) continue;
                TableVisibility tv = null;
                if (vis != null && (tv = vis.getTableVisibility(t.getName())) != null && tv.isVisible() == 0 || (fkl = t.getForeignKeyList()) == null) continue;
                List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
                for (int f = 0; f < fkl.size(); ++f) {
                    ForeignKey fk = (ForeignKey)fkl.get(f);
                    if (ifList != null && ifList.contains(fk.getName())) continue;
                    String refTable = fk.getRefTableName();
                    List<String> fList = fk.getFieldNameList();
                    List<String> refList = fk.getRefFieldNameList();
                    for (int k = 0; k < fList.size(); ++k) {
                        pkTables.addSection(refTable);
                        pkCols.addSection(refList.get(k));
                        fkTables.addSection(t.getName());
                        fkCols.addSection(fList.get(k));
                        fkNames.addSection(fk.getName());
                    }
                }
            }
            int size = pkTables.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    table.newLast(new Object[]{null, null, pkTables.get(i), pkCols.get(i), null, null, fkTables.get(i), fkCols.get(i), fkNames.get(i)});
                }
            }
        }
        return table;
    }

    private static Pattern _$1(String filter) {
        if (!StringUtils.isValidString((Object)filter)) {
            return null;
        }
        filter = filter.trim();
        filter = filter.replaceAll("%", ".*");
        filter = filter.replaceAll("_", ".");
        return Pattern.compile(filter);
    }

    private static String[] _$1(String schemaPattern, String tableNamePattern, LogicMetaData lmd, Visibility vis) {
        if (lmd == null) {
            return null;
        }
        TableList tl = lmd.getTableList();
        List<TableVisibility> tvl = null;
        if (vis != null) {
            tvl = vis.getTableVisibilityList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tl.size(); ++i) {
            Matcher m;
            Pattern p;
            Table table = (Table)tl.get(i);
            String tableName = table.getName();
            if (StringUtils.isValidString((Object)tableNamePattern) && (p = DQLUtil._$1(tableNamePattern)) != null && !(m = p.matcher(tableName)).matches()) continue;
            TableVisibility tv = null;
            if (tvl != null) {
                for (TableVisibility tmp : tvl) {
                    if (!tmp.getName().equals(tableName)) continue;
                    tv = tmp;
                    break;
                }
            }
            if (tv != null && tv.isVisible() == 0) continue;
            list.add(tableName);
        }
        if (list.isEmpty()) {
            return null;
        }
        int size = list.size();
        String[] tableNames = new String[size];
        for (int i = 0; i < size; ++i) {
            tableNames[i] = (String)list.get(i);
        }
        return tableNames;
    }

    private static Object[] _$1(String schemaPattern, String tableNamePattern, String columnNamePattern, LogicMetaData lmd, Visibility vis) {
        if (lmd == null) {
            return null;
        }
        TableList tl = lmd.getTableList();
        if (tl == null) {
            return null;
        }
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Integer> colTypes = new ArrayList<Integer>();
        int size = tl.size();
        for (int i = 0; i < size; ++i) {
            Matcher m;
            Pattern p;
            Table t = (Table)tl.get(i);
            String tableName = t.getName();
            if (StringUtils.isValidString((Object)tableNamePattern) && (p = DQLUtil._$1(tableNamePattern)) != null && !(m = p.matcher(tableName)).matches()) continue;
            TableVisibility tv = null;
            if (vis != null && (tv = vis.getTableVisibility(tableName)) != null && tv.isVisible() == 0) continue;
            FieldList fl = t.getFieldList();
            List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
            for (int j = 0; j < fl.size(); ++j) {
                Matcher m2;
                Pattern p2;
                Field f = (Field)fl.get(j);
                String fieldName = f.getName();
                if (StringUtils.isValidString((Object)columnNamePattern) && (p2 = DQLUtil._$1(columnNamePattern)) != null && !(m2 = p2.matcher(fieldName)).matches() || ifList != null && ifList.contains(fieldName)) continue;
                tables.add(tableName);
                columns.add(fieldName);
                colTypes.add(JDBCUtil.getSQLTypeByType((byte)((byte)f.getDataType())));
            }
        }
        if (tables.isEmpty()) {
            return null;
        }
        int size2 = tables.size();
        String[] tableNames = new String[size2];
        String[] colNames = new String[size2];
        int[] types = new int[size2];
        for (int i = 0; i < size2; ++i) {
            tableNames[i] = (String)tables.get(i);
            colNames[i] = (String)columns.get(i);
            types[i] = (Integer)colTypes.get(i);
        }
        return new Object[]{tableNames, colNames, types};
    }
}

