/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.server.DqlServerConsole;
import com.esproc.dql.server.Server;
import com.scudata.app.common.Section;
import com.scudata.server.odbc.DataTypes;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ServerConsole {
    public static void setDefaultLNF() {
        com.scudata.ide.spl.ServerConsole.setDefaultLNF();
    }

    public static void startServer(boolean start) throws Exception {
        ServerConsole.setDefaultLNF();
        DqlServerConsole dsc = new DqlServerConsole();
        dsc.setVisible(true);
        if (start) {
            dsc.preventExit();
            dsc.startServer();
        }
    }

    public static void stopServer(boolean forceQuit) {
        try {
            Server.setForShutdown();
            Server server = Server.getInstance();
            String host = server.getHost();
            int port = server.getPort();
            Socket s = new Socket();
            s.connect(new InetSocketAddress(host, port), 1000);
            OutputStream os = s.getOutputStream();
            if (forceQuit) {
                DataTypes.writeInt((OutputStream)os, (int)-100);
            } else {
                DataTypes.writeInt((OutputStream)os, (int)-1);
            }
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String arg;
        String usage = "\u8be5\u7c7b\u6839\u636e\u9009\u9879\u6765\u542f\u52a8\u6216\u505c\u6b62DQL\u670d\u52a1\uff0c\u683c\u5f0f\u4e3a ServerConsole.sh -[options]\r\n\u4e0d\u5e26\u4efb\u4f55\u9009\u9879\u65f6\uff0c\u8868\u793a\u542f\u52a8\u670d\u52a1\u63a7\u5236\u53f0\u7a0b\u5e8f[\u56fe\u5f62\u7a97\u53e3\u63a7\u5236\u53f0]\u3002\r\n\u9009\u9879\uff1a\r\n\r\n-d\t\u542f\u52a8\u975e\u56fe\u5f62\u63a7\u5236\u53f0\u670d\u52a1\u3002\r\n-s\t\u542f\u52a8\u56fe\u5f62\u63a7\u5236\u53f0\u4e14\u540c\u65f6\u542f\u52a8\u670d\u52a1\u5668\u3002\r\n-x\t\u505c\u6b62\u5f53\u524d\u670d\u52a1\u5668\u3002\r\n-?\t\u6216\u8005\u9519\u8bef\u9009\u9879\u65f6\uff0c\u6253\u5370\u5f53\u524d\u5e2e\u52a9\u4fe1\u606f\u3002\r\n\r\n";
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0 && arg.charAt(1) != ':') {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        boolean isD = false;
        boolean isX = false;
        boolean isS = false;
        boolean printHelp = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                arg = args[i].toLowerCase();
                if (arg.equalsIgnoreCase("com.esproc.dql.server.ServerConsole")) continue;
                if (arg.equals("-d")) {
                    isD = true;
                    break;
                }
                if (arg.equals("-x")) {
                    isX = true;
                    break;
                }
                if (arg.equals("-s")) {
                    isS = true;
                    break;
                }
                printHelp = true;
            }
        }
        if (printHelp) {
            System.err.println(usage);
            System.err.println("Press enter to exit.");
            try {
                System.in.read();
            }
            catch (Exception x) {
                // empty catch block
            }
            System.exit(0);
        }
        if (isX) {
            ServerConsole.stopServer(false);
            System.exit(0);
        }
        try {
            if (!isD) {
                ServerConsole.startServer(isS);
                return;
            }
            Server server = Server.getInstance();
            server.run();
        }
        catch (Exception x) {
            x.printStackTrace();
            System.err.println("Press enter to exit.");
            try {
                System.in.read();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        System.exit(0);
    }
}

