/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.server.Server;
import com.esproc.dql.server.ServerMsg;
import com.esproc.dql.server.Service;
import com.esproc.dql.server.ServiceImpl;
import com.scudata.app.common.Section;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.spl.SPL;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceManager {
    public static String ESPROC_SERVICES = "esproc-services/";
    static int _$3 = 0;
    static ArrayList<Service> _$2 = new ArrayList();
    static HashMap _$1 = new HashMap();

    public static synchronized void clearServices() {
        _$2.clear();
    }

    public static synchronized void registerService(Service svc) {
        if (_$2.contains(svc)) {
            return;
        }
        if (ServiceManager.getServiceByName(svc.getServiceName()) != null) {
            return;
        }
        _$2.add(svc);
        Logger.debug((Object)(svc.getClass().getName() + ": " + svc.getServiceName() + " registered success."));
    }

    public static synchronized void unregisterService(String svcName) {
        Service svc = ServiceManager.getServiceByName(svcName);
        if (svc != null) {
            _$2.remove(svc);
        }
    }

    public static synchronized Service getServiceByName(String svcName) {
        if (!StringUtils.isValidString((Object)svcName)) {
            return _$2.get(0);
        }
        for (int i = 0; i < _$2.size(); ++i) {
            Service svc = _$2.get(i);
            if (!svc.getServiceName().equals(svcName)) continue;
            return svc;
        }
        return null;
    }

    public static synchronized String[] getServiceNames() {
        String[] names = new String[_$2.size()];
        for (int i = 0; i < _$2.size(); ++i) {
            names[i] = _$2.get(i).getServiceName();
        }
        return names;
    }

    public static synchronized String getInitParam(String param) {
        return (String)_$1.get(param);
    }

    public static String getAttribute(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        int i = attrs.getLength();
        for (int j = 0; j < i; ++j) {
            Node tmp = attrs.item(j);
            String sTmp = tmp.getNodeName();
            if (!sTmp.equalsIgnoreCase(attrName)) continue;
            return tmp.getNodeValue();
        }
        return null;
    }

    public static void loadConfig() throws Exception {
        ServiceManager.clearServices();
        String serverPath = Server.getAbsolutePath(ESPROC_SERVICES + "server.xml");
        File serverFile = new File(serverPath);
        if (!serverFile.exists()) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)serverPath));
        }
        FileInputStream is = new FileInputStream(serverFile);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(is);
        NodeList nl = xmlDocument.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase("SERVER")) continue;
            root = n;
        }
        if (root == null) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.errxml"));
        }
        Section section = new Section("host,port,timeout,log,license,raqsoftConfig,autoStart");
        for (int i = 0; i < section.size(); ++i) {
            String key = section.get(i);
            String value = ServiceManager.getAttribute(root, key);
            _$1.put(key, value);
        }
        if (Server.isForShutdown()) {
            return;
        }
        NodeList serviceNodes = root.getChildNodes();
        for (int i = 0; i < serviceNodes.getLength(); ++i) {
            Node node = serviceNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String name = ServiceManager.getAttribute(node, "name");
            ServiceImpl si = new ServiceImpl();
            si.setServiceName(name);
            String buf = ServiceManager.getAttribute(node, "userinjson");
            if (StringUtils.isValidString((Object)buf)) {
                boolean uij = Boolean.parseBoolean(buf);
                si.setUserInJson(uij);
            }
            if (!StringUtils.isValidString((Object)(buf = ServiceManager.getInitParam("raqsoftConfig")))) {
                throw new Exception("raqsofConfig is not specified!");
            }
            String envFile = Server.getAbsolutePath(buf);
            RaqsoftConfig config = ConfigUtil.load((String)envFile);
            SPL.checkNoUI((RaqsoftConfig)config, (int[])new int[]{7, 6}, (String)ServerMsg.get().getMessage("Server.title"));
            si.load();
            ServiceManager.registerService(si);
        }
    }

    public static void stop() {
        if (_$2 != null) {
            for (int i = 0; i < _$2.size(); ++i) {
                Service service = _$2.get(i);
                service.stopFrequenceWriter();
            }
        }
    }

    public static synchronized int incrementConn() {
        return ++_$3;
    }

    public static synchronized int decrementConn() {
        return ++_$3;
    }

    public static synchronized int getConnNum() {
        return _$3;
    }
}

