/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.Response;
import com.esproc.dql.jdbc.DQLUtil;
import com.esproc.dql.server.RemoteCursor;
import com.esproc.dql.server.RemoteCursorProxy;
import com.esproc.dql.server.RemoteCursorProxyManager;
import com.esproc.dql.server.Server;
import com.esproc.dql.server.ServerMsg;
import com.esproc.dql.server.TaskManager;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.dm.Context;
import com.scudata.dm.query.dql.DQL;
import com.scudata.dm.query.dql.User;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Visibility;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task {
    LogicMetaData _$14;
    Visibility _$13;
    Context _$12;
    String _$11;
    List<Object> _$10;
    boolean _$9;
    int _$8 = -1;
    long _$7 = -1L;
    long _$6 = -1L;
    RemoteCursorProxyManager _$5 = null;
    transient DQL _$4 = null;
    transient boolean _$3 = false;
    private long _$2 = -1L;
    MessageManager _$1 = ServerMsg.get();

    public Task(String dql, List<Object> argList, boolean isDqlMode, int taskId) {
        this._$11 = dql;
        this._$10 = argList;
        this._$9 = isDqlMode;
        this._$8 = taskId;
    }

    public void setEnv(LogicMetaData lmd, Visibility vsb, Context ctx) {
        this._$14 = lmd;
        this._$13 = vsb;
        this._$12 = ctx;
    }

    void _$3() {
        this._$2 = System.currentTimeMillis();
    }

    void _$2() {
        this._$2 = -1L;
    }

    public void destroy() {
        if (this._$5 != null) {
            this._$5.destroy();
            this._$5 = null;
        }
    }

    private void _$1() {
        this._$7 = System.currentTimeMillis();
    }

    public RemoteCursorProxyManager getCursorManager() {
        if (this._$5 == null) {
            this._$5 = new RemoteCursorProxyManager(this);
        }
        return this._$5;
    }

    public boolean isRunning() {
        return this._$4 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute() {
        this._$1();
        try {
            if (this._$3) {
                throw new Exception(this._$1.getMessage("Task.cancel", (Object)this));
            }
            Logger.debug((Object)this._$1.getMessage("Task.begin", (Object)this));
            if (!this._$9) {
                this._$11 = DQLUtil.translateToDQL(this._$14, this._$11);
            }
            User user = new User();
            user.setLmd(this._$14);
            user.setVisibility(this._$13);
            user.setContext(this._$12);
            this._$4 = new DQL(user, this._$11, this._$10);
            Object result = this._$4.execute();
            int proxyId = Server.nextId();
            RemoteCursorProxyManager rcpm = this.getCursorManager();
            RemoteCursorProxy rcp = new RemoteCursorProxy(rcpm, result, proxyId);
            rcpm.addProxy(rcp);
            Server svr = Server.getInstance();
            RemoteCursor rc = new RemoteCursor(svr.getHost(), svr.getPort(), this._$8, proxyId);
            Response res = new Response();
            res.setResult(rc);
            this._$6 = System.currentTimeMillis();
            Logger.debug((Object)this._$1.getMessage("Task.after", (Object)this));
            Response response = res;
            return response;
        }
        catch (Exception x) {
            x.printStackTrace();
            Response res = new Response();
            Throwable t = x.getCause();
            if (t instanceof Error) {
                res.setError((Error)t);
            } else {
                res.setException(x);
            }
            Response response = res;
            return response;
        }
        catch (Error err) {
            err.printStackTrace();
            Response res = new Response();
            res.setError(err);
            Response response = res;
            return response;
        }
        finally {
            if (this._$4 != null) {
                this._$4 = null;
            }
            if (this._$5 == null) {
                TaskManager.delTask(this._$8);
            }
            this._$3();
        }
    }

    public Response cancel() {
        Response res = new Response();
        if (this._$4 == null) {
            if (this._$7 == -1L) {
                res.setResult(Boolean.TRUE);
                this._$3 = true;
            } else {
                res.setException(new Exception(this._$1.getMessage("Task.after", (Object)this)));
            }
        } else {
            res.setResult(Boolean.TRUE);
            Logger.debug((Object)this._$1.getMessage("Task.cancel", (Object)this));
        }
        return res;
    }

    public String getDql() {
        return this._$11;
    }

    public List<Object> getArgList() {
        return this._$10;
    }

    public int getTaskID() {
        return this._$8;
    }

    public long getCallTime() {
        return this._$7;
    }

    public void setCallTime(long callTime) {
        this._$7 = callTime;
    }

    public long getFinishTime() {
        return this._$6;
    }

    public void setFinishTime(long finishTime) {
        this._$6 = finishTime;
    }

    public boolean checkTimeOut(int timeOut) {
        if (this._$2 < 0L) {
            return false;
        }
        long unvisit = (System.currentTimeMillis() - this._$2) / 1000L;
        if (unvisit > (long)timeOut) {
            Logger.info((Object)this._$1.getMessage("Task.timeout", (Object)this));
            this.destroy();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._$8 + " Task");
        sb.append(" [" + this.getDql() + "]");
        return sb.toString();
    }
}

