/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.compile.CalcMethodMaker;
import com.scudata.compile.CellSetUtil2;
import com.scudata.compile.CodeCompiler;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.DataType;
import com.scudata.compile.DeriveMethodMaker;
import com.scudata.compile.FunctionInfo;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.RunMethodMaker;
import com.scudata.compile.RunMethodMaker2;
import com.scudata.compile.RunMethodMaker2Fast;
import com.scudata.compile.RunMethodMaker3;
import com.scudata.compile.SelectMethodMaker;
import com.scudata.compile.SelectMethodMakerFast;
import com.scudata.compile.SplxCompiler;
import com.scudata.compile.VarItem;
import com.scudata.compile.function.FakeFetch;
import com.scudata.compile.function.SequenceDistance;
import com.scudata.dm.Table;
import com.scudata.expression.Calc;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.fn.Between;
import com.scudata.expression.fn.Call;
import com.scudata.expression.mfn.sequence.Derive;
import com.scudata.expression.mfn.sequence.Run;
import com.scudata.expression.mfn.sequence.Select;
import com.scudata.expression.operator.Assign;
import com.scudata.pdm.PureTable;
import com.scudata.util.CellSetUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ClassMaker {
    private List<String> imports;
    private String className;
    private String classOption = "public ";
    private PgmCellSet cellSet;
    private List<String> methods;
    private List<String> fields;
    private boolean fast;
    private boolean debug;
    private boolean encrypt;

    public ClassMaker(String className, PgmCellSet cellSet) {
        this.setClassName(className);
        this.setCellSet(cellSet);
        this.methods = new ArrayList<String>();
        this.imports = new ArrayList<String>();
        this.fields = new ArrayList<String>();
        this.addImport("import com.scudata.dm.*;");
        this.addImport("import com.scudata.dm.Record;");
        this.addImport("import com.scudata.expression.*;");
        this.addImport("import com.scudata.array.*;");
        this.addImport("import com.scudata.array.LongArray;");
        this.addImport("import com.scudata.expression.mfn.sequence.*;");
        this.addImport("import com.scudata.pdm.*;");
        this.addImport("import com.scudata.compile.function.*;");
        this.addImport("import com.scudata.common.*;");
        this.addImport("import com.scudata.resources.EngineMessage;");
        this.addImport("import java.util.Date;");
    }

    private List<String> getImports() {
        this.imports.sort(null);
        return this.imports;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    public static String finishRun(String fileName, PgmCellSet cellSet) {
        int col = cellSet.getColCount();
        int row = cellSet.getRowCount();
        ConcurrentHashMap<String, VarItem> globalVars = new ConcurrentHashMap<String, VarItem>();
        int r = 1;
        while (r <= row) {
            int c = 1;
            while (c <= col) {
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                Expression exp = cell.getExpression();
                String expStr = cell.getExpString();
                if (exp != null) {
                    String name = MethodMaker.col2varName(c, r);
                    Node node = exp.getHome();
                    if (node instanceof Assign) {
                        RunMethodMaker.searchVar(node, globalVars);
                    } else {
                        VarItem csvar = new VarItem(name, null, null, true);
                        csvar.setR(r);
                        csvar.setC(c);
                        globalVars.put(name, csvar);
                        Node right = node.getRight();
                        if (right instanceof Run) {
                            Run run = (Run)right;
                            IParam param = run.getParam();
                            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
                            Expression[] exps = pi.getExpressions1();
                            int len = exps.length;
                            int hash = 123;
                            ClassMaker cls = new ClassMaker("SequenceFunc_" + hash + "_" + name, cellSet);
                            cls.addMethod(RunMethodMaker.defaultRunMethod());
                            cls.addImport("import com.scudata.dm.*;");
                            cls.addImport("import com.scudata.expression.*;");
                            cls.addImport("import com.scudata.array.*;");
                            cls.addImport("import com.scudata.array.LongArray;");
                            RunMethodMaker maker = new RunMethodMaker("calculate(Context ctx) {", "public ", "Object ");
                            String currentVar = "datas[i]";
                            maker.setCurrentVar(currentVar);
                            maker.setCurrentSeq("i");
                            maker.setSeqType("SeqDefaultType");
                            Node left = node.getLeft();
                            String currentVarName = MethodMaker.getVarName(left);
                            maker.setCurrentVarName(currentVarName);
                            try {
                                int i = 0;
                                while (i < len) {
                                    maker.addExp(c, r, exps[i], expStr);
                                    ++i;
                                }
                            }
                            catch (ParseNodeException e) {
                                e.printStackTrace();
                            }
                            maker.adjustVarType(globalVars);
                            maker.setName("calculate_int(Context ctx) ");
                            maker.setSeqType("int");
                            cls.addMethod(maker.finish());
                            maker.setName("calculate_long(Context ctx) ");
                            maker.setSeqType("long");
                            cls.addMethod(maker.finish());
                            maker.setName("calculate_double(Context ctx) ");
                            maker.setSeqType("double");
                            cls.addMethod(maker.finish());
                            cls.addField("private SequenceFunction srcFun;");
                            System.out.println(cls.finish());
                        }
                    }
                }
                ++c;
            }
            ++r;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public boolean isFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String finish() {
        StringBuffer sb = new StringBuffer();
        sb.append("package com.scudata.optimize.function;");
        sb.append(System.lineSeparator());
        List<String> imports = this.getImports();
        for (String imp : imports) {
            sb.append(imp);
            sb.append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        sb.append(String.valueOf(this.classOption) + "class " + this.className);
        sb.append(System.lineSeparator());
        List<String> fields = this.getFields();
        for (String f : fields) {
            sb.append(f);
            sb.append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        List<String> methods = this.methods;
        for (String m : methods) {
            sb.append(m);
            sb.append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        sb.append("}");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public void addMethod(String s) {
        this.methods.add(s);
    }

    public void addField(String s) {
        this.fields.add(s);
    }

    public PgmCellSet getCellSet() {
        return this.cellSet;
    }

    public void setCellSet(PgmCellSet cellSet) {
        this.cellSet = cellSet;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    private static int findString(String s, String target, Integer n) {
        n = n - 1;
        int idx = s.indexOf(target);
        while (idx != -1) {
            if (n == 0) {
                return idx;
            }
            idx = s.indexOf(target, idx + 1);
            n = n - 1;
        }
        return -1;
    }

    private static String strReplace(String expStr, String src, String className, boolean encrypt) {
        return ClassMaker.strReplace(expStr, src, 1, className, encrypt);
    }

    private static String strReplace(String expStr, String src, Integer n, String className, boolean encrypt) {
        int len = expStr.length();
        int idx = ClassMaker.findString(expStr, src, n);
        if (idx == -1) {
            throw new RuntimeException();
        }
        int cnt = 0;
        int end = -1;
        int i = idx + src.length();
        while (i < len) {
            char ch = expStr.charAt(i);
            if (ch == ')') {
                if (--cnt == 0) {
                    end = i;
                    break;
                }
            } else if (ch == '(') {
                ++cnt;
            }
            ++i;
        }
        if (end == -1) {
            throw new RuntimeException();
        }
        if (encrypt) {
            String result = String.valueOf(expStr.substring(0, idx)) + "." + className + expStr.substring(end, len);
            return result;
        }
        end = idx + src.length();
        String result = String.valueOf(expStr.substring(0, idx)) + "." + className + expStr.substring(end, len);
        return result;
    }

    private static String strReplace(String expStr, String src, String className) {
        int len = expStr.length();
        int idx = expStr.indexOf(src);
        int cnt = 0;
        int end = -1;
        int i = idx + src.length();
        while (i < len) {
            char ch = expStr.charAt(i);
            if (ch == ')') {
                if (cnt == 0) {
                    end = i;
                    break;
                }
                --cnt;
            } else if (ch == '(') {
                ++cnt;
            }
            ++i;
        }
        if (end == -1) {
            throw new RuntimeException();
        }
        end = idx + src.length();
        String result = String.valueOf(expStr.substring(0, idx)) + className + expStr.substring(end, len);
        return result;
    }

    private static long hashCode(String str) {
        char[] val = str.toCharArray();
        long h = 0L;
        int i = 0;
        while (i < str.length()) {
            h = 31L * h + (long)val[i];
            ++i;
        }
        return h & Long.MAX_VALUE;
    }

    private byte[] compileClass(String className, String src) {
        CodeCompiler.debug = this.debug;
        return CodeCompiler.javaCodeToBytes(new String[]{className}, new String[]{src});
    }

    private byte[] compileClass(String[] classNames, String[] srcs) {
        CodeCompiler.debug = this.debug;
        return CodeCompiler.javaCodeToBytes(classNames, srcs);
    }

    public byte[] compileFunctionCalc(String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars) {
        byte[] bytecode;
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "SequenceFunc_" + hash + "_" + name;
        String fullClassName = "com.scudata.optimize.function." + className;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends SequenceFunc_XXX {", cellSet);
        cls.addImport("import java.util.Random;");
        cls.addImport("import com.scudata.expression.Calc;");
        CalcMethodMaker maker = new CalcMethodMaker("calculate(Context ctx) {", "public ", "Object ");
        maker.setCurrentVar("datas[i]");
        maker.setCurrentSeq("i");
        maker.setSeqType("SeqDefaultType");
        Node left = node.getLeft();
        Node right = node.getRight();
        if (!(right instanceof Calc)) {
            return null;
        }
        String currentVarName = MethodMaker.getVarName(left);
        maker.setCurrentVarName(currentVarName);
        Calc calc = (Calc)right;
        IParam param = calc.getParam();
        Expression exp = param.getLeafExpression();
        Expression temp = new Expression("~=null");
        temp.getHome().setRight(exp.getHome());
        try {
            maker.addExp(c, r, temp, null);
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
        maker.adjustVarType(globalVars);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        maker.setName("calculate(Context ctx) ");
        String seqType = maker.getSeqType();
        if (seqType.equals("int")) {
            maker.setSeqType("int");
            cls.addMethod(maker.finish());
        } else if (seqType.equals("long")) {
            maker.setSeqType("long");
            cls.addMethod(maker.finish());
        } else if (seqType.equals("double")) {
            maker.setSeqType("double");
            cls.addMethod(maker.finish());
        } else {
            return null;
        }
        String clsStr = cls.finish();
        if (this.debug) {
            System.out.println(clsStr);
        }
        if ((bytecode = this.compileClass(fullClassName, clsStr)) != null) {
            cell.setExpString(ClassMaker.strReplace(expStr, ".(", className, this.encrypt));
        }
        return bytecode;
    }

    private byte[] compileFunctionRun(String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types) {
        byte[] bytecode;
        String seqType;
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "SequenceFunc_" + hash + "_" + name;
        String fullClassName = "com.scudata.optimize.function." + className;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends SequenceFunc_XXX {", cellSet);
        cls.addMethod(RunMethodMaker.defaultRunMethod());
        RunMethodMaker maker = new RunMethodMaker("calculate(Context ctx) {", "public ", "Object ");
        maker.setCurrentVar("datas[i]");
        maker.setCurrentSeq("i");
        maker.setSeqType("SeqDefaultType");
        maker.setGlobalVars(globalVars);
        maker.setTypes(types);
        if (types != null && types.size() != 0 && types.containsKey("default")) {
            String defaultType = types.get("default");
            maker.setSeqType(defaultType);
        }
        Node left = node.getLeft();
        Node right = node.getRight();
        String currentVarName = MethodMaker.getVarName(left);
        maker.setCurrentVarName(currentVarName);
        try {
            Run run = (Run)right;
            IParam param = run.getParam();
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            Expression[] exps = pi.getExpressions1();
            Expression[] assignExps = pi.getExpressions2();
            int len = exps.length;
            int i = 0;
            while (i < len) {
                if (assignExps[i] != null) {
                    Assign ass = new Assign();
                    ass.setLeft(assignExps[i].getHome());
                    ass.setRight(exps[i].getHome());
                    maker.addExp(c, r, new Expression((Node)ass), expStr);
                } else {
                    maker.addExp(c, r, exps[i], expStr);
                }
                ++i;
            }
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
        maker.adjustVarType(globalVars);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        if ((seqType = maker.getSeqType()).equals("int")) {
            maker.setName("calculate_int(Context ctx) ");
            maker.setSeqType("int");
            cls.addMethod(maker.finish());
        } else if (seqType.equals("long")) {
            maker.setName("calculate_long(Context ctx) ");
            maker.setSeqType("long");
            cls.addMethod(maker.finish());
        } else if (seqType.equals("double")) {
            maker.setName("calculate_double(Context ctx) ");
            maker.setSeqType("double");
            cls.addMethod(maker.finish());
        } else {
            if (!this.fast) {
                return null;
            }
            maker.setName("calculate_int(Context ctx) ");
            maker.setSeqType("int");
            cls.addMethod(maker.finish());
            maker.setName("calculate_long(Context ctx) ");
            maker.setSeqType("long");
            cls.addMethod(maker.finish());
            maker.setName("calculate_double(Context ctx) ");
            maker.setSeqType("double");
            cls.addMethod(maker.finish());
        }
        String clsStr = cls.finish();
        if (this.debug) {
            System.out.println(clsStr);
        }
        if ((bytecode = this.compileClass(fullClassName, clsStr)) != null) {
            cell.setExpString(ClassMaker.strReplace(expStr, ".run", className, this.encrypt));
        }
        return bytecode;
    }

    private byte[] compileFunctionRun2(String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types) {
        byte[] bytecode;
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "SequenceFunc_" + hash + "_" + name;
        String fullClassName = "com.scudata.optimize.function." + className;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends SequenceFunc_XXX {", cellSet);
        Node left = node.getLeft();
        Node right = node.getRight();
        String currentVarName = MethodMaker.getVarName(left);
        Object obj = cellSet.getCell(currentVarName).getValue();
        if (obj != null) {
            boolean cfr_ignored_0 = obj instanceof Table;
        }
        RunMethodMaker maker = this.fast ? new RunMethodMaker2Fast((Table)obj, "calculate(Context ctx) {", "public ", "Object ", false) : new RunMethodMaker2((Table)obj, "calculate(Context ctx) {", "public ", "Object ");
        maker.setCurrentSeq("i");
        maker.setSeqType("SeqDefaultType");
        maker.setCurrentVarName(currentVarName);
        maker.setTypes(types);
        try {
            Run run = (Run)right;
            IParam param = run.getParam();
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            Expression[] exps = pi.getExpressions1();
            Expression[] assignExps = pi.getExpressions2();
            int len = exps.length;
            int i = 0;
            while (i < len) {
                if (assignExps[i] != null) {
                    Assign ass = new Assign();
                    ass.setLeft(assignExps[i].getHome());
                    ass.setRight(exps[i].getHome());
                    maker.addExp(c, r, new Expression((Node)ass), expStr);
                } else {
                    maker.addExp(c, r, exps[i], expStr);
                }
                ++i;
            }
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
        maker.adjustVarType(globalVars);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        cls.addMethod(maker.finish());
        String clsStr = cls.finish();
        if (this.debug) {
            System.out.println(clsStr);
        }
        if ((bytecode = this.compileClass(fullClassName, clsStr)) != null) {
            cell.setExpString(ClassMaker.strReplace(expStr, ".run", className, this.encrypt));
        }
        return bytecode;
    }

    private void compileFunctionRun3(String fileName, PureTable table, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, List<Object> files) {
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "RunOperation_" + hash + "_" + name;
        String className2 = "AttachRun_" + hash + "_" + name;
        String fullClassName = "com.scudata.optimize.function." + className;
        String fullClassName2 = "com.scudata.optimize.function." + className2;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends RunOperation_XXX {", cellSet);
        cls.addImport("import com.scudata.dm.*;");
        cls.addImport("import com.scudata.expression.*;");
        cls.addImport("import com.scudata.array.*;");
        cls.addImport("import com.scudata.array.LongArray;");
        cls.addImport("import com.scudata.expression.mfn.sequence.*;");
        cls.addImport("import com.scudata.pdm.*;");
        cls.addImport("import com.scudata.compile.function.*;");
        cls.addImport("import com.scudata.compile.op.*;");
        cls.addImport("import com.scudata.expression.mfn.op.AttachRun;");
        cls.addImport("import com.scudata.dm.op.*;");
        Node left = node.getLeft();
        Node right = node.getRight();
        String currentVarName = MethodMaker.getVarName(left);
        RunMethodMaker3 maker = new RunMethodMaker3(table, "process(Sequence seq, Context ctx)  {", "public ", "Sequence ");
        maker.setCurrentSeq("i");
        maker.setSeqType("SeqDefaultType");
        maker.setCurrentVarName(currentVarName);
        try {
            Run run = (Run)right;
            IParam param = run.getParam();
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            Expression[] exps = pi.getExpressions1();
            Expression[] assignExps = pi.getExpressions2();
            int len = exps.length;
            int i = 0;
            while (i < len) {
                if (assignExps[i] != null) {
                    Assign ass = new Assign();
                    ass.setLeft(assignExps[i].getHome());
                    ass.setRight(exps[i].getHome());
                    maker.addExp(c, r, new Expression((Node)ass), expStr);
                } else {
                    maker.addExp(c, r, exps[i], expStr);
                }
                ++i;
            }
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return;
        }
        maker.adjustVarType(globalVars);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        cls.addMethod(maker.finish());
        cls.addMethod(maker.constructorMethod(className));
        cls.addMethod(maker.duplicateMethod(className));
        String clsStr = cls.finish();
        byte[] bytecode = this.compileClass(fullClassName, clsStr);
        files.add(fullClassName);
        files.add(bytecode);
        String clsStr2 = "package com.scudata.optimize.function;\r\nimport com.scudata.dm.*;\r\nimport com.scudata.expression.mfn.op.AttachRun;\r\nimport " + fullClassName + ";\r\n" + "\r\npublic class " + className2 + " extends AttachRun {\r\n" + "\tpublic Object calculate(Context ctx) {\r\n" + "\t\t" + className + " run = new " + className + "();\r\n" + "\t\tif (cs != null) {\r\n" + "\t\t\trun.setCurrentCell(cs.getCurrent());\r\n" + "\t\t}\r\n" + "\t\treturn operable.addOperation(run, ctx);\r\n" + "\t}\r\n" + "}";
        if (this.debug) {
            System.out.println(clsStr);
            System.out.println(clsStr2);
        }
        byte[] bytecode2 = this.compileClass(new String[]{fullClassName, fullClassName2}, new String[]{clsStr, clsStr2});
        if (bytecode != null && bytecode2 != null) {
            cell.setExpString(ClassMaker.strReplace(expStr, ".run", className2, this.encrypt));
        }
        files.add(fullClassName2);
        files.add(bytecode2);
    }

    private Object getCursorResult(PgmCellSet cellSet, PgmNormalCell cell) {
        PgmNormalCell cell_bkup = (PgmNormalCell)cell.deepClone();
        Expression exp = cell.getExpression();
        Node node = exp.getHome();
        FakeFetch fetch = new FakeFetch();
        node.setRight((Node)fetch);
        cellSet.execute();
        int col = cell.getCol();
        int row = cell.getRow();
        cellSet.setCell(row, col, (INormalCell)cell_bkup);
        return fetch.getResult();
    }

    private void compileFunctionDerive(String fileName, PureTable table, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, List<Object> files) {
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "DeriveOperation_" + hash + "_" + name;
        String className2 = "AttachDerive_" + hash + "_" + name;
        String fullClassName = "com.scudata.optimize.function." + className;
        String fullClassName2 = "com.scudata.optimize.function." + className2;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends RunOperation_XXX {", cellSet);
        cls.addImport("import com.scudata.compile.op.*;");
        cls.addImport("import com.scudata.expression.mfn.op.AttachRun;");
        cls.addImport("import com.scudata.dm.op.*;");
        Node left = node.getLeft();
        Node right = node.getRight();
        String currentVarName = MethodMaker.getVarName(left);
        DeriveMethodMaker maker = new DeriveMethodMaker(table, "process(Sequence seq, Context ctx)  {", "public ", "Sequence ");
        maker.setCurrentSeq("i");
        maker.setSeqType("SeqDefaultType");
        maker.setCurrentVarName(currentVarName);
        try {
            Derive derive = (Derive)right;
            IParam param = derive.getParam();
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            Expression[] exps = pi.getExpressions1();
            Expression[] assignExps = pi.getExpressions2();
            int len = exps.length;
            int i = 0;
            while (i < len) {
                if (assignExps[i] != null) {
                    Assign ass = new Assign();
                    ass.setLeft(assignExps[i].getHome());
                    ass.setRight(exps[i].getHome());
                    maker.addExp(c, r, new Expression((Node)ass), expStr);
                    maker.addAssignVar(assignExps[i].getIdentifierName());
                } else {
                    maker.addExp(c, r, exps[i], expStr);
                }
                ++i;
            }
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return;
        }
        maker.adjustVarType(globalVars);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        cls.addMethod(maker.finish());
        cls.addMethod(maker.constructorMethod(className));
        cls.addMethod(maker.duplicateMethod(className));
        cls.addMethod(maker.newDataStructMethod());
        String clsStr = cls.finish();
        byte[] bytecode = this.compileClass(fullClassName, clsStr);
        files.add(fullClassName);
        files.add(bytecode);
        String clsStr2 = "package com.scudata.optimize.function;\r\nimport com.scudata.dm.*;\r\nimport com.scudata.expression.mfn.op.AttachDerive;\r\nimport " + fullClassName + ";\r\n" + "\r\npublic class " + className2 + " extends AttachDerive {\r\n" + "\tpublic Object calculate(Context ctx) {\r\n" + "\t\t" + className + " derive = new " + className + "();\r\n" + "\t\tif (cs != null) {\r\n" + "\t\t\tderive.setCurrentCell(cs.getCurrent());\r\n" + "\t\t}\r\n" + "\t\treturn operable.addOperation(derive, ctx);\r\n" + "\t}\r\n" + "}";
        if (this.debug) {
            System.out.println(clsStr);
            System.out.println(clsStr2);
        }
        byte[] bytecode2 = this.compileClass(new String[]{fullClassName, fullClassName2}, new String[]{clsStr, clsStr2});
        if (bytecode != null && bytecode2 != null) {
            cell.setExpString(ClassMaker.strReplace(expStr, ".derive", className2, this.encrypt));
        }
        files.add(fullClassName2);
        files.add(bytecode2);
    }

    /*
     * Unable to fully structure code
     */
    private void compileFunctionDerive2(FunctionInfo funcInfo, String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        hash = ClassMaker.hashCode(fileName);
        name = MethodMaker.col2varName(c, r);
        className = "DeriveFunc_" + hash + "_" + name + "_MF";
        fullClassName = "com.scudata.optimize.function." + className;
        cell = cellSet.getPgmNormalCell(r, c);
        expStr = cell.getExpString();
        cls = new ClassMaker(String.valueOf(className) + " extends SequenceDerive_XXX {", cellSet);
        cls.addImport("import com.scudata.common.*;");
        cls.addImport("import com.scudata.resources.EngineMessage;");
        left = node.getLeft();
        right = node.getRight();
        currentVarName = MethodMaker.getVarName(left);
        table = null;
        obj = null;
        try {
            obj = cellSet.getCell(currentVarName).getValue();
        }
        catch (Exception e1) {
            obj = null;
        }
        if (obj == null) {
            try {
                obj = cellSet.getContext().getParam(currentVarName).getValue();
            }
            catch (Exception e) {
                obj = left.calculate(cellSet.getContext());
            }
        }
        if (!(obj instanceof Table)) {
            throw new RuntimeException();
        }
        table = (Table)obj;
        maker = new DeriveMethodMaker(table, "calculate(Sequence seq, int start, int end, Expression []exps, DataStruct newDs, Table table, Context ctx) {", "public ", "void ");
        maker.setCurrentSeq("i");
        maker.setSeqType("SeqDefaultType");
        maker.setCurrentVarName(currentVarName);
        maker.setSequenceDerive(true);
        maker.setTypes(types);
        if (types != null && types.size() != 0 && types.containsKey("default")) {
            defaultType = types.get("default");
            maker.setSeqType(defaultType);
        }
        subClassName = new ArrayList<String>();
        subClass = new ArrayList<String>();
        try {
            derive = (Derive)right;
            param = derive.getParam();
            pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            exps = pi.getExpressions1();
            assignExps = pi.getExpressions2();
            len = exps.length;
            i = 0;
            while (i < len) {
                if (assignExps[i] != null) {
                    block25: {
                        block26: {
                            ass = new Assign();
                            ass.setLeft(assignExps[i].getHome());
                            ass.setRight(exps[i].getHome());
                            try {
                                maker.addExp(c, r, new Expression((Node)ass), expStr);
                                break block25;
                            }
                            catch (ParseNodeException e) {
                                if (funcInfo == null || funcInfo.getSubFuncs() == null) break block26;
                                funcs = funcInfo.getSubFuncs();
                                ** for (fn : funcs)
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.processFunc(fn, fileName, cellSet, node, c, r, globalVars, types, files);
                                if (!fn.isCompiled()) continue;
                                fields = fn.getFields();
                                for (String f : fields) {
                                    if (f.indexOf(".") != -1) {
                                        f2 = f.replaceAll("\\.", "__");
                                        field_ = String.valueOf(("" + f2.charAt(0)).toUpperCase()) + f2.substring(1);
                                        f = f.substring(f.indexOf(".") + 1);
                                    } else {
                                        field_ = String.valueOf(("" + f.charAt(0)).toUpperCase()) + f.substring(1);
                                    }
                                    maker.addLine3(" _" + fn.getName() + ".set" + field_ + "(" + f + ");");
                                    item = new VarItem(f);
                                    item.setType(new DataType(CompilerUtil.getType(f, globalVars, types)));
                                    item.setGlobal(false);
                                    maker.addVar(item);
                                }
                                subClassName.add(fn.getClassName());
                                subClass.add(fn.getClassStr());
                                initCode = String.valueOf(fn.getClassName()) + " _" + fn.getName() + " = (" + fn.getClassName() + ") FunctionUtil.findNodeByClass(exps[" + i + "].getHome(), " + fn.getClassName() + ".class);";
                                maker.addInitCode(initCode);
                                continue;
                            }
                        }
                        maker.addExp(i, assignExps[i].getIdentifierName());
                    }
                    maker.addAssignVar(assignExps[i].getIdentifierName());
                } else {
                    maker.addExp(c, r, exps[i], expStr);
                }
                ++i;
            }
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return;
        }
        maker.adjustVarType(globalVars);
        maker.adjustVarTypeByTip(types);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        cls.addMethod(maker.finish());
        clsStr = cls.finish();
        if (subClassName.size() == 0) {
            bytecode = this.compileClass(fullClassName, clsStr);
        } else {
            subClassName.add(fullClassName);
            subClass.add(clsStr);
            subClassNameArray = new String[subClassName.size()];
            subClassArray = new String[subClass.size()];
            subClassName.toArray(subClassNameArray);
            subClass.toArray(subClassArray);
            bytecode = this.compileClass(subClassNameArray, subClassArray);
        }
        if (bytecode != null) {
            files.add(fullClassName);
            files.add(bytecode);
            expStr = cell.getExpString();
            cell.setExpString(ClassMaker.strReplace(expStr, ".derive", className, this.encrypt));
        } else {
            files.clear();
        }
        if (this.debug) {
            System.out.println(clsStr);
        }
    }

    private void compileFunctionSelect(FunctionInfo funcInfo, String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "SelectFunc_" + hash + "_" + name + "_MF";
        String fullClassName = "com.scudata.optimize.function." + className;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends SequenceFunc_XXX {", cellSet);
        Node left = CompilerUtil.getLeftNode(node);
        Node right = node.getRight();
        String currentVarName = MethodMaker.getVarName(left);
        Table table = null;
        Object obj = null;
        try {
            obj = cellSet.getCell(currentVarName).getValue();
        }
        catch (Exception e1) {
            obj = null;
        }
        if (obj == null) {
            try {
                obj = cellSet.getContext().getParam(currentVarName).getValue();
            }
            catch (Exception e) {
                obj = left.calculate(cellSet.getContext());
            }
        }
        if (obj instanceof Table) {
            table = (Table)obj;
        }
        MethodMaker maker = this.fast ? new SelectMethodMakerFast("calculate(Context ctx) {", "public ", "Object ") : new SelectMethodMaker(table, "calculate(Context ctx) {", "public ", "Object ");
        maker.setTypes(types);
        try {
            Select select = (Select)right;
            IParam param = select.getParam();
            if (param == null || !param.isLeaf() || select.getOption() != null) {
                return;
            }
            Expression exp = param.getLeafExpression();
            maker.addExp(c, r, exp, null);
        }
        catch (ParseNodeException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return;
        }
        maker.adjustVarType(globalVars);
        maker.adjustVarTypeByTip(types);
        if (!this.fast) {
            maker.adjustVarType(cellSet);
        }
        cls.addMethod(maker.finish());
        String clsStr = cls.finish();
        byte[] bytecode = this.compileClass(fullClassName, clsStr);
        if (bytecode != null) {
            files.add(fullClassName);
            files.add(bytecode);
            expStr = cell.getExpString();
            Integer n = funcInfo.getOption() == null ? 1 : Integer.valueOf(funcInfo.getOption());
            cell.setExpString(ClassMaker.strReplace(expStr, ".select", n, className, this.encrypt));
            funcInfo.setClassName(fullClassName);
            funcInfo.setClassStr(clsStr);
            funcInfo.setCompiled(true);
        }
        if (this.debug) {
            System.out.println(clsStr);
        }
    }

    private Object getCursorDeriveResult(PgmCellSet cellSet, PgmNormalCell cell, String func) {
        PgmNormalCell cell_bkup = (PgmNormalCell)cell.deepClone();
        String expStr = cell.getExpString();
        int idx = expStr.lastIndexOf(func);
        expStr = String.valueOf(expStr.substring(0, idx)) + ".FakeFetch()";
        cell.setExpString(expStr);
        FakeFetch.setStaticResult(null);
        cellSet.execute();
        Object result = FakeFetch.getStaticResult();
        int col = cell.getCol();
        int row = cell.getRow();
        cellSet.setCell(row, col, (INormalCell)cell_bkup);
        return result;
    }

    private void compileFunctionBetween(FunctionInfo funcInfo, String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        Between bt = (Between)node;
        IParam param = bt.getParam();
        IParam sub0 = param.getSub(0);
        IParam sub1 = param.getSub(1);
        String exp = sub0.getLeafExpression().getIdentifierName();
        IParam startParam = sub1.getSub(0);
        IParam endParam = sub1.getSub(1);
        String startExp = startParam.getLeafExpression().getIdentifierName();
        String endExp = endParam.getLeafExpression().getIdentifierName();
        String type1 = CompilerUtil.getType(exp, globalVars, types);
        String type2 = CompilerUtil.getType(startExp, globalVars, types);
        String type3 = CompilerUtil.getType(endExp, globalVars, types);
        if (type1 != null && type2 != null && type3 != null && type1.equals(type2) && type1.equals(type3)) {
            PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
            String expStr = cell.getExpString();
            String opt = bt.getOption();
            String type = CompilerUtil.toJavaType(type1).getSimpleName();
            long hash = ClassMaker.hashCode(fileName);
            String name = MethodMaker.col2varName(c, r);
            String className = "BetweenFunc_" + hash + "_" + name + "_F";
            String fullClassName = "com.scudata.optimize.function." + className;
            ClassMaker cls = new ClassMaker(String.valueOf(className) + " extends Between_XXX {", cellSet);
            cls.addImport("import com.scudata.common.ObjectCache;");
            cls.addImport("import com.scudata.compile.function.Between_XXX;");
            String booleanR = opt == null || opt.indexOf(114) == -1 ? "true" : "false";
            String booleanL = opt == null || opt.indexOf(108) == -1 ? "true" : "false";
            String exp1 = "exp.calculate(ctx)";
            String exp2 = "startExp.calculate(ctx)";
            String exp3 = "endExp.calculate(ctx)";
            List<String> fields = funcInfo.getFields();
            if (fields != null) {
                if (fields.contains(exp)) {
                    exp1 = "this." + exp;
                    cls.addMethod(MethodMaker.makeFieldCode(type1, exp));
                }
                if (fields.contains(startExp)) {
                    exp2 = "this." + startExp;
                    cls.addMethod(MethodMaker.makeFieldCode(type2, startExp));
                }
                if (fields.contains(endExp)) {
                    exp3 = "this." + endExp;
                    cls.addMethod(MethodMaker.makeFieldCode(type3, endExp));
                }
            }
            MethodMaker maker = new MethodMaker("calculate(Context ctx) ", "public ", "Object ");
            maker.addLine2("Object val = " + exp1 + ";");
            maker.addLine2("Object startVal = " + exp2 + ";");
            maker.addLine2("int cmp = compare" + type + "(val, startVal);");
            if (opt == null || opt.indexOf(98) == -1) {
                maker.addLine2("\t\t\tif (cmp > 0) {\r\n\t\t\t\tObject endVal = " + exp3 + ";\r\n" + "\t\t\t\tcmp = compare" + type + "(val, endVal);\r\n" + "\t\t\t\tif (cmp < 0) {\r\n" + "\t\t\t\t\treturn Boolean.TRUE;\r\n" + "\t\t\t\t} else if (cmp == 0) {\r\n" + "\t\t\t\t\treturn Boolean.valueOf(" + booleanR + ");\r\n" + "\t\t\t\t} else {\r\n" + "\t\t\t\t\treturn Boolean.FALSE;\r\n" + "\t\t\t\t}\r\n" + "\t\t\t} else if (cmp == 0) {\r\n" + "\t\t\t\treturn Boolean.valueOf(" + booleanL + ");\r\n" + "\t\t\t} else {\r\n" + "\t\t\t\treturn Boolean.FALSE;\r\n" + "\t\t\t}");
            } else {
                maker.addLine2("\t\t\tif (cmp > 0) {\r\n\t\t\t\tObject endVal = " + exp3 + ";\r\n" + "\t\t\t\tcmp = compare" + type + "(val, endVal);\r\n" + "\t\t\t\tif (cmp < 0) {\r\n" + "\t\t\t\t\treturn ObjectCache.getInteger(0);\r\n" + "\t\t\t\t} else if (cmp == 0) {\r\n" + "\t\t\t\t\tif (option.indexOf('r') == -1) {\r\n" + "\t\t\t\t\t\treturn ObjectCache.getInteger(0);\r\n" + "\t\t\t\t\t} else {\r\n" + "\t\t\t\t\t\treturn ObjectCache.getInteger(1);\r\n" + "\t\t\t\t\t}\r\n" + "\t\t\t\t} else {\r\n" + "\t\t\t\t\treturn ObjectCache.getInteger(1);\r\n" + "\t\t\t\t}\r\n" + "\t\t\t} else if (cmp == 0) {\r\n" + "\t\t\t\tif (option.indexOf('l') == -1) {\r\n" + "\t\t\t\t\treturn ObjectCache.getInteger(0);\r\n" + "\t\t\t\t} else {\r\n" + "\t\t\t\t\treturn ObjectCache.getInteger(-1);\r\n" + "\t\t\t\t}\r\n" + "\t\t\t} else {\r\n" + "\t\t\t\treturn ObjectCache.getInteger(-1);\r\n" + "\t\t\t}");
            }
            cls.addMethod(maker.finish());
            String clsStr = cls.finish();
            byte[] bytecode = this.compileClass(fullClassName, clsStr);
            if (bytecode != null) {
                files.add(fullClassName);
                files.add(bytecode);
                cell.setExpString(ClassMaker.strReplace(expStr, funcInfo.getName(), className));
                funcInfo.setClassName(fullClassName);
                funcInfo.setClassStr(clsStr);
                funcInfo.setCompiled(true);
            }
            if (this.debug) {
                System.out.println(clsStr);
            }
        }
    }

    private void processRun(String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        long hash = ClassMaker.hashCode(fileName);
        String name = MethodMaker.col2varName(c, r);
        String className = "SequenceFunc_" + hash + "_" + name;
        String fullClassName = "com.scudata.optimize.function." + className;
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        Expression exp = cell.getExpression();
        byte type = CompilerUtil.getNodeType(node.getLeft(), types, cellSet.getContext());
        if (type == 4) {
            byte[] bytecode = this.compileFunctionRun2(fileName, cellSet, node, c, r, globalVars, types);
            if (bytecode != null) {
                files.add(fullClassName);
                files.add(bytecode);
            }
        } else if (type == 5) {
            className = "AttachRun_" + hash + "_" + name;
            fullClassName = "com.scudata.optimize.function." + className;
            PureTable table = (PureTable)((Object)this.getCursorResult(cellSet, cell));
            cell = cellSet.getPgmNormalCell(r, c);
            exp = cell.getExpression();
            this.compileFunctionRun3(fileName, table, cellSet, exp.getHome(), c, r, globalVars, files);
        } else {
            byte[] bytecode;
            if (!this.fast) {
                cellSet.execute();
            }
            if ((bytecode = this.compileFunctionRun(fileName, cellSet, node, c, r, globalVars, types)) != null) {
                files.add(fullClassName);
                files.add(bytecode);
            }
        }
    }

    private void processDis(PgmCellSet cellSet, int c, int r, List<Object> files) {
        PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
        String expStr = cell.getExpString();
        cell.setExpString(ClassMaker.strReplace(expStr, "dis(", "SequenceDistance"));
        files.add(SequenceDistance.class.getName());
        files.add(new byte[0]);
    }

    private void processDerive(FunctionInfo funcInfo, String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        byte type = CompilerUtil.getNodeType(node.getLeft(), types, cellSet.getContext());
        if (type == 4) {
            this.compileFunctionDerive2(funcInfo, fileName, cellSet, node, c, r, globalVars, types, files);
        } else if (type == 5) {
            PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
            PureTable table = (PureTable)((Object)this.getCursorDeriveResult(cellSet, cell, ".derive"));
            cell = cellSet.getPgmNormalCell(r, c);
            Expression exp = cell.getExpression();
            this.compileFunctionDerive(fileName, table, cellSet, exp.getHome(), c, r, globalVars, files);
        }
    }

    private void processSelect(FunctionInfo funcInfo, String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        byte type = CompilerUtil.getNodeType(node.getLeft(), types, cellSet.getContext());
        if (type == 4) {
            this.compileFunctionSelect(funcInfo, fileName, cellSet, node, c, r, globalVars, types, files);
        } else if (type == 5) {
            throw new RuntimeException();
        }
    }

    private void processFunc(FunctionInfo funcInfo, String fileName, PgmCellSet cellSet, Node node, int c, int r, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types, List<Object> files) {
        String func = funcInfo.getName();
        if (func.startsWith("dis")) {
            this.processDis(cellSet, c, r, files);
        } else if (func.startsWith("between")) {
            Between bt = (Between)CompilerUtil.findNodeByClass(node, Between.class);
            this.compileFunctionBetween(funcInfo, fileName, cellSet, (Node)bt, c, r, globalVars, types, files);
        } else if (func.startsWith("derive")) {
            this.processDerive(funcInfo, fileName, cellSet, node, c, r, globalVars, types, files);
        } else if (func.startsWith("select")) {
            node = CompilerUtil.findNode(node, Select.class, funcInfo);
            this.processSelect(funcInfo, fileName, cellSet, node, c, r, globalVars, types, files);
        } else if (func.startsWith("run")) {
            this.processRun(fileName, cellSet, node, c, r, globalVars, types, files);
        }
    }

    private static void parseTip(ConcurrentHashMap<String, String> types, String tip) {
        String[] lines;
        if (types == null || tip == null) {
            return;
        }
        tip = tip.replaceAll("\r", "");
        tip = tip.replaceAll("\n", "");
        String[] stringArray = lines = tip.split(";");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] subs;
            String line = stringArray[n2];
            if (line != null && !line.contains("(") && (subs = line.split(":")).length == 2 && subs[0] != null && subs[1] != null) {
                types.put(subs[0], subs[1]);
            }
            ++n2;
        }
    }

    public List<Object> compileFunctions(String fileName, PgmCellSet cellSet) {
        ArrayList<Object> files = new ArrayList<Object>();
        SplxCompiler.loadFunctions();
        ConcurrentHashMap<String, VarItem> globalVars = new ConcurrentHashMap<String, VarItem>();
        if (!this.fast) {
            CellSetUtil2.execute(cellSet);
            CompilerUtil.setGlobalVarsByCtx(globalVars, cellSet.getContext());
        }
        int col = cellSet.getColCount();
        int row = cellSet.getRowCount();
        int r = 1;
        while (r <= row) {
            int c = 1;
            while (c <= col) {
                String name = MethodMaker.col2varName(c, r);
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                Expression exp = cell.getExpression();
                String expStr = cell.getExpString();
                if (exp != null && expStr != null) {
                    Node node = exp.getHome();
                    if (this.fast && node instanceof Call && ((Call)node).getOption() != null && ((Call)node).getOption().indexOf(102) != -1) {
                        node.calculate(cellSet.getContext());
                    }
                    if (this.fast) {
                        RunMethodMaker.searchVar(node, globalVars);
                    }
                    ConcurrentHashMap<String, String> types = new ConcurrentHashMap<String, String>();
                    ClassMaker.parseTip(types, cell.getTip());
                    VarItem csvar = new VarItem(name, null, null, true);
                    csvar.setR(r);
                    csvar.setC(c);
                    globalVars.put(name, csvar);
                    List<FunctionInfo> funcs = CompilerUtil.getFuncByTip(cell.getTip());
                    if (funcs != null) {
                        for (FunctionInfo func : funcs) {
                            this.processFunc(func, fileName, cellSet, node, c, r, globalVars, types, files);
                        }
                    } else if (funcs == null) {
                        // empty if block
                    }
                }
                ++c;
            }
            ++r;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(10240);
            CellSetUtil.writePgmCellSet((OutputStream)os, (PgmCellSet)cellSet);
            os.close();
            files.add(0, os.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
        return files;
    }

    public void setClassOption(String classOption) {
        this.classOption = classOption;
    }
}

