/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.RQException;
import com.scudata.compile.AssignItem;
import com.scudata.compile.ClassInfo;
import com.scudata.compile.CodeCompiler;
import com.scudata.compile.CodeItem;
import com.scudata.compile.ConstItem;
import com.scudata.compile.CurContext;
import com.scudata.compile.CurContextItem;
import com.scudata.compile.DataType;
import com.scudata.compile.FunCodeItem;
import com.scudata.compile.FunctionInfo;
import com.scudata.compile.LineItem;
import com.scudata.compile.MacroVarItem;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.SplxCompiler;
import com.scudata.compile.StructType;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.NodeParser;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.FileObject;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.fn.Call;
import com.scudata.expression.fn.EnvSet;
import com.scudata.expression.fn.If;
import com.scudata.expression.fn.Register;
import com.scudata.expression.mfn.cursor.Fetch;
import com.scudata.expression.mfn.db.CreateCursor;
import com.scudata.expression.mfn.sequence.Select;
import com.scudata.expression.operator.DotOperator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompilerUtil {
    public static boolean printError = true;
    private static final String IMPORT_STATEMENTS = "package com.scudata.compile.runtime;\nimport java.util.Date;\nimport java.util.HashMap;\nimport com.scudata.app.common.AppUtil;\nimport com.scudata.cellset.datamodel.PgmCellSet;import com.scudata.cellset.datamodel.PgmCellSet.FuncInfo;import com.scudata.array.IArray;\nimport com.scudata.dm.Record;\nimport com.scudata.dm.*;\nimport com.scudata.dm.cursor.*;\nimport com.scudata.expression.*;\nimport com.scudata.ide.spl.Esprocx;\nimport com.scudata.util.Variant;\n";
    private static final String INIT_CODE = "\tstatic Context ctx;\r\n";

    public static void setGlobalVarsByCtx(ConcurrentHashMap<String, VarItem> globalVars, Context ctx) {
        if (globalVars == null || ctx == null) {
            return;
        }
        ParamList paramList = ctx.getParamList();
        int i = 0;
        int len = paramList.count();
        while (i < len) {
            Param param = paramList.get(i);
            String name = param.getName();
            DataType type = MethodMaker.getObjectType(param.getValue());
            globalVars.put(name, new VarItem(name, type, null));
            ++i;
        }
    }

    private static int indexOfMatch(String str, int start) {
        int end = str.length();
        int match = 0;
        int i = start;
        while (i < end) {
            char ch = str.charAt(i);
            if (ch == '(') {
                ++match;
            } else if (ch == ')') {
                if (match == 0) {
                    return i;
                }
                --match;
            }
            ++i;
        }
        throw new RuntimeException();
    }

    private static FunctionInfo parseFunc(String line) {
        if (line == null || line.length() < 2) {
            return null;
        }
        int s = line.indexOf(40);
        int e = -1;
        if (s != -1) {
            e = CompilerUtil.indexOfMatch(line, s + 1);
        }
        String funcName = line.substring(0, s);
        FunctionInfo func = new FunctionInfo(funcName);
        if ((line = line.substring(s + 1, e)).contains("(") && line.contains(")")) {
            while (line != null && line.length() > 0) {
                s = line.indexOf(40);
                if (s == -1) break;
                e = CompilerUtil.indexOfMatch(line, s + 1);
                String sub = line.substring(0, e + 1);
                FunctionInfo subFunc = CompilerUtil.parseFunc(sub);
                if (subFunc != null) {
                    subFunc.setSuperFunc(func);
                    func.addSubFunc(subFunc);
                }
                if (e + 1 < line.length()) {
                    if (line.charAt(e + 1) == ',') {
                        ++e;
                    }
                    line = line.substring(e + 1);
                    continue;
                }
                break;
            }
        } else {
            String[] fields;
            String[] stringArray = fields = line.split(",");
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                func.addFields(f);
                ++n2;
            }
        }
        return func;
    }

    public static List<FunctionInfo> getFuncByTip(String tip) {
        String[] lines;
        if (tip == null) {
            return null;
        }
        ArrayList<FunctionInfo> funcs = new ArrayList<FunctionInfo>();
        tip = tip.replaceAll("\r", "");
        tip = tip.replaceAll("\n", "");
        String[] stringArray = lines = tip.split(";");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && line.contains("(") && line.contains(")")) {
                FunctionInfo func = CompilerUtil.parseFunc(line);
                funcs.add(func);
            }
            ++n2;
        }
        if (funcs.size() == 0) {
            return null;
        }
        return funcs;
    }

    public static void parseStructType(ConcurrentHashMap<String, DataType> types, String input, NodeParser parser) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int colonIndex = input.indexOf(58);
        int braceStartIndex = input.indexOf(123);
        int braceEndIndex = input.lastIndexOf(125);
        if (colonIndex <= 0 || braceStartIndex <= colonIndex || braceEndIndex <= braceStartIndex) {
            throw new IllegalArgumentException("\u683c\u5f0f\u9519\u8bef: " + input);
        }
        String varName = input.substring(0, colonIndex).trim();
        if (varName.isEmpty()) {
            throw new IllegalArgumentException("\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String type = input.substring(colonIndex + 1, braceStartIndex).trim();
        if (type.isEmpty()) {
            throw new IllegalArgumentException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fieldsPart = input.substring(braceStartIndex + 1, braceEndIndex).trim();
        if (fieldsPart.isEmpty()) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (type.equals("Sequence") && fieldsPart.indexOf(":") == -1) {
            types.put(varName, DataType.newSequenceType(fieldsPart));
            return;
        }
        String[] fieldDefinitions = fieldsPart.split("\\s*,\\s*");
        int len = fieldDefinitions.length;
        String[] fieldNames = new String[len];
        DataType[] fieldTypes = new DataType[len];
        int i = 0;
        while (i < len) {
            String[] parts = fieldDefinitions[i].split("\\s*:\\s*");
            if (parts.length != 2 || parts[0].trim().isEmpty() || parts[1].trim().isEmpty()) {
                throw new IllegalArgumentException("\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef: " + fieldDefinitions[i]);
            }
            fieldNames[i] = parts[0].trim();
            fieldTypes[i] = new DataType(parts[1].trim());
            ++i;
        }
        StructType structType = new StructType(fieldNames, fieldTypes, parser);
        if (type.equals("BaseRecord")) {
            types.put(varName, DataType.newRecordType(structType));
        } else if (type.equals("Sequence")) {
            DataType memberType = DataType.newRecordType(structType);
            types.put(varName, DataType.newSequenceType(memberType));
        } else if (type.equals("ICursor")) {
            types.put(varName, DataType.newCursorType(structType));
        } else {
            types.put(varName, DataType.newTableType(structType));
        }
    }

    public static void parseTip(ConcurrentHashMap<String, DataType> types, String tip, NodeParser parser) {
        String[] lines;
        if (types == null || tip == null) {
            return;
        }
        tip = tip.replaceAll("\r", "");
        tip = tip.replaceAll("\n", "");
        String[] stringArray = lines = tip.split(";");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null && !line.contains("(")) {
                if (line.indexOf(123) != -1) {
                    CompilerUtil.parseStructType(types, line, parser);
                } else {
                    String[] subs = line.split(":");
                    if (subs.length == 2 && subs[0] != null && subs[1] != null) {
                        if (subs[1].equals("Table")) {
                            types.put(subs[0], DataType.newTableType());
                        } else {
                            types.put(subs[0], new DataType(subs[1]));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static byte calcExpValueType(PgmNormalCell cell, ConcurrentHashMap<String, String> types, Context ctx) {
        Object val = cell.getValue();
        if (val == null) {
            Expression exp = cell.getExpression();
            return exp == null ? (byte)101 : CompilerUtil.getNodeType(exp.getHome().getRight(), types, ctx);
        }
        if (val instanceof Table) {
            return 4;
        }
        if (val instanceof DBObject) {
            return 1;
        }
        if (val instanceof FileObject) {
            return 2;
        }
        return 101;
    }

    public static String getNodeName(Node node) {
        return MethodMaker.getVarName(node);
    }

    public static Class<?> toJavaType(String type) {
        if (type.equals("table")) {
            return Table.class;
        }
        if (type.equals("cursor")) {
            return ICursor.class;
        }
        if (type.equals("sequence")) {
            return Sequence.class;
        }
        if (type.equals("file")) {
            return FileObject.class;
        }
        if (type.equals("int") || type.equals("integer")) {
            return Integer.class;
        }
        if (type.equals("long")) {
            return Long.class;
        }
        if (type.equals("double") || type.equals("float")) {
            return Double.class;
        }
        if (type.equals("string")) {
            return String.class;
        }
        if (type.equals("bool") || type.equals("boolean")) {
            return Boolean.class;
        }
        if (type.equals("Date")) {
            return Date.class;
        }
        return null;
    }

    public static String getType(String name, ConcurrentHashMap<String, VarItem> globalVars, ConcurrentHashMap<String, String> types) {
        DataType dt;
        if (name == null) {
            return null;
        }
        if (globalVars != null && globalVars.containsKey(name) && !(dt = globalVars.get(name).getType()).getTypeName().equals("UnknownType")) {
            return dt.getTypeName();
        }
        if (types != null && types.containsKey(name)) {
            return types.get(name);
        }
        if (types != null && types.containsKey("default")) {
            return types.get("default");
        }
        return null;
    }

    public static byte getTypeByName(String name, ConcurrentHashMap<String, String> types, Context ctx) {
        if (name == null) {
            return 101;
        }
        if (types != null && types.containsKey(name)) {
            String type = types.get(name).toLowerCase();
            if (type.equals("table")) {
                return 4;
            }
            if (type.equals("cursor")) {
                return 5;
            }
            if (type.equals("sequence")) {
                return 3;
            }
            if (type.equals("file")) {
                return 2;
            }
        }
        return 101;
    }

    public static byte getNodeType(Node node, ConcurrentHashMap<String, String> types, Context ctx) {
        String nodeName;
        if (node == null) {
            return 101;
        }
        if (types != null && (nodeName = CompilerUtil.getNodeName(node)) != null && types.containsKey(nodeName)) {
            String type = types.get(nodeName).toLowerCase();
            if (type.equals("table")) {
                return 4;
            }
            if (type.equals("cursor")) {
                return 5;
            }
            if (type.equals("sequence")) {
                return 3;
            }
            if (type.equals("file")) {
                return 2;
            }
        }
        if (node instanceof Fetch) {
            return 4;
        }
        if (node instanceof CreateCursor) {
            return 5;
        }
        if (node instanceof CSVariable) {
            CSVariable csv = (CSVariable)node;
            INormalCell cell = csv.getSourceCell();
            if (cell instanceof PgmNormalCell) {
                return CompilerUtil.calcExpValueType((PgmNormalCell)cell, types, ctx);
            }
        } else if (node instanceof DotOperator) {
            return CompilerUtil.getNodeType(node.getLeft(), types, ctx);
        }
        return 101;
    }

    public static Node getLeftNode(Node node) {
        if (node == null) {
            return null;
        }
        Node left = node.getLeft();
        while (true) {
            if (left == null) {
                return null;
            }
            if (!(left instanceof DotOperator)) break;
            left = left.getLeft();
        }
        return left;
    }

    public static Node findNodeByClass(Node node, Class<?> cls) {
        Node n;
        if (node == null) {
            return null;
        }
        if (cls.isInstance(node)) {
            return node;
        }
        if (node instanceof Function) {
            Function fun = (Function)node;
            IParam param = fun.getParam();
            Expression[] exps = null;
            if (param != null) {
                ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"", (boolean)false, (boolean)false);
                Expression[] expressionArray = exps = pi.getExpressions1();
                int n2 = exps.length;
                int n3 = 0;
                while (n3 < n2) {
                    Expression exp = expressionArray[n3];
                    n = CompilerUtil.findNodeByClass(exp.getHome(), cls);
                    if (n != null) {
                        return n;
                    }
                    ++n3;
                }
            }
        }
        if ((n = CompilerUtil.findNodeByClass(node.getLeft(), cls)) != null) {
            return n;
        }
        n = CompilerUtil.findNodeByClass(node.getRight(), cls);
        if (n != null) {
            return n;
        }
        return null;
    }

    public static void findNodeByClass2(Node node, Class<?> cls, List<Node> list) {
        if (node == null) {
            return;
        }
        CompilerUtil.findNodeByClass2(node.getLeft(), cls, list);
        if (cls.isInstance(node.getRight())) {
            list.add(node);
        }
        CompilerUtil.findNodeByClass2(node.getRight(), cls, list);
        if (node instanceof Function) {
            Function fun = (Function)node;
            IParam param = fun.getParam();
            Expression[] exps = null;
            if (param != null) {
                ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"", (boolean)false, (boolean)false);
                Expression[] expressionArray = exps = pi.getExpressions1();
                int n = exps.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression exp = expressionArray[n2];
                    CompilerUtil.findNodeByClass2(exp.getHome(), cls, list);
                    ++n2;
                }
            }
        }
    }

    public static Node findNode(Node node, Class<?> cls, FunctionInfo funcInfo) {
        int idx;
        ArrayList<Node> list = new ArrayList<Node>();
        CompilerUtil.findNodeByClass2(node, Select.class, list);
        int n = idx = funcInfo.getOption() == null ? 0 : Integer.valueOf(funcInfo.getOption());
        if (list == null || list.size() == 0) {
            return node;
        }
        if (list.size() == 1 || idx == 0) {
            return (Node)list.get(0);
        }
        return (Node)list.get(idx - 1);
    }

    public static List<String> splitByAnd(String expr) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> topLevelParts = CompilerUtil.splitTopLevelAnd(expr = CompilerUtil.removeOuterParentheses(expr.trim()));
        if (topLevelParts.size() == 1) {
            result.add(expr);
        } else {
            for (String part : topLevelParts) {
                result.addAll(CompilerUtil.splitByAnd(part));
            }
        }
        return result;
    }

    private static List<String> splitTopLevelAnd(String expr) {
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        int depth = 0;
        int i = 0;
        while (i < expr.length()) {
            char c = expr.charAt(i);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            } else if (c == '&' && i < expr.length() - 1 && expr.charAt(i + 1) == '&' && depth == 0) {
                parts.add(expr.substring(start, i).trim());
                start = i + 2;
                ++i;
            }
            ++i;
        }
        parts.add(expr.substring(start).trim());
        return parts;
    }

    private static String removeOuterParentheses(String expr) {
        while (expr.startsWith("(") && expr.endsWith(")") && CompilerUtil.isWrappedInParentheses(expr)) {
            expr = expr.substring(1, expr.length() - 1).trim();
        }
        return expr;
    }

    private static boolean isWrappedInParentheses(String expr) {
        int depth = 0;
        int i = 0;
        while (i < expr.length()) {
            char c = expr.charAt(i);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            }
            if (depth == 0 && i != expr.length() - 1) {
                return false;
            }
            ++i;
        }
        return depth == 0;
    }

    public static Set<String> extractVariables(String expression) {
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        String regex = "\\b([A-Za-z_]\\w*)\\b(?![\\s.]*\\.)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    private static CodeItem makeFor(NodeParser nparser) {
        nparser.pushCurContext(new CurContext());
        return new LineItem("for(;;){");
    }

    private static CodeItem makeFor(CodeItem item, NodeParser nparser, String cellName) throws ParseNodeException {
        if (item.getType().isType("Sequence")) {
            int seq = nparser.getConstPool().generateNextId();
            String curStr = cellName;
            VarItem curVar = new VarItem(curStr, item.getType().getMemberType());
            nparser.addVar(curVar);
            String seqName = item.toString();
            String init = "";
            if (!(item instanceof VarItem)) {
                seqName = "seq__" + seq;
                init = String.format("Sequence %s = %s;", seqName, item.toString());
            }
            String idxStr = "i__" + seq;
            String lenStr = "len__" + seq;
            String line = String.valueOf(String.format("for (int %s = 1, %s = %s == null ? 0 : %s.length(); %s <= %s; %s++) { ", idxStr, lenStr, seqName, seqName, idxStr, lenStr, idxStr)) + System.lineSeparator();
            String memberTypeStr = item.getType().getMemberType().getTypeName();
            String line2 = String.format("%s = (%s)(%s.get(%s))", curStr, memberTypeStr, seqName, idxStr);
            DataType memberType = item.type.getMemberType();
            CurContext cur = CurContext.newSequenceCurItem(cellName, seqName, curStr, idxStr, memberType);
            nparser.pushCurContext(cur);
            return new LineItem(String.valueOf(init) + line + line2);
        }
        if (item.getType().isType("int") || item.getType().isType("Integer")) {
            String curStr = cellName;
            VarItem curVar = new VarItem(curStr, DataType.IntType);
            nparser.addVar(curVar);
            int seq = nparser.getConstPool().generateNextId();
            String idxStr = curStr;
            String lenStr = "len__" + seq;
            String lenInit = String.valueOf(lenStr) + " = " + item;
            String start = "1";
            if (item.getPreItem() != null) {
                start = item.getPreItem().toString();
            }
            VarItem lenVar = new VarItem(lenStr, DataType.IntType);
            nparser.addVar(lenVar);
            String line = String.format("for (%s = %s, %s; %s <= %s; %s++) { ", idxStr, start, lenInit, idxStr, lenStr, idxStr);
            CurContext cur = new CurContext();
            cur.iStr = idxStr;
            nparser.pushCurContext(cur);
            return new LineItem(line);
        }
        if (item.getType().isType("boolean")) {
            nparser.pushCurContext(new CurContext());
            return new LineItem("for(;" + item + ";){");
        }
        if (item.getType().isType("Table")) {
            int seq = nparser.getConstPool().generateNextId();
            String tableStr = item.toString();
            String init = "";
            if (!(item instanceof VarItem)) {
                tableStr = "table__" + seq;
                init = String.format("Table %s = %s;", tableStr, item.toString());
            }
            String curStr = cellName;
            String idxStr = "i__" + seq;
            StructType structType = item.getType().getStructType();
            CurContext cur = CurContext.newTableCurItem(cellName, tableStr, curStr, idxStr, structType);
            nparser.pushCurContext(cur);
            return new CurContextItem(init, cur, nparser);
        }
        throw new ParseNodeException(item.toString());
    }

    private static DataType calcReturnType(DataType type, DataType newType) {
        if (type == null) {
            return newType;
        }
        if (newType == null) {
            return type;
        }
        if (type.isType("UnknownType")) {
            return newType;
        }
        if (newType.isType("UnknownType")) {
            return type;
        }
        if (type.equalTo(newType)) {
            if (type.getMemberType() == null) {
                return newType;
            }
            if (newType.getMemberType() == null) {
                return type;
            }
            if (!type.getMemberType().equalTo(newType.getMemberType())) {
                type = new DataType(type.getTypeName());
                type.setMemberType(DataType.ObjectType);
                return type;
            }
            return type;
        }
        if (type.isType("Object")) {
            return newType;
        }
        if (newType.isType("Object")) {
            return type;
        }
        return DataType.ObjectType;
    }

    public static boolean checkParentheses(String str) {
        if (str == null || str.length() < 2) {
            return false;
        }
        if (str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
            return false;
        }
        int parenthesesCount = 1;
        int i = 1;
        while (i < str.length() - 1) {
            char c = str.charAt(i);
            if (c == '(') {
                ++parenthesesCount;
            } else if (c == ')') {
                --parenthesesCount;
            }
            if (parenthesesCount == 0) {
                return false;
            }
            ++i;
        }
        return parenthesesCount == 1;
    }

    public static String handleParentheses(String str) {
        if (CompilerUtil.checkParentheses(str)) {
            return str;
        }
        return "(" + str + ")";
    }

    private static CodeItem toBoolItem(CodeItem item) {
        if (item.getType().isType("boolean")) {
            return item;
        }
        return new LineItem("Variant.isTrue(" + item + ")", DataType.BooleanType);
    }

    public static FunCodeItem compilePgmCellSet(PgmCellSet cellSet, int row, int col, int endRow, NodeParser parser) {
        int i;
        PgmNormalCell cell;
        int colCount = cellSet.getColCount();
        ArrayList<CodeItem> items = new ArrayList<CodeItem>();
        ArrayList<PgmNormalCell> lineCells = new ArrayList<PgmNormalCell>();
        DataType returnType = null;
        DataType lastType = null;
        Stack<Integer> ifStack = new Stack<Integer>();
        Stack<Integer> forStack = new Stack<Integer>();
        ConcurrentHashMap<String, DataType> types = parser.getTypes();
        try {
            for (Map.Entry<String, DataType> entry : types.entrySet()) {
                String name = entry.getKey();
                DataType type = entry.getValue();
                VarItem item = new VarItem(name, type);
                if (!parser.isDFX) {
                    item.setParamVar(true);
                }
                parser.addVar(item);
            }
        }
        catch (ParseNodeException e) {
            throw new RQException((Throwable)e);
        }
        int r = row;
        block5: while (r <= endRow) {
            int c = col;
            while (c <= colCount) {
                cell = (PgmNormalCell)cellSet.getCell(r, c);
                if (cell.isNoteBlock()) {
                    int endr = cellSet.getCodeBlockEndRow(r, c);
                    if ((r = endr) <= endRow) break;
                    break block5;
                }
                if (!cell.isBlankCell() && !cell.isNoteCell()) {
                    Command cmd = null;
                    if (cell.isCommandCell() && (cmd = cell.getCommand()) != null && cmd.getType() == 8) {
                        int endr = cellSet.getFuncEndRow(cell.getRow(), cell.getCol());
                        r = endr;
                        if (r <= endRow) break;
                        break block5;
                    }
                    Expression exp = cell.getExpression();
                    String expStr = cell.getExpString();
                    if (exp != null || !expStr.equals("\n")) {
                        CodeItem item;
                        if (!forStack.empty()) {
                            while (!forStack.empty() && c <= (Integer)forStack.peek()) {
                                item = new LineItem("}");
                                items.add(item);
                                lineCells.add(null);
                                forStack.pop();
                                parser.popCurContext();
                            }
                        }
                        if (!ifStack.empty()) {
                            while (!ifStack.empty() && c <= (Integer)ifStack.peek()) {
                                item = new LineItem("}");
                                items.add(item);
                                lineCells.add(null);
                                ifStack.pop();
                            }
                        }
                        if (exp == null && expStr.equals("for") && cmd != null && cmd.getType() == 4) {
                            item = CompilerUtil.makeFor(parser);
                            items.add(item);
                            lineCells.add(null);
                            forStack.push(c);
                        }
                        if (cmd != null && cmd.getType() == 6) {
                            item = new LineItem("break");
                            items.add(item);
                            lineCells.add(null);
                        } else {
                            if (cmd != null && cmd.getType() == 17) {
                                String info = String.valueOf(cellSet.getName()) + " " + NodeParser.col2varName(c, r);
                                if (printError) {
                                    System.out.println(info);
                                }
                                throw new RQException("The goto syntax is not supported");
                            }
                            if (cmd != null && cmd.getType() == 5) {
                                String line = "continue";
                                String lct = cmd.getLocation();
                                if (lct != null) {
                                    line = "continue L_" + lct;
                                    int i2 = 0;
                                    int len = items.size();
                                    while (i2 < len) {
                                        PgmNormalCell lineCell = (PgmNormalCell)lineCells.get(i2);
                                        String cellName = NodeParser.col2varName(lineCell.getCol(), lineCell.getRow());
                                        if (cellName.equals(lct)) {
                                            CodeItem it = (CodeItem)items.get(i2);
                                            LineItem newItem = new LineItem(" L_" + lct + ": \n" + it.toString());
                                            it.setPreItem(newItem);
                                            items.set(i2, newItem);
                                            break;
                                        }
                                        ++i2;
                                    }
                                }
                                LineItem item2 = new LineItem(line);
                                items.add(item2);
                                lineCells.add(null);
                            } else if (cmd != null && cmd.getType() == 8) {
                                int endr = cellSet.getFuncEndRow(cell.getRow(), cell.getCol());
                                r = endr + 1;
                                c = col;
                                if (r > endRow) {
                                    break block5;
                                }
                            } else if (cmd != null && cmd.getType() == 2) {
                                item = new LineItem(" else {");
                                items.add(item);
                                lineCells.add(null);
                                ifStack.push(c);
                            } else {
                                if (cell.getValue() != null && expStr != null) {
                                    Object val = cell.getValue();
                                    if (val instanceof String) {
                                        expStr = NodeParser.toMacroString(expStr);
                                    }
                                    exp = new Expression(String.valueOf(NodeParser.col2varName(c, r)) + "=" + expStr);
                                }
                                if (expStr.equals("null")) {
                                    exp = new Expression(String.valueOf(NodeParser.col2varName(c, r)) + "= null");
                                }
                                try {
                                    if (exp == null && cmd != null && expStr != null) {
                                        exp = cmd.getExpression((ICellSet)cellSet, cellSet.getContext());
                                        expStr = cmd.getExpression();
                                    }
                                    if (exp != null && expStr != null) {
                                        item = parser.compileNode(exp.getHome(), cell);
                                        if (cmd != null) {
                                            Object line;
                                            byte cmdType = cmd.getType();
                                            if (cmdType == 4) {
                                                Expression[] exps = cmd.getExpressions((ICellSet)cellSet, cellSet.getContext());
                                                if (exps != null && exps.length == 2) {
                                                    CodeItem item2 = parser.compileNode(exps[1].getHome(), cell);
                                                    item2.setPreItem(item);
                                                    item = item2;
                                                }
                                                item = CompilerUtil.makeFor(item, parser, NodeParser.col2varName(c, r));
                                                forStack.push(c);
                                            } else if (cmdType == 1) {
                                                line = String.format("if %s {", CompilerUtil.handleParentheses(CompilerUtil.toBoolItem(item).toString()));
                                                item = new LineItem((String)line);
                                                ifStack.push(c);
                                            } else if (cmdType == 3) {
                                                line = String.format("else if %s {", CompilerUtil.handleParentheses(CompilerUtil.toBoolItem(item).toString()));
                                                item = new LineItem((String)line);
                                                ifStack.push(c);
                                            } else if (cmdType == 9) {
                                                line = String.format("return %s", item.cast());
                                                item = new LineItem((String)line, item.getType());
                                                returnType = CompilerUtil.calcReturnType(returnType, item.getType());
                                            }
                                        }
                                        if (item.getPreItems() != null && item.getPreItems().size() > 0) {
                                            for (CodeItem citem : item.getPreItems()) {
                                                items.add(citem);
                                                lineCells.add(null);
                                            }
                                        }
                                        items.add(item);
                                        lineCells.add(cell);
                                        lastType = item.getType();
                                        if (cell.isCalculableCell() && !item.getType().isType("void")) {
                                            String varname = NodeParser.col2varName(c, r);
                                            VarItem var = new VarItem(varname, item.getType(), null, true);
                                            parser.addVar(var);
                                            parser.setVarType(varname, var.getType());
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    String info = String.valueOf(cellSet.getName()) + " " + NodeParser.col2varName(c, r) + " error: " + exp;
                                    if (printError) {
                                        System.out.println(info);
                                    }
                                    if (SplxCompiler.debug) {
                                        e.printStackTrace();
                                    }
                                    throw new RQException((Throwable)e);
                                }
                            }
                        }
                    }
                }
                ++c;
            }
            ++r;
        }
        if (!ifStack.empty()) {
            i = 0;
            int size = ifStack.size();
            while (i < size) {
                LineItem item = new LineItem("}");
                items.add(item);
                lineCells.add(null);
                ++i;
            }
        }
        if (!forStack.empty()) {
            i = 0;
            int size = forStack.size();
            while (i < size) {
                LineItem item = new LineItem("}");
                items.add(item);
                lineCells.add(null);
                ++i;
            }
        }
        ArrayList<String> lines = new ArrayList<String>(items.size());
        for (CodeItem item : items) {
            lines.add(item.toString());
        }
        HashMap<String, VarItem> localVars = parser.getVars();
        HashMap<String, CodeItem> funCodeMap = parser.getFunCodeMap();
        int size = lines.size();
        int i3 = 0;
        while (i3 < size - 1) {
            CodeItem item;
            cell = (PgmNormalCell)lineCells.get(i3);
            if (cell != null && !(item = (CodeItem)items.get(i3)).getType().isType("void")) {
                int c = cell.getCol();
                int r2 = cell.getRow();
                if (cell.isCalculableCell()) {
                    String cellName = NodeParser.col2varName(c, r2);
                    VarItem var = parser.findVar(cellName);
                    if (var == null) {
                        var = new VarItem(cellName, item.getType(), null, true);
                    }
                    boolean isIf = cell.getExpression().getHome() instanceof If;
                    boolean isUsed = true;
                    boolean isConst = item instanceof ConstItem;
                    if (isIf || isUsed || isConst) {
                        if (isIf && !isUsed) {
                            var.type = DataType.ObjectType;
                        }
                        if (item instanceof AssignItem) {
                            items.set(i3, item);
                            String line = String.valueOf(item.toString()) + ";" + cellName + "=" + ((AssignItem)item).getLeft();
                            lines.set(i3, line);
                        } else {
                            item = new AssignItem(var, item);
                            items.set(i3, item);
                            lines.set(i3, item.toString());
                        }
                    }
                }
            }
            ++i3;
        }
        if (localVars.size() != 0) {
            ArrayList<Map.Entry<String, VarItem>> entries = new ArrayList<Map.Entry<String, VarItem>>(localVars.entrySet());
            Collections.reverse(entries);
            for (Map.Entry<String, VarItem> entry : entries) {
                String name = entry.getKey();
                VarItem item = entry.getValue();
                if (item.isStatic()) {
                    LineItem lineitem = new LineItem(String.format("private static %s %s;", item.getType(), name));
                    funCodeMap.put(name, lineitem);
                    continue;
                }
                if (item.isParamVar() || item instanceof MacroVarItem) continue;
                if (item.getInitValue() == null) {
                    lines.add(0, String.format("%s %s", item.getType(), name));
                    continue;
                }
                lines.add(0, String.format("%s %s %s", item.getType(), name, item.getInitValue()));
            }
        }
        returnType = CompilerUtil.calcReturnType(returnType, lastType);
        return new FunCodeItem(lines, returnType);
    }

    private static void searchPCSFunction(PgmCellSet cellSet, HashMap<String, PgmCellSet.FuncInfo> result, List<VarItem> globalVars, boolean add) {
        if (add) {
            HashMap map = cellSet.getFunctionMap();
            result.putAll(map);
        }
        Context ctx = cellSet.getContext();
        int col = cellSet.getColCount();
        int row = cellSet.getRowCount();
        int r = 1;
        while (r <= row) {
            int c = 1;
            while (c <= col) {
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                if (!(cell.isBlankCell() || cell.isNoteBlock() || cell.isNoteCell())) {
                    if (cell.getCommand() != null && cell.getCommand().getType() == 8) {
                        int endr = cellSet.getFuncEndRow(cell.getRow(), cell.getCol());
                        r = endr + 1;
                        c = col;
                    } else {
                        Expression exp = cell.getExpression();
                        String expStr = cell.getExpString();
                        if (exp != null && expStr != null) {
                            EnvSet envSet;
                            Node node = exp.getHome();
                            if (node instanceof Call) {
                                PgmCellSet pcs = ((Call)node).getCallPgmCellSet(ctx);
                                String option = ((Call)node).getOption();
                                boolean fopt = option != null && option.indexOf(102) != -1;
                                CompilerUtil.searchPCSFunction(pcs, result, globalVars, fopt);
                            }
                            if (node instanceof EnvSet && (envSet = (EnvSet)node).getParam() != null && envSet.getParam().getSubSize() == 2) {
                                String name = envSet.getParam().getSub(0).getLeafExpression().toString();
                                NodeParser parser = new NodeParser();
                                Node home = envSet.getParam().getSub(1).getLeafExpression().getHome();
                                try {
                                    CodeItem item = parser.compileNode(home, cell);
                                    globalVars.add(new VarItem(name, item.getType()));
                                }
                                catch (ParseNodeException e) {
                                    e.printStackTrace();
                                }
                            }
                            boolean cfr_ignored_0 = node instanceof Register;
                        }
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public static CodeItem processPgmCellSet(PgmCellSet cellSet, NodeParser parser, List<VarItem> paramVars) {
        int endrow = cellSet.getRowCount();
        PgmNormalCell cell = cellSet.getPgmNormalCell(1, 1);
        ConcurrentHashMap<String, DataType> types = new ConcurrentHashMap<String, DataType>();
        CompilerUtil.parseTip(types, cell.getTip(), parser);
        parser.setTypes(types);
        if (paramVars == null) {
            ParamList paramList = cellSet.getParamList();
            if (paramList != null) {
                int i = 0;
                while (i < paramList.count()) {
                    Param param = paramList.get(i);
                    VarItem var = new VarItem(param.getName(), NodeParser.getObjectType(param.getValue()));
                    try {
                        if (types.get(var.toString()) != null) {
                            var.setType(types.get(var.toString()));
                            String init = "=" + parser.parse((Node)new Constant(param.getValue())).toString();
                            var.setInitValue(init);
                        }
                        parser.addVar(var);
                    }
                    catch (ParseNodeException init) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        } else {
            for (VarItem var : paramVars) {
                var.setParamVar(true);
                try {
                    parser.addVar(var);
                }
                catch (ParseNodeException param) {
                    // empty catch block
                }
            }
        }
        FunCodeItem fci = CompilerUtil.compilePgmCellSet(cellSet, 1, 1, endrow, parser);
        List<String> lines = fci.getLines();
        DataType returnType = fci.getType();
        StringBuilder result = new StringBuilder();
        int size = lines.size();
        int i = 0;
        while (i < size - 1) {
            String line = lines.get(i);
            if (line.length() != 0) {
                result.append(line);
                if (!line.startsWith("}") && !line.endsWith("{")) {
                    result.append(";");
                }
            }
            ++i;
        }
        String lastLine = lines.get(size - 1).trim();
        if (!lastLine.equals("}")) {
            if (lastLine.startsWith("return")) {
                result.append(lastLine);
            } else {
                result.append("return ").append(lastLine);
            }
            result.append(";");
        } else {
            result.append(lastLine);
        }
        return new LineItem(result.toString(), returnType);
    }

    private static long hashCode(String str) {
        char[] val = str.toCharArray();
        long h = 0L;
        int i = 0;
        while (i < str.length()) {
            h = 31L * h + (long)val[i];
            ++i;
        }
        return h & Long.MAX_VALUE;
    }

    private static String getFileNameWithoutExtension(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return "";
        }
        Path path = Paths.get(filePath, new String[0]);
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static boolean hasMacroParam(PgmCellSet.FuncInfo func) {
        String[] args = func.getArgNames();
        if (args == null || args.length == 0) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (func.isMacroArg(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String makeGlobalFunc(HashMap<String, CodeItem> funCodeMap, String code) {
        int count;
        int size = funCodeMap.size();
        if (size == 0) {
            return "";
        }
        String funcsLine = "";
        do {
            count = 0;
            Iterator<Map.Entry<String, CodeItem>> iterator = funCodeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, CodeItem> entry = iterator.next();
                if (!(entry.getValue() instanceof LineItem) || code.indexOf(entry.getKey()) == -1 && funcsLine.indexOf(entry.getKey()) == -1) continue;
                funcsLine = String.valueOf(funcsLine) + entry.getValue().toString() + System.lineSeparator();
                iterator.remove();
                ++count;
            }
        } while (count != 0);
        return funcsLine;
    }

    private static String makeGlobalConst(List<LineItem> constVars, String code1, String code2) {
        int count;
        int size = constVars.size();
        if (size == 0) {
            return "";
        }
        String constLine = "";
        do {
            count = 0;
            Iterator<LineItem> iterator = constVars.iterator();
            while (iterator.hasNext()) {
                LineItem item = iterator.next();
                String varName = item.toString().split(" ")[4];
                if (code1.indexOf(varName) == -1 && code2.indexOf(varName) == -1 && constLine.indexOf(varName) == -1) continue;
                constLine = item + ";" + System.lineSeparator() + constLine;
                iterator.remove();
                ++count;
            }
        } while (count != 0);
        return constLine;
    }

    public static ClassInfo compileSplx(PgmCellSet cellSet) {
        NodeParser parser = new NodeParser();
        HashMap<String, CodeItem> funCodeMap = parser.getFunCodeMap();
        HashMap<String, PgmCellSet.FuncInfo> funMap = new HashMap<String, PgmCellSet.FuncInfo>();
        ArrayList<VarItem> globalVars = new ArrayList<VarItem>();
        CompilerUtil.searchPCSFunction(cellSet, funMap, globalVars, true);
        for (VarItem varItem : globalVars) {
            try {
                varItem.setStatic(true);
                parser.addVar(varItem);
            }
            catch (ParseNodeException parseNodeException) {
                // empty catch block
            }
        }
        for (Map.Entry entry : funMap.entrySet()) {
            PgmCellSet.FuncInfo func = (PgmCellSet.FuncInfo)entry.getValue();
            if (func == null) continue;
            String opt = func.getOption();
            if (opt != null && opt.indexOf("m") != -1) {
                funCodeMap.put((String)entry.getKey(), new FunCodeItem(func));
                continue;
            }
            if (CompilerUtil.hasMacroParam(func)) {
                funCodeMap.put((String)entry.getKey(), new FunCodeItem(func));
                continue;
            }
            if (func.getCell().getTip() == null) {
                funCodeMap.put((String)entry.getKey(), new FunCodeItem(func));
                continue;
            }
            if (func.getCell().getTip() != null && func.getCell().getTip().indexOf("skip") != -1) {
                funCodeMap.put((String)entry.getKey(), new FunCodeItem(func));
                continue;
            }
            funCodeMap.put((String)entry.getKey(), new FunCodeItem(func));
        }
        parser.isDFX = true;
        CodeItem codeItem = CompilerUtil.processPgmCellSet(cellSet, parser, null);
        if (codeItem != null) {
            String fullClassName;
            byte[] buf;
            String cls = "SplxRunner_" + CompilerUtil.getFileNameWithoutExtension(cellSet.getName()) + "_" + CompilerUtil.hashCode(cellSet.getName());
            String initStr = "Context ctx = FunctionExecutor.ctx;" + cls + ".ctx = ctx;";
            String codeStr = String.valueOf(initStr) + System.lineSeparator() + codeItem;
            String funcsLine = CompilerUtil.makeGlobalFunc(funCodeMap, codeStr);
            String constLine = CompilerUtil.makeGlobalConst(parser.getConstPool().getConstVars(), codeStr, funcsLine);
            codeStr = String.format("public class %s {%spublic static Object run() {%s}%s%s%s}", cls, INIT_CODE + System.lineSeparator(), codeStr, System.lineSeparator(), constLine, funcsLine);
            codeStr = IMPORT_STATEMENTS + System.lineSeparator() + codeStr;
            if (SplxCompiler.debug) {
                System.out.println(codeStr);
            }
            if ((buf = CodeCompiler.javaCodeToBytes(new String[]{fullClassName = "com.scudata.compile.runtime." + cls}, new String[]{codeStr})) == null) {
                return null;
            }
            return new ClassInfo(buf, fullClassName);
        }
        return null;
    }
}

