/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.VarItem;

public class MacroVarItem
extends VarItem {
    private String value;

    public MacroVarItem(String name, String value, DataType type) {
        super(name, type);
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public DataType getType() {
        if (this.type == null && this.relatedVar != null) {
            return this.relatedVar.getType();
        }
        return this.type;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        throw new RuntimeException();
    }

    @Override
    public boolean isParamVar() {
        return false;
    }

    @Override
    public void setParamVar(boolean isParamVar) {
    }

    @Override
    public boolean isAssigned() {
        return false;
    }

    @Override
    public void setAssigned(boolean isAssigned) {
        throw new RuntimeException();
    }

    @Override
    public void refCountIncrease() {
        throw new RuntimeException();
    }

    @Override
    public CodeItem makeAssign(CodeItem value) throws ParseNodeException {
        throw new RuntimeException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacroVarItem varItem = (MacroVarItem)o;
        return varItem.value.equals(this.value);
    }

    @Override
    public CodeItem cast() {
        return this;
    }

    @Override
    public CodeItem cast(String type) {
        if (!this.type.isType(type)) {
            return new LineItem("(" + type + ")" + this.value, new DataType(type));
        }
        return this;
    }
}

