/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.IColCell;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.IRowCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.ColCell;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.cellset.datamodel.RowCell;
import com.scudata.cellset.datamodel.SqlCommand;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import com.scudata.common.DBSession;
import com.scudata.common.IRecord;
import com.scudata.common.Logger;
import com.scudata.common.MD5;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.Timer;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.FileObject;
import com.scudata.dm.IQueryable;
import com.scudata.dm.JobSpace;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Machines;
import com.scudata.dm.ParallelCaller;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.RetryException;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.Channel;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.ParamParser;
import com.scudata.expression.fn.Func;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.CursorLooper;
import com.scudata.thread.Job;
import com.scudata.thread.ThreadPool;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class PgmCellSet2
extends PgmCellSet {
    public static final int PRIVILEGE_FULL = 0;
    public static final int PRIVILEGE_EXEC = 1;
    private static final int SIGN_AUTOCALC = 16;
    private int sign = 0;
    private ByteMap customPropMap;
    private String pswHash;
    private int nullPswPrivilege = 1;
    private transient int curPrivilege = 0;
    protected transient CellLocation curLct;
    private transient Object curDb;
    private transient LinkedList<CmdCode> stack = new LinkedList();
    private transient CellLocation parseLct;
    private transient Sequence resultValue;
    private transient int resultCurrent;
    private transient CellLocation resultLct;
    private transient boolean interrupt;
    private transient boolean isInterrupted;
    private transient boolean hasReturn = false;
    private transient String name;
    private transient HashMap<String, PgmCellSet.FuncInfo> fnMap;
    private transient ForkCmdCode forkCmdCode;
    private String isvHash;
    private long[][] times;
    private Timer timer;

    public PgmCellSet2() {
    }

    public PgmCellSet2(int row, int col) {
        super(row, col);
        this.initTimes();
    }

    public NormalCell newCell(int r, int c) {
        return new PgmNormalCell((CellSet)this, r, c);
    }

    public RowCell newRowCell(int r) {
        return new RowCell(r);
    }

    public ColCell newColCell(int c) {
        return new ColCell(c);
    }

    public PgmNormalCell getPgmNormalCell(int row, int col) {
        return (PgmNormalCell)this.cellMatrix.get(row, col);
    }

    public INormalCell getCurrent() {
        return this.curLct == null ? null : this.getNormalCell(this.curLct.getRow(), this.curLct.getCol());
    }

    public void setCurrent(INormalCell cell) {
        if (cell == null) {
            this.curLct = null;
        } else if (this.curLct == null) {
            this.curLct = new CellLocation(cell.getRow(), cell.getCol());
        } else {
            this.curLct.set(cell.getRow(), cell.getCol());
        }
    }

    public PgmCellSet2 newCalc() {
        Matrix m2;
        Matrix m1 = this.cellMatrix;
        int colSize = this.cellMatrix.getColSize();
        int rowSize = this.cellMatrix.getRowSize();
        PgmCellSet2 pcs = new PgmCellSet2();
        pcs.cellMatrix = m2 = new Matrix(rowSize, colSize);
        int r = 0;
        while (r < rowSize) {
            int c = 0;
            while (c < colSize) {
                m2.set(r, c, m1.get(r, c));
                ++c;
            }
            ++r;
        }
        pcs.sign = this.sign;
        pcs.pswHash = this.pswHash;
        pcs.nullPswPrivilege = this.nullPswPrivilege;
        Context ctx = this.getContext();
        pcs.setContext(ctx.newComputeContext());
        pcs.name = this.name;
        return pcs;
    }

    public PgmCellSet2 newCursorDFX(INormalCell cell, Object[] args) {
        Object val;
        int c;
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        PgmCellSet2 newPcs = new PgmCellSet2(rowCount, colCount);
        int row = cell.getRow();
        int col = cell.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        int r = 1;
        while (r < row) {
            c = 1;
            while (c <= colCount) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
                ++c;
            }
            ++r;
        }
        r = endRow + 1;
        while (r <= rowCount) {
            c = 1;
            while (c <= colCount) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
                ++c;
            }
            ++r;
        }
        r = row;
        while (r <= endRow) {
            c = 1;
            while (c < col) {
                val = this.getPgmNormalCell(r, c).getValue();
                newPcs.getPgmNormalCell(r, c).setValue(val);
                ++c;
            }
            c = col;
            while (c <= colCount) {
                INormalCell tmp = this.getCell(r, c);
                INormalCell cellClone = (INormalCell)tmp.deepClone();
                cellClone.setCellSet((ICellSet)newPcs);
                newPcs.setCell(r, c, cellClone);
                ++c;
            }
            ++r;
        }
        if (args != null) {
            int paramRow = row;
            int paramCol = col;
            int i = 0;
            int pcount = args.length;
            while (i < pcount) {
                newPcs.getPgmNormalCell(paramRow, paramCol).setValue(args[i]);
                if (paramCol >= colCount) break;
                ++paramCol;
                ++i;
            }
        }
        newPcs.setContext(this.getContext());
        newPcs.setCurrent(cell);
        newPcs.setNext(row, col + 1, false);
        newPcs.name = this.name;
        return newPcs;
    }

    public Object deepClone() {
        PgmCellSet2 pcs = new PgmCellSet2();
        int colSize = this.cellMatrix.getColSize();
        int rowSize = this.cellMatrix.getRowSize();
        pcs.cellMatrix = new Matrix(rowSize, colSize);
        int col = 1;
        while (col < colSize) {
            int row = 1;
            while (row < rowSize) {
                INormalCell cell = this.getCell(row, col);
                INormalCell cellClone = (INormalCell)cell.deepClone();
                cellClone.setCellSet((ICellSet)pcs);
                pcs.cellMatrix.set(row, col, (Object)cellClone);
                ++row;
            }
            ++col;
        }
        col = 1;
        while (col < colSize) {
            pcs.cellMatrix.set(0, col, this.getColCell(col).deepClone());
            ++col;
        }
        int row = 1;
        while (row < rowSize) {
            pcs.cellMatrix.set(row, 0, this.getRowCell(row).deepClone());
            ++row;
        }
        ParamList param = this.getParamList();
        if (param != null) {
            pcs.setParamList((ParamList)param.deepClone());
        }
        pcs.sign = this.sign;
        if (this.customPropMap != null) {
            pcs.customPropMap = (ByteMap)this.customPropMap.deepClone();
        }
        pcs.pswHash = this.pswHash;
        pcs.nullPswPrivilege = this.nullPswPrivilege;
        pcs.name = this.name;
        return pcs;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(2);
        out.writeInt(this.sign);
        out.writeObject(this.customPropMap);
        out.writeObject(this.pswHash);
        out.writeInt(this.nullPswPrivilege);
        out.writeObject(this.name);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte v = in.readByte();
        this.sign = in.readInt();
        this.customPropMap = (ByteMap)in.readObject();
        this.pswHash = (String)in.readObject();
        this.nullPswPrivilege = in.readInt();
        if (v > 1) {
            this.name = (String)in.readObject();
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        out.writeInt(rowCount);
        out.writeInt(colCount);
        int row = 1;
        while (row <= rowCount) {
            IRowCell rc = this.getRowCell(row);
            out.writeRecord((IRecord)rc);
            ++row;
        }
        int col = 1;
        while (col <= colCount) {
            IColCell cc = this.getColCell(col);
            out.writeRecord((IRecord)cc);
            ++col;
        }
        row = 1;
        while (row <= rowCount) {
            int col2 = 1;
            while (col2 <= colCount) {
                INormalCell nc = this.getCell(row, col2);
                out.writeRecord((IRecord)nc);
                ++col2;
            }
            ++row;
        }
        out.writeRecord((IRecord)this.paramList);
        out.writeInt(this.sign);
        out.writeRecord((IRecord)this.customPropMap);
        out.writeStrings(null);
        out.writeInt(0);
        out.writeString(this.pswHash);
        out.writeInt(this.nullPswPrivilege);
        this.isvHash = null;
        out.writeString(this.isvHash);
        return out.toByteArray();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        int rowCount = in.readInt();
        int colCount = in.readInt();
        this.cellMatrix = new Matrix(rowCount + 1, colCount + 1);
        int row = 1;
        while (row <= rowCount) {
            RowCell rc = (RowCell)in.readRecord((IRecord)this.newRowCell(row));
            this.cellMatrix.set(row, 0, (Object)rc);
            ++row;
        }
        int col = 1;
        while (col <= colCount) {
            ColCell cc = (ColCell)in.readRecord((IRecord)this.newColCell(col));
            this.cellMatrix.set(0, col, (Object)cc);
            ++col;
        }
        row = 1;
        while (row <= rowCount) {
            int col2 = 1;
            while (col2 <= colCount) {
                NormalCell nc = (NormalCell)in.readRecord((IRecord)this.newCell(row, col2));
                this.cellMatrix.set(row, col2, (Object)nc);
                ++col2;
            }
            ++row;
        }
        this.paramList = (ParamList)in.readRecord((IRecord)new ParamList());
        this.sign = in.readInt();
        this.customPropMap = (ByteMap)in.readRecord((IRecord)new ByteMap());
        if (in.available() > 0) {
            in.readStrings();
            if (in.available() > 0) {
                in.readInt();
                if (in.available() > 0) {
                    this.pswHash = in.readString();
                    this.nullPswPrivilege = in.readInt();
                    if (in.available() > 0) {
                        this.isvHash = in.readString();
                    }
                }
            }
        }
    }

    private void skipCodeBlock() {
        int curRow = this.curLct.getRow();
        int curCol = this.curLct.getCol();
        int endBlock = this.getCodeBlockEndRow(curRow, curCol);
        this.setNext(endBlock + 1, 1, true);
    }

    private void toElseCmd() {
        Command command;
        int curRow = this.curLct.getRow();
        int curCol = this.curLct.getCol();
        int totalCol = this.getColCount();
        int level = 0;
        int c = curCol + 1;
        while (c <= totalCol) {
            PgmNormalCell cell = this.getPgmNormalCell(curRow, c);
            command = cell.getCommand();
            if (command != null) {
                byte type = command.getType();
                if (type == 2) {
                    if (level == 0) {
                        this.setNext(curRow, c + 1, false);
                        return;
                    }
                    --level;
                } else if (type == 3) {
                    if (level == 0) {
                        this.setNext(curRow, c, false);
                        this.runIfCmd((NormalCell)cell, command);
                        return;
                    }
                } else if (type == 1) {
                    ++level;
                }
            }
            ++c;
        }
        int endBlock = this.getCodeBlockEndRow(curRow, curCol);
        int nextRow = endBlock + 1;
        if (nextRow <= this.getRowCount()) {
            int c2 = 1;
            while (c2 <= totalCol) {
                PgmNormalCell cell = this.getPgmNormalCell(nextRow, c2);
                if (!cell.isBlankCell()) {
                    if (c2 != curCol) {
                        this.setNext(nextRow, c2, true);
                    } else {
                        command = cell.getCommand();
                        if (command == null) {
                            this.setNext(nextRow, c2, true);
                        } else {
                            byte type = command.getType();
                            if (type == 2) {
                                this.setNext(nextRow, c2 + 1, false);
                            } else if (type == 3) {
                                this.setNext(nextRow, c2, false);
                                this.runIfCmd((NormalCell)cell, command);
                            } else {
                                this.setNext(nextRow, c2, true);
                            }
                        }
                    }
                    return;
                }
                ++c2;
            }
        } else {
            this.setNext(nextRow, 1, true);
        }
    }

    private int getIfBlockEndRow(int prow, int pcol) {
        int totalRow;
        Command command;
        int level = 0;
        int totalCol = this.getColCount();
        int c = pcol + 1;
        while (c <= totalCol) {
            PgmNormalCell cell = this.getPgmNormalCell(prow, c);
            command = cell.getCommand();
            if (command != null) {
                byte type = command.getType();
                if (type == 2) {
                    if (level == 0) {
                        return prow;
                    }
                    --level;
                } else if (type == 3) {
                    if (level == 0) {
                        return prow;
                    }
                } else if (type == 1) {
                    ++level;
                }
            }
            ++c;
        }
        int endBlock = this.getCodeBlockEndRow(prow, pcol);
        if (endBlock < (totalRow = this.getRowCount())) {
            int nextRow = endBlock + 1;
            int c2 = 1;
            while (c2 <= totalCol) {
                PgmNormalCell cell = this.getPgmNormalCell(nextRow, c2);
                if (!cell.isBlankCell()) {
                    command = cell.getCommand();
                    if (command == null) {
                        return endBlock;
                    }
                    byte type = command.getType();
                    if (type == 2) {
                        return this.getCodeBlockEndRow(nextRow, c2);
                    }
                    if (type == 3) {
                        return this.getIfBlockEndRow(nextRow, c2);
                    }
                    return endBlock;
                }
                ++c2;
            }
            throw new RuntimeException();
        }
        return endBlock;
    }

    private void runIfCmd(NormalCell cell, Command command) {
        Context ctx = this.getContext();
        Expression exp = command.getExpression((ICellSet)this, ctx);
        if (exp == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("if" + mm.getMessage("function.invalidParam"));
        }
        Object value = exp.calculate(ctx);
        cell.setValue(value);
        if (Variant.isTrue((Object)value)) {
            this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
        } else {
            this.toElseCmd();
        }
    }

    public int getForCellRepeatSeq(int r, int c) {
        int i = 0;
        while (i < this.stack.size()) {
            CmdCode cmd = this.stack.get(i);
            if (cmd.row == r && cmd.col == c) {
                if (cmd.type != 4) break;
                return ((ForCmdCode)cmd).getSeq();
            }
            ++i;
        }
        if (this.forkCmdCode != null && this.forkCmdCode.row == r && this.forkCmdCode.col == c) {
            return this.forkCmdCode.seq;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("#" + CellLocation.getCellId((int)r, (int)c) + mm.getMessage("engine.needInFor"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runForCmd(NormalCell cell, Command command) {
        ForCmdCode cmdCode;
        CmdCode cmd;
        int row = this.curLct.getRow();
        int col = this.curLct.getCol();
        if (this.stack.size() > 0 && (cmd = this.stack.getFirst()) != null && cmd.row == row && cmd.col == col) {
            ForCmdCode forCmd = (ForCmdCode)cmd;
            if (forCmd.hasNextValue()) {
                cell.setValue(forCmd.nextValue());
                this.setNext(row, col + 1, false);
                return;
            }
            cell.setValue(forCmd.endValue());
            this.stack.removeFirst();
            this.setNext(cmd.blockEndRow + 1, 1, true);
            return;
        }
        Context ctx = this.getContext();
        int endRow = this.getCodeBlockEndRow(row, col);
        Expression exp = command.getExpression((ICellSet)this, ctx);
        if (exp == null) {
            cmdCode = new EndlessForCmdCode(row, col, endRow);
        } else {
            Object value = exp.calculate(ctx);
            if (value instanceof Number) {
                IParam param = command.getParam((ICellSet)this, ctx);
                if (param.isLeaf()) {
                    cmdCode = new IntForCmdCode(row, col, endRow, 1, ((Number)value).intValue(), 1);
                } else {
                    int step;
                    int size = param.getSubSize();
                    if (size > 3) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("for" + mm.getMessage("function.invalidParam"));
                    }
                    IParam sub = param.getSub(1);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("for" + mm.getMessage("function.invalidParam"));
                    }
                    Object obj = sub.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.forVarTypeError"));
                    }
                    int start = ((Number)value).intValue();
                    int end = ((Number)obj).intValue();
                    if (size > 2) {
                        sub = param.getSub(2);
                        if (sub == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        obj = sub.getLeafExpression().calculate(ctx);
                        if (!(obj instanceof Number)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.forVarTypeError"));
                        }
                        step = ((Number)obj).intValue();
                    } else {
                        step = start <= end ? 1 : -1;
                    }
                    cmdCode = new IntForCmdCode(row, col, endRow, start, end, step);
                }
            } else if (value instanceof Sequence) {
                cmdCode = new SequenceForCmdCode(row, col, endRow, (Sequence)value);
            } else {
                if (value instanceof Boolean) {
                    cell.setValue(value);
                    if (((Boolean)value).booleanValue()) {
                        cmdCode = new BoolForCmdCode(row, col, endRow, exp, ctx);
                        cmdCode.setSeq(1);
                        this.stack.addFirst(cmdCode);
                        this.setNext(row, col + 1, false);
                        return;
                    }
                    this.setNext(endRow + 1, 1, true);
                    return;
                }
                if (value instanceof ICursor) {
                    IParam param = command.getParam((ICellSet)this, ctx);
                    int count = 1;
                    Expression gexp = null;
                    if (param.getType() == ';') {
                        if (param.getSubSize() != 2) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        IParam sub = param.getSub(1);
                        if (sub == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        if (!sub.isLeaf()) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        gexp = sub.getLeafExpression();
                    } else if (!param.isLeaf()) {
                        if (param.getSubSize() != 2) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("for" + mm.getMessage("function.invalidParam"));
                        }
                        IParam sub = param.getSub(1);
                        if (sub != null) {
                            Object countObj = sub.getLeafExpression().calculate(ctx);
                            if (!(countObj instanceof Number)) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException(mm.getMessage("engine.forVarTypeError"));
                            }
                            count = ((Number)countObj).intValue();
                            if (count < 1) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("for" + mm.getMessage("function.invalidParam"));
                            }
                        }
                    }
                    cmdCode = new CursorForCmdCode(row, col, endRow, (ICursor)value, count, gexp, ctx);
                } else {
                    if (value != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.forVarTypeError"));
                    }
                    cmdCode = null;
                }
            }
        }
        if (cmdCode != null && cmdCode.hasNextValue()) {
            cell.setValue(cmdCode.nextValue());
            this.stack.addFirst(cmdCode);
            this.setNext(row, col + 1, false);
            return;
        }
        this.setNext(endRow + 1, 1, true);
    }

    private void runContinueCmd(Command command) {
        CellLocation forLct = command.getCellLocation(this.getContext());
        int index = -1;
        int i = 0;
        int size = this.stack.size();
        while (i < size) {
            CmdCode cmd = this.stack.get(i);
            if (cmd.type == 4 && (forLct == null || forLct.getRow() == cmd.row && forLct.getCol() == cmd.col)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("next" + mm.getMessage("engine.needInFor"));
        }
        i = 0;
        while (i < index) {
            CmdCode cmd = this.stack.removeFirst();
            if (cmd.type == 4) {
                this.endForCommand((ForCmdCode)cmd);
            }
            ++i;
        }
        CmdCode cmd = this.stack.getFirst();
        this.setNext(cmd.row, cmd.col, false);
    }

    private void runBreakCmd(Command command) {
        CellLocation forLct = command.getCellLocation(this.getContext());
        int index = -1;
        int i = 0;
        int size = this.stack.size();
        while (i < size) {
            CmdCode cmd = this.stack.get(i);
            if (cmd.type == 4 && (forLct == null || forLct.getRow() == cmd.row && forLct.getCol() == cmd.col)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("break" + mm.getMessage("engine.needInFor"));
        }
        i = 0;
        while (i < index) {
            CmdCode cmd = this.stack.removeFirst();
            if (cmd.type == 4) {
                this.endForCommand((ForCmdCode)cmd);
            }
            ++i;
        }
        CmdCode cmd = this.stack.removeFirst();
        this.endForCommand((ForCmdCode)cmd);
        this.setNext(cmd.blockEndRow + 1, 1, true);
    }

    private void runGotoCmd(Command command) {
        CellLocation lct = command.getCellLocation(this.getContext());
        if (lct == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(command.getLocation()) + mm.getMessage("cellset.cellNotExist"));
        }
        int r = lct.getRow();
        int c = lct.getCol();
        int index = -1;
        int i = 0;
        int size = this.stack.size();
        while (i < size) {
            CmdCode cmd = this.stack.get(i);
            if (r > cmd.blockEndRow || r < cmd.row) {
                index = i;
            } else {
                if (c > cmd.col) break;
                if (r == cmd.row) {
                    index = i;
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("cellset.invalidGotoCell"));
                }
            }
            ++i;
        }
        i = 0;
        while (i <= index) {
            CmdCode cmd = this.stack.removeFirst();
            if (cmd.type == 4) {
                this.endForCommand((ForCmdCode)cmd);
            }
            ++i;
        }
        this.setNext(r, c, false);
    }

    private void endForCommand(ForCmdCode cmd) {
        if (cmd instanceof CursorForCmdCode) {
            ((CursorForCmdCode)cmd).close();
        }
    }

    private PgmCellSet2 newForkPgmCellSet(int row, int col, int endRow, Context ctx, boolean isLocal) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        PgmCellSet2 pcs = new PgmCellSet2(rowCount, colCount);
        if (isLocal) {
            int r = 1;
            while (r <= rowCount) {
                int c = 1;
                while (c <= colCount) {
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    PgmNormalCell newCell = pcs.getPgmNormalCell(r, c);
                    newCell.setExpString(cell.getExpString());
                    newCell.setValue(cell.getValue());
                    ++c;
                }
                ++r;
            }
            pcs.setContext(ctx.newComputeContext());
        } else {
            ParamList usedParams = new ParamList();
            ArrayList usedCells = new ArrayList();
            int r = row;
            while (r <= endRow) {
                int c = col + 1;
                while (c <= colCount) {
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    cell.getUsedParamsAndCells(usedParams, usedCells);
                    PgmNormalCell newCell = pcs.getPgmNormalCell(r, c);
                    newCell.setExpString(cell.getExpString());
                    ++c;
                }
                ++r;
            }
            pcs.setParamList(usedParams);
            for (INormalCell cell : usedCells) {
                int r2 = cell.getRow();
                int c = cell.getCol();
                if (r2 >= row && r2 <= endRow && c >= col) continue;
                pcs.getPgmNormalCell(r2, c).setValue(cell.getValue());
            }
        }
        pcs.name = this.name;
        return pcs;
    }

    private void executeFork(int row, int col, int endRow) {
        this.curLct = new CellLocation(row, col);
        this.setNext(row, col + 1, false);
        CellLocation lct = this.curLct;
        if (lct == null || lct.getRow() > endRow) {
            return;
        }
        while ((lct = this.runNext2()) != null && lct.getRow() <= endRow && this.resultValue == null) {
        }
        if (this.resultValue == null) {
            int colCount = this.getColCount();
            int r = endRow;
            while (r >= row) {
                int c = colCount;
                while (c > col) {
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    if (cell.isCalculableCell() || cell.isCalculableBlock()) {
                        Object val = cell.getValue();
                        this.resultValue = new Sequence(1);
                        this.resultValue.add(val);
                        return;
                    }
                    --c;
                }
                --r;
            }
        }
    }

    private Object getForkResult() {
        if (this.resultValue != null) {
            if (this.resultValue.length() == 0) {
                return null;
            }
            if (this.resultValue.length() == 1) {
                return this.resultValue.get(1);
            }
            return this.resultValue;
        }
        return null;
    }

    private boolean isNextCommandBlock(int prevEndRow, int col, byte cmdType) {
        int totalRowCount = this.getRowCount();
        if (prevEndRow == totalRowCount) {
            return false;
        }
        int nextRow = prevEndRow + 1;
        PgmNormalCell cell = this.getPgmNormalCell(nextRow, col);
        Command nextCommand = cell.getCommand();
        if (nextCommand == null || nextCommand.getType() != cmdType) {
            return false;
        }
        int c = 1;
        while (c < col) {
            cell = this.getPgmNormalCell(nextRow, c);
            if (!cell.isBlankCell()) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private void runForkCmd(Command command, Context ctx) {
        int row = this.curLct.getRow();
        int col = this.curLct.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        IParam param = command.getParam((ICellSet)this, ctx);
        if (!this.isNextCommandBlock(endRow, col, (byte)15)) {
            this.runForkCmd(param, row, col, endRow, ctx);
        } else {
            ArrayList<SubForkJob> list = new ArrayList<SubForkJob>();
            while (true) {
                SubForkJob job = new SubForkJob(param, row, col, endRow, ctx);
                list.add(job);
                if (!this.isNextCommandBlock(endRow, col, (byte)15)) break;
                row = endRow + 1;
                endRow = this.getCodeBlockEndRow(row, col);
                PgmNormalCell cell = this.getPgmNormalCell(row, col);
                command = cell.getCommand();
                param = command.getParam((ICellSet)this, ctx);
            }
            ThreadPool pool = ThreadPool.newInstance((int)list.size());
            try {
                for (SubForkJob job : list) {
                    pool.submit((Job)job);
                }
                for (SubForkJob job : list) {
                    job.join();
                }
            }
            finally {
                pool.shutdown();
            }
        }
        this.setNext(endRow + 1, 1, true);
    }

    private void runForkxCmd(IParam param, int row, int col, int endRow, Context ctx) {
        JobSpace js;
        Command command;
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("fork" + mm.getMessage("function.invalidParam"));
        }
        IParam leftParam = param.getSub(0);
        IParam rightParam = param.getSub(1);
        if (rightParam == null || !rightParam.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("fork" + mm.getMessage("function.invalidParam"));
        }
        Machines mc = new Machines();
        Object hostObj = rightParam.getLeafExpression().calculate(ctx);
        if (!mc.set(hostObj)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("callx" + mm.getMessage("function.invalidParam"));
        }
        String[] hosts = mc.getHosts();
        int[] ports = mc.getPorts();
        int mcount = -1;
        Object[] args = null;
        if (leftParam != null) {
            if (leftParam.isLeaf()) {
                Object val = leftParam.getLeafExpression().calculate(ctx);
                if (val instanceof Sequence) {
                    int len = ((Sequence)val).length();
                    if (len == 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                    }
                    mcount = len;
                }
                args = new Object[]{val};
            } else {
                int pcount = leftParam.getSubSize();
                args = new Object[pcount];
                int p = 0;
                while (p < pcount) {
                    IParam sub = leftParam.getSub(p);
                    if (sub != null) {
                        args[p] = sub.getLeafExpression().calculate(ctx);
                        if (args[p] instanceof Sequence) {
                            int len = ((Sequence)args[p]).length();
                            if (len == 0) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                            }
                            if (mcount == -1) {
                                mcount = len;
                            } else if (mcount != len) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("fork" + mm.getMessage("function.paramCountNotMatch"));
                            }
                        }
                    }
                    ++p;
                }
            }
        }
        PgmCellSet2 pcs = this.newForkPgmCellSet(row, col, endRow, ctx, false);
        ParallelCaller caller = new ParallelCaller((Object)pcs, hosts, ports);
        caller.setContext(ctx);
        int nextRow = endRow + 1;
        if (nextRow <= this.getRowCount() && (command = this.getPgmNormalCell(nextRow, col).getCommand()) != null && command.getType() == 16) {
            int reduceEndRow = this.getCodeBlockEndRow(nextRow, col);
            PgmCellSet2 reduce = this.newForkPgmCellSet(nextRow, col, reduceEndRow, ctx, false);
            caller.setReduce((Object)reduce, new CellLocation(row, col), new CellLocation(nextRow, col));
        }
        if (args != null) {
            String pname = "tmp_fork_param";
            ParamList pl = pcs.getParamList();
            if (pl == null) {
                pl = new ParamList();
                pcs.setParamList(pl);
            }
            pl.add(0, new Param("tmp_fork_param", 0, null));
            pcs.getPgmNormalCell(row, col).setExpString("=tmp_fork_param");
            if (mcount == -1) {
                mcount = 1;
            }
            int pcount = args.length;
            int i = 1;
            while (i <= mcount) {
                ArrayList<Object> list = new ArrayList<Object>(1);
                if (pcount == 1) {
                    if (args[0] instanceof Sequence) {
                        Sequence sequence = (Sequence)args[0];
                        list.add(sequence.get(i));
                    } else {
                        list.add(args[0]);
                    }
                } else {
                    Sequence seq = new Sequence(pcount);
                    list.add(seq);
                    int p = 0;
                    while (p < pcount) {
                        if (args[p] instanceof Sequence) {
                            Sequence sequence = (Sequence)args[p];
                            seq.add(sequence.get(i));
                        } else {
                            seq.add(args[p]);
                        }
                        ++p;
                    }
                }
                caller.addCall(list);
                ++i;
            }
        }
        if ((js = ctx.getJobSpace()) != null) {
            caller.setJobSpaceId(js.getID());
        }
        Object result = caller.execute();
        this.getPgmNormalCell(row, col).setValue(result);
    }

    private void runForkCmd(IParam param, int row, int col, int endRow, Context ctx) {
        Object[] args;
        if (param == null) {
            args = new Object[1];
        } else {
            if (param.getType() == ';') {
                this.runForkxCmd(param, row, col, endRow, ctx);
                return;
            }
            if (param.isLeaf()) {
                Object val = param.getLeafExpression().calculate(ctx);
                if (val instanceof MultipathCursors) {
                    Object[] cursors = ((MultipathCursors)val).getParallelCursors();
                    val = new Sequence(cursors);
                }
                args = new Object[]{val};
            } else {
                int pcount = param.getSubSize();
                args = new Object[pcount];
                int i = 0;
                while (i < pcount) {
                    IParam sub = param.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                    }
                    args[i] = sub.getLeafExpression().calculate(ctx);
                    ++i;
                }
            }
        }
        int pcount = args.length;
        int mcount = -1;
        int i = 0;
        while (i < pcount) {
            if (args[i] instanceof Sequence) {
                int len = ((Sequence)args[i]).length();
                if (len == 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("fork" + mm.getMessage("function.invalidParam"));
                }
                if (mcount == -1) {
                    mcount = len;
                } else if (mcount != len) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("fork" + mm.getMessage("function.paramCountNotMatch"));
                }
            }
            ++i;
        }
        if (mcount == -1) {
            mcount = 1;
        }
        ForkJob[] jobs = new ForkJob[mcount];
        Sequence result = new Sequence(mcount);
        ThreadPool pool = ThreadPool.newInstance((int)mcount);
        PgmCellSet2[] pcss = new PgmCellSet2[mcount];
        try {
            int i2 = 0;
            while (i2 < mcount) {
                Object val;
                PgmCellSet2 pcs;
                pcss[i2] = pcs = this.newForkPgmCellSet(row, col, endRow, ctx, true);
                pcs.forkCmdCode = new ForkCmdCode(row, col, endRow, i2 + 1);
                Context newCtx = pcs.getContext();
                if (pcount == 1) {
                    val = args[0] instanceof Sequence ? ((Sequence)args[0]).get(i2 + 1) : args[0];
                    if (val instanceof ICursor) {
                        ((ICursor)val).setContext(newCtx);
                    }
                } else {
                    Sequence seq;
                    val = seq = new Sequence(pcount);
                    int p = 0;
                    while (p < pcount) {
                        if (args[p] instanceof Sequence) {
                            Object mem = ((Sequence)args[p]).get(i2 + 1);
                            seq.add(mem);
                            if (mem instanceof ICursor) {
                                ((ICursor)mem).setContext(newCtx);
                            }
                        } else {
                            seq.add(args[p]);
                            if (args[p] instanceof ICursor) {
                                ((ICursor)args[p]).setContext(newCtx);
                            }
                        }
                        ++p;
                    }
                }
                pcs.getPgmNormalCell(row, col).setValue(val);
                jobs[i2] = new ForkJob(pcs, row, col, endRow);
                pool.submit((Job)jobs[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < mcount) {
                jobs[i2].join();
                result.add(jobs[i2].getResult());
                this.conjTimes(pcss[i2].times);
                ++i2;
            }
        }
        finally {
            pool.shutdown();
        }
        this.getPgmNormalCell(row, col).setValue((Object)result);
    }

    private void runChannelCmd(Command command, Context ctx) {
        IParam param = command.getParam((ICellSet)this, ctx);
        if (param == null || !param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("channel" + mm.getMessage("function.invalidParam"));
        }
        Object obj = param.getLeafExpression().calculate(ctx);
        if (!(obj instanceof ICursor)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("channel" + mm.getMessage("function.paramTypeError"));
        }
        ICursor cs = (ICursor)obj;
        CellLocation curLct = this.curLct;
        int row = curLct.getRow();
        int col = curLct.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        ArrayList<PgmNormalCell> cellList = new ArrayList<PgmNormalCell>();
        PgmNormalCell cell = this.getPgmNormalCell(row, col);
        Channel channel = cs.newChannel(ctx, false);
        cell.setValue((Object)channel);
        cellList.add(cell);
        this.setNext(row, col + 1, false);
        while ((curLct = this.runNext2()) != null && curLct.getRow() <= endRow) {
        }
        channel.addPushToCursor(cs);
        while (this.isNextCommandBlock(endRow, col, (byte)18)) {
            row = endRow + 1;
            cell = this.getPgmNormalCell(row, col);
            if (cell.getCommand().getParam((ICellSet)this, ctx) != null) break;
            endRow = this.getCodeBlockEndRow(row, col);
            channel = cs.newChannel(ctx, false);
            cell.setValue((Object)channel);
            cellList.add(cell);
            this.setNext(row, col + 1, false);
            while ((curLct = this.runNext2()) != null && curLct.getRow() <= endRow) {
            }
            channel.addPushToCursor(cs);
        }
        if (cs instanceof MultipathCursors) {
            MultipathCursors mcs = (MultipathCursors)cs;
            ICursor[] cursors = mcs.getCursors();
            int csCount = cursors.length;
            ThreadPool pool = ThreadPool.newInstance((int)csCount);
            try {
                CursorLooper[] loopers = new CursorLooper[csCount];
                int i = 0;
                while (i < csCount) {
                    loopers[i] = new CursorLooper(cursors[i]);
                    pool.submit((Job)loopers[i]);
                    ++i;
                }
                CursorLooper[] cursorLooperArray = loopers;
                int n = loopers.length;
                int n2 = 0;
                while (n2 < n) {
                    CursorLooper looper = cursorLooperArray[n2];
                    looper.join();
                    ++n2;
                }
            }
            finally {
                pool.shutdown();
            }
        } else {
            Sequence src;
            while ((src = cs.fuzzyFetch(ICursor.FETCHCOUNT)) != null && src.length() != 0) {
            }
        }
        for (PgmNormalCell chCell : cellList) {
            channel = (Channel)chCell.getValue();
            chCell.setValue(channel.result());
        }
        this.setNext(endRow + 1, 1, true);
    }

    private void runReturnCmd(Command command) {
        this.hasReturn = true;
        Context ctx = this.getContext();
        Expression[] exps = command.getExpressions((ICellSet)this, ctx);
        int count = exps.length;
        this.resultValue = new Sequence(count);
        int i = 0;
        while (i < count) {
            if (exps[i] == null) {
                this.resultValue.add(null);
            } else {
                Object obj = exps[i].calculate(ctx);
                this.resultValue.add(obj);
            }
            ++i;
        }
        int r = this.curLct.getRow();
        int c = this.curLct.getCol();
        this.getCell(r, c).setValue((Object)this.resultValue);
        this.resultLct = new CellLocation(r, c);
        this.setNext(r, c + 1, false);
    }

    private void runSqlCmd(NormalCell cell, SqlCommand command) {
        Object val;
        Object dbObj;
        Context ctx = this.getContext();
        Expression dbExp = command.getDbExpression((ICellSet)this, ctx);
        if (dbExp != null) {
            if (command.isLogicSql()) {
                dbObj = FileObject.createSimpleQuery();
                this.curDb = dbObj;
            } else {
                Object obj = dbExp.calculate(ctx);
                if (!(obj instanceof DBObject) && !(obj instanceof IQueryable)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(command.getDb()) + mm.getMessage("engine.dbsfNotExist"));
                }
                dbObj = obj;
                this.curDb = dbObj;
            }
        } else if (this.curDb == null) {
            DBSession dbs = ctx.getDBSession();
            if (dbs == null) {
                dbObj = FileObject.createSimpleQuery();
                this.curDb = dbObj;
            } else {
                dbObj = new DBObject(dbs);
                this.curDb = dbObj;
            }
        } else {
            dbObj = this.curDb;
        }
        String sql = command.getSql();
        if (sql == null) {
            this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
            return;
        }
        IParam param = command.getParam((ICellSet)this, ctx);
        Object[] paramVals = null;
        byte[] types = null;
        if (param != null) {
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"SQL command", (boolean)true, (boolean)false);
            paramVals = pi.getValues1(ctx);
            Object[] typeObjs = pi.getValues2(ctx);
            int count = typeObjs.length;
            types = new byte[count];
            int i = 0;
            while (i < count) {
                if (typeObjs[i] != null) {
                    if (!(typeObjs[i] instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("SQL command" + mm.getMessage("function.paramTypeError"));
                    }
                    types[i] = ((Number)typeObjs[i]).byteValue();
                }
                ++i;
            }
        }
        if (dbObj instanceof DBObject) {
            String opt = command.getOption();
            val = command.isQuery() ? (opt == null || opt.indexOf(49) == -1 ? ((DBObject)dbObj).query(sql, paramVals, types, opt, ctx) : ((DBObject)dbObj).query1(sql, paramVals, types, opt)) : ((DBObject)dbObj).execute(sql, paramVals, types, opt);
        } else {
            val = ((IQueryable)dbObj).query(sql, paramVals, (ICellSet)this, ctx);
        }
        cell.setValue(val);
        this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
    }

    private void runTryCmd(NormalCell cell, Command command) {
        int row = cell.getRow();
        int col = cell.getCol();
        int endRow = this.getCodeBlockEndRow(row, col);
        CmdCode cmdCode = new CmdCode(19, row, col, endRow);
        this.stack.addFirst(cmdCode);
        this.setNext(row, col + 1, false);
    }

    private void clearArea(IParam startParam, IParam endParam, Context ctx) {
        int bottom;
        int right;
        if (startParam == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("clear" + mm.getMessage("function.invalidParam"));
        }
        INormalCell startCell = startParam.getLeafExpression().calculateCell(ctx);
        if (startCell == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("clear" + mm.getMessage("function.invalidParam"));
        }
        ICellSet cs = startCell.getCellSet();
        int left = startCell.getCol();
        int top = startCell.getRow();
        if (endParam == null) {
            right = this.getColCount();
            bottom = this.getCodeBlockEndRow(top, left);
        } else {
            INormalCell endCell = endParam.getLeafExpression().calculateCell(ctx);
            if (endCell == null || endCell.getCellSet() != cs) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("clear" + mm.getMessage("function.invalidParam"));
            }
            right = endCell.getCol();
            bottom = endCell.getRow();
        }
        if (top <= bottom) {
            if (left <= right) {
                int r = top;
                while (r <= bottom) {
                    int c = left;
                    while (c <= right) {
                        cs.getCell(r, c).clear();
                        ++c;
                    }
                    ++r;
                }
            } else {
                int r = top;
                while (r <= bottom) {
                    int c = left;
                    while (c >= right) {
                        cs.getCell(r, c).clear();
                        --c;
                    }
                    ++r;
                }
            }
        } else if (left <= right) {
            int r = top;
            while (r >= bottom) {
                int c = left;
                while (c <= right) {
                    cs.getCell(r, c).clear();
                    ++c;
                }
                --r;
            }
        } else {
            int r = top;
            while (r >= bottom) {
                int c = left;
                while (c >= right) {
                    cs.getCell(r, c).clear();
                    --c;
                }
                --r;
            }
        }
    }

    private void runClearCmd(Command command) {
        Context ctx = this.getContext();
        IParam param = command.getParam((ICellSet)this, ctx);
        if (param != null) {
            if (param.isLeaf()) {
                INormalCell cell = param.getLeafExpression().calculateCell(ctx);
                if (cell == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("[]" + mm.getMessage("function.invalidParam"));
                }
                cell.clear();
            } else if (param.getType() == ',') {
                int size = param.getSubSize();
                int i = 0;
                while (i < size) {
                    IParam sub = param.getSub(i);
                    if (sub != null) {
                        if (sub.isLeaf()) {
                            INormalCell cell = sub.getLeafExpression().calculateCell(ctx);
                            if (cell == null) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("[]" + mm.getMessage("function.invalidParam"));
                            }
                            cell.clear();
                        } else {
                            this.clearArea(sub.getSub(0), sub.getSub(1), ctx);
                        }
                    }
                    ++i;
                }
            } else if (param.getType() == ':') {
                this.clearArea(param.getSub(0), param.getSub(1), ctx);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("clear" + mm.getMessage("function.invalidParam"));
            }
        }
        this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
    }

    private void runEndCmd(Command command) {
        Context ctx = this.getContext();
        IParam param = command.getParam((ICellSet)this, ctx);
        if (param != null) {
            if (param.isLeaf()) {
                Object obj = param.getLeafExpression().calculate(ctx);
                this.runFinished();
                throw new RetryException("error " + Variant.toString((Object)obj));
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("error" + mm.getMessage("function.invalidParam"));
        }
        this.runFinished();
    }

    public void setNext(int row, int col, boolean isCheckStack) {
        int colCount = this.getColCount();
        if (col > colCount) {
            ++row;
            col = 1;
            isCheckStack = true;
        }
        if (isCheckStack) {
            while (this.stack.size() > 0) {
                CmdCode cmd = this.stack.getFirst();
                if (row <= cmd.blockEndRow) break;
                if (cmd.type == 4) {
                    this.curLct.set(cmd.row, cmd.col);
                    return;
                }
                this.stack.removeFirst();
            }
        }
        if (row > this.getRowCount()) {
            this.runFinished();
        } else {
            PgmNormalCell cell = this.getPgmNormalCell(row, col);
            if (cell.isBlankCell() || cell.isNoteCell() || cell.isConstCell()) {
                this.setNext(row, col + 1, false);
            } else if (cell.isNoteBlock()) {
                this.setNext(this.getCodeBlockEndRow(row, col) + 1, 1, true);
            } else {
                this.curLct.set(row, col);
            }
        }
    }

    public int getCodeBlockEndRow(int prow, int pcol) {
        int totalRow = this.getRowCount();
        int row = prow + 1;
        while (row <= totalRow) {
            int c = 1;
            while (c <= pcol) {
                PgmNormalCell cell = this.getPgmNormalCell(row, c);
                if (!cell.isBlankCell()) {
                    return row - 1;
                }
                ++c;
            }
            ++row;
        }
        return totalRow;
    }

    private CellLocation runNext2() {
        block30: {
            Context ctx = this.getContext();
            if (this.curLct == null) {
                this.curLct = new CellLocation();
                this.setNext(1, 1, false);
                this.hasReturn = false;
                return this.curLct;
            }
            try {
                PgmNormalCell cell = this.getPgmNormalCell(this.curLct.getRow(), this.curLct.getCol());
                Command command = cell.getCommand();
                if (command == null) {
                    if (this.timer == null) {
                        this.initTimes();
                    }
                    this.timer.start();
                    cell.calculate();
                    this.timer.stop();
                    if (!(cell.getExpression().getHome() instanceof Func)) {
                        long[] lArray = this.times[this.curLct.getRow()];
                        int n = this.curLct.getCol();
                        lArray[n] = lArray[n] + this.timer.getValue();
                    }
                    if (cell.isCalculableBlock() || cell.isExecutableBlock()) {
                        int endRow = this.getCodeBlockEndRow(this.curLct.getRow(), this.curLct.getCol());
                        this.setNext(endRow + 1, 1, true);
                    } else {
                        this.setNext(this.curLct.getRow(), this.curLct.getCol() + 1, false);
                    }
                    break block30;
                }
                byte type = command.getType();
                switch (type) {
                    case 1: {
                        this.runIfCmd((NormalCell)cell, command);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.skipCodeBlock();
                        break;
                    }
                    case 4: {
                        this.runForCmd((NormalCell)cell, command);
                        break;
                    }
                    case 5: {
                        this.runContinueCmd(command);
                        break;
                    }
                    case 6: {
                        this.runBreakCmd(command);
                        break;
                    }
                    case 8: 
                    case 16: {
                        this.skipCodeBlock();
                        break;
                    }
                    case 9: 
                    case 11: {
                        this.runReturnCmd(command);
                        break;
                    }
                    case 12: {
                        this.runSqlCmd((NormalCell)cell, (SqlCommand)command);
                        break;
                    }
                    case 13: {
                        this.runClearCmd(command);
                        break;
                    }
                    case 10: {
                        this.runEndCmd(command);
                        break;
                    }
                    case 15: {
                        this.runForkCmd(command, ctx);
                        break;
                    }
                    case 17: {
                        this.runGotoCmd(command);
                        break;
                    }
                    case 18: {
                        this.runChannelCmd(command, ctx);
                        break;
                    }
                    case 19: {
                        this.runTryCmd((NormalCell)cell, command);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (RetryException re) {
                throw re;
            }
            catch (RQException re) {
                String cellId = this.curLct.toString();
                if (this.name != null) {
                    cellId = "[" + this.name + "]." + cellId;
                }
                String msg = re.getMessage();
                if (this.goCatch(String.valueOf(cellId) + ' ' + msg)) {
                    MessageManager mm = EngineMessage.get();
                    msg = String.valueOf(mm.getMessage("error.cell", (Object)cellId)) + msg;
                    Logger.error((Object)msg, (Throwable)re);
                }
                MessageManager mm = EngineMessage.get();
                msg = String.valueOf(mm.getMessage("error.cell", (Object)cellId)) + msg;
                re.setMessage(msg);
                throw re;
            }
            catch (Throwable e) {
                String msg;
                String cellId = this.curLct.toString();
                if (this.name != null) {
                    cellId = "[" + this.name + "]." + cellId;
                }
                if (this.goCatch(msg = e.getMessage())) {
                    MessageManager mm = EngineMessage.get();
                    msg = String.valueOf(mm.getMessage("error.cell", (Object)cellId)) + msg;
                    Logger.error((Object)msg, (Throwable)e);
                }
                MessageManager mm = EngineMessage.get();
                msg = String.valueOf(mm.getMessage("error.cell", (Object)cellId)) + msg;
                throw new RQException(msg, e);
            }
        }
        return this.curLct;
    }

    private boolean goCatch(String error) {
        while (this.stack.size() > 0) {
            CmdCode cmd = this.stack.getFirst();
            if (cmd.type == 19) {
                this.stack.removeFirst();
                this.setNext(cmd.blockEndRow + 1, 1, true);
                this.getPgmNormalCell(cmd.row, cmd.col).setValue((Object)error);
                return true;
            }
            this.stack.removeFirst();
        }
        return false;
    }

    public CellLocation runNext() {
        return this.runNext2();
    }

    public void run() {
        block2: {
            do {
                if (this.isInterrupted) {
                    this.isInterrupted = false;
                    break block2;
                }
                if (this.runNext2() == null) break block2;
            } while (!this.hasReturn());
            this.runFinished();
        }
    }

    public Object executeSubCell(int row, int col) {
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        if (row < 1 || row > rowCount || col < 1 || col > colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(CellLocation.getCellId((int)row, (int)col)) + mm.getMessage("cellset.cellNotExist"));
        }
        if (col == colCount) {
            return null;
        }
        CellLocation oldLct = this.curLct;
        LinkedList<CmdCode> oldStack = this.stack;
        Object retVal = null;
        try {
            this.curLct = new CellLocation();
            this.stack = new LinkedList();
            int endRow = this.getCodeBlockEndRow(row, col);
            this.setNext(row, col + 1, false);
            while (this.curLct != null) {
                int curRow = this.curLct.getRow();
                if (curRow > endRow) {
                    break;
                }
                int curCol = this.curLct.getCol();
                this.runNext2();
                PgmNormalCell cell = this.getPgmNormalCell(curRow, curCol);
                if (!cell.isCalculableCell() && !cell.isCalculableBlock()) continue;
                retVal = cell.getValue();
            }
        }
        finally {
            this.curLct = oldLct;
            this.stack = oldStack;
        }
        return retVal;
    }

    public void runCell(int row, int col) {
        block19: {
            PgmNormalCell cell = this.getPgmNormalCell(row, col);
            if (!cell.needCalculate()) {
                return;
            }
            CellLocation oldLct = this.curLct;
            LinkedList<CmdCode> oldStack = this.stack;
            try {
                this.curLct = new CellLocation(row, col);
                this.stack = new LinkedList();
                Command cmd = cell.getCommand();
                if (cmd == null) {
                    cell.calculate();
                    break block19;
                }
                byte type = cmd.getType();
                switch (type) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: {
                        break;
                    }
                    case 9: 
                    case 11: {
                        this.runReturnCmd(cmd);
                        break;
                    }
                    case 1: {
                        CellLocation lct;
                        int endRow = this.getIfBlockEndRow(row, col);
                        while ((lct = this.runNext2()) != null) {
                            if (lct.getRow() <= endRow) continue;
                            break block19;
                        }
                        break;
                    }
                    case 4: {
                        CellLocation lct;
                        int endRow = this.getCodeBlockEndRow(row, col);
                        while ((lct = this.runNext2()) != null) {
                            if (lct.getRow() <= endRow) continue;
                            break block19;
                        }
                        break;
                    }
                    case 12: {
                        this.runSqlCmd((NormalCell)cell, (SqlCommand)cmd);
                        break;
                    }
                    case 13: {
                        this.runClearCmd(cmd);
                        break;
                    }
                    case 10: {
                        this.runEndCmd(cmd);
                        break;
                    }
                    case 15: {
                        this.runForkCmd(cmd, this.getContext());
                        break;
                    }
                    case 18: {
                        this.runChannelCmd(cmd, this.getContext());
                        break;
                    }
                    case 19: {
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            finally {
                this.curLct = oldLct;
                this.stack = oldStack;
            }
        }
    }

    public Object executeFunc(int row, int col, Object[] args, String opt) {
        PgmNormalCell cell = this.getPgmNormalCell(row, col);
        Command cmd = cell.getCommand();
        if (cmd == null || cmd.getType() != 8) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.callNeedSub"));
        }
        String expStr = cmd.getExpression();
        if (expStr != null && expStr.length() > 0) {
            int nameEnd = KeyWord.scanId((String)expStr, (int)0);
            String fnName = expStr.substring(0, nameEnd);
            return this.executeFunc(fnName, args, opt);
        }
        int endRow = this.getCodeBlockEndRow(row, col);
        if (opt != null && opt.indexOf(105) != -1) {
            CellLocation oldLct = this.curLct;
            Object result = this.executeFunc(row, col, endRow, args);
            this.curLct = oldLct;
            return result;
        }
        PgmCellSet2 pcs = this.newCalc();
        pcs.initTimes();
        int colCount = this.getColCount();
        int r = row;
        while (r <= endRow) {
            int c = col;
            while (c <= colCount) {
                INormalCell tmp = this.getCell(r, c);
                INormalCell cellClone = (INormalCell)tmp.deepClone();
                cellClone.setCellSet((ICellSet)pcs);
                pcs.cellMatrix.set(r, c, (Object)cellClone);
                ++c;
            }
            ++r;
        }
        Object obj = pcs.executeFunc(row, col, endRow, args);
        this.conjTimes(pcs.times);
        return obj;
    }

    public PgmCellSet.FuncInfo getFuncInfo(String fnName) {
        PgmCellSet.FuncInfo funcInfo;
        if (this.fnMap == null) {
            this.fnMap = new HashMap();
            int rowCount = this.getRowCount();
            int colCount = this.getColCount();
            Context ctx = this.getContext();
            int r = 1;
            while (r <= rowCount) {
                int c = 1;
                while (c <= colCount) {
                    String expStr;
                    PgmNormalCell cell = this.getPgmNormalCell(r, c);
                    Command command = cell.getCommand();
                    if (command != null && command.getType() == 8 && (expStr = command.getExpression()) != null && expStr.length() != 0) {
                        int len = expStr.length();
                        int nameEnd = KeyWord.scanId((String)expStr, (int)0);
                        if (nameEnd == len) {
                            PgmCellSet.FuncInfo funcInfo2 = new PgmCellSet.FuncInfo((PgmCellSet)this, this.name, cell, null);
                            this.fnMap.put(expStr, funcInfo2);
                        } else {
                            String name = expStr.substring(0, nameEnd);
                            while (nameEnd < len && Character.isWhitespace(expStr.charAt(nameEnd))) {
                                ++nameEnd;
                            }
                            if (nameEnd == len) {
                                PgmCellSet.FuncInfo funcInfo3 = new PgmCellSet.FuncInfo((PgmCellSet)this, name, cell, null);
                                this.fnMap.put(name, funcInfo3);
                            } else if (expStr.charAt(nameEnd) == '(' && expStr.charAt(len - 1) == ')') {
                                String[] argNames = null;
                                IParam param = ParamParser.parse((String)expStr.substring(nameEnd + 1, len - 1), (ICellSet)this, (Context)ctx, (boolean)false);
                                if (param != null) {
                                    argNames = param.toStringArray("func", false);
                                }
                                PgmCellSet.FuncInfo funcInfo4 = new PgmCellSet.FuncInfo((PgmCellSet)this, name, cell, argNames);
                                this.fnMap.put(name, funcInfo4);
                            } else {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("func" + mm.getMessage("function.invalidParam"));
                            }
                        }
                    }
                    ++c;
                }
                ++r;
            }
        }
        if ((funcInfo = this.fnMap.get(fnName)) != null) {
            return funcInfo;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(fnName) + mm.getMessage("Expression.unknownFunction"));
    }

    public Object executeFunc(String fnName, Object[] args, String opt) {
        PgmCellSet.FuncInfo funcInfo = this.getFuncInfo(fnName);
        PgmNormalCell cell = funcInfo.getCell();
        int row = cell.getRow();
        int col = cell.getCol();
        int colCount = this.getColCount();
        int endRow = this.getCodeBlockEndRow(row, col);
        PgmCellSet2 pcs = this.newCalc();
        String[] argNames = funcInfo.getArgNames();
        if (argNames != null) {
            int argCount = argNames.length;
            if (args == null || args.length != argCount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(fnName) + mm.getMessage("function.paramCountNotMatch"));
            }
            Context ctx = pcs.getContext();
            int i = 0;
            while (i < argCount) {
                ctx.setParamValue(argNames[i], args[i]);
                ++i;
            }
        }
        int r = row;
        while (r <= endRow) {
            int c = col;
            while (c <= colCount) {
                INormalCell tmp = this.getCell(r, c);
                INormalCell cellClone = (INormalCell)tmp.deepClone();
                cellClone.setCellSet((ICellSet)pcs);
                pcs.cellMatrix.set(r, c, (Object)cellClone);
                ++c;
            }
            ++r;
        }
        return pcs.executeFunc(row, col, endRow, null);
    }

    private Object executeFunc(int row, int col, int endRow, Object[] args) {
        int colCount = this.getColCount();
        if (args != null) {
            int paramRow = row;
            int paramCol = col;
            int i = 0;
            int pcount = args.length;
            while (i < pcount) {
                this.getPgmNormalCell(paramRow, paramCol).setValue(args[i]);
                if (paramCol >= colCount) break;
                ++paramCol;
                ++i;
            }
        }
        this.curLct = new CellLocation(row, col);
        this.setNext(row, col + 1, false);
        while (this.curLct != null) {
            int curRow = this.curLct.getRow();
            if (curRow > endRow) break;
            int curCol = this.curLct.getCol();
            PgmNormalCell cell = this.getPgmNormalCell(curRow, curCol);
            Command cmd = cell.getCommand();
            if (cmd == null) {
                this.runNext2();
                continue;
            }
            if (cmd.getType() == 9) {
                Context ctx = this.getContext();
                Expression exp = cmd.getExpression((ICellSet)this, ctx);
                if (exp != null) {
                    return exp.calculate(ctx);
                }
                return null;
            }
            this.runNext2();
        }
        int r = endRow;
        while (r >= row) {
            int c = colCount;
            while (c > col) {
                PgmNormalCell cell = this.getPgmNormalCell(r, c);
                if (cell.isCalculableCell() || cell.isCalculableBlock()) {
                    return cell.getValue();
                }
                --c;
            }
            --r;
        }
        return null;
    }

    public void runFinished() {
        super.runFinished();
        this.curLct = null;
        this.stack.clear();
        this.curDb = null;
    }

    public void reset() {
        super.reset();
        this.resultValue = null;
        this.resultCurrent = 0;
        this.resultLct = null;
        this.interrupt = false;
        this.isInterrupted = false;
        this.hasReturn = false;
        this.fnMap = null;
    }

    protected void setParseCurrent(int row, int col) {
        if (this.parseLct == null) {
            this.parseLct = new CellLocation(row, col);
        } else {
            this.parseLct.set(row, col);
        }
    }

    public String getMacroReplaceString(String strCell) {
        int ec;
        int er;
        int sc;
        int sr;
        int colonIndex;
        Context ctx = this.getContext();
        strCell = Expression.replaceMacros((String)strCell, (ICellSet)this, (Context)ctx);
        if ((strCell = strCell.trim()) != null && (colonIndex = strCell.indexOf(58)) != -1) {
            String startStr = strCell.substring(0, colonIndex);
            INormalCell startCell = this.getCell(startStr);
            if (startCell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(startStr) + mm.getMessage("cellset.cellNotExist"));
            }
            String endStr = strCell.substring(colonIndex + 1);
            INormalCell endCell = this.getCell(endStr);
            if (endCell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(endStr) + mm.getMessage("cellset.cellNotExist"));
            }
            sr = startCell.getRow();
            sc = startCell.getCol();
            er = endCell.getRow();
            ec = endCell.getCol();
            if (sr > er || sc > ec) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\":\"" + mm.getMessage("operator.cellLocation"));
            }
        } else {
            INormalCell cell = this.getCell(strCell);
            if (cell == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(strCell) + mm.getMessage("cellset.cellNotExist"));
            }
            er = sr = cell.getRow();
            ec = sc = cell.getCol();
        }
        StringBuffer buffer = new StringBuffer(100);
        int r = sr;
        while (r <= er) {
            int c = sc;
            while (c <= ec) {
                PgmNormalCell cell = this.getPgmNormalCell(r, c);
                if (!cell.isBlankCell() && !cell.isNoteCell()) {
                    if (cell.isNoteBlock()) {
                        r = this.getCodeBlockEndRow(r, c);
                        break;
                    }
                    this.setParseCurrent(r, c);
                    String cellStr = cell.getMacroReplaceString();
                    buffer.append(Expression.replaceMacros((String)cellStr, (ICellSet)this, (Context)ctx));
                    buffer.append(',');
                }
                ++c;
            }
            ++r;
        }
        int len = buffer.length();
        return len > 0 ? buffer.substring(0, len - 1) : "";
    }

    public String getPrevCellSet(String str, int pos) {
        return null;
    }

    public boolean isCallInterrupted() {
        return this.curLct != null && this.resultValue == null;
    }

    public Object execute() {
        this.resultValue = null;
        while (this.runNext2() != null && this.resultValue == null) {
            if (!this.isInterrupted) continue;
            this.isInterrupted = false;
            break;
        }
        if (this.resultValue != null) {
            if (this.resultValue.length() == 0) {
                return null;
            }
            if (this.resultValue.length() == 1) {
                return this.resultValue.get(1);
            }
            return this.resultValue;
        }
        return this.getLastCalculableCellValue();
    }

    public Object getLastCalculableCellValue() {
        int colCount = this.getColCount();
        int r = this.getRowCount();
        while (r > 0) {
            int c = colCount;
            while (c > 0) {
                PgmNormalCell cell = this.getPgmNormalCell(r, c);
                if (cell.isCalculableCell() || cell.isCalculableBlock()) {
                    Object val = cell.getValue();
                    this.resultValue = new Sequence(1);
                    this.resultValue.add(val);
                    return val;
                }
                --c;
            }
            --r;
        }
        return null;
    }

    public void calculateResult() {
        this.execute();
    }

    public boolean hasNextResult() {
        if (this.resultValue != null && this.resultValue.length() > 0) {
            return true;
        }
        if (this.curLct == null) {
            return false;
        }
        this.resultValue = null;
        this.resultCurrent = 0;
        while (this.runNext2() != null && this.resultValue == null) {
            if (!this.isInterrupted) continue;
            this.isInterrupted = false;
            return false;
        }
        return this.hasNextResult();
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public Object nextResult() {
        if (!this.hasNextResult()) {
            return null;
        }
        if (this.resultCurrent < 1) {
            this.resultCurrent = 1;
        }
        Object obj = this.resultValue.get(this.resultCurrent);
        if (this.resultCurrent < this.resultValue.length()) {
            this.resultValue.set(this.resultCurrent, null);
            ++this.resultCurrent;
        } else {
            this.resultValue = null;
        }
        return obj;
    }

    public CellLocation nextResultLocation() {
        if (!this.hasNextResult()) {
            return null;
        }
        return this.resultLct;
    }

    public void interrupt() {
        this.interrupt = true;
        this.isInterrupted = true;
    }

    public boolean getInterrupt() {
        return this.interrupt;
    }

    public void setAutoCalc(boolean b) {
        this.sign = b ? (this.sign |= 0x10) : (this.sign &= 0xFFFFFFEF);
    }

    public boolean isAutoCalc() {
        return (this.sign & 0x10) == 16;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ByteMap getCustomPropMap() {
        return this.customPropMap;
    }

    public void setCustomPropMap(ByteMap map) {
        if (!this.isExecuteOnly()) {
            this.customPropMap = map;
        }
    }

    public void setPassword(String psw) {
        if (psw == null || psw.length() == 0) {
            this.pswHash = null;
        } else {
            MD5 md5 = new MD5();
            this.pswHash = md5.getMD5ofStr(psw);
        }
    }

    public String getPasswordHash() {
        return this.pswHash;
    }

    public int getNullPasswordPrivilege() {
        return this.nullPswPrivilege;
    }

    public void setCurrentPassword(String psw) {
        this.curPrivilege = PgmCellSet2.getPrivilege(this.pswHash, psw, this.nullPswPrivilege);
    }

    public static int getPrivilege(String pswHash, String psw, int nullPswPrivilege) {
        if (pswHash == null) {
            return 0;
        }
        if (psw == null || psw.length() == 0) {
            return nullPswPrivilege;
        }
        MD5 md5 = new MD5();
        if ((psw = md5.getMD5ofStr(psw)).equals(pswHash)) {
            return 0;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("cellset.pswError"));
    }

    public int getCurrentPrivilege() {
        return this.curPrivilege;
    }

    public boolean isExecuteOnly() {
        return this.curPrivilege == 1;
    }

    public Sequence getResultValue() {
        return this.resultValue;
    }

    public void setResultValue(Sequence resultValue) {
        this.resultValue = resultValue;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    public void initTimes() {
        int colSize = this.cellMatrix.getColSize();
        int rowSize = this.cellMatrix.getRowSize();
        long[][] times = new long[rowSize][];
        int r = 0;
        while (r < rowSize) {
            times[r] = new long[colSize];
            ++r;
        }
        this.times = times;
        this.timer = new Timer();
    }

    public void conjTimes(long[][] otherTimes) {
        int colSize = this.cellMatrix.getColSize();
        int rowSize = this.cellMatrix.getRowSize();
        long[][] times = this.times;
        int col = 1;
        while (col < colSize) {
            int row = 1;
            while (row < rowSize) {
                long[] lArray = times[row];
                int n = col;
                lArray[n] = lArray[n] + otherTimes[row][col];
                ++row;
            }
            ++col;
        }
    }

    public long[][] getTimes() {
        return this.times;
    }

    public void setTimes(long[][] times) {
        this.times = times;
    }

    private static class BoolForCmdCode
    extends ForCmdCode {
        private Expression exp;
        private Context ctx;

        public BoolForCmdCode(int r, int c, int endRow, Expression exp, Context ctx) {
            super(r, c, endRow);
            this.exp = exp;
            this.ctx = ctx;
        }

        @Override
        public boolean hasNextValue() {
            Object value = this.exp.calculate(this.ctx);
            if (!(value instanceof Boolean)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.forVarTypeError"));
            }
            return (Boolean)value;
        }

        @Override
        public Object nextValue() {
            ++this.seq;
            return Boolean.TRUE;
        }

        @Override
        public Object endValue() {
            return Boolean.FALSE;
        }
    }

    private static class CmdCode {
        protected byte type;
        protected int row;
        protected int col;
        protected int blockEndRow;

        public CmdCode(byte type, int r, int c, int endRow) {
            this.type = type;
            this.row = r;
            this.col = c;
            this.blockEndRow = endRow;
        }
    }

    private static class CursorForCmdCode
    extends ForCmdCode {
        private ICursor cursor;
        private int count;
        private Expression gexp;
        private Context ctx;
        private Sequence table;

        public CursorForCmdCode(int r, int c, int endRow, ICursor cursor, int count, Expression gexp, Context ctx) {
            super(r, c, endRow);
            this.cursor = cursor;
            this.count = count;
            this.gexp = gexp;
            this.ctx = ctx;
        }

        @Override
        public boolean hasNextValue() {
            this.table = this.gexp == null ? this.cursor.fetch(this.count) : this.cursor.fetchGroup(this.gexp, this.ctx);
            return this.table != null && this.table.length() > 0;
        }

        @Override
        public Object nextValue() {
            ++this.seq;
            return this.table;
        }

        public void close() {
            this.cursor.close();
        }
    }

    private static class EndlessForCmdCode
    extends ForCmdCode {
        public EndlessForCmdCode(int r, int c, int endRow) {
            super(r, c, endRow);
        }

        @Override
        public boolean hasNextValue() {
            return true;
        }

        @Override
        public Object nextValue() {
            return new Integer(++this.seq);
        }
    }

    private static abstract class ForCmdCode
    extends CmdCode {
        protected int seq = 0;

        public ForCmdCode(int r, int c, int endRow) {
            super((byte)4, r, c, endRow);
        }

        public abstract boolean hasNextValue();

        public abstract Object nextValue();

        public Object endValue() {
            return null;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int n) {
            this.seq = n;
        }
    }

    private static class ForkCmdCode
    extends CmdCode {
        protected int seq = 0;

        public ForkCmdCode(int r, int c, int endRow, int seq) {
            super((byte)15, r, c, endRow);
            this.seq = seq;
        }
    }

    private static class ForkJob
    extends Job {
        PgmCellSet2 pcs;
        int row;
        int col;
        int endRow;

        public ForkJob(PgmCellSet2 pcs, int row, int col, int endRow) {
            this.pcs = pcs;
            this.row = row;
            this.col = col;
            this.endRow = endRow;
        }

        public void run() {
            this.pcs.executeFork(this.row, this.col, this.endRow);
        }

        public Object getResult() {
            return this.pcs.getForkResult();
        }
    }

    private static class IntForCmdCode
    extends ForCmdCode {
        private int start;
        private int end;
        private int step;

        public IntForCmdCode(int r, int c, int endRow, int start, int end, int step) {
            super(r, c, endRow);
            this.start = start;
            this.end = end;
            this.step = step;
        }

        @Override
        public boolean hasNextValue() {
            if (this.step >= 0) {
                return this.start <= this.end;
            }
            return this.start >= this.end;
        }

        @Override
        public Object nextValue() {
            Integer val = new Integer(this.start);
            ++this.seq;
            this.start += this.step;
            return val;
        }

        @Override
        public Object endValue() {
            return new Integer(this.start);
        }
    }

    private static class SequenceForCmdCode
    extends ForCmdCode {
        private Sequence sequence;

        public SequenceForCmdCode(int r, int c, int endRow, Sequence sequence) {
            super(r, c, endRow);
            this.sequence = sequence;
        }

        @Override
        public boolean hasNextValue() {
            return this.seq < this.sequence.length();
        }

        @Override
        public Object nextValue() {
            return this.sequence.get(++this.seq);
        }
    }

    private class SubForkJob
    extends Job {
        private IParam param;
        private int row;
        private int col;
        private int endRow;
        private Context ctx;

        public SubForkJob(IParam param, int row, int col, int endRow, Context ctx) {
            this.param = param;
            this.row = row;
            this.col = col;
            this.endRow = endRow;
            this.ctx = ctx;
        }

        public void run() {
            PgmCellSet2.this.runForkCmd(this.param, this.row, this.col, this.endRow, this.ctx);
        }
    }
}

