/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.DataType;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.VarItem;
import com.scudata.dm.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SelectMethodMakerFast
extends MethodMaker {
    protected boolean hasUnknownExp;
    private String initCode;

    public SelectMethodMakerFast(String name) {
        super(name);
    }

    public SelectMethodMakerFast(String name, String option, String retType) {
        super(name, option, retType);
    }

    protected void startCycle(StringBuffer out) {
        out.append("int len = seq.length();");
        out.append(System.lineSeparator());
        out.append("for (int i = 1; i <= len; i++) {");
        out.append(System.lineSeparator());
    }

    protected void endCycle(StringBuffer out) {
        out.append("}");
        out.append(System.lineSeparator());
    }

    @Override
    public String finish() {
        return this.finishTable();
    }

    private String finishTable() {
        List<String> strs;
        String name;
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append(System.lineSeparator());
        result.append("Sequence seq = srcSequence;");
        result.append(System.lineSeparator());
        result.append("if (seq == null) return seq;");
        result.append(System.lineSeparator());
        result.append("DataStruct ds = ((Table)seq).dataStruct();");
        result.append(System.lineSeparator());
        result.append("IArray mems = seq.getMems();");
        result.append(System.lineSeparator());
        result.append("int len = mems.size();");
        result.append(System.lineSeparator());
        if (this.initCode != null) {
            result.append(this.initCode);
            result.append(System.lineSeparator());
        }
        for (Map.Entry entry : this.vars.entrySet()) {
            String t;
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("SeqDefaultType")) {
                t = CompilerUtil.getType(item.getName(), null, this.types);
                type.setTypeName(t);
            }
            if (type != null && type.isType("UnknownType")) {
                t = CompilerUtil.getType(item.getName(), null, this.types);
                type.setTypeName(t);
            }
            name = item.getName();
            String typeName = type.getTypeName();
            if (!item.isGlobal()) {
                String idxVarName = "idx_" + name;
                result.append("final int " + idxVarName + " = ds.getFieldIndex(\"" + name + "\");");
                result.append(System.lineSeparator());
                String define = String.format("%s %s", typeName, item.getName());
                result.append(define);
            } else {
                result.append(type);
                result.append(" ");
                result.append(item.getName());
                if (item.isCell()) {
                    result.append(" = (" + type + ")getObject(\"" + item.getName() + "\")");
                } else {
                    result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                }
            }
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("IArray resultArray = mems.newInstance(256);");
        result.append(System.lineSeparator());
        if (this.hasUnknownExp) {
            SelectMethodMakerFast.appendLine(result, "ComputeStack stack = ctx.getComputeStack();");
            SelectMethodMakerFast.appendLine(result, "Current current = new Current(seq);");
            SelectMethodMakerFast.appendLine(result, "stack.push(current);");
        }
        result.append("for (int i = 1; i <= len; ++i) {");
        result.append(System.lineSeparator());
        result.append("BaseRecord r = (BaseRecord)seq.get(i);");
        result.append(System.lineSeparator());
        if (this.hasUnknownExp) {
            result.append("current.setCurrent(i);");
            result.append(System.lineSeparator());
        }
        if ((strs = CompilerUtil.splitByAnd(this.code.toString())).size() > 1) {
            result.append("boolean flag;");
            result.append(System.lineSeparator());
            ArrayList<String> outs = new ArrayList<String>();
            int i = 0;
            int len = strs.size();
            while (i < len) {
                String str = strs.get(i);
                Set<String> strSets = CompilerUtil.extractVariables(str);
                for (Map.Entry entry : this.vars.entrySet()) {
                    VarItem item = (VarItem)entry.getValue();
                    String name2 = item.getName();
                    String key = (String)entry.getKey();
                    DataType type = item.getType();
                    if (!strSets.contains(key) || outs.contains(key)) continue;
                    outs.add(key);
                    if (item.isGlobal()) continue;
                    result.append(String.valueOf(name2) + " = (" + type + ")r.getNormalFieldValue(idx_" + name2 + ");");
                    result.append(System.lineSeparator());
                }
                result.append("flag = " + str + ";");
                result.append(System.lineSeparator());
                if (i != len - 1) {
                    result.append("if (!flag) {\r\n\t\t\tcontinue; \r\n\t\t}");
                    result.append(System.lineSeparator());
                }
                ++i;
            }
            SelectMethodMakerFast.appendLine(result, "if (flag) {");
            SelectMethodMakerFast.appendLine(result, "resultArray.add(mems, i);");
            SelectMethodMakerFast.appendLine(result, "}");
        } else {
            for (Map.Entry entry : this.vars.entrySet()) {
                VarItem item = (VarItem)entry.getValue();
                name = item.getName();
                DataType type = item.getType();
                if (item.isGlobal()) continue;
                result.append(String.valueOf(name) + " = (" + type + ")r.getNormalFieldValue(idx_" + name + ");");
                result.append(System.lineSeparator());
            }
            SelectMethodMakerFast.appendLine(result, "boolean flag = " + this.code.toString());
            SelectMethodMakerFast.appendLine(result, "if (flag) {");
            SelectMethodMakerFast.appendLine(result, "resultArray.add(mems, i);");
            SelectMethodMakerFast.appendLine(result, "}");
        }
        this.endCycle(result);
        SelectMethodMakerFast.appendLine(result, "return new Sequence(resultArray);");
        result.append("}");
        return result.toString();
    }

    @Override
    public ConcurrentHashMap<String, String> getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(ConcurrentHashMap<String, String> types) {
        this.types = types;
    }

    @Override
    public void adjustVarTypeByTip(ConcurrentHashMap<String, String> types) {
        for (Map.Entry entry : this.vars.entrySet()) {
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type == null || !type.isType("UnknownType") || !types.containsKey(name)) continue;
            String ty = types.get(name);
            type.setTypeName(ty);
        }
    }

    @Override
    public void adjustVarType(ConcurrentHashMap<String, VarItem> global) {
        for (Map.Entry entry : this.vars.entrySet()) {
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("UnknownType") && global.containsKey(name)) {
                VarItem gvar = global.get(name);
                type.setTypeName(gvar.getType().getTypeName());
            }
            if (!global.containsKey(name)) continue;
            item.setGlobal(true);
            item.setCell(global.get(name).isCell());
            item.setC(global.get(name).getC());
            item.setR(global.get(name).getR());
        }
    }

    @Override
    public void adjustVarType(PgmCellSet cellSet) {
        Context ctx = cellSet.getContext();
        for (Map.Entry entry : this.vars.entrySet()) {
            Object obj;
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            try {
                obj = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType = SelectMethodMakerFast.getObjectType(obj);
            if (newType == null || newType.isType("UnknownType")) continue;
            type.setTypeName(newType.getTypeName());
            type.setArray(newType.isArray());
        }
    }
}

