/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.function;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.function.SequenceFunc_XXX;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;

public class SequenceDerive_XXX
extends SequenceFunc_XXX {
    protected Expression[] exps;
    protected String[] names;
    protected DataStruct newDs;

    protected void initParam(Context ctx) {
        IParam param = this.param;
        int level = 0;
        if (param != null && param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("derive" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = param.getSub(1);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("derive" + mm.getMessage("function.invalidParam"));
            }
            Object val = sub.getLeafExpression().calculate(ctx);
            if (!(val instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("derive" + mm.getMessage("function.paramTypeError"));
            }
            level = ((Number)val).intValue();
            if (level < 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("derive" + mm.getMessage("function.invalidParam"));
            }
            param = param.getSub(0);
        } else if (this.option != null && this.option.indexOf(120) != -1) {
            level = 2;
        }
        if (param == null && level < 2) {
            throw new RuntimeException();
        }
        if (param != null) {
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"derive", (boolean)false, (boolean)false);
            this.exps = pi.getExpressions1();
            this.names = pi.getExpressionStrs2();
        }
    }

    protected void initDataStructure(String[] names, Expression[] exps, String opt, Context ctx) {
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                throw new RuntimeException();
            }
            if (opt.indexOf(122) != -1) {
                throw new RuntimeException();
            }
        }
        Sequence seq = this.srcSequence;
        DataStruct ds = seq.dataStruct();
        int colCount = exps.length;
        if (ds == null) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < colCount) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("derive" + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getFieldName(ds);
            } else if (exps[i] == null) {
                exps[i] = Expression.NULL;
            }
            ++i;
        }
        String[] oldNames = ds.getFieldNames();
        int oldColCount = oldNames.length;
        int newColCount = oldColCount + colCount;
        String[] totalNames = new String[newColCount];
        System.arraycopy(oldNames, 0, totalNames, 0, oldColCount);
        System.arraycopy(names, 0, totalNames, oldColCount, colCount);
        this.newDs = ds.create(totalNames);
    }

    @Override
    public Object calculate(Context ctx) {
        this.initParam(ctx);
        Sequence seq = this.srcSequence;
        if (seq == null) {
            return seq;
        }
        IArray mems = seq.getMems();
        int len = mems.size();
        this.initDataStructure(this.names, this.exps, this.option, ctx);
        String opt = this.option;
        int parallelNum = Env.getParallelNum();
        if (len <= MultithreadUtil.SINGLE_PROSS_COUNT || parallelNum < 2) {
            opt = opt.replace('m', ' ');
        }
        if (opt != null && opt.indexOf("m") != -1) {
            int threadCount = (len - 1) / MultithreadUtil.SINGLE_PROSS_COUNT + 1;
            if (threadCount > parallelNum) {
                threadCount = parallelNum;
            }
            int singleCount = len / threadCount;
            int expCount = this.exps.length;
            int start = 1;
            Table[] result = new Table[threadCount];
            Thread[] threads = new Thread[threadCount];
            int i = 0;
            while (i < threadCount) {
                int end = i + 1 == threadCount ? len + 1 : start + singleCount;
                Context tmpCtx = ctx.newComputeContext();
                Expression[] tmpExps = new Expression[expCount];
                int k = 0;
                while (k < expCount) {
                    tmpExps[k] = this.exps[k].newExpression(tmpCtx);
                    ++k;
                }
                result[i] = new Table(this.newDs, len / threadCount);
                threads[i] = this.newDeriveThread(seq, start, end, tmpExps, this.newDs, result[i], tmpCtx);
                threads[i].start();
                start = end;
                ++i;
            }
            Table table = new Table(this.newDs, len);
            try {
                int i2 = 0;
                while (i2 < threadCount) {
                    threads[i2].join();
                    table.getMems().addAll(result[i2].getMems());
                    ++i2;
                }
            }
            catch (InterruptedException e) {
                throw new RQException((Throwable)e);
            }
            return table;
        }
        Table table = new Table(this.newDs, len);
        this.calculate(seq, 1, len + 1, this.exps, this.newDs, table, ctx);
        return table;
    }

    protected void calculate(Sequence seq, int start, int end, Expression[] exps, DataStruct newDs, Table table, Context ctx) {
        throw new RuntimeException();
    }

    protected Thread newDeriveThread(final Sequence seq, final int start, final int end, final Expression[] exps, final DataStruct newDs, final Table table, final Context ctx) {
        return new Thread(){

            @Override
            public void run() {
                SequenceDerive_XXX.this.calculate(seq, start, end, exps, newDs, table, ctx);
            }
        };
    }
}

