/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.common.RQException;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CurContext;
import com.scudata.compile.CurContextItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.NumberCurContext;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.StructType;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.expression.operator.Assign;

public class CodeMaker {
    private static String toBoolString(CodeItem item) {
        if (item.getType().isType("boolean") || item.getType().isType("Boolean")) {
            return item.toString();
        }
        return "Variant.isTrue(" + item + ")";
    }

    private static void checkLeftStructType(CodeItem left) {
        DataType type = left.getType();
        if (type.isType("ICursor") && type.getStructType() == null) {
            throw new ParseNodeException(left + " need struct type");
        }
    }

    public static CodeItem generateSequenceSelect(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String methodName = "sequenceSelect_" + id;
        String iStr = "i_" + id;
        String recStr = "rec";
        String sequenceStr = "src";
        String lenStr = "len_" + id;
        String leftName = left.toString();
        StructType structType = left.getType().getStructType();
        CurContext cur = CurContext.newTableCurItem(leftName, sequenceStr, recStr, iStr, structType);
        parser.pushCurContext(leftName, sequenceStr, recStr, structType, true, iStr);
        CurContextItem curItem = new CurContextItem("", cur, parser);
        String expStr = CodeMaker.toBoolString(parser.parse(exp.getHome()));
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String method = "\tprivate static Sequence " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "\t\tif(src==null||src.length()==0)return null;int " + lenStr + " = src.length();" + "\t\tSequence seq = new Sequence(" + lenStr + ");\r\n" + "\t\tIArray resultMems = seq.getMems();\r\n" + curItem + ";" + "\t\t\tif (" + expStr + ") resultMems.add(rec);" + "\t\t}" + "\t\treturn seq;" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left.cast("Sequence"), paramVars);
        return new LineItem(line, left.getType());
    }

    public static CodeItem generateSequenceSelect2(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String methodName = "sequenceSelect_" + id;
        String iStr = "i_" + id;
        String recStr = "rec";
        String sequenceStr = "src";
        String lenStr = "len_" + id;
        String leftName = left.toString();
        StructType structType = left.getType().getStructType();
        CurContext cur = CurContext.newTableCurItem(leftName, sequenceStr, recStr, iStr, structType);
        parser.pushCurContext(leftName, sequenceStr, recStr, structType, true, iStr);
        CurContextItem curItem = new CurContextItem("", cur, parser);
        String expStr = CodeMaker.toBoolString(parser.parse(exp.getHome()));
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String method = "\tprivate static Sequence " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "\t\tint " + lenStr + " = src.length();if(src.length()==0)return null;" + "\t\tSequence seq = new Sequence(" + lenStr + ");\r\n" + "\t\tIArray resultMems = tbl.getMems();\r\n" + curItem + ";" + "\t\t\tif (" + expStr + ") resultMems.add(rec);" + "\t\t}" + "\t\treturn tbl;" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, left.getType());
    }

    public static CodeItem generateTableSelect(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String methodName = "tableSelect_" + id;
        String iStr = "i_" + id;
        String recStr = "rec";
        String tableStr = "src";
        String lenStr = "len_" + id;
        String leftName = left.toString();
        StructType structType = left.getType().getStructType();
        CurContext cur = CurContext.newTableCurItem(leftName, tableStr, recStr, iStr, structType);
        parser.pushCurContext(leftName, tableStr, recStr, structType, true, iStr);
        CurContextItem curItem = new CurContextItem("", cur, parser);
        String expStr = CodeMaker.toBoolString(parser.parse(exp.getHome()));
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String method = "\tprivate static Table " + methodName + "(Table src" + paramVarsDefine + ") {" + locVars + "\t\tif(src==null)return null;int " + lenStr + " = src.length();if(src.length()==0)return null;" + "\t\tTable tbl = new Table(src.dataStruct(), " + lenStr + ");\r\n" + "\t\tIArray resultMems = tbl.getMems();\r\n" + curItem + ";" + "\t\t\tif (" + expStr + ") resultMems.add(rec);" + "\t\t}" + "\t\treturn tbl;" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, left.getType());
    }

    public static CodeItem generateSequenceNew(NodeParser parser, CodeItem left, String[] names, Expression[] exps) throws ParseNodeException {
        int len = names.length;
        String codeline = "";
        DataType[] fieldTypes = new DataType[len];
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        DataType curType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(leftName, "src", null, iStr, curType);
        parser.pushCurContext(cur);
        CodeItem[] items = new CodeItem[len];
        int i = 0;
        while (i < len) {
            String line = "";
            items[i] = parser.parse(exps[i].getHome());
            CodeItem item = items[i];
            if (item.getPreItems() != null && item.getPreItems().size() > 0) {
                for (CodeItem citem : item.getPreItems()) {
                    line = String.valueOf(line) + citem.toString() + ";";
                }
            }
            String expStr = item.toString();
            fieldTypes[i] = item.getType();
            VarItem vi = new VarItem(names[i], item.getType());
            vi.setField(true);
            parser.addVar(vi);
            line = i == len - 1 ? String.valueOf(line) + String.format("r.setNormalFieldValue(%d, %s);", i, expStr) : String.valueOf(line) + String.format("r.setNormalFieldValue(%d, %s=%s);", i, names[i], expStr);
            codeline = String.valueOf(codeline) + line;
            ++i;
        }
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceNew_" + id;
        String method = "\tprivate static Table " + methodName + "(Sequence src, DataStruct ds, Context ctx" + paramVarsDefine + ") {\r\n" + locVars + "\r\n" + "\t\tif(src==null)return null;int " + lenStr + " = src.length();" + "\t\tTable tbl = new Table(ds, " + lenStr + ");" + "\t\tIArray resultMems = tbl.getMems();" + "\t\tfor (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + "\t\t\tRecord r = new Record(ds);" + "\t\t\t\t\tresultMems.add(r);" + "\t\t\t" + codeline + "\r\n" + "\t\t}\r\n" + "\t\treturn tbl;\r\n" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String ds = parser.generateDataStructConstVar(names);
        String line = String.format("%s(%s, %s, ctx%s)", methodName, left, ds, paramVars);
        StructType structType = new StructType(names, fieldTypes, parser);
        return new LineItem(line, DataType.newTableType(structType));
    }

    public static CodeItem generateSequenceCount(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        DataType curType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(leftName, "src", null, iStr, curType);
        parser.pushCurContext(cur);
        String expStr = CodeMaker.toBoolString(parser.parse(exp.getHome()));
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceCount_" + id;
        String method = "\tprivate static int " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "\t\tif(src==null)return 0;int " + lenStr + " = src.length();int count = 0;" + "\t\tfor (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + "\t\t\tif (" + expStr + ") {count++;}" + "\t\t}" + "\t\treturn count;" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, DataType.IntType);
    }

    public static CodeItem generateSequencePSelect(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        String expStr;
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String methodName = "sequencePSelect_" + id;
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        if (left.getType().isType("Table")) {
            StructType structType = left.getType().getStructType();
            parser.pushCurContext(leftName, "src", "rec", structType, true, iStr);
        } else {
            DataType curType = left.getType().getMemberType();
            CurContext cur = CurContext.newSequenceCurItem(leftName, "src", null, iStr, curType);
            parser.pushCurContext(cur);
        }
        try {
            expStr = CodeMaker.toBoolString(parser.parse(exp.getHome()));
        }
        catch (Exception e) {
            parser.popCurContext();
            parser.popStack();
            throw new RQException((Throwable)e);
        }
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String method = "\tprivate static Integer " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "\t\tif(src==null)return null;int " + lenStr + " = src.length();if(src.length()==0)return null;" + "\t\tfor (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + "\t\t\tif (" + expStr + ") return " + iStr + ";" + "\t\t}" + "\t\treturn null;" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, DataType.IntTypeNullable);
    }

    public static CodeItem generateTableNew(NodeParser parser, CodeItem left, String[] names, Expression[] exps) throws ParseNodeException {
        int len = names.length;
        String codeline = "";
        DataType[] fieldTypes = new DataType[len];
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        StructType structType = left.getType().getStructType();
        parser.pushCurContext(leftName, "src", "srcRec", structType, true, iStr);
        CodeItem[] items = new CodeItem[len];
        int i = 0;
        while (i < len) {
            String line = "";
            items[i] = parser.parse(exps[i].getHome());
            CodeItem item = items[i];
            if (item.getPreItems() != null && item.getPreItems().size() > 0) {
                for (CodeItem citem : item.getPreItems()) {
                    line = String.valueOf(line) + citem.toString() + ";";
                }
            }
            String expStr = item.toString();
            fieldTypes[i] = item.getType();
            boolean flag = false;
            if (structType.dataStruct().getFieldIndex(names[i]) == -1 && !parser.parentVars.containsKey(names[i])) {
                VarItem vi = new VarItem(names[i], item.getType());
                vi.setField(true);
                parser.addVar(vi);
                flag = true;
            }
            line = i == len - 1 || !flag ? String.valueOf(line) + String.format("r.setNormalFieldValue(%d, %s);", i, expStr) : String.valueOf(line) + String.format("r.setNormalFieldValue(%d, %s=%s);", i, names[i], expStr);
            codeline = String.valueOf(codeline) + line;
            ++i;
        }
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "tableNew_" + id;
        String method = "\tprivate static Table " + methodName + "(Table src, DataStruct ds, Context ctx" + paramVarsDefine + ") {" + locVars + "\r\n" + "\t\tif(src==null)return null;int " + lenStr + " = src.length();\r\n" + "\t\tTable tbl = new Table(ds, " + lenStr + ");\r\n" + "\t\tIArray resultMems = tbl.getMems();\r\n" + "\t\tfor (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {\r\n" + "\t\t\tBaseRecord srcRec = src.getRecord(" + iStr + ");" + "\t\t\tRecord r = new Record(ds);\r\n" + "\t\t\t\t\tresultMems.add(r);\r\n" + "\t\t\t" + codeline + "\r\n" + "\t\t}\r\n" + "\t\treturn tbl;\r\n" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String ds = parser.generateDataStructConstVar(names);
        String line = String.format("%s(%s, %s, ctx%s)", methodName, left, ds, paramVars);
        return new LineItem(line, DataType.newTableType(new StructType(names, fieldTypes, parser)));
    }

    private static CodeItem generateNumberCalc(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        String codeline = "";
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        DataType curType = left.getType();
        NumberCurContext cur = new NumberCurContext("result", iStr, curType);
        parser.pushCurContext(cur);
        CodeItem item = parser.parse(exp.getHome());
        if (item.getPreItems() != null && item.getPreItems().size() > 0) {
            for (CodeItem citem : item.getPreItems()) {
                codeline = String.valueOf(codeline) + citem.toString() + ";";
            }
        }
        codeline = String.valueOf(codeline) + "result.add(" + item + ");";
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "numberCalc_" + id;
        String method = "private static Sequence " + methodName + "(Number src" + paramVarsDefine + ") {" + locVars + "int " + lenStr + " = ((Number)src).intValue();" + "Sequence result = new Sequence(" + lenStr + ");" + "for (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + codeline + "}" + "return result;" + "}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, DataType.newSequenceType(item.getType()));
    }

    private static CodeItem generateSequenceCalc(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        String codeline = "";
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.cast().toString();
        DataType curType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(leftName, "src", null, iStr, curType);
        parser.pushCurContext(cur);
        CodeItem item = parser.parse(exp.getHome());
        if (item.getPreItems() != null && item.getPreItems().size() > 0) {
            for (CodeItem citem : item.getPreItems()) {
                codeline = String.valueOf(codeline) + citem.toString() + ";";
            }
        }
        codeline = String.valueOf(codeline) + "result.add(" + item + ");";
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceCalc_" + id;
        String method = "private static Sequence " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "if(src==null)return null;int " + lenStr + " = src.length();" + "Sequence result = new Sequence(" + lenStr + ");" + "for (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + codeline + "}" + "return result;" + "}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left.cast(), paramVars);
        return new LineItem(line, DataType.newSequenceType(item.getType()));
    }

    private static CodeItem generateTableCalc(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        String codeline = "";
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        StructType structType = left.getType().getStructType();
        parser.pushCurContext(leftName, "src", "rec", structType, true, iStr);
        CodeItem item = parser.parse(exp.getHome());
        if (item.getPreItems() != null && item.getPreItems().size() > 0) {
            for (CodeItem citem : item.getPreItems()) {
                codeline = String.valueOf(codeline) + citem.toString() + ";";
            }
        }
        codeline = String.valueOf(codeline) + "result.add(" + item + ");";
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceCalc_" + id;
        String method = "private static Sequence " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "if(src==null)return null;int " + lenStr + " = src.length();" + "Sequence result = new Sequence(" + lenStr + ");" + "for (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + codeline + "}" + "return result;" + "}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, DataType.newSequenceType(item.getType()));
    }

    public static CodeItem generateRecordRun(NodeParser parser, CodeItem left, Expression[] exps, Expression[] assignExps) throws ParseNodeException {
        String codeline = "";
        String leftName = left.toString();
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        CurContext cur = CurContext.newRecordCurItem(leftName, "rec", left.getType());
        parser.pushCurContext(cur);
        int size = exps.length;
        int i = 0;
        while (i < size) {
            Expression assignExp;
            Expression exp = exps[i];
            Node node = exp.getHome();
            if (assignExps != null && (assignExp = assignExps[i]) != null) {
                Assign assign = new Assign();
                assign.setLeft(assignExp.getHome());
                assign.setRight(exp.getHome());
                node = assign;
            }
            try {
                CodeItem item = parser.parse(node);
                if (item.getPreItem() != null) {
                    codeline = String.valueOf(codeline) + item.getPreItem() + ";";
                }
                codeline = String.valueOf(codeline) + item + ";";
            }
            catch (Exception e) {
                parser.popCurContext();
                parser.popStack();
                throw new RQException((Throwable)e);
            }
            ++i;
        }
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "recordRun_" + id;
        String method = "private static BaseRecord " + methodName + "(BaseRecord rec" + paramVarsDefine + ") {" + locVars + "if (rec == null) return null;" + codeline + "return rec;" + "}";
        left.getType().setStructType(cur.getStructType());
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, left.getType());
    }

    public static CodeItem generateSequenceRun(NodeParser parser, CodeItem left, Expression[] exps, Expression[] assignExps) throws ParseNodeException {
        String codeline = "";
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        DataType curType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(leftName, "src", null, iStr, curType);
        parser.pushCurContext(cur);
        if (left.getType().getStructType() != null) {
            parser.addVars(left.getType().getStructType().getFieldVars());
        }
        Expression[] expressionArray = exps;
        int n = exps.length;
        int n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            CodeItem item = parser.parse(exp.getHome());
            if (item.getPreItem() != null) {
                codeline = String.valueOf(codeline) + item.getPreItem() + ";";
            }
            codeline = String.valueOf(codeline) + item + ";";
            ++n2;
        }
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceRun_" + id;
        String method = "private static Sequence " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "if(src==null)return null;int " + lenStr + " = src.length();" + "for (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + codeline + "}" + "return src;" + "}";
        left.getType().setMemberType(cur.getMemberType());
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, left.getType());
    }

    public static CodeItem generateTableRun(NodeParser parser, CodeItem left, Expression[] exps, Expression[] assignExps) throws ParseNodeException {
        VarItem[] fieldVars;
        String codeline = "";
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        StructType structType = left.getType().getStructType();
        parser.pushCurContext(leftName, "src", "rec", structType, true, iStr);
        int size = exps.length;
        int i = 0;
        while (i < size) {
            Expression exp = exps[i];
            Node node = null;
            if (assignExps != null) {
                Expression assignExp = assignExps[i];
                if (assignExp != null) {
                    Assign assign = new Assign();
                    assign.setLeft(assignExp.getHome());
                    assign.setRight(exp.getHome());
                    node = assign;
                }
            } else {
                node = exp.getHome();
            }
            try {
                CodeItem item = parser.parse(node);
                if (item.getPreItem() != null) {
                    codeline = String.valueOf(codeline) + item.getPreItem() + ";";
                }
                codeline = String.valueOf(codeline) + item + ";";
            }
            catch (Exception e) {
                parser.popCurContext();
                parser.popStack();
                throw new RQException((Throwable)e);
            }
            ++i;
        }
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        String recInit = "";
        for (VarItem var : parser.assignVars) {
            if (!var.isField()) continue;
            recInit = "BaseRecord rec = src.getRecord(" + iStr + ");";
            break;
        }
        String fieldInit = "";
        VarItem[] varItemArray = fieldVars = parser.getCurContext().getStructType().getFieldVars();
        int n = fieldVars.length;
        int n2 = 0;
        while (n2 < n) {
            VarItem var = varItemArray[n2];
            if (var.refCount > 0) {
                String varName = var.getName();
                String line = String.format("%s %s = %s;", var.getType(), varName, parser.getCurContext().formatFieldRef(varName));
                fieldInit = String.valueOf(fieldInit) + line;
            }
            ++n2;
        }
        if (fieldInit.length() > 0 && recInit.length() == 0) {
            recInit = "BaseRecord rec = src.getRecord(" + iStr + ");";
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "tableRun_" + id;
        String method = "private static Table " + methodName + "(Table src" + paramVarsDefine + ") {" + locVars + "if(src==null)return null;int " + lenStr + " = src.length();" + "for (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + recInit + fieldInit + codeline + "}" + "return src;" + "}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, left.getType());
    }

    public static CodeItem generateCalc(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        if (left.getType().isType("Sequence")) {
            return CodeMaker.generateSequenceCalc(parser, left, exp);
        }
        if (left.getType().isType("Table")) {
            return CodeMaker.generateTableCalc(parser, left, exp);
        }
        return CodeMaker.generateNumberCalc(parser, left, exp);
    }

    public static CodeItem generateSequenceSum(NodeParser parser, CodeItem left, Expression exp) throws ParseNodeException {
        String codeline = "";
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String init = "";
        String leftName = left.toString();
        DataType curType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(leftName, "src", null, iStr, curType);
        parser.pushCurContext(cur);
        CodeItem item = parser.parse(exp.getHome());
        if (item.getPreItems() != null && item.getPreItems().size() > 0) {
            for (CodeItem citem : item.getPreItems()) {
                codeline = String.valueOf(codeline) + citem.toString() + ";";
            }
        }
        DataType type = item.getType();
        init = (type = DataType.ifIntToLong(type)).getDefaultValueStr() == null ? type + " result;" : type + " result = " + type.getDefaultValueStr() + ";";
        codeline = type.isNumber() && !type.isNullable() ? String.valueOf(codeline) + "result += " + item + ";" : (!type.isNumber() ? String.valueOf(codeline) + "result = Variant.add(result," + item + ");" : String.valueOf(codeline) + "result = (" + type + ")MathLib.add(result," + item.cast() + ");");
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceSum_" + id;
        String method = "private static " + DataType.toNullable(type) + " " + methodName + "(Sequence src" + paramVarsDefine + ") {" + locVars + "if (src == null) return null;" + "int " + lenStr + " = src.length();" + init + "for (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + codeline + "}" + "return result;" + "}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String line = String.format("%s(%s%s)", methodName, left, paramVars);
        return new LineItem(line, DataType.toNullable(type), DataType.toNullable(type));
    }

    public static CodeItem generateSequenceDerive(NodeParser parser, CodeItem left, String[] names, Expression[] exps, String opt) throws ParseNodeException {
        DataType returnType;
        boolean hasO = false;
        if (opt != null && opt.indexOf("o") != -1) {
            hasO = true;
        }
        int len = names.length;
        DataType[] fieldTypes = new DataType[len];
        parser.pushStack();
        int id = parser.constPool.generateNextId();
        String iStr = "i_" + id;
        String lenStr = "len_" + id;
        String leftName = left.toString();
        CodeMaker.checkLeftStructType(left);
        DataType memberType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(leftName, "src", "srcRec", iStr, memberType);
        parser.pushCurContext(cur);
        int colCount = left.getType().getStructType().getFieldCount();
        String codeline = "";
        String line = hasO ? String.format("Record srcRec = (Record)src.get(" + iStr + ");Record r = srcRec;r.derive(newDs);", new Object[0]) : String.format("Record srcRec = (Record)src.get(" + iStr + ");Record r = new Record(newDs);r.set(srcRec);", new Object[0]);
        CodeItem[] items = new CodeItem[len];
        int i = 0;
        while (i < len) {
            String expStr;
            if (exps[i] == null) {
                expStr = "null";
                fieldTypes[i] = DataType.ObjectType;
            } else {
                CodeItem item;
                try {
                    item = items[i] = parser.parse(exps[i].getHome());
                }
                catch (Exception e) {
                    parser.popCurContext();
                    parser.popStack();
                    return null;
                }
                if (item.getPreItems() != null && item.getPreItems().size() > 0) {
                    for (CodeItem citem : item.getPreItems()) {
                        line = String.valueOf(line) + citem.toString() + ";";
                    }
                }
                expStr = item.toString();
                fieldTypes[i] = item.getType();
            }
            line = hasO ? String.valueOf(line) + String.format("r.setNormalFieldValue(%d, %s);", colCount + i, expStr) : String.valueOf(line) + String.format("r.setNormalFieldValue(%d, %s);", colCount + i, expStr);
            ++i;
        }
        if (!hasO) {
            line = String.valueOf(line) + String.format("resultMems.add(r);", iStr);
        }
        codeline = line;
        String locVars = parser.getVarsDefinition();
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        if (paramVarsDefine.length() != 0) {
            paramVarsDefine = ", " + paramVarsDefine;
        }
        if (paramVars.length() != 0) {
            paramVars = ", " + paramVars;
        }
        parser.popCurContext();
        parser.popStack();
        String methodName = "sequenceDerive_" + id;
        String method = hasO ? "\tprivate static Table " + methodName + "(Table src, DataStruct newDs" + paramVarsDefine + ") {\r\n" + locVars + "\t\tif(src==null)return null;int " + lenStr + " = src.length();" + "\t\tfor (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + "\t\t\t" + codeline + "\r\n" + "\t\t}\r\n" + "src.setDataStruct(newDs);" + "\t\treturn src;\r\n" + "\t}" : "\tprivate static Table " + methodName + "(Sequence src, DataStruct newDs" + paramVarsDefine + ") {\r\n" + locVars + "\t\tint " + lenStr + " = src.length();" + "\t\tTable tbl = new Table(newDs, " + lenStr + ");" + "\t\tIArray resultMems = tbl.getMems();" + "\t\tfor (int " + iStr + " = 1; " + iStr + " <= " + lenStr + "; " + iStr + "++) {" + "\t\t\t" + codeline + "\r\n" + "\t\t}\r\n" + "\t\treturn tbl;\r\n" + "\t}";
        parser.funCodeMap.put(methodName, new LineItem(method));
        String[] newNames = null;
        if (left.getType().getStructType() != null) {
            String[] arr = left.getType().getStructType().getFieldNames();
            newNames = new String[arr.length + names.length];
            System.arraycopy(arr, 0, newNames, 0, arr.length);
            System.arraycopy(names, 0, newNames, arr.length, names.length);
            DataType[] arr1 = left.getType().getStructType().getFieldTypes();
            DataType[] newTypes = new DataType[arr1.length + fieldTypes.length];
            System.arraycopy(arr1, 0, newTypes, 0, arr1.length);
            System.arraycopy(fieldTypes, 0, newTypes, arr1.length, fieldTypes.length);
            StructType structType = new StructType(newNames, newTypes, parser);
            returnType = left.getType().isType("ICursor") ? DataType.newCursorType(structType) : DataType.newTableType(structType);
        } else {
            returnType = DataType.newTableType(null);
        }
        if (opt != null && opt.indexOf("o") != -1) {
            left.setType(returnType);
            parser.setVarType(((VarItem)left).getName(), returnType);
        }
        String newDs = parser.generateDataStructConstVar(newNames);
        line = String.format("%s(%s, %s%s)", methodName, left, newDs, paramVars);
        return new LineItem(line, returnType);
    }

    public static CodeItem generateSequenceConj(NodeParser parser, CodeItem left, Expression exp, String option) throws ParseNodeException {
        String line;
        if (left.getType().getMemberType().isType("ICursor")) {
            throw new RuntimeException();
        }
        if (exp != null) {
            CodeItem item = CodeMaker.generateSequenceCalc(parser, left, exp);
            line = String.format("SequenceLib.conj(%s,%s)", item, option);
        } else {
            line = String.format("SequenceLib.conj(%s,%s)", left, option);
        }
        return new LineItem(line, left.getType());
    }
}

