/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.common.MessageManager;
import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.RecordFunction;
import com.scudata.expression.mfn.record.FieldName;
import com.scudata.expression.mfn.record.FieldValue;
import com.scudata.resources.EngineMessage;

public class RecordFunctionParser {
    private static CodeItem parseFieldName(NodeParser parser, FieldName node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            String line = String.format("RecordLib.fieldName(%s)", left.cast());
            return new LineItem(line, DataType.newSequenceType("String"));
        }
        if (param.isLeaf()) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            String line = String.format("RecordLib.fieldName(%s, %s)", left.cast(), obj);
            return new LineItem(line, DataType.StringType);
        }
        MessageManager mm = EngineMessage.get();
        throw new ParseNodeException("sum" + mm.getMessage("function.invalidParam"));
    }

    private static CodeItem parseCommon(NodeParser parser, RecordFunction node, CodeItem left) throws ParseNodeException {
        if (!(node instanceof FieldValue)) {
            throw new ParseNodeException(node.toString());
        }
        DataType returnType = DataType.ObjectType;
        return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
    }

    public static CodeItem parseNode(NodeParser parser, RecordFunction node, CodeItem left) throws ParseNodeException {
        if (node instanceof FieldName) {
            return RecordFunctionParser.parseFieldName(parser, (FieldName)node, left);
        }
        if (node instanceof RecordFunction) {
            return RecordFunctionParser.parseCommon(parser, node, left);
        }
        throw new ParseNodeException(node.toString());
    }
}

