/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CurContext;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.StructType;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.CodeMaker;
import com.scudata.compile.parser.FunctionNodeParser;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.SequenceFunction;
import com.scudata.expression.mfn.sequence.Align;
import com.scudata.expression.mfn.sequence.Avg;
import com.scudata.expression.mfn.sequence.Concat;
import com.scudata.expression.mfn.sequence.Conj;
import com.scudata.expression.mfn.sequence.Count;
import com.scudata.expression.mfn.sequence.Delete;
import com.scudata.expression.mfn.sequence.Derive;
import com.scudata.expression.mfn.sequence.Group;
import com.scudata.expression.mfn.sequence.Groups;
import com.scudata.expression.mfn.sequence.Id;
import com.scudata.expression.mfn.sequence.Insert;
import com.scudata.expression.mfn.sequence.Len;
import com.scudata.expression.mfn.sequence.MGet;
import com.scudata.expression.mfn.sequence.Max;
import com.scudata.expression.mfn.sequence.Maxp;
import com.scudata.expression.mfn.sequence.Merge;
import com.scudata.expression.mfn.sequence.Min;
import com.scudata.expression.mfn.sequence.New;
import com.scudata.expression.mfn.sequence.PMin;
import com.scudata.expression.mfn.sequence.PSeg;
import com.scudata.expression.mfn.sequence.PSelect;
import com.scudata.expression.mfn.sequence.PSort;
import com.scudata.expression.mfn.sequence.PTop;
import com.scudata.expression.mfn.sequence.Pos;
import com.scudata.expression.mfn.sequence.RecordValue;
import com.scudata.expression.mfn.sequence.Run;
import com.scudata.expression.mfn.sequence.Rvs;
import com.scudata.expression.mfn.sequence.Select;
import com.scudata.expression.mfn.sequence.Sort;
import com.scudata.expression.mfn.sequence.Step;
import com.scudata.expression.mfn.sequence.Sum;
import com.scudata.expression.mfn.sequence.To;
import com.scudata.expression.mfn.sequence.Top;
import com.scudata.expression.mfn.sequence.Union;
import com.scudata.resources.EngineMessage;

public class SequenceNodeParser {
    private static CodeItem parseAlign(NodeParser parser, Align node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("align" + mm.getMessage("function.missingParam"));
        }
        return parser.parseFunctionToGeneric((Function)node, left, "align", DataType.newSequenceType(left.getType()), parser);
    }

    private static CodeItem parsePMin(NodeParser parser, PMin node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            String line = "pmin(" + left + ")";
            return new LineItem(line, new DataType("int"));
        }
        throw new ParseNodeException(node.toString());
    }

    private static CodeItem parseSelect(NodeParser parser, Select node, CodeItem left) throws ParseNodeException {
        String line;
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param == null) {
            line = String.format("SequenceLib.select(%s, %s, ctx)", left, option);
        } else if (param.isLeaf()) {
            if (left.getType().isType("Table")) {
                return CodeMaker.generateTableSelect(parser, left, param.getLeafExpression());
            }
            if (left.getType().isType("Sequence") && left.getType().getMemberType() != null && left.getType().getMemberType().isType("BaseRecord")) {
                return CodeMaker.generateSequenceSelect(parser, left, param.getLeafExpression());
            }
            String expStr = parser.generateExpressionConstVar(param.getLeafExpression().toString());
            line = String.format("SequenceLib.select(%s, %s, %s, ctx)", left.cast("Sequence"), expStr, option);
        } else {
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"select", (boolean)true, (boolean)true);
            String[] fltExps = pi.getExpressionStrs1();
            String[] fltExps2 = pi.getExpressionStrs2();
            StringBuilder combined = new StringBuilder();
            int length = fltExps.length;
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    combined.append(" && ");
                }
                combined.append(fltExps[i]).append("==").append(fltExps2[i]);
                ++i;
            }
            String expStr = parser.generateExpressionConstVar(combined.toString());
            line = String.format("SequenceLib.select(%s, %s, %s, ctx)", left, expStr, option);
        }
        return new LineItem(line, left.getType());
    }

    private static CodeItem parseSum(NodeParser parser, Sum node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (left instanceof VarItem && !left.getType().isType("Sequence") && !left.getType().isType("Table")) {
            parser.setVarType(((VarItem)left).getName(), DataType.newSequenceType());
        }
        if (param == null) {
            String line = String.valueOf(left.cast().toString()) + ".sum()";
            DataType type = DataType.ifIntToLong(left.getType().getMemberType());
            return new LineItem(line, type, DataType.ObjectType);
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            return CodeMaker.generateSequenceSum(parser, left, exp);
        }
        MessageManager mm = EngineMessage.get();
        throw new ParseNodeException("sum" + mm.getMessage("function.invalidParam"));
    }

    private static CodeItem parseLen(NodeParser parser, Len node, CodeItem left) throws ParseNodeException {
        return new LineItem("SequenceLib.len(" + left.cast("Sequence") + ")", DataType.IntTypeNullable);
    }

    private static CodeItem parseUnion(NodeParser parser, Union node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param == null) {
            return new LineItem(String.format("%s.union(%s)", left, option), left.getType());
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            CodeItem leftItem = CodeMaker.generateCalc(parser, left, exp);
            return new LineItem(String.format("%s.union(%s)", leftItem, option), left.getType());
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("union" + mm.getMessage("function.invalidParam"));
    }

    private static CodeItem parseInsert(NodeParser parser, Insert node, CodeItem left) throws ParseNodeException {
        String line;
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(1);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        CodeItem val = parser.parse(sub.getLeafExpression().getHome());
        sub = param.getSub(0);
        if (sub != null) {
            CodeItem posVal = parser.parse(sub.getLeafExpression().getHome());
            line = String.format("SequenceLib.insert(%s,%s,%s,%s)", left, posVal.cast("int"), val, option);
        } else {
            line = String.format("SequenceLib.insert(%s,%s,%s,%s)", left, null, val, option);
        }
        return new LineItem(line, left.getType());
    }

    private static CodeItem parseMax(NodeParser parser, Max node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            return new LineItem(String.valueOf(left.toString()) + ".max()", left.getType().getMemberType(), DataType.ObjectType);
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            CodeItem leftItem = CodeMaker.generateCalc(parser, left, exp);
            return new LineItem(String.valueOf(leftItem.toString()) + ".max()", left.getType().getMemberType(), DataType.ObjectType);
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new ParseNodeException("max" + mm.getMessage("function.invalidParam"));
        }
        IParam param0 = param.getSub(0);
        IParam param1 = param.getSub(1);
        if (param1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new ParseNodeException("max" + mm.getMessage("function.invalidParam"));
        }
        String countExpStr = parser.generateExpressionConstVar(param1.getLeafExpression().toString());
        if (param0 == null) {
            String line = String.format("%s.max(%s)", left, countExpStr);
            return new LineItem(line, left.getType().getMemberType(), DataType.ObjectType);
        }
        Expression exp = param0.getLeafExpression();
        String expStr = parser.generateExpressionConstVar(exp.toString());
        String line = String.format("%s.calc(%s, \"o\", ctx).max(%s)", left, expStr, countExpStr);
        return new LineItem(line, left.getType(), DataType.ObjectType);
    }

    private static CodeItem parseMin(NodeParser parser, Min node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            return new LineItem(String.valueOf(left.toString()) + ".min()", left.getType().getMemberType(), DataType.ObjectType);
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            String expStr = parser.generateExpressionConstVar(exp.toString());
            String line = String.format("%s.calc(%s, \"o\", ctx).min()", left, expStr);
            return new LineItem(line, left.getType().getMemberType(), DataType.ObjectType);
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new ParseNodeException("min" + mm.getMessage("function.invalidParam"));
        }
        IParam param0 = param.getSub(0);
        IParam param1 = param.getSub(1);
        if (param1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new ParseNodeException("min" + mm.getMessage("function.invalidParam"));
        }
        String countExpStr = parser.generateExpressionConstVar(param1.getLeafExpression().toString());
        if (param0 == null) {
            String line = String.format("%s.min(%s)", left, countExpStr);
            return new LineItem(line, left.getType().getMemberType(), DataType.ObjectType);
        }
        Expression exp = param0.getLeafExpression();
        String expStr = parser.generateExpressionConstVar(exp.toString());
        String line = String.format("%s.calc(%s, \"o\", ctx).min(%s)", left, expStr, countExpStr);
        return new LineItem(line, left.getType().getMemberType(), DataType.ObjectType);
    }

    private static CodeItem parseMGet(NodeParser parser, MGet node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param.isLeaf()) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            String line = String.format("SequenceLib.MGet(%s, %s, %s)", left, obj, option);
            DataType type = left.getType().getMemberType();
            type = type == null ? null : DataType.toNullable(type);
            return new LineItem(line, type, DataType.ObjectType);
        }
        if (param.getType() == ':') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("m" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = param.getSub(0);
            IParam sub1 = param.getSub(1);
            CodeItem obj0 = LineItem.NULL;
            CodeItem obj1 = LineItem.NULL;
            if (sub0 != null) {
                obj0 = parser.parse(sub0.getLeafExpression().getHome());
            }
            if (sub1 != null) {
                obj1 = parser.parse(sub1.getLeafExpression().getHome());
            }
            String line = String.format("SequenceLib.MGet(%s, %s, %s, %s)", left, obj0, obj1, option);
            return new LineItem(line, left.getType());
        }
        throw new ParseNodeException();
    }

    private static CodeItem parseNew(NodeParser parser, New node, CodeItem left) throws ParseNodeException {
        CodeItem item;
        IParam param = node.getParam();
        ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"new", (boolean)false, (boolean)false);
        Expression[] exps = pi.getExpressions1();
        String[] names = pi.getExpressionStrs2();
        int colCount = names.length;
        int i = 0;
        while (i < colCount) {
            if ((names[i] == null || names[i].length() == 0) && exps[i] != null) {
                names[i] = exps[i].getFieldName();
            }
            ++i;
        }
        if (left.getType().isType("Sequence")) {
            CodeItem item2 = CodeMaker.generateSequenceNew(parser, left, names, exps);
            if (item2 != null) {
                return item2;
            }
        } else if (left.getType().isType("Table") && (item = CodeMaker.generateTableNew(parser, left, names, exps)) != null) {
            return item;
        }
        String result1 = parser.generateExpArrConstVar(pi.getExpressionStrs1());
        String result2 = parser.generateStrArrConstVar(names);
        String opt = NodeParser.toMacroString(node.getOption());
        String line = String.format("%s.newTable(%s, %s, %s, ctx)", left, result2, result1, opt);
        return new LineItem(line, DataType.newTableType());
    }

    private static CodeItem parseDerive(NodeParser parser, Derive node, CodeItem left) throws ParseNodeException {
        String result2;
        String result1;
        IParam param = node.getParam();
        String opt = node.getOption();
        Expression[] exps = null;
        String[] names = null;
        ParamInfo2 pi = null;
        if (param != null) {
            CodeItem item;
            pi = ParamInfo2.parse((IParam)param, (String)"derive", (boolean)false, (boolean)false);
            exps = pi.getExpressions1();
            names = pi.getExpressionStrs2();
            if ((opt == null || opt.equals("o")) && (item = CodeMaker.generateSequenceDerive(parser, left, names, exps, opt)) != null) {
                return item;
            }
        }
        String preLine = "";
        DataType returnType = null;
        if (names != null) {
            DataType[] types = new DataType[exps.length];
            int i = 0;
            while (i < exps.length) {
                if (exps[i] == null) {
                    types[i] = DataType.ObjectType;
                } else if (exps[i].getHome() instanceof Constant) {
                    Object obj = ((Constant)exps[i].getHome()).getValue();
                    types[i] = NodeParser.getObjectType(obj);
                } else {
                    parser.pushStack();
                    parser.addVars(left.getType().getStructType().getFieldVars());
                    CodeItem item = parser.parse(exps[i].getHome());
                    if (parser.parentVars.size() > 0) {
                        for (String var : parser.parentVars.keySet()) {
                            preLine = String.valueOf(preLine) + String.format("ctx.setParamValue(\"%s\", %s);", var, var);
                        }
                    }
                    parser.popStack();
                    types[i] = item.getType();
                }
                ++i;
            }
            if (left.getType().getStructType() != null) {
                String[] arr = left.getType().getStructType().getFieldNames();
                String[] newNames = new String[arr.length + names.length];
                System.arraycopy(arr, 0, newNames, 0, arr.length);
                System.arraycopy(names, 0, newNames, arr.length, names.length);
                DataType[] arr1 = left.getType().getStructType().getFieldTypes();
                DataType[] newTypes = new DataType[arr1.length + types.length];
                System.arraycopy(arr1, 0, newTypes, 0, arr1.length);
                System.arraycopy(types, 0, newTypes, arr1.length, types.length);
                StructType structType = new StructType(newNames, newTypes, parser);
                returnType = DataType.newTableType(structType);
            } else {
                returnType = DataType.newTableType(null);
            }
            if (opt != null && opt.indexOf("o") != -1) {
                left.setType(returnType);
                if (left instanceof VarItem) {
                    parser.setVarType(((VarItem)left).getName(), returnType);
                }
            }
        }
        if (param == null) {
            returnType = left.getType();
        }
        if (param == null) {
            result1 = parser.generateExpArrConstVar(null);
            result2 = parser.generateStrArrConstVar(null);
        } else {
            result1 = parser.generateExpArrConstVar(pi.getExpressionStrs1());
            result2 = parser.generateStrArrConstVar(names);
        }
        opt = NodeParser.toMacroString(node.getOption());
        String line = String.format("%s.derive(%s, %s, %s, ctx)", left, result2, result1, opt);
        LineItem item = new LineItem(line, returnType);
        item.setPreItem(new LineItem(preLine));
        return item;
    }

    private static CodeItem parsePos(NodeParser parser, Pos node, CodeItem left) throws ParseNodeException {
        String typeStr;
        DataType retType;
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (option != null && option.indexOf(97) != -1) {
            retType = DataType.newSequenceType("int");
            typeStr = "(Sequence)";
        } else {
            retType = DataType.IntTypeNullable;
            typeStr = "(Integer)";
        }
        String leftStr = NodeParser.checkIfNeedParentheses(left);
        if (param.isLeaf()) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            String line = String.format("%s%s.pos(%s, %s)", typeStr, leftStr, obj, option);
            return new LineItem(line, retType);
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pos" + mm.getMessage("function.invalidParam"));
        }
        IParam sub0 = param.getSub(0);
        IParam sub1 = param.getSub(1);
        if (sub0 == null || sub1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("pos" + mm.getMessage("function.invalidParam"));
        }
        CodeItem posVal = parser.parse(sub1.getLeafExpression().getHome());
        String posStr = !posVal.getType().isType("int") ? "((Number)" + posVal + ").intValue()" : posVal.toString();
        CodeItem val = parser.parse(sub0.getLeafExpression().getHome());
        String line = String.format("%s%s.pos(%s, %s, %s)", typeStr, leftStr, val, posStr, option);
        return new LineItem(line, retType);
    }

    private static CodeItem parsePSelect(NodeParser parser, PSelect node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (node.getOption() != null) {
            return parser.parseFunctionToGeneric((Function)node, left, "pselect", DataType.ObjectType, parser);
        }
        if (param == null) {
            String option = NodeParser.toMacroString(node.getOption());
            String line = String.format("(Sequence)%s.pselect(null, %s, ctx)", left, option);
            return new LineItem(line, DataType.newSequenceType("int"));
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            return CodeMaker.generateSequencePSelect(parser, left, exp);
        }
        return parser.parseFunctionToGeneric((Function)node, left, "pselect", DataType.ObjectType, parser);
    }

    private static CodeItem parseStep(NodeParser parser, Step node, CodeItem left) throws ParseNodeException {
        LineItem seqs;
        CodeItem interval;
        IParam param = node.getParam();
        if (param.isLeaf()) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            interval = obj.getType().isType("int") ? obj : new LineItem("((Number)" + obj + ").intValue()");
            seqs = new LineItem("new int[]{1}");
        } else {
            IParam sub = param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("step" + mm.getMessage("function.invalidParam"));
            }
            CodeItem obj = parser.parse(sub.getLeafExpression().getHome());
            interval = obj.getType().isType("int") ? obj : new LineItem("((Number)" + obj + ").intValue()");
            int size = param.getSubSize();
            String seqsStr = "new int[]{";
            int i = 1;
            while (i < size) {
                sub = param.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("step" + mm.getMessage("function.invalidParam"));
                }
                obj = parser.parse(sub.getLeafExpression().getHome());
                seqsStr = obj.getType().isType("int") ? String.valueOf(seqsStr) + obj : String.valueOf(seqsStr) + "((Number)" + obj + ").intValue(),";
                ++i;
            }
            seqsStr = String.valueOf(seqsStr) + "}";
            seqs = new LineItem(seqsStr);
        }
        if (left.getType().isType("int") || left.getType().isType("Integer")) {
            left = new LineItem("FunLib.To(" + left + ")", DataType.newSequenceType(left.getType()));
        }
        return new LineItem(String.format("%s.step(%s, %s)", left, interval, seqs), left.getType());
    }

    private static CodeItem parseTo(NodeParser parser, To node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            return new LineItem("new Sequence(" + left + ")", left.getType());
        }
        return parser.parseFunctionToGeneric((Function)node, left, "to", left.getType(), parser);
    }

    private static CodeItem parseConcat(NodeParser parser, Concat node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        String sep = "";
        if (param != null) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            if (obj.getType().isType("String")) {
                sep = obj.toString();
            } else {
                if (obj.getType().isType("Sequence")) {
                    String lens = "((Sequence)" + obj + ").toIntArray()";
                    String line = String.format("com.scudata.expression.mfn.sequence.concat(%s, %s, %s)", left, lens, option);
                    return new LineItem(line, DataType.StringType);
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("concat" + mm.getMessage("function.paramTypeError"));
            }
        }
        String line = String.format("(%s).toString(%s, %s)", left, NodeParser.toMacroString(sep), option);
        return new LineItem(line, DataType.StringType);
    }

    private static CodeItem parseCount(NodeParser parser, Count node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            String line = String.format("%s.count()", left);
            return new LineItem(line, DataType.IntType);
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            return CodeMaker.generateSequenceCount(parser, left, exp);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("count" + mm.getMessage("function.invalidParam"));
    }

    private static CodeItem parseId(NodeParser parser, Id node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param == null) {
            return new LineItem(String.format("%s.id(%s)", left, option), left.getType());
        }
        DataType curType = left.getType().getMemberType();
        CurContext cur = CurContext.newSequenceCurItem(left.toString(), "src", null, null, curType);
        parser.pushCurContext(cur);
        CodeItem[] items = parser.parseParams0(param);
        parser.popCurContext();
        DataType returnType = items.length == 1 ? DataType.newSequenceType(items[0].getType()) : DataType.newSequenceType("Sequence");
        return parser.parseFunctionToGeneric((Function)node, left, "id", returnType, parser);
    }

    private static CodeItem parseRecordValue(NodeParser parser, RecordValue node, CodeItem left) throws ParseNodeException {
        CodeItem o2;
        CodeItem o1;
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param == null) {
            o1 = LineItem.NULL;
            o2 = LineItem.NULL;
        } else if (param.isLeaf()) {
            o1 = parser.parse(param.getLeafExpression().getHome());
            o2 = LineItem.NULL;
        } else {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = param.getSub(0);
            IParam sub2 = param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.invalidParam"));
            }
            o1 = parser.parse(sub1.getLeafExpression().getHome());
            o2 = parser.parse(sub2.getLeafExpression().getHome());
        }
        String line = String.format("SequenceLib.recordValue(%s, %s, %s, %s)", left, o1, o2, option);
        return new LineItem(line, left.getType(), DataType.newSequenceType());
    }

    private static CodeItem parseConj(NodeParser parser, Conj node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        Expression exp = null;
        if (param.isLeaf()) {
            exp = param.getLeafExpression();
        }
        return CodeMaker.generateSequenceConj(parser, left, exp, option);
    }

    private static CodeItem parseRun(NodeParser parser, Run node, CodeItem left) throws ParseNodeException {
        CodeItem item;
        Expression[] exps;
        IParam param = node.getParam();
        Expression[] assignExps = null;
        if (param == null) {
            return left;
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            exps = new Expression[]{exp};
        } else {
            ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
            exps = pi.getExpressions1();
            assignExps = pi.getExpressions2();
        }
        if (left.getType().isType("Sequence") ? (item = CodeMaker.generateSequenceRun(parser, left, exps, assignExps)) != null : (left.getType().isType("Table") ? (item = CodeMaker.generateTableRun(parser, left, exps, assignExps)) != null : left.getType().isType("BaseRecord") && (item = CodeMaker.generateRecordRun(parser, left, exps, assignExps)) != null)) {
            return item;
        }
        throw new RQException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CodeItem parseCommon(NodeParser parser, SequenceFunction node, CodeItem left) throws ParseNodeException {
        DataType returnType;
        String option = node.getOption();
        if (node instanceof Group) {
            DataType type = left.getType();
            if (type.isType("Table")) {
                DataType memberType = DataType.newRecordType(type.getStructType());
                type = DataType.newSequenceType(memberType);
            }
            returnType = DataType.newSequenceType(type);
            return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
        } else if (node instanceof Groups) {
            returnType = DataType.newTableType();
            return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
        } else if (node instanceof Sort) {
            returnType = left.getType();
            return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
        } else if (node instanceof Maxp) {
            returnType = option != null && option.indexOf("a") != -1 ? left.getType() : left.getType().getMemberType();
            return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
        } else if (node instanceof Conj) {
            returnType = left.getType();
            return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
        } else {
            if (node instanceof Merge) {
                String funName = "merge";
                return FunctionNodeParser.parseCommonMFN(parser, (Function)node, left, funName, left.getType().getMemberType());
            }
            if (node instanceof Rvs) {
                return new LineItem(left + ".rvs()", left.getType());
            }
            if (node instanceof Top) {
                returnType = left.getType();
                return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
            } else if (node instanceof Insert) {
                if (!left.getType().isType("Table") && (option == null || option.indexOf(110) == -1)) return SequenceNodeParser.parseInsert(parser, (Insert)node, left);
                returnType = left.getType();
                return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
            } else if (node instanceof Delete) {
                returnType = left.getType();
                return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
            } else if (node instanceof Avg) {
                returnType = DataType.DoubleTypeNullable;
                return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
            } else if (node instanceof PSeg) {
                returnType = DataType.IntTypeNullable;
                return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
            } else if (node instanceof PSort) {
                returnType = DataType.newSequenceType(DataType.IntTypeNullable);
                return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
            } else {
                if (!(node instanceof PTop)) throw new ParseNodeException(node.toString());
                returnType = DataType.newSequenceType(DataType.IntTypeNullable);
            }
        }
        return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
    }

    public static CodeItem parseNode(NodeParser parser, SequenceFunction node, CodeItem left) throws ParseNodeException {
        if (node instanceof Align) {
            return SequenceNodeParser.parseAlign(parser, (Align)node, left);
        }
        if (node instanceof PMin) {
            return SequenceNodeParser.parsePMin(parser, (PMin)node, left);
        }
        if (node instanceof Select) {
            return SequenceNodeParser.parseSelect(parser, (Select)node, left);
        }
        if (node instanceof Sum) {
            return SequenceNodeParser.parseSum(parser, (Sum)node, left);
        }
        if (node instanceof Max) {
            return SequenceNodeParser.parseMax(parser, (Max)node, left);
        }
        if (node instanceof Min) {
            return SequenceNodeParser.parseMin(parser, (Min)node, left);
        }
        if (node instanceof MGet) {
            return SequenceNodeParser.parseMGet(parser, (MGet)node, left);
        }
        if (node instanceof New) {
            return SequenceNodeParser.parseNew(parser, (New)node, left);
        }
        if (node instanceof Step) {
            return SequenceNodeParser.parseStep(parser, (Step)node, left);
        }
        if (node instanceof Pos) {
            return SequenceNodeParser.parsePos(parser, (Pos)node, left);
        }
        if (node instanceof To) {
            return SequenceNodeParser.parseTo(parser, (To)node, left);
        }
        if (node instanceof Concat) {
            return SequenceNodeParser.parseConcat(parser, (Concat)node, left);
        }
        if (node instanceof Count) {
            return SequenceNodeParser.parseCount(parser, (Count)node, left);
        }
        if (node instanceof PSelect) {
            return SequenceNodeParser.parsePSelect(parser, (PSelect)node, left);
        }
        if (node instanceof Len) {
            return SequenceNodeParser.parseLen(parser, (Len)node, left);
        }
        if (node instanceof Union) {
            return SequenceNodeParser.parseUnion(parser, (Union)node, left);
        }
        if (node instanceof Id) {
            return SequenceNodeParser.parseId(parser, (Id)node, left);
        }
        if (node instanceof Conj) {
            return SequenceNodeParser.parseConj(parser, (Conj)node, left);
        }
        if (node instanceof RecordValue) {
            return SequenceNodeParser.parseRecordValue(parser, (RecordValue)node, left);
        }
        if (node instanceof Run) {
            return SequenceNodeParser.parseRun(parser, (Run)node, left);
        }
        if (node instanceof Derive) {
            return SequenceNodeParser.parseDerive(parser, (Derive)node, left);
        }
        if (node instanceof SequenceFunction) {
            return SequenceNodeParser.parseCommon(parser, node, left);
        }
        throw new ParseNodeException(node.toString());
    }
}

