/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.Function;
import com.scudata.expression.StringFunction;
import com.scudata.expression.mfn.string.Split;

public class StringFunctionParser {
    private static CodeItem parseCommon(NodeParser parser, StringFunction node, CodeItem left) throws ParseNodeException {
        DataType returnType;
        if (node instanceof Split) {
            String option = node.getOption();
            returnType = option != null && option.indexOf("p") != -1 ? DataType.newSequenceType(DataType.IntType) : DataType.newSequenceType(DataType.StringType);
        } else {
            throw new ParseNodeException(node.toString());
        }
        return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
    }

    public static CodeItem parseNode(NodeParser parser, StringFunction node, CodeItem left) throws ParseNodeException {
        String leftStr = left.toString();
        if (leftStr.startsWith("(")) {
            left = new LineItem("(" + leftStr + ")", left.getType());
        }
        if (node instanceof StringFunction) {
            return StringFunctionParser.parseCommon(parser, node, left);
        }
        throw new ParseNodeException(node.toString());
    }
}

