/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.CodeItem;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.StructType;
import com.scudata.compile.parser.NodeParser;
import com.scudata.dm.DataStruct;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.TableFunction;
import com.scudata.expression.mfn.table.Alter;
import com.scudata.expression.mfn.table.Rename;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

public class TableFunctionParser {
    private static CodeItem parseAlter(NodeParser parser, Alter node, CodeItem left) throws ParseNodeException {
        IParam oldParam;
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("alter" + mm.getMessage("function.missingParam"));
        }
        DataStruct ds = left.getType().getStructType().dataStruct();
        String[] oldFields = ds.getFieldNames();
        int oldCount = oldFields.length;
        int[] state = new int[oldCount];
        ArrayList<String> newFieldList = new ArrayList<String>(oldCount);
        if (param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("alter" + mm.getMessage("function.invalidParam"));
            }
            oldParam = param.getSub(0);
            IParam deleteParam = param.getSub(1);
            if (deleteParam == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("alter" + mm.getMessage("function.invalidParam"));
            }
            if (deleteParam.isLeaf()) {
                String field = deleteParam.getLeafExpression().getIdentifierName();
                int index = ds.getFieldIndex(field);
                if (index == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(field) + mm.getMessage("ds.fieldNotExist"));
                }
                state[index] = -1;
            } else {
                int i = 0;
                int size = deleteParam.getSubSize();
                while (i < size) {
                    IParam sub = deleteParam.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("alter" + mm.getMessage("function.invalidParam"));
                    }
                    String field = sub.getLeafExpression().getIdentifierName();
                    int index = ds.getFieldIndex(field);
                    if (index == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(field) + mm.getMessage("ds.fieldNotExist"));
                    }
                    state[index] = -1;
                    ++i;
                }
            }
        } else {
            oldParam = param;
        }
        if (oldParam != null) {
            if (oldParam.isLeaf()) {
                String field = oldParam.getLeafExpression().getIdentifierName();
                int index = ds.getFieldIndex(field);
                if (index != -1) {
                    if (state[index] == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("alter" + mm.getMessage("function.invalidParam"));
                    }
                    state[index] = 1;
                    field = oldFields[index];
                }
                newFieldList.add(field);
            } else {
                int i = 0;
                int size = oldParam.getSubSize();
                while (i < size) {
                    IParam sub = oldParam.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("alter" + mm.getMessage("function.invalidParam"));
                    }
                    String field = sub.getLeafExpression().getIdentifierName();
                    int index = ds.getFieldIndex(field);
                    if (index != -1) {
                        if (state[index] == -1) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("alter" + mm.getMessage("function.invalidParam"));
                        }
                        state[index] = 1;
                        field = oldFields[index];
                    }
                    newFieldList.add(field);
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < oldCount) {
            if (state[i] != -1 && state[i] != 1) {
                newFieldList.add(oldFields[i]);
            }
            ++i;
        }
        int newCount = newFieldList.size();
        String[] newFields = new String[newCount];
        newFieldList.toArray(newFields);
        String fileds = parser.generateStrArrConstVar(newFields);
        String methodName = "alter_" + parser.constPool.generateNextId();
        String line = String.format("table.alter(%s);return table;", fileds);
        String method = String.format("private static Table %s(Table table) {%s}", methodName, line);
        parser.funCodeMap.put(methodName, new LineItem(method));
        LineItem item = new LineItem(String.valueOf(methodName) + "(" + left + ")", left.getType());
        return item;
    }

    private static CodeItem parseRename(NodeParser parser, Rename node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"rename", (boolean)true, (boolean)false);
        String[] srcFields = pi.getExpressionStrs1();
        String[] newFields = pi.getExpressionStrs2();
        StructType structType = left.getType().getStructType();
        StructType newStructType = new StructType(newFields, structType.getFieldTypes(), parser);
        left.getType().setStructType(newStructType);
        left.getType().getMemberType().setStructType(newStructType);
        String methodName = "rename_" + parser.constPool.generateNextId();
        String v1 = parser.generateStrArrConstVar(srcFields);
        String v2 = parser.generateStrArrConstVar(newFields);
        String line = String.format("table.rename(%s, %s);return table;", v1, v2);
        String method = String.format("private static Table %s(Table table) {%s}", methodName, line);
        parser.funCodeMap.put(methodName, new LineItem(method));
        LineItem item = new LineItem(String.valueOf(methodName) + "(" + left + ")", left.getType());
        return item;
    }

    public static CodeItem parseNode(NodeParser parser, TableFunction node, CodeItem left) throws ParseNodeException {
        String leftStr = left.toString();
        if (leftStr.startsWith("(")) {
            left = new LineItem("(" + leftStr + ")", left.getType());
        }
        if (node instanceof Alter) {
            return TableFunctionParser.parseAlter(parser, (Alter)node, left);
        }
        if (node instanceof Rename) {
            return TableFunctionParser.parseRename(parser, (Rename)node, left);
        }
        throw new ParseNodeException(node.toString());
    }
}

