/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.dm.query.dql.DimLevelNode;
import com.scudata.dm.query.dql.DimNode;
import com.scudata.dm.query.dql.ExpNode;
import com.scudata.dm.query.dql.FieldNode;
import com.scudata.dm.query.dql.GatherNode;
import com.scudata.dm.query.dql.INode;
import com.scudata.dm.query.dql.TempTableNode;
import com.scudata.dm.query.metadata.LogicMetaData;
import java.util.List;

class Column {
    private ExpNode expNode;
    private String aliasName;
    private FieldNode tempTableField;

    public Column(ExpNode expNode, String aliasName) {
        this.expNode = expNode;
        this.aliasName = aliasName == null ? expNode.getAliasName() : aliasName;
    }

    public boolean isEquals(String name) {
        return LogicMetaData.equalSymbol(name, this.aliasName);
    }

    public boolean isEquals(ExpNode exp) {
        return this.expNode.isEquals(exp);
    }

    public String getAliasName() {
        int len;
        if (this.aliasName != null && (len = this.aliasName.length()) > 2 && this.aliasName.charAt(0) == '\'' && this.aliasName.charAt(len - 1) == '\'') {
            return this.aliasName.substring(1, len - 1);
        }
        return this.aliasName;
    }

    public ExpNode getExpNode() {
        return this.expNode;
    }

    public void listFieldNode(List<FieldNode> out) {
        this.expNode.listFieldNode(out);
    }

    public void listGatherNode(List<GatherNode> out) {
        this.expNode.listGatherNode(out);
    }

    public boolean isFieldNode() {
        return this.expNode.isFieldNode();
    }

    public boolean isGatherNode() {
        return this.expNode.isGatherNode();
    }

    public void changeDimField(TempTableNode tableNode) {
        if (this.expNode.isFieldNode()) {
            INode node = this.expNode.getNode(0);
            this.tempTableField = node instanceof DimNode ? tableNode.changeField((DimNode)node) : (node instanceof DimLevelNode ? tableNode.changeField((DimLevelNode)node) : tableNode.changeField((FieldNode)node));
        }
    }

    public void toFinalExpression(StringBuffer out) {
        if (this.tempTableField == null) {
            this.expNode.toFinalExpression(out);
        } else {
            this.tempTableField.toExpression(out);
        }
    }

    public void toExpression(StringBuffer out) {
        this.expNode.toExpression(out);
    }
}

